/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.mockito.internal.verification;

import java.util.List;
import org.evosuite.shaded.org.mockito.internal.exceptions.Reporter;
import org.evosuite.shaded.org.mockito.internal.invocation.InvocationMatcher;
import org.evosuite.shaded.org.mockito.internal.stubbing.InvocationContainerImpl;
import org.evosuite.shaded.org.mockito.internal.util.ObjectMethodsGuru;
import org.evosuite.shaded.org.mockito.internal.verification.api.VerificationData;
import org.evosuite.shaded.org.mockito.invocation.Invocation;
import org.evosuite.shaded.org.mockito.invocation.MatchableInvocation;

public class VerificationDataImpl
implements VerificationData {
    private final InvocationMatcher wanted;
    private final InvocationContainerImpl invocations;

    public VerificationDataImpl(InvocationContainerImpl invocations, InvocationMatcher wanted) {
        this.invocations = invocations;
        this.wanted = wanted;
        this.assertWantedIsVerifiable();
    }

    @Override
    public List<Invocation> getAllInvocations() {
        return this.invocations.getInvocations();
    }

    @Override
    public MatchableInvocation getTarget() {
        return this.wanted;
    }

    @Override
    public InvocationMatcher getWanted() {
        return this.wanted;
    }

    private void assertWantedIsVerifiable() {
        if (this.wanted == null) {
            return;
        }
        if (ObjectMethodsGuru.isToStringMethod(this.wanted.getMethod())) {
            throw Reporter.cannotVerifyToString();
        }
    }
}

