/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.mockito.internal.verification.argumentmatching;

import java.util.LinkedList;
import java.util.List;
import org.evosuite.shaded.org.mockito.ArgumentMatcher;
import org.evosuite.shaded.org.mockito.internal.matchers.ContainsExtraTypeInfo;

public class ArgumentMatchingTool {
    private ArgumentMatchingTool() {
    }

    public static Integer[] getSuspiciouslyNotMatchingArgsIndexes(List<ArgumentMatcher> matchers, Object[] arguments) {
        if (matchers.size() != arguments.length) {
            return new Integer[0];
        }
        LinkedList<Integer> suspicious = new LinkedList<Integer>();
        int i = 0;
        for (ArgumentMatcher m : matchers) {
            if (m instanceof ContainsExtraTypeInfo && !ArgumentMatchingTool.safelyMatches(m, arguments[i]) && ArgumentMatchingTool.toStringEquals(m, arguments[i]) && !((ContainsExtraTypeInfo)((Object)m)).typeMatches(arguments[i])) {
                suspicious.add(i);
            }
            ++i;
        }
        return suspicious.toArray(new Integer[0]);
    }

    private static boolean safelyMatches(ArgumentMatcher m, Object arg) {
        try {
            return m.matches(arg);
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static boolean toStringEquals(ArgumentMatcher m, Object arg) {
        return m.toString().equals(arg == null ? "null" : arg.toString());
    }
}

