/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.springframework.aop.support;

import org.evosuite.shaded.org.aopalliance.intercept.MethodInvocation;
import org.evosuite.shaded.org.springframework.aop.DynamicIntroductionAdvice;
import org.evosuite.shaded.org.springframework.aop.IntroductionInterceptor;
import org.evosuite.shaded.org.springframework.aop.ProxyMethodInvocation;
import org.evosuite.shaded.org.springframework.aop.support.AopUtils;
import org.evosuite.shaded.org.springframework.aop.support.IntroductionInfoSupport;
import org.evosuite.shaded.org.springframework.util.Assert;

public class DelegatingIntroductionInterceptor
extends IntroductionInfoSupport
implements IntroductionInterceptor {
    private Object delegate;

    public DelegatingIntroductionInterceptor(Object delegate) {
        this.init(delegate);
    }

    protected DelegatingIntroductionInterceptor() {
        this.init(this);
    }

    private void init(Object delegate) {
        Assert.notNull(delegate, "Delegate must not be null");
        this.delegate = delegate;
        this.implementInterfacesOnObject(delegate);
        this.suppressInterface(IntroductionInterceptor.class);
        this.suppressInterface(DynamicIntroductionAdvice.class);
    }

    @Override
    public Object invoke(MethodInvocation mi) throws Throwable {
        if (this.isMethodOnIntroducedInterface(mi)) {
            Object retVal = AopUtils.invokeJoinpointUsingReflection(this.delegate, mi.getMethod(), mi.getArguments());
            if (retVal == this.delegate && mi instanceof ProxyMethodInvocation) {
                Object proxy = ((ProxyMethodInvocation)mi).getProxy();
                if (mi.getMethod().getReturnType().isInstance(proxy)) {
                    retVal = proxy;
                }
            }
            return retVal;
        }
        return this.doProceed(mi);
    }

    protected Object doProceed(MethodInvocation mi) throws Throwable {
        return mi.proceed();
    }
}

