/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.springframework.context.event;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.evosuite.shaded.org.springframework.aop.support.AopUtils;
import org.evosuite.shaded.org.springframework.beans.factory.BeanFactory;
import org.evosuite.shaded.org.springframework.context.ApplicationEvent;
import org.evosuite.shaded.org.springframework.context.event.EventExpressionRootObject;
import org.evosuite.shaded.org.springframework.context.expression.AnnotatedElementKey;
import org.evosuite.shaded.org.springframework.context.expression.BeanFactoryResolver;
import org.evosuite.shaded.org.springframework.context.expression.CachedExpressionEvaluator;
import org.evosuite.shaded.org.springframework.context.expression.MethodBasedEvaluationContext;
import org.evosuite.shaded.org.springframework.expression.EvaluationContext;
import org.evosuite.shaded.org.springframework.expression.Expression;

class EventExpressionEvaluator
extends CachedExpressionEvaluator {
    private final Map<CachedExpressionEvaluator.ExpressionKey, Expression> conditionCache = new ConcurrentHashMap<CachedExpressionEvaluator.ExpressionKey, Expression>(64);
    private final Map<AnnotatedElementKey, Method> targetMethodCache = new ConcurrentHashMap<AnnotatedElementKey, Method>(64);

    EventExpressionEvaluator() {
    }

    public EvaluationContext createEvaluationContext(ApplicationEvent event, Class<?> targetClass, Method method, Object[] args, BeanFactory beanFactory) {
        Method targetMethod = this.getTargetMethod(targetClass, method);
        EventExpressionRootObject root = new EventExpressionRootObject(event, args);
        MethodBasedEvaluationContext evaluationContext = new MethodBasedEvaluationContext(root, targetMethod, args, this.getParameterNameDiscoverer());
        if (beanFactory != null) {
            evaluationContext.setBeanResolver(new BeanFactoryResolver(beanFactory));
        }
        return evaluationContext;
    }

    public boolean condition(String conditionExpression, AnnotatedElementKey elementKey, EvaluationContext evalContext) {
        return this.getExpression(this.conditionCache, elementKey, conditionExpression).getValue(evalContext, Boolean.TYPE);
    }

    private Method getTargetMethod(Class<?> targetClass, Method method) {
        AnnotatedElementKey methodKey = new AnnotatedElementKey(method, targetClass);
        Method targetMethod = this.targetMethodCache.get(methodKey);
        if (targetMethod == null) {
            targetMethod = AopUtils.getMostSpecificMethod(method, targetClass);
            this.targetMethodCache.put(methodKey, targetMethod);
        }
        return targetMethod;
    }
}

