/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.springframework.context.support;

import java.io.IOException;
import java.util.Properties;
import org.evosuite.shaded.org.springframework.beans.BeansException;
import org.evosuite.shaded.org.springframework.beans.factory.BeanInitializationException;
import org.evosuite.shaded.org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.evosuite.shaded.org.springframework.beans.factory.config.PlaceholderConfigurerSupport;
import org.evosuite.shaded.org.springframework.context.EnvironmentAware;
import org.evosuite.shaded.org.springframework.core.env.ConfigurablePropertyResolver;
import org.evosuite.shaded.org.springframework.core.env.Environment;
import org.evosuite.shaded.org.springframework.core.env.MutablePropertySources;
import org.evosuite.shaded.org.springframework.core.env.PropertiesPropertySource;
import org.evosuite.shaded.org.springframework.core.env.PropertySource;
import org.evosuite.shaded.org.springframework.core.env.PropertySources;
import org.evosuite.shaded.org.springframework.core.env.PropertySourcesPropertyResolver;
import org.evosuite.shaded.org.springframework.util.Assert;
import org.evosuite.shaded.org.springframework.util.StringValueResolver;

public class PropertySourcesPlaceholderConfigurer
extends PlaceholderConfigurerSupport
implements EnvironmentAware {
    public static final String LOCAL_PROPERTIES_PROPERTY_SOURCE_NAME = "localProperties";
    public static final String ENVIRONMENT_PROPERTIES_PROPERTY_SOURCE_NAME = "environmentProperties";
    private MutablePropertySources propertySources;
    private PropertySources appliedPropertySources;
    private Environment environment;

    public void setPropertySources(PropertySources propertySources) {
        this.propertySources = new MutablePropertySources(propertySources);
    }

    @Override
    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    @Override
    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (this.propertySources == null) {
            this.propertySources = new MutablePropertySources();
            if (this.environment != null) {
                this.propertySources.addLast(new PropertySource<Environment>(ENVIRONMENT_PROPERTIES_PROPERTY_SOURCE_NAME, this.environment){

                    @Override
                    public String getProperty(String key) {
                        return ((Environment)this.source).getProperty(key);
                    }
                });
            }
            try {
                PropertiesPropertySource localPropertySource = new PropertiesPropertySource(LOCAL_PROPERTIES_PROPERTY_SOURCE_NAME, this.mergeProperties());
                if (this.localOverride) {
                    this.propertySources.addFirst(localPropertySource);
                } else {
                    this.propertySources.addLast(localPropertySource);
                }
            }
            catch (IOException ex) {
                throw new BeanInitializationException("Could not load properties", ex);
            }
        }
        this.processProperties(beanFactory, new PropertySourcesPropertyResolver(this.propertySources));
        this.appliedPropertySources = this.propertySources;
    }

    protected void processProperties(ConfigurableListableBeanFactory beanFactoryToProcess, final ConfigurablePropertyResolver propertyResolver) throws BeansException {
        propertyResolver.setPlaceholderPrefix(this.placeholderPrefix);
        propertyResolver.setPlaceholderSuffix(this.placeholderSuffix);
        propertyResolver.setValueSeparator(this.valueSeparator);
        StringValueResolver valueResolver = new StringValueResolver(){

            @Override
            public String resolveStringValue(String strVal) {
                String resolved;
                String string = resolved = PropertySourcesPlaceholderConfigurer.this.ignoreUnresolvablePlaceholders ? propertyResolver.resolvePlaceholders(strVal) : propertyResolver.resolveRequiredPlaceholders(strVal);
                if (PropertySourcesPlaceholderConfigurer.this.trimValues) {
                    resolved = resolved.trim();
                }
                return resolved.equals(PropertySourcesPlaceholderConfigurer.this.nullValue) ? null : resolved;
            }
        };
        this.doProcessProperties(beanFactoryToProcess, valueResolver);
    }

    @Override
    @Deprecated
    protected void processProperties(ConfigurableListableBeanFactory beanFactory, Properties props) {
        throw new UnsupportedOperationException("Call processProperties(ConfigurableListableBeanFactory, ConfigurablePropertyResolver) instead");
    }

    public PropertySources getAppliedPropertySources() throws IllegalStateException {
        Assert.state(this.appliedPropertySources != null, "PropertySources have not get been applied");
        return this.appliedPropertySources;
    }
}

