/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.springframework.jdbc.datasource.embedded;

import org.evosuite.shaded.org.springframework.jdbc.datasource.embedded.DerbyEmbeddedDatabaseConfigurer;
import org.evosuite.shaded.org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseConfigurer;
import org.evosuite.shaded.org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseType;
import org.evosuite.shaded.org.springframework.jdbc.datasource.embedded.H2EmbeddedDatabaseConfigurer;
import org.evosuite.shaded.org.springframework.jdbc.datasource.embedded.HsqlEmbeddedDatabaseConfigurer;
import org.evosuite.shaded.org.springframework.util.Assert;

final class EmbeddedDatabaseConfigurerFactory {
    public static EmbeddedDatabaseConfigurer getConfigurer(EmbeddedDatabaseType type) throws IllegalStateException {
        Assert.notNull((Object)type, "EmbeddedDatabaseType is required");
        try {
            switch (type) {
                case HSQL: {
                    return HsqlEmbeddedDatabaseConfigurer.getInstance();
                }
                case H2: {
                    return H2EmbeddedDatabaseConfigurer.getInstance();
                }
                case DERBY: {
                    return DerbyEmbeddedDatabaseConfigurer.getInstance();
                }
            }
            throw new UnsupportedOperationException("Embedded database type [" + (Object)((Object)type) + "] is not supported");
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException("Driver for test database type [" + (Object)((Object)type) + "] is not available in the classpath", ex);
        }
    }

    private EmbeddedDatabaseConfigurerFactory() {
    }
}

