/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.springframework.jdbc.datasource.init;

import javax.sql.DataSource;
import org.evosuite.shaded.org.springframework.beans.factory.DisposableBean;
import org.evosuite.shaded.org.springframework.beans.factory.InitializingBean;
import org.evosuite.shaded.org.springframework.jdbc.datasource.init.DatabasePopulator;
import org.evosuite.shaded.org.springframework.jdbc.datasource.init.DatabasePopulatorUtils;
import org.evosuite.shaded.org.springframework.util.Assert;

public class DataSourceInitializer
implements InitializingBean,
DisposableBean {
    private DataSource dataSource;
    private DatabasePopulator databasePopulator;
    private DatabasePopulator databaseCleaner;
    private boolean enabled = true;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setDatabasePopulator(DatabasePopulator databasePopulator) {
        this.databasePopulator = databasePopulator;
    }

    public void setDatabaseCleaner(DatabasePopulator databaseCleaner) {
        this.databaseCleaner = databaseCleaner;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public void afterPropertiesSet() {
        this.execute(this.databasePopulator);
    }

    @Override
    public void destroy() {
        this.execute(this.databaseCleaner);
    }

    private void execute(DatabasePopulator populator) {
        Assert.state(this.dataSource != null, "DataSource must be set");
        if (this.enabled && populator != null) {
            DatabasePopulatorUtils.execute(populator, this.dataSource);
        }
    }
}

