/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.springframework.jdbc.support;

import java.util.Collections;
import java.util.Map;
import javax.sql.DataSource;
import org.evosuite.shaded.org.apache.commons.logging.Log;
import org.evosuite.shaded.org.apache.commons.logging.LogFactory;
import org.evosuite.shaded.org.springframework.beans.BeansException;
import org.evosuite.shaded.org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.evosuite.shaded.org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.evosuite.shaded.org.springframework.core.io.ClassPathResource;
import org.evosuite.shaded.org.springframework.core.io.Resource;
import org.evosuite.shaded.org.springframework.jdbc.support.CustomSQLExceptionTranslatorRegistry;
import org.evosuite.shaded.org.springframework.jdbc.support.JdbcUtils;
import org.evosuite.shaded.org.springframework.jdbc.support.MetaDataAccessException;
import org.evosuite.shaded.org.springframework.jdbc.support.SQLErrorCodes;
import org.evosuite.shaded.org.springframework.jdbc.support.SQLExceptionTranslator;
import org.evosuite.shaded.org.springframework.util.Assert;
import org.evosuite.shaded.org.springframework.util.ConcurrentReferenceHashMap;
import org.evosuite.shaded.org.springframework.util.PatternMatchUtils;

public class SQLErrorCodesFactory {
    public static final String SQL_ERROR_CODE_OVERRIDE_PATH = "sql-error-codes.xml";
    public static final String SQL_ERROR_CODE_DEFAULT_PATH = "org/evosuite/shaded/org/springframework/jdbc/support/sql-error-codes.xml";
    private static final Log logger = LogFactory.getLog(SQLErrorCodesFactory.class);
    private static final SQLErrorCodesFactory instance = new SQLErrorCodesFactory();
    private final Map<String, SQLErrorCodes> errorCodesMap;
    private final Map<DataSource, SQLErrorCodes> dataSourceCache = new ConcurrentReferenceHashMap<DataSource, SQLErrorCodes>(16);

    public static SQLErrorCodesFactory getInstance() {
        return instance;
    }

    protected SQLErrorCodesFactory() {
        Map<Object, Object> errorCodes;
        try {
            DefaultListableBeanFactory lbf = new DefaultListableBeanFactory();
            lbf.setBeanClassLoader(this.getClass().getClassLoader());
            XmlBeanDefinitionReader bdr = new XmlBeanDefinitionReader(lbf);
            Resource resource = this.loadResource(SQL_ERROR_CODE_DEFAULT_PATH);
            if (resource != null && resource.exists()) {
                bdr.loadBeanDefinitions(resource);
            } else {
                logger.warn("Default sql-error-codes.xml not found (should be included in spring.jar)");
            }
            resource = this.loadResource(SQL_ERROR_CODE_OVERRIDE_PATH);
            if (resource != null && resource.exists()) {
                bdr.loadBeanDefinitions(resource);
                logger.info("Found custom sql-error-codes.xml file at the root of the classpath");
            }
            errorCodes = lbf.getBeansOfType(SQLErrorCodes.class, true, false);
            if (logger.isInfoEnabled()) {
                logger.info("SQLErrorCodes loaded: " + errorCodes.keySet());
            }
        }
        catch (BeansException ex) {
            logger.warn("Error loading SQL error codes from config file", ex);
            errorCodes = Collections.emptyMap();
        }
        this.errorCodesMap = errorCodes;
    }

    protected Resource loadResource(String path) {
        return new ClassPathResource(path, this.getClass().getClassLoader());
    }

    public SQLErrorCodes getErrorCodes(String databaseName) {
        Assert.notNull(databaseName, "Database product name must not be null");
        SQLErrorCodes sec = this.errorCodesMap.get(databaseName);
        if (sec == null) {
            for (SQLErrorCodes candidate : this.errorCodesMap.values()) {
                if (!PatternMatchUtils.simpleMatch(candidate.getDatabaseProductNames(), databaseName)) continue;
                sec = candidate;
                break;
            }
        }
        if (sec != null) {
            this.checkCustomTranslatorRegistry(databaseName, sec);
            if (logger.isDebugEnabled()) {
                logger.debug("SQL error codes for '" + databaseName + "' found");
            }
            return sec;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("SQL error codes for '" + databaseName + "' not found");
        }
        return new SQLErrorCodes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLErrorCodes getErrorCodes(DataSource dataSource) {
        SQLErrorCodes sec;
        Assert.notNull(dataSource, "DataSource must not be null");
        if (logger.isDebugEnabled()) {
            logger.debug("Looking up default SQLErrorCodes for DataSource [" + this.identify(dataSource) + "]");
        }
        if ((sec = this.dataSourceCache.get(dataSource)) == null) {
            Map<DataSource, SQLErrorCodes> map = this.dataSourceCache;
            synchronized (map) {
                sec = this.dataSourceCache.get(dataSource);
                if (sec == null) {
                    try {
                        String name = (String)JdbcUtils.extractDatabaseMetaData(dataSource, "getDatabaseProductName");
                        if (name != null) {
                            return this.registerDatabase(dataSource, name);
                        }
                    }
                    catch (MetaDataAccessException ex) {
                        logger.warn("Error while extracting database name - falling back to empty error codes", ex);
                    }
                    return new SQLErrorCodes();
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("SQLErrorCodes found in cache for DataSource [" + this.identify(dataSource) + "]");
        }
        return sec;
    }

    public SQLErrorCodes registerDatabase(DataSource dataSource, String databaseName) {
        SQLErrorCodes sec = this.getErrorCodes(databaseName);
        if (logger.isDebugEnabled()) {
            logger.debug("Caching SQL error codes for DataSource [" + this.identify(dataSource) + "]: database product name is '" + databaseName + "'");
        }
        this.dataSourceCache.put(dataSource, sec);
        return sec;
    }

    public SQLErrorCodes unregisterDatabase(DataSource dataSource) {
        return this.dataSourceCache.remove(dataSource);
    }

    private String identify(DataSource dataSource) {
        return dataSource.getClass().getName() + '@' + Integer.toHexString(dataSource.hashCode());
    }

    private void checkCustomTranslatorRegistry(String databaseName, SQLErrorCodes errorCodes) {
        SQLExceptionTranslator customTranslator = CustomSQLExceptionTranslatorRegistry.getInstance().findTranslatorForDatabase(databaseName);
        if (customTranslator != null) {
            if (errorCodes.getCustomSqlExceptionTranslator() != null && logger.isWarnEnabled()) {
                logger.warn("Overriding already defined custom translator '" + errorCodes.getCustomSqlExceptionTranslator().getClass().getSimpleName() + " with '" + customTranslator.getClass().getSimpleName() + "' found in the CustomSQLExceptionTranslatorRegistry for database '" + databaseName + "'");
            } else if (logger.isInfoEnabled()) {
                logger.info("Using custom translator '" + customTranslator.getClass().getSimpleName() + "' found in the CustomSQLExceptionTranslatorRegistry for database '" + databaseName + "'");
            }
            errorCodes.setCustomSqlExceptionTranslator(customTranslator);
        }
    }
}

