/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.springframework.orm.hibernate4.support;

import org.evosuite.shaded.org.apache.commons.logging.Log;
import org.evosuite.shaded.org.apache.commons.logging.LogFactory;
import org.evosuite.shaded.org.hibernate.FlushMode;
import org.evosuite.shaded.org.hibernate.HibernateException;
import org.evosuite.shaded.org.hibernate.Session;
import org.evosuite.shaded.org.hibernate.SessionFactory;
import org.evosuite.shaded.org.springframework.dao.DataAccessException;
import org.evosuite.shaded.org.springframework.dao.DataAccessResourceFailureException;
import org.evosuite.shaded.org.springframework.orm.hibernate4.SessionFactoryUtils;
import org.evosuite.shaded.org.springframework.orm.hibernate4.SessionHolder;
import org.evosuite.shaded.org.springframework.orm.hibernate4.support.AsyncRequestInterceptor;
import org.evosuite.shaded.org.springframework.transaction.support.TransactionSynchronizationManager;
import org.evosuite.shaded.org.springframework.ui.ModelMap;
import org.evosuite.shaded.org.springframework.web.context.request.AsyncWebRequestInterceptor;
import org.evosuite.shaded.org.springframework.web.context.request.WebRequest;
import org.evosuite.shaded.org.springframework.web.context.request.async.CallableProcessingInterceptor;
import org.evosuite.shaded.org.springframework.web.context.request.async.DeferredResultProcessingInterceptor;
import org.evosuite.shaded.org.springframework.web.context.request.async.WebAsyncManager;
import org.evosuite.shaded.org.springframework.web.context.request.async.WebAsyncUtils;

public class OpenSessionInViewInterceptor
implements AsyncWebRequestInterceptor {
    public static final String PARTICIPATE_SUFFIX = ".PARTICIPATE";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private SessionFactory sessionFactory;

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void preHandle(WebRequest request) throws DataAccessException {
        String participateAttributeName = this.getParticipateAttributeName();
        WebAsyncManager asyncManager = WebAsyncUtils.getAsyncManager((WebRequest)request);
        if (asyncManager.hasConcurrentResult() && this.applySessionBindingInterceptor(asyncManager, participateAttributeName)) {
            return;
        }
        if (TransactionSynchronizationManager.hasResource(this.getSessionFactory())) {
            Integer count = (Integer)request.getAttribute(participateAttributeName, 0);
            int newCount = count != null ? count + 1 : 1;
            request.setAttribute(this.getParticipateAttributeName(), (Object)newCount, 0);
        } else {
            this.logger.debug("Opening Hibernate Session in OpenSessionInViewInterceptor");
            Session session = this.openSession();
            SessionHolder sessionHolder = new SessionHolder(session);
            TransactionSynchronizationManager.bindResource(this.getSessionFactory(), sessionHolder);
            AsyncRequestInterceptor asyncRequestInterceptor = new AsyncRequestInterceptor(this.getSessionFactory(), sessionHolder);
            asyncManager.registerCallableInterceptor((Object)participateAttributeName, (CallableProcessingInterceptor)asyncRequestInterceptor);
            asyncManager.registerDeferredResultInterceptor((Object)participateAttributeName, (DeferredResultProcessingInterceptor)asyncRequestInterceptor);
        }
    }

    public void postHandle(WebRequest request, ModelMap model) {
    }

    public void afterCompletion(WebRequest request, Exception ex) throws DataAccessException {
        if (!this.decrementParticipateCount(request)) {
            SessionHolder sessionHolder = (SessionHolder)TransactionSynchronizationManager.unbindResource(this.getSessionFactory());
            this.logger.debug("Closing Hibernate Session in OpenSessionInViewInterceptor");
            SessionFactoryUtils.closeSession(sessionHolder.getSession());
        }
    }

    private boolean decrementParticipateCount(WebRequest request) {
        String participateAttributeName = this.getParticipateAttributeName();
        Integer count = (Integer)request.getAttribute(participateAttributeName, 0);
        if (count == null) {
            return false;
        }
        if (count > 1) {
            request.setAttribute(participateAttributeName, (Object)(count - 1), 0);
        } else {
            request.removeAttribute(participateAttributeName, 0);
        }
        return true;
    }

    public void afterConcurrentHandlingStarted(WebRequest request) {
        if (!this.decrementParticipateCount(request)) {
            TransactionSynchronizationManager.unbindResource(this.getSessionFactory());
        }
    }

    protected Session openSession() throws DataAccessResourceFailureException {
        try {
            Session session = this.getSessionFactory().openSession();
            session.setFlushMode(FlushMode.MANUAL);
            return session;
        }
        catch (HibernateException ex) {
            throw new DataAccessResourceFailureException("Could not open Hibernate Session", ex);
        }
    }

    protected String getParticipateAttributeName() {
        return this.getSessionFactory().toString() + PARTICIPATE_SUFFIX;
    }

    private boolean applySessionBindingInterceptor(WebAsyncManager asyncManager, String key) {
        if (asyncManager.getCallableInterceptor((Object)key) == null) {
            return false;
        }
        ((AsyncRequestInterceptor)asyncManager.getCallableInterceptor((Object)key)).bindSession();
        return true;
    }
}

