/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.springframework.orm.jdo.support;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Query;
import org.evosuite.shaded.org.springframework.beans.factory.FactoryBean;
import org.evosuite.shaded.org.springframework.beans.factory.InitializingBean;
import org.evosuite.shaded.org.springframework.orm.jdo.DefaultJdoDialect;
import org.evosuite.shaded.org.springframework.orm.jdo.JdoDialect;
import org.evosuite.shaded.org.springframework.orm.jdo.PersistenceManagerFactoryUtils;
import org.evosuite.shaded.org.springframework.util.Assert;

public class SpringPersistenceManagerProxyBean
implements FactoryBean<PersistenceManager>,
InitializingBean {
    private PersistenceManagerFactory persistenceManagerFactory;
    private JdoDialect jdoDialect;
    private Class<? extends PersistenceManager> persistenceManagerInterface = PersistenceManager.class;
    private boolean allowCreate = true;
    private PersistenceManager proxy;

    public void setPersistenceManagerFactory(PersistenceManagerFactory persistenceManagerFactory) {
        this.persistenceManagerFactory = persistenceManagerFactory;
    }

    protected PersistenceManagerFactory getPersistenceManagerFactory() {
        return this.persistenceManagerFactory;
    }

    public void setJdoDialect(JdoDialect jdoDialect) {
        this.jdoDialect = jdoDialect;
    }

    protected JdoDialect getJdoDialect() {
        return this.jdoDialect;
    }

    public void setPersistenceManagerInterface(Class<? extends PersistenceManager> persistenceManagerInterface) {
        this.persistenceManagerInterface = persistenceManagerInterface;
        Assert.notNull(persistenceManagerInterface, "persistenceManagerInterface must not be null");
        Assert.isAssignable(PersistenceManager.class, persistenceManagerInterface);
    }

    protected Class<? extends PersistenceManager> getPersistenceManagerInterface() {
        return this.persistenceManagerInterface;
    }

    public void setAllowCreate(boolean allowCreate) {
        this.allowCreate = allowCreate;
    }

    protected boolean isAllowCreate() {
        return this.allowCreate;
    }

    @Override
    public void afterPropertiesSet() {
        if (this.getPersistenceManagerFactory() == null) {
            throw new IllegalArgumentException("Property 'persistenceManagerFactory' is required");
        }
        if (this.jdoDialect == null) {
            this.jdoDialect = new DefaultJdoDialect(this.getPersistenceManagerFactory().getConnectionFactory());
        }
        this.proxy = (PersistenceManager)Proxy.newProxyInstance(this.getPersistenceManagerFactory().getClass().getClassLoader(), new Class[]{this.getPersistenceManagerInterface()}, (InvocationHandler)new PersistenceManagerInvocationHandler());
    }

    @Override
    public PersistenceManager getObject() {
        return this.proxy;
    }

    @Override
    public Class<? extends PersistenceManager> getObjectType() {
        return this.getPersistenceManagerInterface();
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    private class PersistenceManagerInvocationHandler
    implements InvocationHandler {
        private PersistenceManagerInvocationHandler() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("equals")) {
                return proxy == args[0];
            }
            if (method.getName().equals("hashCode")) {
                return System.identityHashCode(proxy);
            }
            if (method.getName().equals("toString")) {
                return "Spring PersistenceManager proxy for target factory [" + SpringPersistenceManagerProxyBean.this.getPersistenceManagerFactory() + "]";
            }
            if (method.getName().equals("getPersistenceManagerFactory")) {
                return SpringPersistenceManagerProxyBean.this.getPersistenceManagerFactory();
            }
            if (method.getName().equals("isClosed")) {
                return false;
            }
            if (method.getName().equals("close")) {
                return null;
            }
            PersistenceManager pm = PersistenceManagerFactoryUtils.doGetPersistenceManager(SpringPersistenceManagerProxyBean.this.getPersistenceManagerFactory(), SpringPersistenceManagerProxyBean.this.isAllowCreate());
            try {
                Object retVal = method.invoke((Object)pm, args);
                if (retVal instanceof Query) {
                    PersistenceManagerFactoryUtils.applyTransactionTimeout((Query)retVal, SpringPersistenceManagerProxyBean.this.getPersistenceManagerFactory());
                }
                Object object = retVal;
                return object;
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
            finally {
                PersistenceManagerFactoryUtils.doReleasePersistenceManager(pm, SpringPersistenceManagerProxyBean.this.getPersistenceManagerFactory());
            }
        }
    }
}

