/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.springframework.orm.jpa.support;

import java.util.concurrent.Callable;
import javax.persistence.EntityManagerFactory;
import org.evosuite.shaded.org.apache.commons.logging.Log;
import org.evosuite.shaded.org.apache.commons.logging.LogFactory;
import org.evosuite.shaded.org.springframework.orm.jpa.EntityManagerFactoryUtils;
import org.evosuite.shaded.org.springframework.orm.jpa.EntityManagerHolder;
import org.evosuite.shaded.org.springframework.transaction.support.TransactionSynchronizationManager;
import org.evosuite.shaded.org.springframework.web.context.request.NativeWebRequest;
import org.evosuite.shaded.org.springframework.web.context.request.async.CallableProcessingInterceptorAdapter;
import org.evosuite.shaded.org.springframework.web.context.request.async.DeferredResult;
import org.evosuite.shaded.org.springframework.web.context.request.async.DeferredResultProcessingInterceptor;

class AsyncRequestInterceptor
extends CallableProcessingInterceptorAdapter
implements DeferredResultProcessingInterceptor {
    private static final Log logger = LogFactory.getLog(AsyncRequestInterceptor.class);
    private final EntityManagerFactory emFactory;
    private final EntityManagerHolder emHolder;
    private volatile boolean timeoutInProgress;

    public AsyncRequestInterceptor(EntityManagerFactory emFactory, EntityManagerHolder emHolder) {
        this.emFactory = emFactory;
        this.emHolder = emHolder;
    }

    public <T> void preProcess(NativeWebRequest request, Callable<T> task) {
        this.bindSession();
    }

    public void bindSession() {
        this.timeoutInProgress = false;
        TransactionSynchronizationManager.bindResource(this.emFactory, this.emHolder);
    }

    public <T> void postProcess(NativeWebRequest request, Callable<T> task, Object concurrentResult) {
        TransactionSynchronizationManager.unbindResource(this.emFactory);
    }

    public <T> Object handleTimeout(NativeWebRequest request, Callable<T> task) {
        this.timeoutInProgress = true;
        return RESULT_NONE;
    }

    public <T> void afterCompletion(NativeWebRequest request, Callable<T> task) throws Exception {
        this.closeAfterTimeout();
    }

    private void closeAfterTimeout() {
        if (this.timeoutInProgress) {
            logger.debug("Closing JPA EntityManager after async request timeout");
            EntityManagerFactoryUtils.closeEntityManager(this.emHolder.getEntityManager());
        }
    }

    public <T> void beforeConcurrentHandling(NativeWebRequest request, DeferredResult<T> deferredResult) {
    }

    public <T> void preProcess(NativeWebRequest request, DeferredResult<T> deferredResult) {
    }

    public <T> void postProcess(NativeWebRequest request, DeferredResult<T> deferredResult, Object result) {
    }

    public <T> boolean handleTimeout(NativeWebRequest request, DeferredResult<T> deferredResult) {
        this.timeoutInProgress = true;
        return true;
    }

    public <T> void afterCompletion(NativeWebRequest request, DeferredResult<T> deferredResult) {
        this.closeAfterTimeout();
    }
}

