/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.springframework.orm.jpa.vendor;

import java.sql.Connection;
import java.sql.SQLException;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceException;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.evosuite.shaded.org.springframework.jdbc.datasource.ConnectionHandle;
import org.evosuite.shaded.org.springframework.orm.jpa.DefaultJpaDialect;
import org.evosuite.shaded.org.springframework.transaction.TransactionDefinition;
import org.evosuite.shaded.org.springframework.transaction.TransactionException;

public class EclipseLinkJpaDialect
extends DefaultJpaDialect {
    private boolean lazyDatabaseTransaction = false;

    public void setLazyDatabaseTransaction(boolean lazyDatabaseTransaction) {
        this.lazyDatabaseTransaction = lazyDatabaseTransaction;
    }

    @Override
    public Object beginTransaction(EntityManager entityManager, TransactionDefinition definition) throws PersistenceException, SQLException, TransactionException {
        if (definition.getIsolationLevel() != -1) {
            UnitOfWork uow = entityManager.unwrap(UnitOfWork.class);
            uow.getLogin().setTransactionIsolation(definition.getIsolationLevel());
        }
        entityManager.getTransaction().begin();
        if (!definition.isReadOnly() && !this.lazyDatabaseTransaction) {
            entityManager.unwrap(UnitOfWork.class).beginEarlyTransaction();
        }
        return null;
    }

    @Override
    public ConnectionHandle getJdbcConnection(EntityManager entityManager, boolean readOnly) throws PersistenceException, SQLException {
        return new EclipseLinkConnectionHandle(entityManager);
    }

    private static class EclipseLinkConnectionHandle
    implements ConnectionHandle {
        private final EntityManager entityManager;
        private Connection connection;

        public EclipseLinkConnectionHandle(EntityManager entityManager) {
            this.entityManager = entityManager;
        }

        @Override
        public Connection getConnection() {
            if (this.connection == null) {
                this.connection = this.entityManager.unwrap(Connection.class);
            }
            return this.connection;
        }

        @Override
        public void releaseConnection(Connection con) {
        }
    }
}

