/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.shaded.org.springframework.validation;

import org.evosuite.shaded.org.springframework.context.support.DefaultMessageSourceResolvable;
import org.evosuite.shaded.org.springframework.util.Assert;

public class ObjectError
extends DefaultMessageSourceResolvable {
    private final String objectName;

    public ObjectError(String objectName, String defaultMessage) {
        this(objectName, null, null, defaultMessage);
    }

    public ObjectError(String objectName, String[] codes, Object[] arguments, String defaultMessage) {
        super(codes, arguments, defaultMessage);
        Assert.notNull(objectName, "Object name must not be null");
        this.objectName = objectName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    @Override
    public String toString() {
        return "Error in object '" + this.objectName + "': " + this.resolvableToString();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || other.getClass() != this.getClass() || !super.equals(other)) {
            return false;
        }
        ObjectError otherError = (ObjectError)other;
        return this.getObjectName().equals(otherError.getObjectName());
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 29 + this.getObjectName().hashCode();
    }
}

