/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.maven;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.evosuite.continuous.ContinuousTestGeneration;

@Mojo(name="export")
public class ExportMojo
extends AbstractMojo {
    @Parameter(property="targetFolder", defaultValue="src/test/java")
    private String targetFolder;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Exporting tests");
        File basedir = this.project.getBasedir();
        try {
            boolean exported = ContinuousTestGeneration.exportToFolder((String)basedir.getAbsolutePath(), (String)this.targetFolder);
            if (!exported) {
                this.getLog().info((CharSequence)"Nothing to export");
                return;
            }
        }
        catch (IOException e) {
            String msg = "Error while exporting tests: " + e.getMessage();
            this.getLog().error((CharSequence)msg);
            throw new MojoFailureException(msg);
        }
        File target = ContinuousTestGeneration.resolveExportFolder((String)basedir.getAbsolutePath(), (String)this.targetFolder);
        this.getLog().info((CharSequence)("Exported tests to " + target));
    }
}

