/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.maven;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.eclipse.aether.RepositorySystemSession;
import org.evosuite.Properties;
import org.evosuite.maven.util.EvoSuiteRunner;
import org.evosuite.maven.util.FileUtils;
import org.evosuite.maven.util.HistoryChanges;
import org.evosuite.utils.SpawnProcessKeepAliveChecker;

@Mojo(name="generate", requiresDependencyResolution=ResolutionScope.TEST, requiresDependencyCollection=ResolutionScope.TEST)
@Execute(phase=LifecyclePhase.COMPILE)
public class GenerateMojo
extends AbstractMojo {
    @Parameter(property="memoryInMB", defaultValue="800")
    private int memoryInMB;
    @Parameter(property="cores", defaultValue="1")
    private int numberOfCores;
    @Parameter(property="cuts")
    private String cuts;
    @Parameter(property="cutsFile")
    private String cutsFile;
    @Parameter(property="timeInMinutesPerClass", defaultValue="2")
    private int timeInMinutesPerClass;
    @Parameter(property="timeInMinutesPerProject", defaultValue="0")
    private int timeInMinutesPerProject;
    @Parameter(property="criterion", defaultValue="LINE:BRANCH:EXCEPTION:WEAKMUTATION:OUTPUT:METHOD:METHODNOEXCEPTION:CBRANCH")
    private String criterion;
    @Parameter(property="spawnManagerPort", defaultValue="")
    private Integer spawnManagerPort;
    @Parameter(property="extraArgs", defaultValue="")
    private String extraArgs;
    @Parameter(property="schedule", defaultValue="BUDGET")
    private String schedule;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${plugin.artifacts}", required=true, readonly=true)
    private List<Artifact> artifacts;
    @Component
    private ProjectBuilder projectBuilder;
    @Parameter(defaultValue="${repositorySystemSession}", required=true, readonly=true)
    private RepositorySystemSession repoSession;
    private String[] includes = new String[]{"**/*.java"};
    private String[] excludes;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Going to generate tests with EvoSuite");
        this.getLog().info((CharSequence)("Total memory: " + this.memoryInMB + "mb"));
        this.getLog().info((CharSequence)("Time per class: " + this.timeInMinutesPerClass + " minutes"));
        this.getLog().info((CharSequence)("Number of used cores: " + this.numberOfCores));
        if (this.cuts != null) {
            this.getLog().info((CharSequence)("Specified classes under test: " + this.cuts));
        }
        String target = null;
        String cp = null;
        try {
            for (String element : this.project.getCompileClasspathElements()) {
                File file;
                if (element.endsWith(".jar") || !(file = new File(element)).exists() || !file.getAbsolutePath().startsWith(this.project.getBasedir().getAbsolutePath())) continue;
                if (target == null) {
                    target = element;
                    continue;
                }
                target = target + File.pathSeparator + element;
            }
            HashSet<String> alreadyAdded = new HashSet<String>();
            for (String element : this.project.getTestClasspathElements()) {
                if (element.toLowerCase().contains("powermock")) {
                    this.getLog().warn((CharSequence)("Skipping PowerMock dependency at: " + element));
                    continue;
                }
                if (element.toLowerCase().contains("jmockit")) {
                    this.getLog().warn((CharSequence)("Skipping JMockit dependency at: " + element));
                    continue;
                }
                this.getLog().debug((CharSequence)("TEST ELEMENT: " + element));
                cp = this.addPathIfExists(cp, element, alreadyAdded);
            }
        }
        catch (DependencyResolutionRequiredException e) {
            this.getLog().error((CharSequence)("Error: " + e.getMessage()), (Throwable)e);
            return;
        }
        File basedir = this.project.getBasedir();
        this.getLog().info((CharSequence)("Target: " + target));
        this.getLog().debug((CharSequence)("Classpath: " + cp));
        this.getLog().info((CharSequence)("Basedir: " + basedir.getAbsolutePath()));
        if (target == null || cp == null || basedir == null) {
            this.getLog().info((CharSequence)"Nothing to test");
            return;
        }
        this.runEvoSuiteOnSeparatedProcess(target, cp, basedir.getAbsolutePath());
    }

    private String addPathIfExists(String cp, String element, Set<String> alreadyExist) {
        File file = new File(element);
        if (!file.exists()) {
            return cp;
        }
        if (alreadyExist.contains(element)) {
            return cp;
        }
        alreadyExist.add(element);
        cp = cp == null ? element : cp + File.pathSeparator + element;
        return cp;
    }

    private void runEvoSuiteOnSeparatedProcess(String target, String cp, String dir) throws MojoFailureException {
        int port;
        ArrayList<String> params = new ArrayList<String>();
        params.add("-continuous");
        params.add("execute");
        params.add("-target");
        params.add(target);
        params.add("-Dcriterion=" + this.criterion);
        params.add("-Dctg_schedule=" + this.schedule);
        if (this.schedule.toUpperCase().equals(Properties.AvailableSchedule.HISTORY.toString())) {
            try {
                List<File> files = FileUtils.scan(this.project.getCompileSourceRoots(), this.includes, this.excludes);
                HistoryChanges.keepTrack(dir, files);
            }
            catch (Exception e) {
                throw new MojoFailureException("", (Throwable)e);
            }
            params.add("-Dctg_history_file=" + dir + File.separator + Properties.CTG_DIR + File.separator + "history_file");
        }
        params.add("-Dctg_memory=" + this.memoryInMB);
        params.add("-Dctg_cores=" + this.numberOfCores);
        if (this.spawnManagerPort != null) {
            SpawnProcessKeepAliveChecker.getInstance().registerToRemoteServerAndDieIfFails(this.spawnManagerPort.intValue());
            port = this.spawnManagerPort;
        } else {
            port = SpawnProcessKeepAliveChecker.getInstance().startServer();
        }
        params.add("-Dspawn_process_manager_port=" + port);
        if (this.timeInMinutesPerProject != 0) {
            params.add("-Dctg_time=" + this.timeInMinutesPerProject);
            params.add("-Dctg_min_time_per_job=" + this.timeInMinutesPerClass);
        } else {
            params.add("-Dctg_time_per_class=" + this.timeInMinutesPerClass);
        }
        if (this.cuts != null) {
            params.add("-Dctg_selected_cuts=" + this.cuts);
        }
        if (this.cutsFile != null) {
            params.add("-Dctg_selected_cuts_file_location=" + this.cutsFile);
        }
        if (this.extraArgs != null && !this.extraArgs.isEmpty()) {
            String[] tokens;
            String args = "";
            for (String token : tokens = this.extraArgs.split(" ")) {
                if ((token = token.trim()).isEmpty()) continue;
                if (!token.startsWith("-D")) {
                    this.getLog().error((CharSequence)("Invalid extra argument \"" + token + "\". It should start with a -D"));
                    continue;
                }
                args = args + " " + token;
            }
            params.add("-Dctg_extra_args=\"" + args + "\"");
        }
        String path = this.writeClasspathToFile(cp);
        params.add("-DCP_file_path=" + path);
        EvoSuiteRunner runner = new EvoSuiteRunner(this.getLog(), this.artifacts, this.projectBuilder, this.repoSession);
        runner.registerShutDownHook();
        boolean ok = runner.runEvoSuite(dir, params);
        if (this.spawnManagerPort != null) {
            SpawnProcessKeepAliveChecker.getInstance().unRegister();
        } else {
            SpawnProcessKeepAliveChecker.getInstance().stopServer();
        }
        if (!ok) {
            throw new MojoFailureException("Failed to correctly execute EvoSuite");
        }
    }

    private String writeClasspathToFile(String classpath) {
        try {
            File file = File.createTempFile("EvoSuite_classpathFile", ".txt");
            file.deleteOnExit();
            BufferedWriter out = new BufferedWriter(new FileWriter(file));
            String line = classpath;
            out.write(line);
            out.newLine();
            out.close();
            return file.getAbsolutePath();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to create tmp file for classpath specification: " + e.getMessage());
        }
    }
}

