/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.maven.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.eclipse.aether.RepositorySystemSession;
import org.evosuite.EvoSuite;
import org.evosuite.runtime.util.JavaExecCmdUtil;

public class EvoSuiteRunner {
    public static final String EVOSUITE_HOME_VARIABLE = "EVOSUITE_HOME";
    private final Log logger;
    private final List<Artifact> artifacts;
    private final ProjectBuilder projectBuilder;
    private final RepositorySystemSession repoSession;
    private Process process;

    public EvoSuiteRunner(Log logger, List<Artifact> artifacts, ProjectBuilder projectBuilder, RepositorySystemSession repoSession) {
        this.logger = logger;
        this.artifacts = artifacts;
        this.projectBuilder = projectBuilder;
        this.repoSession = repoSession;
    }

    public void registerShutDownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                if (EvoSuiteRunner.this.process != null) {
                    EvoSuiteRunner.this.process.destroy();
                }
            }
        });
    }

    public boolean runEvoSuite(String dir, List<String> params) {
        List<String> cmd = this.getCommandToRunEvoSuite();
        if (cmd == null) {
            return false;
        }
        cmd.addAll(params);
        return this.runProcess(dir, cmd);
    }

    private List<String> getCommandToRunEvoSuite() {
        ProjectBuildingResult res;
        this.logger.debug((CharSequence)("EvoSuite Maven Plugin Artifacts: " + Arrays.toString(this.artifacts.toArray())));
        Artifact evosuite = null;
        for (Artifact art : this.artifacts) {
            if (!art.getArtifactId().equals("evosuite-master")) continue;
            evosuite = art;
            break;
        }
        if (evosuite == null) {
            this.logger.error((CharSequence)"CRITICAL ERROR: plugin can detect EvoSuite executable");
            return null;
        }
        this.logger.debug((CharSequence)("EvoSuite located at: " + evosuite.getFile()));
        DefaultProjectBuildingRequest req = new DefaultProjectBuildingRequest();
        req.setRepositorySession(this.repoSession);
        req.setValidationLevel(0);
        req.setSystemProperties(System.getProperties());
        req.setResolveDependencies(true);
        try {
            res = this.projectBuilder.build(evosuite, (ProjectBuildingRequest)req);
        }
        catch (ProjectBuildingException e) {
            this.logger.error((CharSequence)("Failed: " + e.getMessage()), (Throwable)e);
            return null;
        }
        String cp = evosuite.getFile().getAbsolutePath();
        for (Artifact dep : res.getProject().getArtifacts()) {
            cp = cp + File.pathSeparator + dep.getFile().getAbsolutePath();
        }
        this.logger.debug((CharSequence)("EvoSuite classpath: " + cp));
        String entryPoint = EvoSuite.class.getName();
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(JavaExecCmdUtil.getJavaBinExecutablePath());
        cmd.add("-Duse_different_logback=logback-ctg-entry.xml");
        cmd.add("-Dlogback.configurationFile=logback-ctg-entry.xml");
        cmd.add("-cp");
        cmd.add(cp);
        cmd.add(entryPoint);
        return cmd;
    }

    @Deprecated
    private List<String> getCommandToRunExternalEvoSuite() {
        String home = System.getenv(EVOSUITE_HOME_VARIABLE);
        if (home == null || home.isEmpty()) {
            this.logger.error((CharSequence)"Need to set the environment variable EVOSUITE_HOME pointing to where EvoSuite is installed");
            return null;
        }
        File folder = new File(home);
        if (!folder.exists()) {
            this.logger.error((CharSequence)("EvoSuite home " + home + " does not exist"));
            return null;
        }
        if (!folder.isDirectory()) {
            this.logger.error((CharSequence)("EvoSuite home " + home + " is not a folder"));
            return null;
        }
        File[] jars = folder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                String lc = name.toLowerCase();
                return lc.startsWith("evosuite") && lc.endsWith(".jar");
            }
        });
        if (jars.length == 0) {
            this.logger.error((CharSequence)("No evosuite jar in " + folder.getPath()));
            return null;
        }
        if (jars.length > 1) {
            Arrays.sort(jars, new Comparator<File>(){

                @Override
                public int compare(File o1, File o2) {
                    return (int)(o2.length() - o1.length());
                }
            });
        }
        String evo = jars[0].getAbsolutePath();
        this.logger.info((CharSequence)("Going to use EvoSuite jar: " + evo));
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(JavaExecCmdUtil.getJavaBinExecutablePath());
        cmd.add("-jar");
        cmd.add("" + evo);
        return cmd;
    }

    private boolean runProcess(String baseDir, List<String> cmd) {
        try {
            if (baseDir == null) {
                baseDir = System.getProperty("user.dir");
            }
            this.logger.debug((CharSequence)("Working directory: " + baseDir));
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((CharSequence)("Going to execute command: " + String.join((CharSequence)" ", cmd)));
            }
            File dir = new File(baseDir);
            ProcessBuilder builder = new ProcessBuilder(cmd);
            builder.directory(dir);
            builder.redirectErrorStream(true);
            this.process = builder.start();
            this.handleProcessOutput(this.process, this.logger);
            int exitCode = this.process.waitFor();
            if (exitCode != 0) {
                this.logger.error((CharSequence)"Error in EvoSuite");
                return false;
            }
            this.logger.debug((CharSequence)"EvoSuite terminated");
        }
        catch (IOException e) {
            this.logger.error((CharSequence)("Failed to start EvoSuite: " + e.getMessage()), (Throwable)e);
            return false;
        }
        catch (InterruptedException e) {
            if (this.process != null) {
                try {
                    this.process.getOutputStream().close();
                    this.process.getInputStream().close();
                    this.process.getErrorStream().close();
                }
                catch (Exception t) {
                    this.logger.error((CharSequence)("Failed to close process stream: " + t.toString()));
                }
                this.process.destroy();
            }
            return false;
        }
        this.process = null;
        return true;
    }

    private void handleProcessOutput(final Process process, final Log logger) {
        Thread reader = new Thread(){

            @Override
            public void run() {
                try {
                    BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    while (!this.isInterrupted()) {
                        String line = in.readLine();
                        if (line == null || line.isEmpty()) continue;
                        logger.info((CharSequence)line);
                    }
                }
                catch (Exception e) {
                    logger.debug((CharSequence)("Exception while reading spawn process output: " + e.toString()));
                }
            }
        };
        reader.start();
        logger.debug((CharSequence)"Started thread to read spawn process output");
    }
}

