/*
 * Decompiled with CFR 0.152.
 */
package org.evrete.dsl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.evrete.Configuration;
import org.evrete.KnowledgeService;
import org.evrete.api.Knowledge;
import org.evrete.api.TypeResolver;
import org.evrete.dsl.AbstractDSLProvider;
import org.evrete.dsl.Utils;
import org.evrete.dsl.annotation.RuleSet;
import org.evrete.util.compiler.ServiceClassLoader;

public class DSLJarProvider
extends AbstractDSLProvider {
    static final String CLASSES_PROPERTY = "org.evrete.dsl.rule-classes";
    private static final String EMPTY_CLASSES = "";
    private static final String CLASS_ENTRY_SUFFIX = ".class";
    private static final String[] DISALLOWED_PACKAGES = new String[]{"java.", "javax.", "sun.", "org.evrete."};

    private static Knowledge apply(Knowledge knowledge, Set<String> ruleClasses, InputStream ... streams) throws IOException {
        ClassLoader ctxClassLoader = knowledge.getClassLoader();
        ServiceClassLoader classLoader = new ServiceClassLoader(ctxClassLoader);
        List<Class<?>> ruleSets = DSLJarProvider.fillClassLoader(classLoader, streams);
        Knowledge current = knowledge;
        if (ruleClasses.isEmpty()) {
            if (ruleSets.isEmpty()) {
                Utils.LOGGER.warning("Classes annotated with @" + RuleSet.class.getSimpleName() + " not found");
                return knowledge;
            }
            for (Class<?> cl : ruleSets) {
                current = DSLJarProvider.processRuleSet(current, cl);
            }
        } else {
            for (String ruleClass : ruleClasses) {
                try {
                    Class cl = classLoader.loadClass(ruleClass);
                    current = DSLJarProvider.processRuleSet(current, cl);
                }
                catch (ClassNotFoundException e) {
                    Utils.LOGGER.warning("Ruleset class '" + ruleClass + "' not found");
                }
            }
        }
        return current;
    }

    private static Set<String> ruleClasses(Configuration configuration) {
        HashSet<String> ruleClasses = new HashSet<String>();
        String ruleSets = (String)configuration.getOrDefault((Object)CLASSES_PROPERTY, (Object)EMPTY_CLASSES);
        if (!ruleSets.isEmpty()) {
            String[] classNames;
            for (String className : classNames = ruleSets.split("[\\s,;]")) {
                if (className == null || className.isEmpty()) continue;
                ruleClasses.add(className);
            }
        }
        return ruleClasses;
    }

    private static List<Class<?>> fillClassLoader(ServiceClassLoader classLoader, InputStream ... resources) throws IOException {
        JarInputStream[] streams = new JarInputStream[resources.length];
        for (int i = 0; i < resources.length; ++i) {
            streams[i] = new JarInputStream(resources[i]);
        }
        LinkedList ruleSets = new LinkedList();
        JarInputStream[] jarInputStreamArray = streams;
        int n = jarInputStreamArray.length;
        for (int i = 0; i < n; ++i) {
            JarInputStream resource;
            try (JarInputStream is = resource = jarInputStreamArray[i];){
                List<Class<?>> jarRuleSets = DSLJarProvider.applyJar(classLoader, is);
                ruleSets.addAll(jarRuleSets);
                continue;
            }
        }
        return ruleSets;
    }

    private static List<Class<?>> applyJar(ServiceClassLoader secureClassLoader, JarInputStream is) throws IOException {
        JarEntry entry;
        byte[] buffer = new byte[1024];
        HashMap<String, byte[]> resources = new HashMap<String, byte[]>();
        HashMap<String, byte[]> classes = new HashMap<String, byte[]>();
        while ((entry = is.getNextJarEntry()) != null) {
            if (entry.isDirectory()) continue;
            byte[] bytes = DSLJarProvider.toBytes(is, buffer);
            String name = entry.getName();
            if (name.endsWith(CLASS_ENTRY_SUFFIX)) {
                String className = name.substring(0, name.length() - CLASS_ENTRY_SUFFIX.length()).replaceAll("/", ".");
                DSLJarProvider.validateClassName(className);
                classes.put(className, bytes);
                continue;
            }
            resources.put(name, bytes);
        }
        LinkedList ruleSets = new LinkedList();
        for (Map.Entry e : classes.entrySet()) {
            Class clazz;
            block6: {
                String className = (String)e.getKey();
                byte[] bytes = (byte[])e.getValue();
                try {
                    clazz = secureClassLoader.loadClass(className);
                }
                catch (ClassNotFoundException cnf) {
                    clazz = secureClassLoader.buildClass(bytes);
                    if (clazz.getName().equals(className)) break block6;
                    throw new IllegalStateException();
                }
            }
            if (clazz.getAnnotation(RuleSet.class) == null) continue;
            ruleSets.add(clazz);
        }
        for (Map.Entry e : resources.entrySet()) {
            secureClassLoader.addResource((String)e.getKey(), (byte[])e.getValue());
        }
        return ruleSets;
    }

    private static void validateClassName(String className) {
        for (String pkg : DISALLOWED_PACKAGES) {
            if (!className.startsWith(pkg)) continue;
            throw new IllegalArgumentException("Package name not allowed '" + className + "'");
        }
    }

    private static byte[] toBytes(JarInputStream is, byte[] buffer) throws IOException {
        int read;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((read = is.read(buffer)) != -1) {
            bos.write(buffer, 0, read);
        }
        bos.flush();
        bos.close();
        return bos.toByteArray();
    }

    public Knowledge create(KnowledgeService service, TypeResolver typeResolver, InputStream ... streams) throws IOException {
        if (streams == null || streams.length == 0) {
            throw new IOException("Empty streams");
        }
        Set<String> ruleClasses = DSLJarProvider.ruleClasses(service.getConfiguration());
        Knowledge knowledge = service.newKnowledge(typeResolver);
        return DSLJarProvider.apply(knowledge, ruleClasses, streams);
    }

    public String getName() {
        return "JAVA-JAR";
    }
}

