/*
 * Decompiled with CFR 0.152.
 */
package com.greenpineyu.fel.function;

import com.greenpineyu.fel.FelEngine;
import com.greenpineyu.fel.common.StringUtils;
import com.greenpineyu.fel.compile.FelMethod;
import com.greenpineyu.fel.compile.SourceBuilder;
import com.greenpineyu.fel.context.FelContext;
import com.greenpineyu.fel.function.Function;
import com.greenpineyu.fel.parser.FelNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dollar
implements Function {
    private static final String suffix = ".new";

    @Override
    public String getName() {
        return "$";
    }

    @Override
    public Object call(FelNode node, FelContext context) {
        String txt = this.getChildText(node);
        boolean isNew = this.isNew(txt);
        Class<?> cls = this.getClass(txt, isNew);
        if (isNew) {
            return this.newObject(cls);
        }
        return cls;
    }

    private Object newObject(Class<?> cls) {
        Object o = null;
        if (cls != null) {
            try {
                o = cls.newInstance();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return o;
    }

    private Class<?> getClass(FelNode node) {
        String txt = this.getChildText(node);
        boolean isNew = this.isNew(txt);
        return this.getClass(txt, isNew);
    }

    private Class<?> getClass(String txt, boolean isNew) {
        String className = txt;
        if (isNew) {
            className = className.substring(0, txt.length() - suffix.length());
        }
        if (className.indexOf(".") == -1) {
            className = "java.lang." + className;
        }
        try {
            Class<?> clz = Class.forName(className);
            return clz;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    private boolean isNew(String txt) {
        boolean isNew = txt.endsWith(suffix);
        return isNew;
    }

    private String getChildText(FelNode node) {
        String txt = node.getChildren().get(0).getText();
        txt = StringUtils.remove(txt, '\'');
        txt = StringUtils.remove(txt, '\"');
        return txt;
    }

    @Override
    public SourceBuilder toMethod(FelNode node, FelContext ctx) {
        String txt = this.getChildText(node);
        boolean isNew = this.isNew(txt);
        Class<?> cls = this.getClass(txt, isNew);
        String code = cls.getName();
        if (isNew) {
            code = "new " + code + "()";
        }
        return new FelMethod(cls, code);
    }

    public static void main(String[] args) {
        String exp = "$('Math').max($('Math').min(1,2),3).doubleValue()";
        exp = "$('String.new').concat('abc')";
        Object eval = FelEngine.instance.eval(exp);
        System.out.println(eval);
    }
}

