/*
 * Decompiled with CFR 0.152.
 */
package com.greenpineyu.fel.optimizer;

import com.greenpineyu.fel.compile.InterpreterSourceBuilder;
import com.greenpineyu.fel.compile.SourceBuilder;
import com.greenpineyu.fel.compile.SourceGeneratorImpl;
import com.greenpineyu.fel.compile.VarBuffer;
import com.greenpineyu.fel.context.FelContext;
import com.greenpineyu.fel.context.MapContext;
import com.greenpineyu.fel.context.Var;
import com.greenpineyu.fel.interpreter.Interpreter;
import com.greenpineyu.fel.optimizer.Optimizer;
import com.greenpineyu.fel.parser.AbstFelNode;
import com.greenpineyu.fel.parser.FelNode;
import com.greenpineyu.fel.parser.VarAstNode;
import java.util.List;
import java.util.Map;

public class VarVisitOpti
implements Optimizer {
    private Map<String, Var> varMap;

    public VarVisitOpti(Var ... vars) {
        this.varMap = new MapContext();
        if (vars != null) {
            Var[] varArray = vars;
            int n = vars.length;
            int n2 = 0;
            while (n2 < n) {
                Var var = varArray[n2];
                if (var != null) {
                    this.varMap.put(var.getName(), var);
                }
                ++n2;
            }
        }
    }

    public VarVisitOpti() {
    }

    public FelNode call(FelContext ctx, FelNode node) {
        List<FelNode> nodes = AbstFelNode.getNodes(node, SourceGeneratorImpl.varsFilter);
        for (FelNode varNode : nodes) {
            VarAstNode n;
            if (!(varNode instanceof VarAstNode) || !(n = (VarAstNode)varNode).isDefaultInterpreter()) continue;
            n.setInterpreter(this.createInterpreter());
            n.setSourcebuilder(this.createVarSourceBuilder(n));
        }
        return node;
    }

    private Interpreter createInterpreter() {
        return new Interpreter(){

            public Object interpret(FelContext context, FelNode node) {
                Var var = VarVisitOpti.this.getVar(context, node);
                return var != null ? var.getValue() : null;
            }
        };
    }

    private SourceBuilder createVarSourceBuilder(VarAstNode n) {
        return new SourceBuilder(){
            private String src = null;
            private Class<?> returnType = null;

            @Override
            public String source(FelContext ctx, FelNode node) {
                if (this.src == null) {
                    Var var = VarVisitOpti.this.getVar(ctx, node);
                    String varFieldName = VarBuffer.push(var);
                    Class<?> type = this.returnType(ctx, node);
                    this.src = VarAstNode.getVarFullCode(type, String.valueOf(varFieldName) + ".getValue()");
                }
                return this.src;
            }

            @Override
            public Class<?> returnType(FelContext ctx, FelNode node) {
                if (this.returnType == null) {
                    this.returnType = InterpreterSourceBuilder.getInstance().returnType(ctx, node);
                }
                return this.returnType;
            }
        };
    }

    private Var getVar(FelContext context, FelNode node) {
        Var var = null;
        if (this.varMap != null) {
            var = this.varMap.get(node.getText());
        }
        if (var == null) {
            var = context.getVar(node.getText());
        }
        return var;
    }
}

