/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.bined.highlight.swing.extended;

import java.awt.Color;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.bined.CodeAreaSection;
import org.exbin.bined.basic.BasicCodeAreaSection;
import org.exbin.bined.color.CodeAreaColorType;
import org.exbin.bined.highlight.swing.color.CodeAreaMatchColorType;
import org.exbin.bined.swing.CodeAreaCore;
import org.exbin.bined.swing.extended.ExtendedCodeAreaPainter;

@ParametersAreNonnullByDefault
public class ExtendedHighlightCodeAreaPainter
extends ExtendedCodeAreaPainter {
    private final List<SearchMatch> matches = new ArrayList<SearchMatch>();
    private int currentMatchIndex = -1;
    private int matchIndex = 0;
    private long matchPosition = -1L;
    private Color foundMatchesColor = new Color(180, 255, 180);
    private Color currentMatchColor = new Color(255, 210, 180);

    public ExtendedHighlightCodeAreaPainter(CodeAreaCore codeArea) {
        super(codeArea);
    }

    public void paintMainArea(@Nonnull Graphics g) {
        this.matchIndex = 0;
        super.paintMainArea(g);
    }

    @Nullable
    public Color getPositionTextColor(long rowDataPosition, int byteOnRow, int charOnRow, CodeAreaSection section, boolean unprintables) {
        if (!this.matches.isEmpty() && charOnRow < this.getCharactersPerRow() - 1) {
            SearchMatch currentMatch;
            long dataPosition = rowDataPosition + (long)byteOnRow;
            if (this.currentMatchIndex >= 0 && dataPosition >= (currentMatch = this.matches.get(this.currentMatchIndex)).position && dataPosition < currentMatch.position + currentMatch.length && (section == BasicCodeAreaSection.TEXT_PREVIEW || (long)charOnRow != (currentMatch.position + currentMatch.length - rowDataPosition) * (long)this.getCharactersPerRow() - 1L)) {
                Color activeMatchColor = this.getColorsProfile().getColor((CodeAreaColorType)CodeAreaMatchColorType.ACTIVE_MATCH_COLOR);
                return activeMatchColor != null ? activeMatchColor : super.getPositionTextColor(rowDataPosition, byteOnRow, charOnRow, section, unprintables);
            }
            if (this.matchPosition < rowDataPosition) {
                this.matchIndex = 0;
            }
            for (int lineMatchIndex = this.matchIndex; lineMatchIndex < this.matches.size(); ++lineMatchIndex) {
                SearchMatch match = this.matches.get(lineMatchIndex);
                if (dataPosition >= match.position && dataPosition < match.position + match.length && (section == BasicCodeAreaSection.TEXT_PREVIEW || (long)charOnRow != (match.position + match.length - rowDataPosition) * (long)this.getCharactersPerRow() - 1L)) {
                    Color matchesColor;
                    if (byteOnRow == 0) {
                        this.matchIndex = lineMatchIndex;
                        this.matchPosition = match.position;
                    }
                    return (matchesColor = this.getColorsProfile().getColor((CodeAreaColorType)CodeAreaMatchColorType.MATCH_COLOR)) != null ? matchesColor : super.getPositionTextColor(rowDataPosition, byteOnRow, charOnRow, section, unprintables);
                }
                if (match.position > dataPosition) break;
                if (byteOnRow != 0) continue;
                this.matchIndex = lineMatchIndex;
                this.matchPosition = match.position;
            }
        }
        return super.getPositionTextColor(rowDataPosition, byteOnRow, charOnRow, section, unprintables);
    }

    @Nullable
    public Color getPositionBackgroundColor(long rowDataPosition, int byteOnRow, int charOnRow, CodeAreaSection section, boolean unprintables) {
        if (!this.matches.isEmpty() && charOnRow < this.getCharactersPerRow() - 1) {
            SearchMatch currentMatch;
            long dataPosition = rowDataPosition + (long)byteOnRow;
            if (this.currentMatchIndex >= 0 && dataPosition >= (currentMatch = this.matches.get(this.currentMatchIndex)).position && dataPosition < currentMatch.position + currentMatch.length && (section == BasicCodeAreaSection.TEXT_PREVIEW || (long)charOnRow != (currentMatch.position + currentMatch.length - rowDataPosition) * (long)this.getCharactersPerRow() - 1L)) {
                Color activeMatchBackground = this.getColorsProfile().getColor((CodeAreaColorType)CodeAreaMatchColorType.ACTIVE_MATCH_BACKGROUND);
                return activeMatchBackground != null ? activeMatchBackground : this.currentMatchColor;
            }
            if (this.matchPosition < rowDataPosition) {
                this.matchIndex = 0;
            }
            for (int lineMatchIndex = this.matchIndex; lineMatchIndex < this.matches.size(); ++lineMatchIndex) {
                SearchMatch match = this.matches.get(lineMatchIndex);
                if (dataPosition >= match.position && dataPosition < match.position + match.length && (section == BasicCodeAreaSection.TEXT_PREVIEW || (long)charOnRow != (match.position + match.length - rowDataPosition) * (long)this.getCharactersPerRow() - 1L)) {
                    Color matchesBackground;
                    if (byteOnRow == 0) {
                        this.matchIndex = lineMatchIndex;
                        this.matchPosition = match.position;
                    }
                    return (matchesBackground = this.getColorsProfile().getColor((CodeAreaColorType)CodeAreaMatchColorType.MATCH_BACKGROUND)) != null ? matchesBackground : this.foundMatchesColor;
                }
                if (match.position > dataPosition) break;
                if (byteOnRow != 0) continue;
                this.matchIndex = lineMatchIndex;
                this.matchPosition = match.position;
            }
        }
        return super.getPositionBackgroundColor(rowDataPosition, byteOnRow, charOnRow, section, unprintables);
    }

    @Nonnull
    public List<SearchMatch> getMatches() {
        return this.matches;
    }

    public void setMatches(List<SearchMatch> matches) {
        this.matches.clear();
        this.matches.addAll(matches);
        this.currentMatchIndex = -1;
    }

    public void clearMatches() {
        this.matches.clear();
        this.currentMatchIndex = -1;
    }

    @Nullable
    public SearchMatch getCurrentMatch() {
        if (this.currentMatchIndex >= 0) {
            return this.matches.get(this.currentMatchIndex);
        }
        return null;
    }

    public int getCurrentMatchIndex() {
        return this.currentMatchIndex;
    }

    public void setCurrentMatchIndex(int currentMatchIndex) {
        this.currentMatchIndex = currentMatchIndex;
    }

    @Nonnull
    public Color getFoundMatchesBackgroundColor() {
        return this.foundMatchesColor;
    }

    public void setFoundMatchesBackgroundColor(Color foundMatchesBackgroundColor) {
        this.foundMatchesColor = foundMatchesBackgroundColor;
    }

    @Nonnull
    public Color getCurrentMatchBackgroundColor() {
        return this.currentMatchColor;
    }

    public void setCurrentMatchBackgroundColor(Color currentMatchBackgroundColor) {
        this.currentMatchColor = currentMatchBackgroundColor;
    }

    public static class SearchMatch {
        private long position;
        private long length;

        public SearchMatch() {
        }

        public SearchMatch(long position, long length) {
            this.position = position;
            this.length = length;
        }

        public long getPosition() {
            return this.position;
        }

        public void setPosition(long position) {
            this.position = position;
        }

        public long getLength() {
            return this.length;
        }

        public void setLength(long length) {
            this.length = length;
        }
    }
}

