/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.bined.swing.extended;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import org.exbin.auxiliary.binary_data.BinaryData;
import org.exbin.bined.CaretOverlapMode;
import org.exbin.bined.CodeAreaCaret;
import org.exbin.bined.CodeAreaCaretPosition;
import org.exbin.bined.CodeAreaSection;
import org.exbin.bined.CodeAreaSelection;
import org.exbin.bined.CodeAreaUtils;
import org.exbin.bined.CodeCharactersCase;
import org.exbin.bined.CodeType;
import org.exbin.bined.DataChangedListener;
import org.exbin.bined.DataProvider;
import org.exbin.bined.DefaultCodeAreaCaretPosition;
import org.exbin.bined.EditOperation;
import org.exbin.bined.PositionCodeType;
import org.exbin.bined.ScrollBarVisibility;
import org.exbin.bined.basic.BasicCodeAreaSection;
import org.exbin.bined.basic.BasicCodeAreaZone;
import org.exbin.bined.basic.CodeAreaScrollPosition;
import org.exbin.bined.basic.CodeAreaViewMode;
import org.exbin.bined.basic.MovementDirection;
import org.exbin.bined.basic.PositionScrollVisibility;
import org.exbin.bined.basic.ScrollViewDimension;
import org.exbin.bined.basic.ScrollingDirection;
import org.exbin.bined.capability.CaretCapable;
import org.exbin.bined.capability.CharsetCapable;
import org.exbin.bined.capability.CodeCharactersCaseCapable;
import org.exbin.bined.capability.EditModeCapable;
import org.exbin.bined.capability.RowWrappingCapable;
import org.exbin.bined.capability.ScrollingCapable;
import org.exbin.bined.capability.SelectionCapable;
import org.exbin.bined.color.BasicCodeAreaDecorationColorType;
import org.exbin.bined.color.CodeAreaBasicColors;
import org.exbin.bined.color.CodeAreaColorType;
import org.exbin.bined.extended.ExtendedCodeAreaStructure;
import org.exbin.bined.extended.ExtendedHorizontalScrollUnit;
import org.exbin.bined.extended.capability.PositionCodeTypeCapable;
import org.exbin.bined.extended.capability.ShowUnprintablesCapable;
import org.exbin.bined.extended.caret.CodeAreaCaretShape;
import org.exbin.bined.extended.caret.CodeAreaCaretType;
import org.exbin.bined.extended.color.CodeAreaUnprintablesColorType;
import org.exbin.bined.extended.layout.ExtendedCodeAreaLayoutProfile;
import org.exbin.bined.extended.layout.PositionIterator;
import org.exbin.bined.extended.layout.SpaceType;
import org.exbin.bined.extended.theme.ExtendedBackgroundPaintMode;
import org.exbin.bined.swing.CodeAreaCore;
import org.exbin.bined.swing.CodeAreaPainter;
import org.exbin.bined.swing.CodeAreaSwingControl;
import org.exbin.bined.swing.CodeAreaSwingUtils;
import org.exbin.bined.swing.basic.AntialiasingMode;
import org.exbin.bined.swing.basic.BasicCodeAreaMetrics;
import org.exbin.bined.swing.basic.DefaultCodeAreaCaret;
import org.exbin.bined.swing.basic.DefaultCodeAreaMouseListener;
import org.exbin.bined.swing.basic.color.CodeAreaColorsProfile;
import org.exbin.bined.swing.capability.AntialiasingCapable;
import org.exbin.bined.swing.capability.FontCapable;
import org.exbin.bined.swing.extended.ExtendedCodeAreaDimensions;
import org.exbin.bined.swing.extended.ExtendedCodeAreaScrollPane;
import org.exbin.bined.swing.extended.ExtendedCodeAreaScrolling;
import org.exbin.bined.swing.extended.ExtendedCodeAreaVisibility;
import org.exbin.bined.swing.extended.caret.CaretsProfileCapableCodeAreaPainter;
import org.exbin.bined.swing.extended.caret.DefaultExtendedCodeAreaCaretsProfile;
import org.exbin.bined.swing.extended.caret.ExtendedCodeAreaCaretsProfile;
import org.exbin.bined.swing.extended.color.ColorsProfileCapableCodeAreaPainter;
import org.exbin.bined.swing.extended.color.ExtendedCodeAreaColorProfile;
import org.exbin.bined.swing.extended.layout.DefaultExtendedCodeAreaLayoutProfile;
import org.exbin.bined.swing.extended.layout.LayoutProfileCapableCodeAreaPainter;
import org.exbin.bined.swing.extended.theme.ExtendedCodeAreaThemeProfile;
import org.exbin.bined.swing.extended.theme.ThemeProfileCapableCodeAreaPainter;

@ParametersAreNonnullByDefault
public class ExtendedCodeAreaPainter
implements CodeAreaPainter,
ColorsProfileCapableCodeAreaPainter,
LayoutProfileCapableCodeAreaPainter,
ThemeProfileCapableCodeAreaPainter,
CaretsProfileCapableCodeAreaPainter {
    @Nonnull
    protected final CodeAreaCore codeArea;
    private volatile boolean initialized = false;
    private volatile boolean fontChanged = false;
    private volatile boolean layoutChanged = true;
    private volatile boolean caretChanged = true;
    private volatile boolean resetColors = true;
    @Nonnull
    private final JComponent dataView;
    @Nonnull
    private final ExtendedCodeAreaScrollPane scrollPanel;
    @Nonnull
    private final DefaultCodeAreaMouseListener codeAreaMouseListener;
    @Nonnull
    private final ComponentListener codeAreaComponentListener;
    @Nonnull
    private final DataChangedListener codeAreaDataChangeListener;
    @Nonnull
    private final BasicCodeAreaMetrics metrics = new BasicCodeAreaMetrics();
    @Nonnull
    private final ExtendedCodeAreaStructure structure = new ExtendedCodeAreaStructure();
    @Nonnull
    private final ExtendedCodeAreaScrolling scrolling = new ExtendedCodeAreaScrolling();
    @Nonnull
    private final ExtendedCodeAreaDimensions dimensions = new ExtendedCodeAreaDimensions();
    @Nonnull
    private final ExtendedCodeAreaVisibility visibility = new ExtendedCodeAreaVisibility();
    @Nonnull
    private ExtendedCodeAreaLayoutProfile layoutProfile = new DefaultExtendedCodeAreaLayoutProfile();
    @Nonnull
    private CodeAreaColorsProfile colorsProfile = new ExtendedCodeAreaColorProfile();
    @Nonnull
    private ExtendedCodeAreaThemeProfile themeProfile = new ExtendedCodeAreaThemeProfile();
    @Nonnull
    private ExtendedCodeAreaCaretsProfile caretsProfile = new DefaultExtendedCodeAreaCaretsProfile();
    @Nullable
    private CodeCharactersCase codeCharactersCase;
    @Nullable
    private EditOperation editOperation;
    @Nullable
    private PositionIterator positionIterator;
    @Nullable
    private ScrollViewDimension viewDimension;
    private boolean showMirrorCursor;
    private boolean showUnprintables;
    @Nonnull
    private AntialiasingMode antialiasingMode = AntialiasingMode.AUTO;
    private int rowPositionLength;
    private int minRowPositionLength;
    private int maxRowPositionLength;
    @Nullable
    private Font font;
    @Nullable
    private Charset charset;
    @Nullable
    private RowDataCache rowDataCache = null;
    @Nullable
    private CursorDataCache cursorDataCache = null;
    @Nullable
    private Charset charMappingCharset = null;
    @Nonnull
    private final char[] charMapping = new char[256];
    private static final char SPACE_CHAR = ' ';
    @Nullable
    protected Map<Character, Character> unprintableCharactersMapping = null;

    public ExtendedCodeAreaPainter(CodeAreaCore codeArea) {
        this.codeArea = codeArea;
        this.dataView = new JComponent(){};
        this.dataView.setBorder(null);
        this.dataView.setVisible(false);
        this.dataView.setLayout(null);
        this.dataView.setOpaque(false);
        this.dataView.setInheritsPopupMenu(true);
        this.dataView.setPreferredSize(new Dimension(0, 0));
        this.scrollPanel = new ExtendedCodeAreaScrollPane((CodeAreaSwingControl)codeArea, this.metrics, this.structure, this.scrolling, this.dimensions);
        this.scrollPanel.setViewportView(this.dataView);
        JViewport viewport = this.scrollPanel.getViewport();
        viewport.setOpaque(false);
        this.scrolling.setHorizontalExtentChangeListener(() -> this.horizontalExtentChanged());
        this.scrolling.setVerticalExtentChangeListener(() -> this.verticalExtentChanged());
        this.codeAreaMouseListener = new DefaultCodeAreaMouseListener(codeArea, (JScrollPane)this.scrollPanel);
        viewport.addMouseListener((MouseListener)this.codeAreaMouseListener);
        viewport.addMouseMotionListener((MouseMotionListener)this.codeAreaMouseListener);
        viewport.addMouseWheelListener((MouseWheelListener)this.codeAreaMouseListener);
        viewport.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                int verticalScrollBarSize = ExtendedCodeAreaPainter.this.getVerticalScrollBarSize();
                int horizontalScrollBarSize = ExtendedCodeAreaPainter.this.getHorizontalScrollBarSize();
                if (ExtendedCodeAreaPainter.this.dimensions.getVerticalScrollBarSize() != verticalScrollBarSize || ExtendedCodeAreaPainter.this.dimensions.getHorizontalScrollBarSize() != horizontalScrollBarSize) {
                    ExtendedCodeAreaPainter.this.recomputeDimensions();
                    ExtendedCodeAreaPainter.this.recomputeScrollState();
                }
                JViewport viewport = ExtendedCodeAreaPainter.this.scrollPanel.getViewport();
                if (ExtendedCodeAreaPainter.this.viewDimension != null && (ExtendedCodeAreaPainter.this.viewDimension.getDataViewWidth() != viewport.getWidth() || ExtendedCodeAreaPainter.this.viewDimension.getDataViewHeight() != viewport.getHeight())) {
                    ExtendedCodeAreaPainter.this.updateScrollBars();
                }
            }
        });
        this.codeAreaComponentListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ExtendedCodeAreaPainter.this.recomputeLayout();
            }
        };
        this.codeAreaDataChangeListener = () -> this.dataChanged();
        this.rebuildColors();
    }

    public void attach() {
        this.codeArea.add((Component)this.scrollPanel);
        this.codeArea.addMouseListener((MouseListener)this.codeAreaMouseListener);
        this.codeArea.addMouseMotionListener((MouseMotionListener)this.codeAreaMouseListener);
        this.codeArea.addMouseWheelListener((MouseWheelListener)this.codeAreaMouseListener);
        this.codeArea.addComponentListener(this.codeAreaComponentListener);
        this.codeArea.addDataChangedListener(this.codeAreaDataChangeListener);
    }

    public void detach() {
        this.codeArea.remove((Component)this.scrollPanel);
        this.codeArea.removeMouseListener((MouseListener)this.codeAreaMouseListener);
        this.codeArea.removeMouseMotionListener((MouseMotionListener)this.codeAreaMouseListener);
        this.codeArea.removeMouseWheelListener((MouseWheelListener)this.codeAreaMouseListener);
        this.codeArea.removeComponentListener(this.codeAreaComponentListener);
        this.codeArea.removeDataChangedListener(this.codeAreaDataChangeListener);
    }

    public void reset() {
        this.resetColors();
        this.resetFont();
        this.resetLayout();
        this.resetCaret();
    }

    public void resetColors() {
        this.resetColors = true;
    }

    public void resetFont() {
        this.fontChanged = true;
        this.resetLayout();
    }

    public void resetLayout() {
        this.layoutChanged = true;
    }

    public void resetCaret() {
        this.caretChanged = true;
    }

    public void rebuildColors() {
        this.colorsProfile.reinitialize();
    }

    private void recomputeLayout() {
        this.rowPositionLength = this.getRowPositionLength();
        this.recomputeDimensions();
        int halfCharsPerPage = this.dimensions.getHalfCharsPerPage();
        this.structure.updateCache((DataProvider)this.codeArea, halfCharsPerPage, this.layoutProfile);
        this.positionIterator = this.layoutProfile.createPositionIterator(this.structure.getCodeType(), this.structure.getViewMode(), this.structure.getBytesPerRow());
        this.codeCharactersCase = ((CodeCharactersCaseCapable)this.codeArea).getCodeCharactersCase();
        this.showMirrorCursor = ((CaretCapable)this.codeArea).isShowMirrorCursor();
        this.showUnprintables = ((ShowUnprintablesCapable)this.codeArea).isShowUnprintables();
        this.minRowPositionLength = ((RowWrappingCapable)this.codeArea).getMinRowPositionLength();
        this.maxRowPositionLength = ((RowWrappingCapable)this.codeArea).getMaxRowPositionLength();
        this.antialiasingMode = ((AntialiasingCapable)this.codeArea).getAntialiasingMode();
        int rowsPerPage = this.dimensions.getRowsPerPage();
        long rowsPerDocument = this.structure.getRowsPerDocument();
        int halfCharsPerRow = this.structure.getHalfCharsPerRow();
        if (this.metrics.isInitialized()) {
            int characterWidth = this.metrics.getCharacterWidth();
            this.scrolling.updateMaximumScrollPosition(rowsPerDocument, rowsPerPage, halfCharsPerRow, halfCharsPerPage, this.dimensions.getHalfCharOffset(), this.dimensions.getRowOffset(), characterWidth);
        }
        this.updateScrollBars();
        this.layoutChanged = false;
    }

    private void updateCaret() {
        this.editOperation = ((EditModeCapable)this.codeArea).getActiveOperation();
        this.caretChanged = false;
    }

    private void validateCaret() {
        CodeAreaCaret caret = ((CaretCapable)this.codeArea).getCaret();
        CodeAreaCaretPosition caretPosition = caret.getCaretPosition();
        if (caretPosition.getDataPosition() > this.codeArea.getDataSize()) {
            caret.setCaretPosition(null);
        }
    }

    private void validateSelection() {
        CodeAreaSelection selectionHandler = ((SelectionCapable)this.codeArea).getSelectionHandler();
        if (!selectionHandler.isEmpty()) {
            long dataSize = this.codeArea.getDataSize();
            if (dataSize == 0L) {
                ((SelectionCapable)this.codeArea).clearSelection();
            } else {
                boolean selectionChanged = false;
                long start = selectionHandler.getStart();
                long end = selectionHandler.getEnd();
                if (start >= dataSize) {
                    start = dataSize;
                    selectionChanged = true;
                }
                if (end >= dataSize) {
                    end = dataSize;
                    selectionChanged = true;
                }
                if (selectionChanged) {
                    ((SelectionCapable)this.codeArea).setSelection(start, end);
                }
            }
        }
    }

    private void recomputeDimensions() {
        int verticalScrollBarSize = this.getVerticalScrollBarSize();
        int horizontalScrollBarSize = this.getHorizontalScrollBarSize();
        Insets insets = this.codeArea.getInsets();
        int componentWidth = this.codeArea.getWidth() - insets.left - insets.right;
        int componentHeight = this.codeArea.getHeight() - insets.top - insets.bottom;
        this.dimensions.recomputeSizes(this.metrics, insets.right, insets.top, componentWidth, componentHeight, this.rowPositionLength, verticalScrollBarSize, horizontalScrollBarSize, this.layoutProfile);
    }

    public void recomputeCharPositions() {
        this.visibility.recomputeCharPositions(this.metrics, this.structure, this.dimensions, this.layoutProfile, this.scrolling);
        this.updateRowDataCache();
    }

    private void updateRowDataCache() {
        if (this.rowDataCache == null) {
            this.rowDataCache = new RowDataCache();
        }
        boolean shifted = this.layoutProfile.isHalfShiftedUsed();
        int maxRowDataChars = this.visibility.getMaxRowDataChars();
        int codeLength = this.structure.getCodeType().getMaxDigitsForByte();
        this.rowDataCache.headerCodeData = new char[this.structure.getCodeType().getMaxDigitsForByte()];
        this.rowDataCache.headerChars = new char[maxRowDataChars + codeLength];
        this.rowDataCache.headerCharsShifted = shifted ? new char[maxRowDataChars + codeLength] : null;
        this.rowDataCache.rowCodeData = new char[this.structure.getCodeType().getMaxDigitsForByte()];
        this.rowDataCache.rowData = new byte[this.structure.getBytesPerRow() + this.metrics.getMaxBytesPerChar() - 1];
        this.rowDataCache.rowPositionCode = new char[this.rowPositionLength];
        this.rowDataCache.rowCharacters = new char[maxRowDataChars];
        this.rowDataCache.rowCharactersShifted = shifted ? new char[maxRowDataChars] : null;
        this.rowDataCache.unprintables = new byte[this.structure.getBytesPerRow() + 7 >> 3];
    }

    public void fontChanged(Graphics g) {
        if (this.font == null) {
            this.reset();
        }
        this.charset = ((CharsetCapable)this.codeArea).getCharset();
        this.font = ((FontCapable)this.codeArea).getCodeFont();
        this.metrics.recomputeMetrics(g.getFontMetrics(this.font), this.charset);
        this.recomputeLayout();
        this.recomputeCharPositions();
        this.initialized = true;
    }

    private void recomputeScrollState() {
        this.scrolling.setScrollPosition(((ScrollingCapable)this.codeArea).getScrollPosition());
        int characterWidth = this.metrics.getCharacterWidth();
        if (characterWidth > 0) {
            this.scrolling.updateCache((DataProvider)this.codeArea, this.getHorizontalScrollBarSize(), this.getVerticalScrollBarSize());
            this.recomputeCharPositions();
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void paintComponent(Graphics g) {
        if (!this.initialized) {
            this.reset();
        }
        this.updateCache();
        if (this.font == null) {
            this.fontChanged(g);
        }
        if (this.rowDataCache == null) {
            return;
        }
        if (this.antialiasingMode != AntialiasingMode.OFF && g instanceof Graphics2D) {
            Object antialiasingHint = this.antialiasingMode.getAntialiasingHint((Graphics2D)g);
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, antialiasingHint);
        }
        if (this.layoutChanged) {
            this.recomputeLayout();
            this.recomputeCharPositions();
        }
        this.paintOutsideArea(g);
        this.paintHeader(g);
        this.paintRowPosition(g);
        this.paintMainArea(g);
    }

    protected synchronized void updateCache() {
        if (this.resetColors) {
            this.resetColors = false;
            this.rebuildColors();
        }
    }

    public void paintOutsideArea(Graphics g) {
        int lineX;
        int headerAreaHeight = this.dimensions.getHeaderAreaHeight();
        int rowPositionAreaWidth = this.dimensions.getRowPositionAreaWidth();
        Rectangle componentRect = this.dimensions.getComponentRectangle();
        int characterWidth = this.metrics.getCharacterWidth();
        g.setColor(this.colorsProfile.getColor((CodeAreaColorType)CodeAreaBasicColors.TEXT_BACKGROUND));
        g.fillRect(componentRect.x, componentRect.y, componentRect.width, headerAreaHeight);
        g.setColor(this.colorsProfile.getColor((CodeAreaColorType)BasicCodeAreaDecorationColorType.LINE));
        if (this.themeProfile.showHeaderLine()) {
            g.drawLine(componentRect.x, componentRect.y + headerAreaHeight - 1, componentRect.x + rowPositionAreaWidth, componentRect.y + headerAreaHeight - 1);
        }
        if (this.themeProfile.showRowPositionLine() && (lineX = componentRect.x + rowPositionAreaWidth - characterWidth / 2) >= componentRect.x) {
            g.drawLine(lineX, componentRect.y, lineX, componentRect.y + headerAreaHeight);
        }
        if (this.themeProfile.showBoxLine()) {
            g.drawLine(rowPositionAreaWidth - 1, headerAreaHeight - 1, rowPositionAreaWidth, headerAreaHeight - 1);
        }
    }

    public void paintHeader(Graphics g) {
        int groupSize;
        int lineX;
        if (!this.dimensions.getLayoutProfile().isShowHeader()) {
            return;
        }
        Rectangle headerArea = this.dimensions.getHeaderAreaRectangle();
        Rectangle clipBounds = g.getClipBounds();
        g.setClip(clipBounds != null ? clipBounds.intersection(headerArea) : headerArea);
        int characterWidth = this.metrics.getCharacterWidth();
        int halfSpaceWidth = characterWidth / 2;
        int rowHeight = this.metrics.getRowHeight();
        int dataViewX = this.dimensions.getScrollPanelX();
        int skipRestFrom = this.visibility.getSkipRestFrom();
        int skipToChar = this.visibility.getSkipToChar();
        int skipRestFromChar = this.visibility.getSkipRestFromChar();
        g.setFont(this.font);
        g.setColor(this.colorsProfile.getColor((CodeAreaColorType)CodeAreaBasicColors.TEXT_BACKGROUND));
        g.fillRect(headerArea.x, headerArea.y, headerArea.width, headerArea.height);
        CodeAreaViewMode viewMode = this.structure.getViewMode();
        if ((viewMode == CodeAreaViewMode.DUAL || viewMode == CodeAreaViewMode.CODE_MATRIX) && this.visibility.isCodeSectionVisible()) {
            boolean paintGrid;
            int headerX = dataViewX - this.scrolling.getHorizontalScrollX(characterWidth);
            int headerY = headerArea.y + this.dimensions.getLayoutProfile().computeHeaderOffsetPositionY() + rowHeight - this.metrics.getSubFontSpace();
            Arrays.fill(this.rowDataCache.headerChars, ' ');
            if (this.layoutProfile.isHalfShiftedUsed()) {
                Arrays.fill(this.rowDataCache.headerCharsShifted, ' ');
            }
            int codeLength = this.structure.getCodeType().getMaxDigitsForByte();
            int base = this.structure.getPositionCodeType().getBase();
            g.setColor(this.colorsProfile.getColor((CodeAreaColorType)CodeAreaBasicColors.ALTERNATE_BACKGROUND));
            this.positionIterator.reset();
            this.positionIterator.skip(this.visibility.getSkipTo());
            int halfCharPos = this.positionIterator.getHalfCharPosition();
            boolean bl = paintGrid = this.themeProfile.getBackgroundPaintMode() == ExtendedBackgroundPaintMode.GRIDDED || this.themeProfile.getBackgroundPaintMode() == ExtendedBackgroundPaintMode.CHESSBOARD;
            while (this.positionIterator.getSection() != BasicCodeAreaSection.TEXT_PREVIEW) {
                int byteOffset = this.positionIterator.getBytePosition();
                int gridStartX = paintGrid ? this.layoutProfile.computePositionX(halfCharPos, characterWidth, halfSpaceWidth) : 0;
                int gridEndX = 0;
                CodeAreaUtils.longToBaseCode((char[])this.rowDataCache.headerCodeData, (int)0, (long)byteOffset, (int)base, (int)codeLength, (boolean)true, (CodeCharactersCase)this.codeCharactersCase);
                for (int i = this.positionIterator.getCodeOffset(); i < codeLength; ++i) {
                    int charPos = halfCharPos / 2 - skipToChar;
                    if ((halfCharPos & 1) == 0) {
                        this.rowDataCache.headerChars[charPos] = this.rowDataCache.headerCodeData[i];
                    } else {
                        this.rowDataCache.headerCharsShifted[charPos] = this.rowDataCache.headerCodeData[i];
                    }
                    if (paintGrid && i + 1 == codeLength) {
                        gridEndX = this.layoutProfile.computePositionX(halfCharPos + 2, characterWidth, halfSpaceWidth);
                    }
                    halfCharPos += 2 + this.positionIterator.nextSpaceType().getHalfCharSize();
                }
                if (paintGrid && (byteOffset & 1) != 0) {
                    g.fillRect(headerX + gridStartX, headerArea.y, gridEndX - gridStartX, headerArea.height);
                }
                if ((this.positionIterator.getPosition() < skipRestFrom || skipRestFrom < 0) && this.positionIterator.getSection() != BasicCodeAreaSection.TEXT_PREVIEW && !this.positionIterator.isEndReached()) continue;
            }
            g.setColor(this.colorsProfile.getColor((CodeAreaColorType)CodeAreaBasicColors.TEXT_COLOR));
            this.positionIterator.reset();
            this.positionIterator.skip(this.visibility.getSkipTo());
            halfCharPos = this.positionIterator.getHalfCharPosition();
            int renderCharOffset = halfCharPos / 2;
            int renderCharOffsetShifted = renderCharOffset / 2;
            Color renderColor = null;
            Color renderColorShifted = null;
            do {
                for (int i = 0; i < codeLength; ++i) {
                    Color color;
                    char currentChar;
                    boolean nonshifted;
                    int charPos = halfCharPos / 2;
                    boolean sequenceBreak = false;
                    boolean bl2 = nonshifted = (halfCharPos & 1) == 0;
                    if (nonshifted) {
                        currentChar = this.rowDataCache.headerChars[charPos - skipToChar];
                        if (currentChar == ' ' && renderCharOffset == charPos) {
                            ++renderCharOffset;
                            continue;
                        }
                        color = this.colorsProfile.getColor((CodeAreaColorType)CodeAreaBasicColors.TEXT_COLOR);
                        if (!CodeAreaSwingUtils.areSameColors((Color)color, renderColor)) {
                            sequenceBreak = true;
                        }
                        if (sequenceBreak) {
                            if (renderCharOffset < charPos) {
                                this.drawCenteredChars(g, this.rowDataCache.headerChars, renderCharOffset - skipToChar, charPos - renderCharOffset, characterWidth, headerX + renderCharOffset * characterWidth, headerY);
                            }
                            if (!CodeAreaSwingUtils.areSameColors((Color)color, renderColor)) {
                                renderColor = color;
                                g.setColor(color);
                            }
                            renderCharOffset = charPos;
                        }
                    } else {
                        currentChar = this.rowDataCache.headerCharsShifted[charPos - skipToChar];
                        if (currentChar == ' ' && renderCharOffsetShifted == charPos) {
                            ++renderCharOffsetShifted;
                            continue;
                        }
                        color = this.colorsProfile.getColor((CodeAreaColorType)CodeAreaBasicColors.TEXT_COLOR);
                        if (!CodeAreaSwingUtils.areSameColors((Color)color, renderColorShifted)) {
                            sequenceBreak = true;
                        }
                        if (sequenceBreak) {
                            if (renderCharOffsetShifted < charPos) {
                                this.drawCenteredChars(g, this.rowDataCache.headerCharsShifted, renderCharOffsetShifted - skipToChar, charPos - renderCharOffsetShifted, characterWidth, headerX + renderCharOffsetShifted * characterWidth + halfSpaceWidth, headerY);
                            }
                            if (!CodeAreaSwingUtils.areSameColors((Color)color, renderColorShifted)) {
                                renderColorShifted = color;
                                g.setColor(color);
                            }
                            renderCharOffsetShifted = charPos;
                        }
                    }
                    halfCharPos += 2 + this.positionIterator.nextSpaceType().getHalfCharSize();
                }
            } while ((this.positionIterator.getPosition() < skipRestFrom || skipRestFrom < 0) && this.positionIterator.getSection() != BasicCodeAreaSection.TEXT_PREVIEW && !this.positionIterator.isEndReached());
            if (renderCharOffset < skipRestFromChar) {
                this.drawCenteredChars(g, this.rowDataCache.headerChars, renderCharOffset - skipToChar, skipRestFromChar - renderCharOffset, characterWidth, headerX + renderCharOffset * characterWidth, headerY);
            }
            if (this.layoutProfile.isHalfShiftedUsed() && renderCharOffsetShifted < skipRestFromChar) {
                this.drawCenteredChars(g, this.rowDataCache.headerCharsShifted, renderCharOffsetShifted - skipToChar, skipRestFromChar - renderCharOffsetShifted, characterWidth, headerX + renderCharOffsetShifted * characterWidth + halfSpaceWidth, headerY);
            }
        }
        g.setColor(this.colorsProfile.getColor((CodeAreaColorType)BasicCodeAreaDecorationColorType.LINE));
        if (this.themeProfile.showHeaderLine() || this.themeProfile.showBoxLine()) {
            g.drawLine(headerArea.x, headerArea.y + headerArea.height - 1, headerArea.x + headerArea.width, headerArea.y + headerArea.height - 1);
        }
        int splitLinePos = this.visibility.getSplitLinePos();
        if (this.themeProfile.showSplitLine() && splitLinePos > 0 && (lineX = dataViewX + splitLinePos - this.scrolling.getHorizontalScrollX(characterWidth)) >= dataViewX) {
            g.drawLine(lineX, headerArea.y, lineX, headerArea.y + headerArea.height);
        }
        if ((groupSize = this.themeProfile.getVerticalLineByteGroupSize()) > 0 && (viewMode == CodeAreaViewMode.DUAL || viewMode == CodeAreaViewMode.CODE_MATRIX) && this.visibility.isCodeSectionVisible()) {
            this.positionIterator.reset();
            this.positionIterator.skip(this.visibility.getSkipTo());
            int halfCharPos = this.positionIterator.getHalfCharPosition();
            while (!this.positionIterator.isEndReached()) {
                SpaceType nextSpaceType = this.positionIterator.nextSpaceType();
                if (this.positionIterator.isEndReached() || this.positionIterator.getSection() != BasicCodeAreaSection.CODE_MATRIX) break;
                int spaceHalfCharSize = nextSpaceType.getHalfCharSize();
                halfCharPos += 2;
                if (this.positionIterator.getCodeOffset() == 0 && this.positionIterator.getBytePosition() % groupSize == 0) {
                    int lineX2 = dataViewX + this.layoutProfile.computePositionX(halfCharPos, characterWidth, halfSpaceWidth) + spaceHalfCharSize * halfSpaceWidth / 2 - this.scrolling.getHorizontalScrollX(characterWidth);
                    g.drawLine(lineX2, headerArea.y, lineX2, headerArea.y + headerArea.height);
                }
                halfCharPos += spaceHalfCharSize;
                if ((this.positionIterator.getPosition() < skipRestFrom || skipRestFrom < 0) && this.positionIterator.getSection() != BasicCodeAreaSection.TEXT_PREVIEW) continue;
                break;
            }
        }
        g.setClip(clipBounds);
    }

    public void paintRowPosition(Graphics g) {
        int row;
        long dataPosition;
        if (!this.dimensions.getLayoutProfile().isShowRowPosition()) {
            return;
        }
        int bytesPerRow = this.structure.getBytesPerRow();
        long dataSize = this.codeArea.getDataSize();
        int rowHeight = this.metrics.getRowHeight();
        int characterWidth = this.metrics.getCharacterWidth();
        int subFontSpace = this.metrics.getSubFontSpace();
        int rowsPerRect = this.dimensions.getRowsPerRect();
        Rectangle rowPosRectangle = this.dimensions.getRowPositionAreaRectangle();
        Rectangle dataViewRectangle = this.dimensions.getDataViewRectangle();
        Rectangle clipBounds = g.getClipBounds();
        g.setClip(clipBounds != null ? clipBounds.intersection(rowPosRectangle) : rowPosRectangle);
        g.setFont(this.font);
        g.setColor(this.colorsProfile.getColor((CodeAreaColorType)CodeAreaBasicColors.TEXT_BACKGROUND));
        g.fillRect(rowPosRectangle.x, rowPosRectangle.y, rowPosRectangle.width, rowPosRectangle.height);
        CodeAreaScrollPosition scrollPosition = this.scrolling.getScrollPosition();
        if (this.themeProfile.isPaintRowPosBackground() && (this.themeProfile.getBackgroundPaintMode() == ExtendedBackgroundPaintMode.STRIPED || this.themeProfile.getBackgroundPaintMode() == ExtendedBackgroundPaintMode.GRIDDED || this.themeProfile.getBackgroundPaintMode() == ExtendedBackgroundPaintMode.CHESSBOARD)) {
            dataPosition = scrollPosition.getRowPosition() * (long)bytesPerRow + (long)((scrollPosition.getRowPosition() & 1L) > 0L ? 0 : bytesPerRow);
            int stripePositionY = rowPosRectangle.y - scrollPosition.getRowOffset() + ((scrollPosition.getRowPosition() & 1L) > 0L ? 0 : rowHeight);
            g.setColor(this.colorsProfile.getColor((CodeAreaColorType)CodeAreaBasicColors.ALTERNATE_BACKGROUND));
            for (row = 0; row <= rowsPerRect / 2 && dataPosition <= dataSize; dataPosition += (long)(bytesPerRow * 2), ++row) {
                g.fillRect(rowPosRectangle.x, stripePositionY, rowPosRectangle.width, rowHeight);
                stripePositionY += rowHeight * 2;
            }
        }
        dataPosition = (long)bytesPerRow * scrollPosition.getRowPosition();
        int positionY = rowPosRectangle.y + rowHeight - subFontSpace - scrollPosition.getRowOffset();
        g.setColor(this.colorsProfile.getColor((CodeAreaColorType)CodeAreaBasicColors.TEXT_COLOR));
        for (row = 0; row <= rowsPerRect && dataPosition <= dataSize; ++row) {
            CodeAreaUtils.longToBaseCode((char[])this.rowDataCache.rowPositionCode, (int)0, (long)(dataPosition < 0L ? 0L : dataPosition), (int)this.structure.getPositionCodeType().getBase(), (int)this.rowPositionLength, (boolean)true, (CodeCharactersCase)CodeCharactersCase.UPPER);
            this.drawCenteredChars(g, this.rowDataCache.rowPositionCode, 0, this.rowPositionLength, characterWidth, rowPosRectangle.x + this.dimensions.getLayoutProfile().computeRowPositionOffsetPositionX(), positionY);
            positionY += rowHeight;
            if ((dataPosition += (long)bytesPerRow) < 0L) break;
        }
        g.setColor(this.colorsProfile.getColor((CodeAreaColorType)BasicCodeAreaDecorationColorType.LINE));
        if (this.themeProfile.showRowPositionLine()) {
            int lineX = rowPosRectangle.x + rowPosRectangle.width - characterWidth / 2;
            if (lineX >= rowPosRectangle.x) {
                g.drawLine(lineX, dataViewRectangle.y, lineX, dataViewRectangle.y + dataViewRectangle.height);
            }
            g.drawLine(dataViewRectangle.x, dataViewRectangle.y - 1, dataViewRectangle.x + dataViewRectangle.width, dataViewRectangle.y - 1);
        }
        if (this.themeProfile.showBoxLine() && rowPosRectangle.width >= 0) {
            g.drawLine(rowPosRectangle.width - 1, dataViewRectangle.y, rowPosRectangle.width - 1, dataViewRectangle.y + dataViewRectangle.height);
        }
        g.setClip(clipBounds);
    }

    public void paintMainArea(Graphics g) {
        if (!this.initialized) {
            this.reset();
        }
        if (this.fontChanged) {
            this.fontChanged(g);
            this.fontChanged = false;
        }
        Rectangle mainAreaRect = this.dimensions.getMainAreaRectangle();
        Rectangle dataViewRectangle = this.dimensions.getDataViewRectangle();
        int splitLinePos = this.visibility.getSplitLinePos();
        Rectangle clipBounds = g.getClipBounds();
        g.setClip(clipBounds != null ? clipBounds.intersection(mainAreaRect) : mainAreaRect);
        this.paintBackground(g);
        int characterWidth = this.metrics.getCharacterWidth();
        this.paintRows(g);
        g.setColor(this.colorsProfile.getColor((CodeAreaColorType)BasicCodeAreaDecorationColorType.LINE));
        int lineX = dataViewRectangle.x + splitLinePos - this.scrolling.getHorizontalScrollX(characterWidth);
        if (this.themeProfile.showSplitLine() && splitLinePos > 0) {
            g.drawLine(lineX, dataViewRectangle.y, lineX, dataViewRectangle.y + dataViewRectangle.height);
        }
        int groupSize = this.themeProfile.getVerticalLineByteGroupSize();
        CodeAreaViewMode viewMode = this.structure.getViewMode();
        int skipRestFrom = this.visibility.getSkipRestFrom();
        if (groupSize > 0 && (viewMode == CodeAreaViewMode.DUAL || viewMode == CodeAreaViewMode.CODE_MATRIX) && this.visibility.isCodeSectionVisible()) {
            int halfSpaceWidth = characterWidth / 2;
            this.positionIterator.reset();
            this.positionIterator.skip(this.visibility.getSkipTo());
            int halfCharPos = this.positionIterator.getHalfCharPosition();
            while (!this.positionIterator.isEndReached()) {
                SpaceType nextSpaceType = this.positionIterator.nextSpaceType();
                if (this.positionIterator.isEndReached() || this.positionIterator.getSection() != BasicCodeAreaSection.CODE_MATRIX) break;
                int spaceHalfCharSize = nextSpaceType.getHalfCharSize();
                halfCharPos += 2;
                if (this.positionIterator.getBytePosition() > 0 && this.positionIterator.getCodeOffset() == 0 && this.positionIterator.getBytePosition() % groupSize == 0) {
                    int lineX2 = dataViewRectangle.x + this.layoutProfile.computePositionX(halfCharPos, characterWidth, halfSpaceWidth) + spaceHalfCharSize * halfSpaceWidth / 2 - this.scrolling.getHorizontalScrollX(characterWidth);
                    g.drawLine(lineX2, dataViewRectangle.y, lineX2, dataViewRectangle.y + dataViewRectangle.height);
                }
                halfCharPos += spaceHalfCharSize;
                if ((this.positionIterator.getPosition() < skipRestFrom || skipRestFrom < 0) && this.positionIterator.getSection() != BasicCodeAreaSection.TEXT_PREVIEW) continue;
                break;
            }
        }
        g.setClip(clipBounds);
        this.paintCursor(g);
    }

    public void paintBackground(Graphics g) {
        int bytesPerRow = this.structure.getBytesPerRow();
        long dataSize = this.codeArea.getDataSize();
        int rowHeight = this.metrics.getRowHeight();
        int characterWidth = this.metrics.getCharacterWidth();
        int halfSpaceWidth = characterWidth / 2;
        int rowsPerRect = this.dimensions.getRowsPerRect();
        Rectangle dataViewRect = this.dimensions.getDataViewRectangle();
        CodeAreaScrollPosition scrollPosition = this.scrolling.getScrollPosition();
        g.setColor(this.colorsProfile.getColor((CodeAreaColorType)CodeAreaBasicColors.TEXT_BACKGROUND));
        if (this.themeProfile.getBackgroundPaintMode() != ExtendedBackgroundPaintMode.TRANSPARENT) {
            g.fillRect(dataViewRect.x, dataViewRect.y, dataViewRect.width, dataViewRect.height);
        }
        if (this.themeProfile.getBackgroundPaintMode() == ExtendedBackgroundPaintMode.STRIPED || this.themeProfile.getBackgroundPaintMode() == ExtendedBackgroundPaintMode.GRIDDED || this.themeProfile.getBackgroundPaintMode() == ExtendedBackgroundPaintMode.CHESSBOARD) {
            g.setColor(this.colorsProfile.getColor((CodeAreaColorType)CodeAreaBasicColors.ALTERNATE_BACKGROUND));
            long dataPosition = scrollPosition.getRowPosition() * (long)bytesPerRow;
            int rowAlternatingOffset = (int)(scrollPosition.getRowPosition() & 1L);
            int stripePositionY = dataViewRect.y - scrollPosition.getRowOffset();
            for (int row = 0; row <= rowsPerRect && dataPosition <= dataSize; dataPosition += (long)bytesPerRow, ++row) {
                boolean oddRow;
                boolean bl = oddRow = (row & 1) != rowAlternatingOffset;
                if (oddRow && (this.themeProfile.getBackgroundPaintMode() == ExtendedBackgroundPaintMode.STRIPED || this.themeProfile.getBackgroundPaintMode() == ExtendedBackgroundPaintMode.GRIDDED)) {
                    g.fillRect(dataViewRect.x, stripePositionY, dataViewRect.width, rowHeight);
                }
                if (this.themeProfile.getBackgroundPaintMode() == ExtendedBackgroundPaintMode.GRIDDED || this.themeProfile.getBackgroundPaintMode() == ExtendedBackgroundPaintMode.CHESSBOARD) {
                    this.positionIterator.reset();
                    this.positionIterator.skip(this.visibility.getSkipTo());
                    int gridStartX = 0;
                    int halfCharPos = 0;
                    int bytePosition = 0;
                    boolean first = true;
                    do {
                        if (first || this.positionIterator.getCodeOffset() == 0) {
                            int nextGridStartX = first ? 0 : this.layoutProfile.computePositionX(this.positionIterator.getHalfCharPosition(), characterWidth, halfSpaceWidth);
                            first = false;
                            if (this.themeProfile.getBackgroundPaintMode() == ExtendedBackgroundPaintMode.GRIDDED && bytePosition & true && !oddRow || this.themeProfile.getBackgroundPaintMode() == ExtendedBackgroundPaintMode.CHESSBOARD && (bytePosition & 1) != (row + rowAlternatingOffset & 1)) {
                                int positionX = dataViewRect.x - this.scrolling.getHorizontalScrollX(characterWidth) + gridStartX;
                                int width = this.layoutProfile.computePositionX(halfCharPos, characterWidth, halfSpaceWidth) - gridStartX;
                                g.fillRect(positionX, stripePositionY, width, rowHeight);
                            }
                            gridStartX = nextGridStartX;
                        }
                        if (this.positionIterator.getPosition() == this.visibility.getSkipRestFrom() || this.positionIterator.getSection() == BasicCodeAreaSection.TEXT_PREVIEW) break;
                        halfCharPos = this.positionIterator.getHalfCharPosition() + 2;
                        bytePosition = this.positionIterator.getBytePosition();
                        this.positionIterator.nextSpaceType();
                    } while (!this.positionIterator.isEndReached());
                }
                stripePositionY += rowHeight;
            }
        }
    }

    public void paintRows(Graphics g) {
        int bytesPerRow = this.structure.getBytesPerRow();
        int rowHeight = this.metrics.getRowHeight();
        int dataViewX = this.dimensions.getScrollPanelX();
        int dataViewY = this.dimensions.getScrollPanelY();
        int rowsPerRect = this.dimensions.getRowsPerRect();
        long dataSize = this.codeArea.getDataSize();
        CodeAreaScrollPosition scrollPosition = this.scrolling.getScrollPosition();
        long dataPosition = scrollPosition.getRowPosition() * (long)bytesPerRow;
        int characterWidth = this.metrics.getCharacterWidth();
        int rowPositionX = dataViewX - this.scrolling.getHorizontalScrollX(characterWidth);
        int rowPositionY = dataViewY - scrollPosition.getRowOffset();
        g.setColor(this.colorsProfile.getColor((CodeAreaColorType)CodeAreaBasicColors.TEXT_COLOR));
        for (int row = 0; row <= rowsPerRect && dataPosition <= dataSize; ++row) {
            this.prepareRowData(dataPosition);
            this.paintRowBackground(g, dataPosition, rowPositionX, rowPositionY);
            this.paintRowText(g, dataPosition, rowPositionX, rowPositionY);
            rowPositionY += rowHeight;
            if (Long.MAX_VALUE - dataPosition < (long)bytesPerRow) {
                dataPosition = Long.MAX_VALUE;
                continue;
            }
            dataPosition += (long)bytesPerRow;
        }
    }

    private void prepareRowData(long dataPosition) {
        int maxBytesPerChar = this.metrics.getMaxBytesPerChar();
        int bytesPerRow = this.structure.getBytesPerRow();
        long dataSize = this.codeArea.getDataSize();
        CodeType codeType = this.structure.getCodeType();
        int rowStart = 0;
        if (dataPosition < dataSize) {
            int rowDataSize = bytesPerRow + maxBytesPerChar - 1;
            if (dataSize - dataPosition < (long)rowDataSize) {
                rowDataSize = (int)(dataSize - dataPosition);
            }
            if (dataPosition < 0L) {
                rowStart = (int)(-dataPosition);
            }
            BinaryData data = this.codeArea.getContentData();
            data.copyToArray(dataPosition + (long)rowStart, this.rowDataCache.rowData, rowStart, rowDataSize - rowStart);
        }
        Arrays.fill(this.rowDataCache.rowCharacters, ' ');
        if (this.layoutProfile.isHalfShiftedUsed()) {
            Arrays.fill(this.rowDataCache.rowCharactersShifted, ' ');
        }
        if (this.showUnprintables) {
            Arrays.fill(this.rowDataCache.unprintables, (byte)0);
            if (this.unprintableCharactersMapping == null) {
                this.buildUnprintableCharactersMapping();
            }
        }
        this.positionIterator.reset();
        this.positionIterator.skip(this.visibility.getSkipTo());
        int skipToChar = this.visibility.getSkipToChar();
        int halfCharPos = this.positionIterator.getHalfCharPosition();
        boolean first = true;
        do {
            int targetChar;
            Character replacement;
            String displayString;
            int charDataLength;
            BasicCodeAreaSection section = this.positionIterator.getSection();
            if (this.positionIterator.getPosition() == this.visibility.getSkipRestFrom()) break;
            int byteOffset = this.positionIterator.getBytePosition();
            int charPos = halfCharPos / 2 - skipToChar;
            int codeOffset = this.positionIterator.getCodeOffset();
            byte dataByte = this.rowDataCache.rowData[byteOffset];
            if (section == BasicCodeAreaSection.CODE_MATRIX) {
                if (dataPosition + (long)byteOffset < dataSize) {
                    if (this.showUnprintables) {
                        charDataLength = maxBytesPerChar;
                        if (byteOffset + charDataLength > this.rowDataCache.rowData.length) {
                            charDataLength = this.rowDataCache.rowData.length - byteOffset;
                        }
                        if (!(displayString = new String(this.rowDataCache.rowData, byteOffset, charDataLength, this.charset)).isEmpty() && (replacement = this.unprintableCharactersMapping.get(Character.valueOf((char)(targetChar = displayString.charAt(0))))) != null) {
                            int n = byteOffset >> 3;
                            this.rowDataCache.unprintables[n] = (byte)(this.rowDataCache.unprintables[n] | 1 << (byteOffset & 7));
                        }
                    }
                    if (first || codeOffset == 0) {
                        CodeAreaUtils.byteToCharsCode((byte)dataByte, (CodeType)codeType, (char[])this.rowDataCache.rowCodeData, (int)0, (CodeCharactersCase)this.codeCharactersCase);
                        first = false;
                    }
                    if ((halfCharPos & 1) == 0) {
                        this.rowDataCache.rowCharacters[charPos] = this.rowDataCache.rowCodeData[codeOffset];
                    } else {
                        this.rowDataCache.rowCharactersShifted[charPos] = this.rowDataCache.rowCodeData[codeOffset];
                    }
                }
            } else {
                if (dataPosition + (long)byteOffset >= dataSize) break;
                if (maxBytesPerChar > 1) {
                    if (dataPosition + (long)maxBytesPerChar > dataSize) {
                        maxBytesPerChar = (int)(dataSize - dataPosition);
                    }
                    if (byteOffset + (charDataLength = maxBytesPerChar) > this.rowDataCache.rowData.length) {
                        charDataLength = this.rowDataCache.rowData.length - byteOffset;
                    }
                    targetChar = !(displayString = new String(this.rowDataCache.rowData, byteOffset, charDataLength, this.charset)).isEmpty() ? (int)displayString.charAt(0) : 32;
                } else {
                    if (this.charMappingCharset == null || this.charMappingCharset != this.charset) {
                        this.buildCharMapping(this.charset);
                    }
                    targetChar = this.charMapping[dataByte & 0xFF];
                }
                if (this.showUnprintables && (replacement = this.unprintableCharactersMapping.get(Character.valueOf((char)targetChar))) != null) {
                    int n = byteOffset >> 3;
                    this.rowDataCache.unprintables[n] = (byte)(this.rowDataCache.unprintables[n] | 1 << (byteOffset & 7));
                    targetChar = replacement.charValue();
                }
                if ((halfCharPos & 1) == 0) {
                    this.rowDataCache.rowCharacters[charPos] = targetChar;
                } else {
                    this.rowDataCache.rowCharactersShifted[charPos] = targetChar;
                }
            }
            halfCharPos += 2 + this.positionIterator.nextSpaceType().getHalfCharSize();
        } while (!this.positionIterator.isEndReached());
    }

    public void paintRowBackground(Graphics g, long rowDataPosition, int rowPositionX, int rowPositionY) {
        CodeAreaViewMode viewMode = this.structure.getViewMode();
        int charactersPerRow = this.structure.getHalfCharsPerRow();
        Color renderColor = null;
        this.positionIterator.reset();
        this.positionIterator.skip(this.visibility.getSkipTo());
        int renderOffset = this.positionIterator.getHalfCharPosition();
        int spaceSize = 0;
        int halfCharPos = this.positionIterator.getHalfCharPosition();
        do {
            boolean splitSpace;
            BasicCodeAreaSection section = this.positionIterator.getSection();
            if (this.positionIterator.getPosition() == this.visibility.getSkipRestFrom()) break;
            int byteOnRow = this.positionIterator.getBytePosition();
            int charPos = halfCharPos;
            boolean sequenceBreak = false;
            boolean unprintable = this.showUnprintables && (this.rowDataCache.unprintables[byteOnRow >> 3] & 1 << (byteOnRow & 7)) != 0;
            Color color = this.getPositionBackgroundColor(rowDataPosition, byteOnRow, charPos, (CodeAreaSection)section, unprintable);
            if (!CodeAreaSwingUtils.areSameColors((Color)color, renderColor)) {
                sequenceBreak = true;
            }
            boolean bl = splitSpace = viewMode == CodeAreaViewMode.DUAL && this.positionIterator.getSection() == BasicCodeAreaSection.TEXT_PREVIEW && this.positionIterator.getBytePosition() == 0;
            if (splitSpace) {
                sequenceBreak = true;
                charPos = halfCharPos - spaceSize;
            }
            if (sequenceBreak) {
                if (renderOffset < charPos && renderColor != null) {
                    this.renderBackgroundSequence(g, renderOffset, charPos, rowPositionX, rowPositionY);
                }
                if (!CodeAreaSwingUtils.areSameColors((Color)color, renderColor)) {
                    renderColor = color;
                    if (color != null) {
                        g.setColor(color);
                    }
                }
                renderOffset = charPos;
            }
            if (splitSpace) {
                renderOffset += spaceSize;
            }
            spaceSize = this.positionIterator.nextSpaceType().getHalfCharSize();
            halfCharPos += 2 + spaceSize;
        } while (!this.positionIterator.isEndReached());
        if (renderOffset < charactersPerRow && renderColor != null) {
            this.renderBackgroundSequence(g, renderOffset, charactersPerRow, rowPositionX, rowPositionY);
        }
    }

    @Nullable
    public Color getPositionBackgroundColor(long rowDataPosition, int byteOnRow, int halfCharOnRow, CodeAreaSection section, boolean unprintable) {
        CodeAreaSelection selectionHandler = ((SelectionCapable)this.codeArea).getSelectionHandler();
        int codeLastCharPos = this.structure.getCodeLastHalfCharPos();
        boolean inSelection = selectionHandler.isInSelection(rowDataPosition + (long)byteOnRow);
        if (inSelection && section == BasicCodeAreaSection.CODE_MATRIX && halfCharOnRow == codeLastCharPos) {
            inSelection = false;
        }
        if (inSelection) {
            return section == ((CaretCapable)this.codeArea).getActiveSection() ? this.colorsProfile.getColor((CodeAreaColorType)CodeAreaBasicColors.SELECTION_BACKGROUND) : this.colorsProfile.getColor((CodeAreaColorType)CodeAreaBasicColors.SELECTION_MIRROR_BACKGROUND);
        }
        if (this.showUnprintables && unprintable) {
            return this.colorsProfile.getColor((CodeAreaColorType)CodeAreaUnprintablesColorType.UNPRINTABLES_BACKGROUND, null);
        }
        return null;
    }

    @Nonnull
    public PositionScrollVisibility computePositionScrollVisibility(CodeAreaCaretPosition caretPosition) {
        int bytesPerRow = this.structure.getBytesPerRow();
        int characterWidth = this.metrics.getCharacterWidth();
        int rowHeight = this.metrics.getRowHeight();
        int dataViewWidth = this.dimensions.getDataViewWidth();
        int rowOffset = this.dimensions.getRowOffset();
        int rowsPerPage = this.dimensions.getRowsPerPage();
        int charactersPerPage = this.dimensions.getHalfCharsPerPage();
        long dataPosition = caretPosition.getDataPosition();
        long rowPosition = dataPosition / (long)bytesPerRow;
        int halfCharPosition = this.computeHalfCharPosition(dataPosition, bytesPerRow, caretPosition);
        return this.scrolling.computePositionScrollVisibility(rowPosition, halfCharPosition, bytesPerRow, rowsPerPage, charactersPerPage, dataViewWidth, rowOffset, characterWidth, rowHeight);
    }

    @Nonnull
    public Optional<CodeAreaScrollPosition> computeRevealScrollPosition(CodeAreaCaretPosition caretPosition) {
        int bytesPerRow = this.structure.getBytesPerRow();
        int characterWidth = this.metrics.getCharacterWidth();
        int rowHeight = this.metrics.getRowHeight();
        int dataViewWidth = this.dimensions.getDataViewWidth();
        int rowOffset = this.dimensions.getRowOffset();
        int rowsPerPage = this.dimensions.getRowsPerPage();
        int halfCharsPerPage = this.dimensions.getHalfCharsPerPage();
        long dataPosition = caretPosition.getDataPosition();
        long rowPosition = dataPosition / (long)bytesPerRow;
        int halfCharPosition = this.computeHalfCharPosition(dataPosition, bytesPerRow, caretPosition);
        int halfCharOffset = dataViewWidth % (this.scrolling.getHorizontalScrollUnit() == ExtendedHorizontalScrollUnit.HALF_CHARACTER ? characterWidth : characterWidth / 2);
        return this.scrolling.computeRevealScrollPosition(rowPosition, halfCharPosition, bytesPerRow, rowsPerPage, halfCharsPerPage, halfCharOffset, rowOffset, characterWidth, rowHeight);
    }

    @Nonnull
    public Optional<CodeAreaScrollPosition> computeCenterOnScrollPosition(CodeAreaCaretPosition caretPosition) {
        int bytesPerRow = this.structure.getBytesPerRow();
        int characterWidth = this.metrics.getCharacterWidth();
        int rowHeight = this.metrics.getRowHeight();
        int dataViewWidth = this.dimensions.getDataViewWidth();
        int dataViewHeight = this.dimensions.getDataViewHeight();
        int rowOffset = this.dimensions.getRowOffset();
        int rowsPerRect = this.dimensions.getRowsPerRect();
        int halfCharsPerRect = this.dimensions.getHalfCharsPerRect();
        long dataPosition = caretPosition.getDataPosition();
        long rowPosition = dataPosition / (long)bytesPerRow;
        int halfCharPosition = this.computeHalfCharPosition(dataPosition, bytesPerRow, caretPosition);
        return this.scrolling.computeCenterOnScrollPosition(rowPosition, halfCharPosition, bytesPerRow, rowsPerRect, halfCharsPerRect, dataViewWidth, dataViewHeight, rowOffset, characterWidth, rowHeight);
    }

    private int computeHalfCharPosition(long dataPosition, int bytesPerRow, CodeAreaCaretPosition caretPosition) {
        int byteOffset = (int)(dataPosition % (long)bytesPerRow);
        return this.structure.computeFirstCodeHalfCharPos(byteOffset, this.getSection(caretPosition)) + caretPosition.getCodeOffset() * 2;
    }

    public void paintRowText(Graphics g, long rowDataPosition, int rowPositionX, int rowPositionY) {
        int renderCharOffset;
        int rowHeight = this.metrics.getRowHeight();
        int characterWidth = this.metrics.getCharacterWidth();
        int halfSpaceWidth = characterWidth / 2;
        int subFontSpace = this.metrics.getSubFontSpace();
        int skipToChar = this.visibility.getSkipToChar();
        int skipRestFromChar = this.visibility.getSkipRestFromChar();
        g.setFont(this.font);
        int positionY = rowPositionY + rowHeight - subFontSpace;
        Color lastColor = null;
        Color renderColor = null;
        Color renderColorShifted = null;
        boolean unprintables = false;
        this.positionIterator.reset();
        this.positionIterator.skip(this.visibility.getSkipTo());
        int halfCharPos = this.positionIterator.getHalfCharPosition();
        int renderCharOffsetShifted = renderCharOffset = halfCharPos / 2;
        do {
            boolean sequenceBreak;
            Color color;
            char currentChar;
            BasicCodeAreaSection section = this.positionIterator.getSection();
            int byteOffset = this.positionIterator.getBytePosition();
            boolean currentUnprintables = false;
            if (this.showUnprintables) {
                currentUnprintables = (this.rowDataCache.unprintables[byteOffset >> 3] & 1 << (byteOffset & 7)) != 0;
            }
            int charPos = halfCharPos / 2;
            if ((halfCharPos & 1) == 0) {
                currentChar = this.rowDataCache.rowCharacters[charPos - skipToChar];
                if (currentChar == ' ' && renderCharOffset == charPos) {
                    ++renderCharOffset;
                    continue;
                }
                color = this.getPositionTextColor(rowDataPosition, byteOffset, halfCharPos, (CodeAreaSection)section, currentUnprintables);
                if (color == null) {
                    color = this.colorsProfile.getColor((CodeAreaColorType)CodeAreaBasicColors.TEXT_COLOR);
                }
                sequenceBreak = false;
                if (!CodeAreaSwingUtils.areSameColors((Color)color, renderColor)) {
                    if (renderColor == null) {
                        renderColor = color;
                    }
                    sequenceBreak = true;
                }
                if (unprintables != currentUnprintables) {
                    sequenceBreak = true;
                }
                if (sequenceBreak) {
                    if (!CodeAreaSwingUtils.areSameColors((Color)lastColor, (Color)renderColor)) {
                        g.setColor(renderColor);
                        lastColor = renderColor;
                    }
                    if (charPos > renderCharOffset) {
                        this.drawCenteredChars(g, this.rowDataCache.rowCharacters, renderCharOffset - skipToChar, charPos - renderCharOffset, characterWidth, rowPositionX + renderCharOffset * characterWidth, positionY);
                    }
                    if (!CodeAreaSwingUtils.areSameColors((Color)lastColor, (Color)(renderColor = color))) {
                        g.setColor(renderColor);
                        lastColor = renderColor;
                    }
                    renderCharOffset = charPos;
                    unprintables = currentUnprintables;
                }
            } else {
                currentChar = this.rowDataCache.rowCharactersShifted[charPos - skipToChar];
                if (currentChar == ' ' && renderCharOffsetShifted == charPos) {
                    ++renderCharOffsetShifted;
                    continue;
                }
                color = this.getPositionTextColor(rowDataPosition, byteOffset, halfCharPos, (CodeAreaSection)section, currentUnprintables);
                if (color == null) {
                    color = this.colorsProfile.getColor((CodeAreaColorType)CodeAreaBasicColors.TEXT_COLOR);
                }
                sequenceBreak = false;
                if (!CodeAreaSwingUtils.areSameColors((Color)color, renderColorShifted)) {
                    if (renderColorShifted == null) {
                        renderColorShifted = color;
                    }
                    sequenceBreak = true;
                }
                if (unprintables != currentUnprintables) {
                    sequenceBreak = true;
                }
                if (sequenceBreak) {
                    if (!CodeAreaSwingUtils.areSameColors((Color)lastColor, (Color)renderColorShifted)) {
                        g.setColor(renderColorShifted);
                        lastColor = renderColorShifted;
                    }
                    if (charPos > renderCharOffsetShifted) {
                        this.drawCenteredChars(g, this.rowDataCache.rowCharactersShifted, renderCharOffsetShifted - skipToChar, charPos - renderCharOffsetShifted, characterWidth, rowPositionX + renderCharOffsetShifted * characterWidth + halfSpaceWidth, positionY);
                    }
                    if (!CodeAreaSwingUtils.areSameColors((Color)lastColor, (Color)(renderColorShifted = color))) {
                        g.setColor(renderColorShifted);
                        lastColor = renderColorShifted;
                    }
                    renderCharOffsetShifted = charPos;
                    unprintables = currentUnprintables;
                }
            }
            halfCharPos += 2 + this.positionIterator.nextSpaceType().getHalfCharSize();
            if (this.positionIterator.getPosition() == this.visibility.getSkipRestFrom()) break;
        } while (!this.positionIterator.isEndReached());
        if (renderCharOffset < skipRestFromChar) {
            if (!CodeAreaSwingUtils.areSameColors(lastColor, renderColor)) {
                g.setColor(renderColor);
                lastColor = renderColor;
            }
            this.drawCenteredChars(g, this.rowDataCache.rowCharacters, renderCharOffset - skipToChar, skipRestFromChar - renderCharOffset, characterWidth, rowPositionX + renderCharOffset * characterWidth, positionY);
        }
        if (this.layoutProfile.isHalfShiftedUsed() && renderCharOffsetShifted < skipRestFromChar) {
            if (!CodeAreaSwingUtils.areSameColors((Color)lastColor, (Color)renderColorShifted)) {
                g.setColor(renderColorShifted);
            }
            this.drawCenteredChars(g, this.rowDataCache.rowCharactersShifted, renderCharOffsetShifted - skipToChar, skipRestFromChar - renderCharOffsetShifted, characterWidth, rowPositionX + renderCharOffsetShifted * characterWidth + halfSpaceWidth, positionY);
        }
    }

    @Nullable
    public Color getPositionTextColor(long rowDataPosition, int byteOnRow, int halfCharOnRow, CodeAreaSection section, boolean unprintable) {
        CodeAreaSelection selectionHandler = ((SelectionCapable)this.codeArea).getSelectionHandler();
        int codeLastCharPos = this.structure.getCodeLastHalfCharPos();
        boolean inSelection = selectionHandler.isInSelection(rowDataPosition + (long)byteOnRow);
        if (inSelection && section == BasicCodeAreaSection.CODE_MATRIX && halfCharOnRow == codeLastCharPos) {
            inSelection = false;
        }
        if (unprintable && section == BasicCodeAreaSection.TEXT_PREVIEW) {
            return this.colorsProfile.getColor((CodeAreaColorType)CodeAreaUnprintablesColorType.UNPRINTABLES_COLOR, CodeAreaBasicColors.TEXT_COLOR);
        }
        if (inSelection) {
            return section == ((CaretCapable)this.codeArea).getActiveSection() ? this.colorsProfile.getColor((CodeAreaColorType)CodeAreaBasicColors.SELECTION_COLOR) : this.colorsProfile.getColor((CodeAreaColorType)CodeAreaBasicColors.SELECTION_MIRROR_COLOR);
        }
        return null;
    }

    public void paintCursor(Graphics g) {
        boolean cursorVisible;
        DefaultCodeAreaCaret caret;
        Rectangle cursorRect;
        int cursorDataLength;
        int cursorCharsLength;
        if (!this.codeArea.hasFocus()) {
            return;
        }
        if (this.caretChanged) {
            this.updateCaret();
        }
        int maxBytesPerChar = this.metrics.getMaxBytesPerChar();
        Rectangle mainAreaRect = this.dimensions.getMainAreaRectangle();
        CodeType codeType = this.structure.getCodeType();
        CodeAreaViewMode viewMode = this.structure.getViewMode();
        if (this.cursorDataCache == null) {
            this.cursorDataCache = new CursorDataCache();
        }
        if (this.cursorDataCache.cursorCharsLength != (cursorCharsLength = codeType.getMaxDigitsForByte())) {
            this.cursorDataCache.cursorCharsLength = cursorCharsLength;
            this.cursorDataCache.cursorChars = new char[cursorCharsLength];
        }
        if (this.cursorDataCache.cursorDataLength != (cursorDataLength = maxBytesPerChar)) {
            this.cursorDataCache.cursorDataLength = cursorDataLength;
            this.cursorDataCache.cursorData = new byte[cursorDataLength];
        }
        if ((cursorRect = this.getCursorPositionRect((caret = (DefaultCodeAreaCaret)((CaretCapable)this.codeArea).getCaret()).getDataPosition(), caret.getCodeOffset(), caret.getSection())).isEmpty()) {
            return;
        }
        Rectangle scrolledCursorRect = new Rectangle(cursorRect.x, cursorRect.y, cursorRect.width, cursorRect.height);
        Rectangle clipBounds = g.getClipBounds();
        Rectangle intersection = scrolledCursorRect.intersection(mainAreaRect);
        boolean bl = cursorVisible = caret.isCursorVisible() && !intersection.isEmpty();
        if (cursorVisible) {
            g.setClip(intersection);
            DefaultCodeAreaCaret.CursorRenderingMode renderingMode = caret.getRenderingMode();
            g.setColor(this.colorsProfile.getColor((CodeAreaColorType)CodeAreaBasicColors.CURSOR_COLOR));
            CodeAreaCaretShape caretShape = this.caretsProfile.identifyCaretShape(CodeAreaCaretType.INSERT);
            this.paintCursorRect(g, intersection.x, intersection.y, intersection.width, intersection.height, renderingMode, caret, caretShape);
        }
        if (viewMode == CodeAreaViewMode.DUAL && this.showMirrorCursor) {
            this.updateMirrorCursorRect(caret.getDataPosition(), caret.getSection());
            Rectangle mirrorCursorRect = this.cursorDataCache.mirrorCursorRect;
            if (!mirrorCursorRect.isEmpty()) {
                boolean mirrorCursorVisible;
                intersection = mainAreaRect.intersection(mirrorCursorRect);
                boolean bl2 = mirrorCursorVisible = !intersection.isEmpty();
                if (mirrorCursorVisible) {
                    g.setClip(intersection);
                    g.setColor(this.colorsProfile.getColor((CodeAreaColorType)CodeAreaBasicColors.CURSOR_COLOR));
                    Graphics2D g2d = (Graphics2D)g.create();
                    g2d.setStroke(this.cursorDataCache.dashedStroke);
                    g2d.drawRect(mirrorCursorRect.x, mirrorCursorRect.y, mirrorCursorRect.width - 1, mirrorCursorRect.height - 1);
                    g2d.dispose();
                }
            }
        }
        g.setClip(clipBounds);
    }

    private void paintCursorRect(Graphics g, int cursorX, int cursorY, int width, int height, DefaultCodeAreaCaret.CursorRenderingMode renderingMode, DefaultCodeAreaCaret caret, CodeAreaCaretShape caretShape) {
        switch (renderingMode) {
            case PAINT: {
                this.caretsProfile.paintCaret(g, cursorX, cursorY, width, height, caretShape);
                break;
            }
            case XOR: {
                g.setXORMode(this.colorsProfile.getColor((CodeAreaColorType)CodeAreaBasicColors.TEXT_BACKGROUND));
                this.caretsProfile.paintCaret(g, cursorX, cursorY, width, height, caretShape);
                g.setPaintMode();
                break;
            }
            case NEGATIVE: {
                int characterWidth = this.metrics.getCharacterWidth();
                int rowHeight = this.metrics.getRowHeight();
                int maxBytesPerChar = this.metrics.getMaxBytesPerChar();
                int subFontSpace = this.metrics.getSubFontSpace();
                int dataViewX = this.dimensions.getScrollPanelX();
                int dataViewY = this.dimensions.getScrollPanelY();
                CodeAreaViewMode viewMode = this.structure.getViewMode();
                CodeAreaScrollPosition scrollPosition = this.scrolling.getScrollPosition();
                long dataSize = this.codeArea.getDataSize();
                CodeType codeType = this.structure.getCodeType();
                this.caretsProfile.paintCaret(g, cursorX, cursorY, width, height, caretShape);
                g.setColor(this.colorsProfile.getColor((CodeAreaColorType)CodeAreaBasicColors.CURSOR_NEGATIVE_COLOR));
                BinaryData contentData = this.codeArea.getContentData();
                int row = (cursorY + scrollPosition.getRowOffset() - dataViewY) / rowHeight;
                int posY = dataViewY + (row + 1) * rowHeight - subFontSpace - scrollPosition.getRowOffset();
                long dataPosition = caret.getDataPosition();
                CodeAreaSection section = caret.getSection();
                int codeOffset = caret.getCodeOffset();
                int bytesPerRow = this.structure.getBytesPerRow();
                int byteOffset = (int)(dataPosition % (long)bytesPerRow);
                int halfCharPos = this.layoutProfile.computeFirstByteHalfCharPos(byteOffset, section, this.structure);
                int relativeX = dataViewX - this.scrolling.getHorizontalScrollX(characterWidth);
                int posX = relativeX + this.layoutProfile.computePositionX(halfCharPos += codeOffset * 2, characterWidth, characterWidth / 2);
                if (viewMode != CodeAreaViewMode.CODE_MATRIX && caret.getSection() == BasicCodeAreaSection.TEXT_PREVIEW) {
                    if (dataPosition >= dataSize) break;
                    if (maxBytesPerChar > 1) {
                        int charDataLength = maxBytesPerChar;
                        if (dataPosition + (long)maxBytesPerChar > dataSize) {
                            charDataLength = (int)(dataSize - dataPosition);
                        }
                        if (contentData.isEmpty()) {
                            this.cursorDataCache.cursorChars[0] = 32;
                        } else {
                            contentData.copyToArray(dataPosition, this.cursorDataCache.cursorData, 0, charDataLength);
                            String displayString = new String(this.cursorDataCache.cursorData, 0, charDataLength, this.charset);
                            if (!displayString.isEmpty()) {
                                this.cursorDataCache.cursorChars[0] = displayString.charAt(0);
                            }
                        }
                    } else {
                        if (this.charMappingCharset == null || this.charMappingCharset != this.charset) {
                            this.buildCharMapping(this.charset);
                        }
                        this.cursorDataCache.cursorChars[0] = contentData.isEmpty() ? 32 : this.charMapping[contentData.getByte(dataPosition) & 0xFF];
                    }
                    this.drawCenteredChars(g, this.cursorDataCache.cursorChars, 0, 1, characterWidth, posX, posY);
                    break;
                }
                if (dataPosition < dataSize) {
                    byte dataByte = contentData.getByte(dataPosition);
                    CodeAreaUtils.byteToCharsCode((byte)dataByte, (CodeType)codeType, (char[])this.cursorDataCache.cursorChars, (int)0, (CodeCharactersCase)this.codeCharactersCase);
                } else {
                    Arrays.fill(this.cursorDataCache.cursorChars, ' ');
                }
                this.drawCenteredChars(g, this.cursorDataCache.cursorChars, codeOffset, 1, characterWidth, posX, posY);
                break;
            }
            default: {
                throw CodeAreaUtils.getInvalidTypeException((Enum)renderingMode);
            }
        }
    }

    @Nonnull
    public CodeAreaCaretPosition mousePositionToClosestCaretPosition(int positionX, int positionY, CaretOverlapMode overflowMode) {
        long cursorRowY;
        DefaultCodeAreaCaretPosition caret = new DefaultCodeAreaCaretPosition();
        CodeAreaScrollPosition scrollPosition = this.scrolling.getScrollPosition();
        int characterWidth = this.metrics.getCharacterWidth();
        int halfSpaceWidth = characterWidth / 2;
        int rowHeight = this.metrics.getRowHeight();
        int rowPositionAreaWidth = this.dimensions.getRowPositionAreaWidth();
        int headerAreaHeight = this.dimensions.getHeaderAreaHeight();
        int diffX = 0;
        if (positionX < rowPositionAreaWidth) {
            if (overflowMode == CaretOverlapMode.PARTIAL_OVERLAP) {
                diffX = characterWidth;
            }
            positionX = rowPositionAreaWidth;
        }
        int cursorX = positionX - rowPositionAreaWidth + this.scrolling.getHorizontalScrollX(characterWidth) - diffX;
        int halfCharPosX = 0;
        int codeOffset = 0;
        int byteOnRow = 0;
        BasicCodeAreaSection section = null;
        this.positionIterator.reset();
        do {
            codeOffset = this.positionIterator.getCodeOffset();
            byteOnRow = this.positionIterator.getBytePosition();
            section = this.positionIterator.getSection();
            int nextSpaceSize = this.positionIterator.nextSpaceType().getHalfCharSize();
            int posX = this.layoutProfile.computePositionX(halfCharPosX + 2 + nextSpaceSize / 2, characterWidth, halfSpaceWidth);
            if (cursorX < posX) break;
            halfCharPosX += 2 + nextSpaceSize;
        } while (!this.positionIterator.isEndReached());
        int diffY = 0;
        if (positionY < headerAreaHeight) {
            if (overflowMode == CaretOverlapMode.PARTIAL_OVERLAP) {
                diffY = 1;
            }
            positionY = headerAreaHeight;
        }
        if ((cursorRowY = (long)((positionY - headerAreaHeight + scrollPosition.getRowOffset()) / rowHeight) + scrollPosition.getRowPosition() - (long)diffY) < 0L) {
            cursorRowY = 0L;
        }
        int bytesPerRow = this.structure.getBytesPerRow();
        long dataSize = this.codeArea.getDataSize();
        long dataPosition = (long)byteOnRow + cursorRowY * (long)bytesPerRow;
        if (dataPosition < 0L) {
            dataPosition = 0L;
            codeOffset = 0;
        }
        if (dataPosition >= dataSize) {
            dataPosition = dataSize;
            codeOffset = 0;
        }
        caret.setSection((CodeAreaSection)section);
        caret.setDataPosition(dataPosition);
        caret.setCodeOffset(codeOffset);
        return caret;
    }

    @Nonnull
    public CodeAreaCaretPosition computeMovePosition(CodeAreaCaretPosition position, MovementDirection direction) {
        return this.structure.computeMovePosition(position, direction, this.dimensions.getRowsPerPage());
    }

    @Nonnull
    public CodeAreaScrollPosition computeScrolling(CodeAreaScrollPosition startPosition, ScrollingDirection direction) {
        int rowsPerPage = this.dimensions.getRowsPerPage();
        long rowsPerDocument = this.structure.getRowsPerDocument();
        return this.scrolling.computeScrolling(startPosition, direction, rowsPerPage, rowsPerDocument);
    }

    @Nullable
    public Point getPositionPoint(long dataPosition, int codeOffset, CodeAreaSection section) {
        int bytesPerRow = this.structure.getBytesPerRow();
        int rowsPerRect = this.dimensions.getRowsPerRect();
        int characterWidth = this.metrics.getCharacterWidth();
        int rowHeight = this.metrics.getRowHeight();
        CodeAreaScrollPosition scrollPosition = this.scrolling.getScrollPosition();
        long row = dataPosition / (long)bytesPerRow - scrollPosition.getRowPosition();
        if (row < -1L || row > (long)rowsPerRect) {
            return null;
        }
        int byteOffset = (int)(dataPosition % (long)bytesPerRow);
        Rectangle dataViewRect = this.dimensions.getDataViewRectangle();
        int caretY = (int)((long)dataViewRect.y + row * (long)rowHeight) - scrollPosition.getRowOffset();
        int halfCharPos = this.layoutProfile.computeFirstByteHalfCharPos(byteOffset, section, this.structure);
        int caretX = dataViewRect.x + this.layoutProfile.computePositionX(halfCharPos += codeOffset * 2, characterWidth, characterWidth / 2);
        return new Point(caretX -= this.scrolling.getHorizontalScrollX(characterWidth), caretY);
    }

    private void updateMirrorCursorRect(long dataPosition, CodeAreaSection section) {
        CodeType codeType = this.structure.getCodeType();
        Point mirrorCursorPoint = this.getPositionPoint(dataPosition, 0, (CodeAreaSection)(section == BasicCodeAreaSection.CODE_MATRIX ? BasicCodeAreaSection.TEXT_PREVIEW : BasicCodeAreaSection.CODE_MATRIX));
        if (mirrorCursorPoint == null) {
            this.cursorDataCache.mirrorCursorRect.setSize(0, 0);
        } else {
            this.cursorDataCache.mirrorCursorRect.setBounds(mirrorCursorPoint.x, mirrorCursorPoint.y, this.metrics.getCharacterWidth() * (section == BasicCodeAreaSection.TEXT_PREVIEW ? codeType.getMaxDigitsForByte() : 1), this.metrics.getRowHeight());
        }
    }

    public int getMouseCursorShape(int positionX, int positionY) {
        int dataViewX = this.dimensions.getScrollPanelX();
        int dataViewY = this.dimensions.getScrollPanelY();
        int scrollPanelWidth = this.dimensions.getScrollPanelWidth();
        int scrollPanelHeight = this.dimensions.getScrollPanelHeight();
        if (positionX >= dataViewX && positionX < dataViewX + scrollPanelWidth && positionY >= dataViewY && positionY < dataViewY + scrollPanelHeight) {
            return 2;
        }
        return 0;
    }

    @Nonnull
    public BasicCodeAreaZone getPositionZone(int positionX, int positionY) {
        return this.dimensions.getPositionZone(positionX, positionY);
    }

    @Override
    @Nonnull
    public CodeAreaColorsProfile getColorsProfile() {
        return this.colorsProfile;
    }

    @Override
    public void setColorsProfile(CodeAreaColorsProfile colorsProfile) {
        this.colorsProfile = colorsProfile;
        this.codeArea.repaint();
    }

    @Override
    @Nonnull
    public ExtendedCodeAreaLayoutProfile getLayoutProfile() {
        return this.layoutProfile.createCopy();
    }

    @Override
    public void setLayoutProfile(ExtendedCodeAreaLayoutProfile layoutProfile) {
        this.layoutProfile = layoutProfile.createCopy();
        this.resetLayout();
    }

    @Override
    @Nonnull
    public ExtendedCodeAreaThemeProfile getThemeProfile() {
        return this.themeProfile.createCopy();
    }

    @Override
    public void setThemeProfile(ExtendedCodeAreaThemeProfile themeProfile) {
        this.themeProfile = themeProfile.createCopy();
        this.codeArea.repaint();
    }

    @Override
    @Nonnull
    public ExtendedCodeAreaCaretsProfile getCaretsProfile() {
        return this.caretsProfile;
    }

    @Override
    public void setCaretsProfile(ExtendedCodeAreaCaretsProfile caretsProfile) {
        this.caretsProfile = caretsProfile;
        this.codeArea.repaint();
    }

    protected void drawCenteredChars(Graphics g, char[] drawnChars, int charOffset, int length, int cellWidth, int positionX, int positionY) {
        int pos;
        int group = 0;
        for (pos = 0; pos < length; ++pos) {
            int charsWidth;
            char drawnChar = drawnChars[charOffset + pos];
            int charWidth = this.metrics.getCharWidth(drawnChar);
            boolean groupable = this.metrics.hasUniformLineMetrics() ? charWidth == cellWidth : (charsWidth = this.metrics.getCharsWidth(drawnChars, charOffset + pos - group, group + 1)) == cellWidth * (group + 1);
            switch (Character.getDirectionality(drawnChar)) {
                case -1: 
                case 1: 
                case 2: 
                case 9: 
                case 13: 
                case 16: 
                case 17: 
                case 18: {
                    groupable = false;
                }
            }
            if (groupable) {
                ++group;
                continue;
            }
            if (group > 0) {
                this.drawShiftedChars(g, drawnChars, charOffset + pos - group, group, positionX + (pos - group) * cellWidth, positionY);
                group = 0;
            }
            this.drawShiftedChars(g, drawnChars, charOffset + pos, 1, positionX + pos * cellWidth + (cellWidth - charWidth) / 2, positionY);
        }
        if (group > 0) {
            this.drawShiftedChars(g, drawnChars, charOffset + pos - group, group, positionX + (pos - group) * cellWidth, positionY);
        }
    }

    protected void drawShiftedChars(Graphics g, char[] drawnChars, int charOffset, int length, int positionX, int positionY) {
        g.drawChars(drawnChars, charOffset, length, positionX, positionY);
    }

    private void buildCharMapping(Charset charset) {
        for (int i = 0; i < 256; ++i) {
            this.charMapping[i] = new String(new byte[]{(byte)i}, charset).charAt(0);
        }
        this.charMappingCharset = charset;
    }

    private int getRowPositionLength() {
        if (this.minRowPositionLength > 0 && this.minRowPositionLength == this.maxRowPositionLength) {
            return this.minRowPositionLength;
        }
        PositionCodeType positionCodeType = ((PositionCodeTypeCapable)this.codeArea).getPositionCodeType();
        long dataSize = this.codeArea.getDataSize();
        if (dataSize == 0L) {
            return 1;
        }
        double natLog = Math.log(dataSize == Long.MAX_VALUE ? (double)dataSize : (double)(dataSize + 1L));
        int positionLength = (int)Math.ceil(natLog / positionCodeType.getBaseLog());
        if (this.minRowPositionLength > 0 && positionLength < this.minRowPositionLength) {
            positionLength = this.minRowPositionLength;
        }
        if (this.maxRowPositionLength > 0 && positionLength > this.maxRowPositionLength) {
            positionLength = this.maxRowPositionLength;
        }
        return positionLength == 0 ? 1 : positionLength;
    }

    @Nonnull
    public Rectangle getCursorPositionRect(long dataPosition, int codeOffset, CodeAreaSection section) {
        Rectangle rect = new Rectangle();
        this.updateRectToCursorPosition(rect, dataPosition, codeOffset, section);
        return rect;
    }

    protected void updateRectToCursorPosition(Rectangle rect, long dataPosition, int codeOffset, CodeAreaSection section) {
        int characterWidth = this.metrics.getCharacterWidth();
        int rowHeight = this.metrics.getRowHeight();
        Point cursorPoint = this.getPositionPoint(dataPosition, codeOffset, section);
        if (cursorPoint == null) {
            rect.setBounds(0, 0, 0, 0);
        } else {
            DefaultCodeAreaCaret.CursorShape cursorShape = this.editOperation == EditOperation.INSERT ? DefaultCodeAreaCaret.CursorShape.INSERT : DefaultCodeAreaCaret.CursorShape.OVERWRITE;
            int cursorThickness = DefaultCodeAreaCaret.getCursorThickness((DefaultCodeAreaCaret.CursorShape)cursorShape, (int)characterWidth, (int)rowHeight);
            rect.setBounds(cursorPoint.x, cursorPoint.y, cursorThickness, rowHeight);
        }
    }

    private void renderBackgroundSequence(Graphics g, int startOffset, int endOffset, int rowPositionX, int positionY) {
        int characterWidth = this.metrics.getCharacterWidth();
        int halfSpaceSize = characterWidth / 2;
        int rowHeight = this.metrics.getRowHeight();
        g.fillRect(rowPositionX + this.layoutProfile.computePositionX(startOffset, characterWidth, halfSpaceSize), positionY, this.layoutProfile.computePositionX(endOffset - startOffset, characterWidth, halfSpaceSize), rowHeight);
    }

    private void buildUnprintableCharactersMapping() {
        this.unprintableCharactersMapping = new HashMap<Character, Character>();
        for (int i = 0; i < 32; ++i) {
            this.unprintableCharactersMapping.put(Character.valueOf((char)i), Character.valueOf(Character.toChars(9216 + i)[0]));
        }
        this.unprintableCharactersMapping.put(Character.valueOf(' '), Character.valueOf(Character.toChars(183)[0]));
        this.unprintableCharactersMapping.put(Character.valueOf('\t'), Character.valueOf(Character.toChars(187)[0]));
        this.unprintableCharactersMapping.put(Character.valueOf('\r'), Character.valueOf(Character.toChars(164)[0]));
        this.unprintableCharactersMapping.put(Character.valueOf('\n'), Character.valueOf(Character.toChars(182)[0]));
        this.unprintableCharactersMapping.put(Character.valueOf(Character.toChars(127)[0]), Character.valueOf(Character.toChars(176)[0]));
    }

    public void updateScrollBars() {
        int verticalScrollBarPolicy = CodeAreaSwingUtils.getVerticalScrollBarPolicy((ScrollBarVisibility)this.scrolling.getVerticalScrollBarVisibility());
        if (this.scrollPanel.getVerticalScrollBarPolicy() != verticalScrollBarPolicy) {
            this.scrollPanel.setVerticalScrollBarPolicy(verticalScrollBarPolicy);
        }
        int horizontalScrollBarPolicy = CodeAreaSwingUtils.getHorizontalScrollBarPolicy((ScrollBarVisibility)this.scrolling.getHorizontalScrollBarVisibility());
        if (this.scrollPanel.getHorizontalScrollBarPolicy() != horizontalScrollBarPolicy) {
            this.scrollPanel.setHorizontalScrollBarPolicy(horizontalScrollBarPolicy);
        }
        int characterWidth = this.metrics.getCharacterWidth();
        int rowHeight = this.metrics.getRowHeight();
        long rowsPerDocument = this.structure.getRowsPerDocument();
        this.recomputeScrollState();
        boolean revalidate = false;
        Rectangle scrollPanelRectangle = this.dimensions.getScrollPanelRectangle();
        Rectangle oldRect = this.scrollPanel.getBounds();
        if (!oldRect.equals(scrollPanelRectangle)) {
            this.scrollPanel.setBounds(scrollPanelRectangle);
            revalidate = true;
        }
        JViewport viewport = this.scrollPanel.getViewport();
        if (rowHeight > 0 && characterWidth > 0) {
            this.viewDimension = this.scrolling.computeViewDimension(viewport.getWidth(), viewport.getHeight(), this.layoutProfile, this.structure, characterWidth, rowHeight);
            if (this.dataView.getWidth() != this.viewDimension.getWidth() || this.dataView.getHeight() != this.viewDimension.getHeight()) {
                Dimension dataViewSize = new Dimension(this.viewDimension.getWidth(), this.viewDimension.getHeight());
                this.dataView.setPreferredSize(dataViewSize);
                this.dataView.setSize(dataViewSize);
                this.recomputeDimensions();
                scrollPanelRectangle = this.dimensions.getScrollPanelRectangle();
                if (!oldRect.equals(scrollPanelRectangle)) {
                    this.scrollPanel.setBounds(scrollPanelRectangle);
                }
                revalidate = true;
            }
            int verticalScrollValue = this.scrolling.getVerticalScrollValue(rowHeight, rowsPerDocument);
            int horizontalScrollValue = this.scrolling.getHorizontalScrollValue(characterWidth);
            this.scrollPanel.updateScrollBars(verticalScrollValue, horizontalScrollValue);
        }
        if (revalidate) {
            this.horizontalExtentChanged();
            this.verticalExtentChanged();
            this.codeArea.revalidate();
        }
    }

    public void scrollPositionModified() {
        this.scrolling.clearLastVerticalScrollingValue();
        this.recomputeScrollState();
    }

    public void scrollPositionChanged() {
        this.recomputeScrollState();
        this.updateScrollBars();
    }

    private void horizontalExtentChanged() {
        this.scrollPanel.horizontalExtentChanged();
    }

    private void verticalExtentChanged() {
        this.scrollPanel.verticalExtentChanged();
    }

    private void dataChanged() {
        this.validateCaret();
        this.validateSelection();
        this.recomputeLayout();
    }

    protected int getCharactersPerRow() {
        return this.structure.getHalfCharsPerRow();
    }

    public int getBytesPerRow() {
        return this.structure.getBytesPerRow();
    }

    public int getRowHeight() {
        return this.metrics.getRowHeight();
    }

    private int getHorizontalScrollBarSize() {
        JScrollBar horizontalScrollBar = this.scrollPanel.getHorizontalScrollBar();
        return horizontalScrollBar.isVisible() ? horizontalScrollBar.getHeight() : 0;
    }

    private int getVerticalScrollBarSize() {
        JScrollBar verticalScrollBar = this.scrollPanel.getVerticalScrollBar();
        return verticalScrollBar.isVisible() ? verticalScrollBar.getWidth() : 0;
    }

    @Nonnull
    private CodeAreaSection getSection(CodeAreaCaretPosition caretPosition) {
        return (CodeAreaSection)caretPosition.getSection().orElse(BasicCodeAreaSection.CODE_MATRIX);
    }

    private static class CursorDataCache {
        Rectangle caretRect = new Rectangle();
        Rectangle mirrorCursorRect = new Rectangle();
        final Stroke dashedStroke = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{2.0f}, 0.0f);
        int cursorCharsLength;
        char[] cursorChars;
        int cursorDataLength;
        byte[] cursorData;

        private CursorDataCache() {
        }
    }

    private static class RowDataCache {
        char[] headerCodeData;
        char[] headerChars;
        char[] headerCharsShifted;
        char[] rowCodeData;
        byte[] rowData;
        char[] rowPositionCode;
        char[] rowCharacters;
        char[] rowCharactersShifted;
        byte[] unprintables;

        private RowDataCache() {
        }
    }
}

