/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.bined.swing.extended;

import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.bined.basic.BasicCodeAreaSection;
import org.exbin.bined.basic.CodeAreaViewMode;
import org.exbin.bined.extended.ExtendedCodeAreaStructure;
import org.exbin.bined.extended.layout.ExtendedCodeAreaLayoutProfile;
import org.exbin.bined.extended.layout.PositionIterator;
import org.exbin.bined.swing.basic.BasicCodeAreaMetrics;
import org.exbin.bined.swing.extended.ExtendedCodeAreaDimensions;
import org.exbin.bined.swing.extended.ExtendedCodeAreaScrolling;

@ParametersAreNonnullByDefault
public class ExtendedCodeAreaVisibility {
    private int splitLinePos;
    private int skipTo;
    private int skipToChar;
    private int skipRestFrom;
    private int skipRestFromChar;
    private boolean codeSectionVisible;
    private boolean previewSectionVisible;

    public void recomputeCharPositions(BasicCodeAreaMetrics metrics, ExtendedCodeAreaStructure structure, ExtendedCodeAreaDimensions dimensions, ExtendedCodeAreaLayoutProfile layout, ExtendedCodeAreaScrolling scrolling) {
        int characterWidth = metrics.getCharacterWidth();
        int halfSpaceWidth = characterWidth / 2;
        CodeAreaViewMode viewMode = structure.getViewMode();
        int invisibleFromLeftX = scrolling.getHorizontalScrollX(characterWidth);
        int invisibleFromRightX = invisibleFromLeftX + dimensions.getDataViewWidth();
        this.skipTo = 0;
        this.skipToChar = 0;
        this.skipRestFrom = -1;
        this.skipRestFromChar = -1;
        this.codeSectionVisible = viewMode != CodeAreaViewMode.TEXT_PREVIEW;
        this.previewSectionVisible = viewMode != CodeAreaViewMode.CODE_MATRIX;
        int linePos = 0;
        PositionIterator positionIterator = layout.createPositionIterator(structure.getCodeType(), structure.getViewMode(), structure.getBytesPerRow());
        int halfCharPos = 0;
        while (!positionIterator.isEndReached()) {
            int positionX;
            int nextSpaceSize = positionIterator.nextSpaceType().getHalfCharSize();
            if (viewMode == CodeAreaViewMode.DUAL && positionIterator.getBytePosition() == 0 && positionIterator.getSection() == BasicCodeAreaSection.TEXT_PREVIEW) {
                linePos = layout.computePositionX(halfCharPos + 2, characterWidth, halfSpaceWidth) + layout.computePositionX(nextSpaceSize, characterWidth, halfSpaceWidth) / 2;
            }
            if ((positionX = layout.computePositionX(halfCharPos += 2 + nextSpaceSize, characterWidth, halfSpaceWidth)) < invisibleFromLeftX) {
                ++this.skipTo;
                this.skipToChar = positionIterator.getHalfCharPosition() / 2;
                if (positionIterator.getSection() != BasicCodeAreaSection.TEXT_PREVIEW && !positionIterator.isEndReached()) continue;
                this.codeSectionVisible = false;
                continue;
            }
            if (this.skipRestFrom != -1 || positionX <= invisibleFromRightX) continue;
            this.skipRestFrom = positionIterator.getPosition();
            this.skipRestFromChar = (positionIterator.getHalfCharPosition() + 1) / 2;
            if (viewMode != CodeAreaViewMode.DUAL && positionIterator.getSection() != BasicCodeAreaSection.CODE_MATRIX) continue;
            this.previewSectionVisible = false;
        }
        if (this.skipRestFromChar == -1) {
            this.skipRestFromChar = (positionIterator.getHalfCharPosition() + 1) / 2;
        }
        this.splitLinePos = linePos;
    }

    public int getSplitLinePos() {
        return this.splitLinePos;
    }

    public int getSkipTo() {
        return this.skipTo;
    }

    public int getSkipToChar() {
        return this.skipToChar;
    }

    public int getSkipRestFrom() {
        return this.skipRestFrom;
    }

    public int getSkipRestFromChar() {
        return this.skipRestFromChar;
    }

    public boolean isCodeSectionVisible() {
        return this.codeSectionVisible;
    }

    public boolean isPreviewSectionVisible() {
        return this.previewSectionVisible;
    }

    public int getMaxRowDataChars() {
        return this.skipRestFromChar - this.skipToChar;
    }
}

