/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.bined.swing.extended.caret;

import java.awt.Graphics;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.bined.CodeAreaUtils;
import org.exbin.bined.extended.caret.CodeAreaCaretShape;
import org.exbin.bined.extended.caret.CodeAreaCaretType;
import org.exbin.bined.extended.caret.DefaultCodeAreaCaretShape;
import org.exbin.bined.swing.extended.caret.ExtendedCodeAreaCaretsProfile;

@ParametersAreNonnullByDefault
public class EditableExtendedCodeAreaCaretsProfile
implements ExtendedCodeAreaCaretsProfile {
    @Override
    @Nonnull
    public CodeAreaCaretShape identifyCaretShape(CodeAreaCaretType caretType) {
        switch (caretType) {
            case INSERT: {
                return DefaultCodeAreaCaretShape.LINE;
            }
            case OVERWRITE: {
                return DefaultCodeAreaCaretShape.FULL_BOX;
            }
            case SHADOW: {
                return DefaultCodeAreaCaretShape.DOTTED_BOX;
            }
        }
        throw CodeAreaUtils.getInvalidTypeException((Enum)caretType);
    }

    @Override
    public void paintCaret(Graphics g, int cursorX, int cursorY, int width, int height, CodeAreaCaretShape codeAreaCaretShape) {
        g.fillRect(cursorX, cursorY, width, height);
        if (codeAreaCaretShape instanceof DefaultCodeAreaCaretShape) {
            switch ((DefaultCodeAreaCaretShape)codeAreaCaretShape) {
                case FULL_BOX: {
                    break;
                }
                case LINE: {
                    break;
                }
            }
        }
    }
}

