/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.bined.swing.extended.diff;

import java.awt.Color;
import java.awt.Graphics;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.auxiliary.binary_data.BinaryData;
import org.exbin.bined.CodeAreaSection;
import org.exbin.bined.CodeAreaUtils;
import org.exbin.bined.swing.CodeAreaCore;
import org.exbin.bined.swing.extended.ExtendedCodeAreaPainter;

@ParametersAreNonnullByDefault
public class DiffHighlightCodeAreaPainter
extends ExtendedCodeAreaPainter {
    private BinaryData comparedData;
    private Color diffColor;
    private Color addedColor;

    public DiffHighlightCodeAreaPainter(CodeAreaCore codeArea) {
        this(codeArea, null);
    }

    public DiffHighlightCodeAreaPainter(CodeAreaCore codeArea, @Nullable BinaryData comparedData) {
        super(codeArea);
        this.comparedData = comparedData;
        this.diffColor = new Color(255, 180, 180);
        this.addedColor = new Color(180, 255, 180);
    }

    @Override
    public void paintMainArea(@Nonnull Graphics g) {
        super.paintMainArea(g);
    }

    @Override
    @Nullable
    public Color getPositionTextColor(long rowDataPosition, int byteOnRow, int charOnRow, CodeAreaSection section, boolean unprintables) {
        byte comparedByte;
        byte sourceByte;
        long position = rowDataPosition + (long)byteOnRow;
        if (this.comparedData != null && position >= this.comparedData.getDataSize()) {
            return this.addedColor;
        }
        if (this.comparedData != null && position < this.codeArea.getDataSize() && position < this.comparedData.getDataSize() && (sourceByte = ((BinaryData)CodeAreaUtils.requireNonNull((Object)this.codeArea.getContentData())).getByte(position)) != (comparedByte = this.comparedData.getByte(position))) {
            return this.diffColor;
        }
        return super.getPositionTextColor(rowDataPosition, byteOnRow, charOnRow, section, unprintables);
    }

    public void setComparedData(BinaryData comparedData) {
        this.comparedData = comparedData;
        this.codeArea.notifyDataChanged();
    }

    @Nonnull
    public Color getDiffColor() {
        return this.diffColor;
    }

    public void setDiffColor(Color diffColor) {
        this.diffColor = diffColor;
    }
}

