/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.bined.swing.extended.theme;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.bined.extended.theme.CodeAreaDecorationType;
import org.exbin.bined.extended.theme.ExtendedBackgroundPaintMode;
import org.exbin.bined.swing.extended.layout.ExtendedCodeAreaDecorations;

@ParametersAreNonnullByDefault
public class ExtendedCodeAreaThemeProfile {
    @Nonnull
    private ExtendedBackgroundPaintMode borderPaintMode = ExtendedBackgroundPaintMode.STRIPED;
    private boolean paintRowPosBackground = true;
    private int verticalLineByteGroupSize = 0;
    private final Set<CodeAreaDecorationType> decorations = new HashSet<CodeAreaDecorationType>();

    public ExtendedCodeAreaThemeProfile() {
        this.decorations.add(ExtendedCodeAreaDecorations.HEADER_LINE);
        this.decorations.add(ExtendedCodeAreaDecorations.ROW_POSITION_LINE);
        this.decorations.add(ExtendedCodeAreaDecorations.SPLIT_LINE);
    }

    @Nonnull
    public ExtendedCodeAreaThemeProfile createCopy() {
        ExtendedCodeAreaThemeProfile copy = new ExtendedCodeAreaThemeProfile();
        copy.borderPaintMode = this.borderPaintMode;
        copy.paintRowPosBackground = this.paintRowPosBackground;
        copy.verticalLineByteGroupSize = this.verticalLineByteGroupSize;
        copy.decorations.clear();
        copy.decorations.addAll(this.decorations);
        return copy;
    }

    @Nonnull
    public ExtendedBackgroundPaintMode getBackgroundPaintMode() {
        return this.borderPaintMode;
    }

    public void setBackgroundPaintMode(ExtendedBackgroundPaintMode borderPaintMode) {
        this.borderPaintMode = borderPaintMode;
    }

    public boolean isPaintRowPosBackground() {
        return this.paintRowPosBackground;
    }

    public void setPaintRowPosBackground(boolean paintRowPosBackground) {
        this.paintRowPosBackground = paintRowPosBackground;
    }

    public int getVerticalLineByteGroupSize() {
        return this.verticalLineByteGroupSize;
    }

    public void setVerticalLineByteGroupSize(int verticalLineByteGroupSize) {
        this.verticalLineByteGroupSize = verticalLineByteGroupSize;
    }

    public boolean hasDecoration(CodeAreaDecorationType decoration) {
        return this.decorations.contains(decoration);
    }

    public void setDecoration(CodeAreaDecorationType decoration, boolean value) {
        if (!value && this.hasDecoration(decoration)) {
            this.decorations.remove(decoration);
        } else if (value && !this.hasDecoration(decoration)) {
            this.decorations.add(decoration);
        }
    }

    public boolean showRowPositionLine() {
        return this.decorations.contains((Object)ExtendedCodeAreaDecorations.ROW_POSITION_LINE);
    }

    public boolean showHeaderLine() {
        return this.decorations.contains((Object)ExtendedCodeAreaDecorations.HEADER_LINE);
    }

    public boolean showSplitLine() {
        return this.decorations.contains((Object)ExtendedCodeAreaDecorations.SPLIT_LINE);
    }

    public boolean showBoxLine() {
        return this.decorations.contains((Object)ExtendedCodeAreaDecorations.BOX_LINES);
    }

    public boolean showGroupLines() {
        return this.decorations.contains((Object)ExtendedCodeAreaDecorations.GROUP_LINES);
    }
}

