/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.deltahex.swing;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.exbin.deltahex.CaretMovedListener;
import org.exbin.deltahex.CaretPosition;
import org.exbin.deltahex.CodeAreaLineNumberLength;
import org.exbin.deltahex.CodeType;
import org.exbin.deltahex.DataChangedListener;
import org.exbin.deltahex.EditationAllowed;
import org.exbin.deltahex.EditationMode;
import org.exbin.deltahex.EditationModeChangedListener;
import org.exbin.deltahex.HexCharactersCase;
import org.exbin.deltahex.PositionCodeType;
import org.exbin.deltahex.ScrollBarVisibility;
import org.exbin.deltahex.ScrollingListener;
import org.exbin.deltahex.Section;
import org.exbin.deltahex.SelectionChangedListener;
import org.exbin.deltahex.SelectionRange;
import org.exbin.deltahex.ViewMode;
import org.exbin.deltahex.swing.CodeAreaCaret;
import org.exbin.deltahex.swing.CodeAreaCommandHandler;
import org.exbin.deltahex.swing.CodeAreaPainter;
import org.exbin.deltahex.swing.CodeAreaSpace;
import org.exbin.deltahex.swing.ColorsGroup;
import org.exbin.deltahex.swing.DefaultCodeAreaCommandHandler;
import org.exbin.deltahex.swing.DefaultCodeAreaPainter;
import org.exbin.utils.binary_data.BinaryData;

public class CodeArea
extends JComponent {
    public static final int NO_MODIFIER = 0;
    public static final int DECORATION_HEADER_LINE = 1;
    public static final int DECORATION_LINENUM_LINE = 2;
    public static final int DECORATION_PREVIEW_LINE = 4;
    public static final int DECORATION_BOX = 8;
    public static final int DECORATION_DEFAULT = 7;
    public static final int MOUSE_SCROLL_LINES = 3;
    private BinaryData data;
    private CodeAreaPainter painter;
    private CodeAreaCommandHandler commandHandler;
    private final CodeAreaCaret caret;
    private SelectionRange selection;
    private ViewMode viewMode = ViewMode.DUAL;
    private CodeType codeType = CodeType.HEXADECIMAL;
    private PositionCodeType positionCodeType = PositionCodeType.HEXADECIMAL;
    private BackgroundMode backgroundMode = BackgroundMode.STRIPPED;
    private boolean lineNumberBackground = true;
    private Charset charset = Charset.defaultCharset();
    private int decorationMode = 7;
    private EditationAllowed editationAllowed = EditationAllowed.ALLOWED;
    private EditationMode editationMode = EditationMode.OVERWRITE;
    private CharRenderingMode charRenderingMode = CharRenderingMode.AUTO;
    private CharAntialiasingMode charAntialiasingMode = CharAntialiasingMode.AUTO;
    private HexCharactersCase hexCharactersCase = HexCharactersCase.UPPER;
    private final CodeAreaSpace headerSpace = new CodeAreaSpace(CodeAreaSpace.SpaceType.HALF_UNIT);
    private final CodeAreaSpace lineNumberSpace = new CodeAreaSpace();
    private final CodeAreaLineNumberLength lineNumberLength = new CodeAreaLineNumberLength();
    private int lineLength = 16;
    private int byteGroupSize = 1;
    private int spaceGroupSize = 0;
    private int subFontSpace = 3;
    private boolean showHeader = true;
    private boolean showLineNumbers = true;
    private boolean mouseDown;
    private boolean wrapMode = false;
    private boolean handleClipboard = true;
    private boolean showUnprintableCharacters = false;
    private boolean showShadowCursor = true;
    private ScrollBarVisibility verticalScrollBarVisibility = ScrollBarVisibility.IF_NEEDED;
    private VerticalScrollMode verticalScrollMode = VerticalScrollMode.PER_LINE;
    private ScrollBarVisibility horizontalScrollBarVisibility = ScrollBarVisibility.IF_NEEDED;
    private HorizontalScrollMode horizontalScrollMode = HorizontalScrollMode.PIXEL;
    private JScrollBar horizontalScrollBar;
    private JScrollBar verticalScrollBar;
    private final ScrollPosition scrollPosition = new ScrollPosition();
    private final ColorsGroup mainColors = new ColorsGroup();
    private final ColorsGroup alternateColors = new ColorsGroup();
    private final ColorsGroup selectionColors = new ColorsGroup();
    private final ColorsGroup mirrorSelectionColors = new ColorsGroup();
    private Color cursorColor;
    private Color negativeCursorColor;
    private Color decorationLineColor;
    private final List<SelectionChangedListener> selectionChangedListeners = new ArrayList<SelectionChangedListener>();
    private final List<CaretMovedListener> caretMovedListeners = new ArrayList<CaretMovedListener>();
    private final List<EditationModeChangedListener> editationModeChangedListeners = new ArrayList<EditationModeChangedListener>();
    private final List<DataChangedListener> dataChangedListeners = new ArrayList<DataChangedListener>();
    private final List<ScrollingListener> scrollingListeners = new ArrayList<ScrollingListener>();
    private final PaintDataCache paintDataCache = new PaintDataCache();

    public CodeArea() {
        this.caret = new CodeAreaCaret(this);
        this.painter = new DefaultCodeAreaPainter(this);
        this.commandHandler = new DefaultCodeAreaCommandHandler(this);
        this.init();
    }

    private void init() {
        Color selectionBackgroundColor;
        Color backgroundColor;
        Color textColor = UIManager.getColor("TextArea.foreground");
        if (textColor == null) {
            textColor = Color.BLACK;
        }
        if ((backgroundColor = UIManager.getColor("TextArea.background")) == null) {
            backgroundColor = Color.WHITE;
        }
        super.setForeground(textColor);
        super.setBackground(CodeArea.createOddColor(backgroundColor));
        Color unprintablesColor = new Color(textColor.getRed(), (textColor.getGreen() + 128) % 256, textColor.getBlue());
        this.mainColors.setTextColor(textColor);
        this.mainColors.setBothBackgroundColors(backgroundColor);
        this.mainColors.setUnprintablesColor(unprintablesColor);
        this.alternateColors.setTextColor(textColor);
        this.alternateColors.setBothBackgroundColors(CodeArea.createOddColor(backgroundColor));
        this.alternateColors.setUnprintablesColor(unprintablesColor);
        Color selectionTextColor = UIManager.getColor("TextArea.selectionForeground");
        if (selectionTextColor == null) {
            selectionTextColor = Color.WHITE;
        }
        if ((selectionBackgroundColor = UIManager.getColor("TextArea.selectionBackground")) == null) {
            selectionBackgroundColor = new Color(96, 96, 255);
        }
        this.selectionColors.setTextColor(selectionTextColor);
        this.selectionColors.setBothBackgroundColors(selectionBackgroundColor);
        this.selectionColors.setUnprintablesColor(unprintablesColor);
        this.mirrorSelectionColors.setTextColor(selectionTextColor);
        int grayLevel = (selectionBackgroundColor.getRed() + selectionBackgroundColor.getGreen() + selectionBackgroundColor.getBlue()) / 3;
        this.mirrorSelectionColors.setBothBackgroundColors(new Color(grayLevel, grayLevel, grayLevel));
        this.mirrorSelectionColors.setUnprintablesColor(unprintablesColor);
        this.cursorColor = UIManager.getColor("TextArea.caretForeground");
        if (this.cursorColor == null) {
            this.cursorColor = Color.BLACK;
        }
        this.negativeCursorColor = CodeArea.createNegativeColor(this.cursorColor);
        this.decorationLineColor = Color.GRAY;
        this.verticalScrollBar = new JScrollBar(1);
        this.verticalScrollBar.setVisible(false);
        this.verticalScrollBar.setIgnoreRepaint(true);
        this.verticalScrollBar.addAdjustmentListener(new VerticalAdjustmentListener());
        this.add(this.verticalScrollBar);
        this.horizontalScrollBar = new JScrollBar(0);
        this.horizontalScrollBar.setIgnoreRepaint(true);
        this.horizontalScrollBar.setVisible(false);
        this.horizontalScrollBar.addAdjustmentListener(new HorizontalAdjustmentListener());
        this.add(this.horizontalScrollBar);
        this.setFocusable(true);
        this.setFocusTraversalKeysEnabled(false);
        this.addComponentListener(new CodeAreaComponentListener());
        CodeAreaMouseListener codeAreaMouseListener = new CodeAreaMouseListener();
        this.addMouseListener(codeAreaMouseListener);
        this.addMouseMotionListener(codeAreaMouseListener);
        this.addMouseWheelListener(codeAreaMouseListener);
        this.addKeyListener(new CodeAreaKeyListener());
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                CodeArea.this.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                CodeArea.this.repaint();
            }
        });
    }

    @Override
    public void paintComponent(Graphics g) {
        Insets insets = this.getInsets();
        Dimension size = this.getSize();
        Rectangle compRect = new Rectangle();
        compRect.x = insets.left;
        compRect.y = insets.top;
        compRect.width = size.width - insets.left - insets.right;
        compRect.height = size.height - insets.top - insets.bottom;
        if (!this.paintDataCache.componentRectangle.equals(compRect)) {
            this.computePaintData();
        }
        Rectangle clipBounds = g.getClipBounds();
        if (this.charAntialiasingMode != CharAntialiasingMode.OFF && g instanceof Graphics2D) {
            Object antialiasingHint = this.getAntialiasingHint((Graphics2D)g);
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, antialiasingHint);
        }
        if (this.paintDataCache.fontMetrics == null) {
            this.computeFontMetrics();
        }
        this.painter.paintOverall(g);
        Rectangle hexRect = this.paintDataCache.codeSectionRectangle;
        if (this.showHeader) {
            g.setClip(clipBounds.createIntersection(new Rectangle(hexRect.x, 0, hexRect.width, hexRect.y)));
            this.painter.paintHeader(g);
        }
        g.setClip(clipBounds.createIntersection(new Rectangle(0, hexRect.y, hexRect.x + hexRect.width, hexRect.height)));
        this.painter.paintBackground(g);
        if (this.showLineNumbers) {
            this.painter.paintLineNumbers(g);
            g.setClip(clipBounds.createIntersection(new Rectangle(hexRect.x, hexRect.y, hexRect.width, hexRect.height)));
        }
        this.painter.paintMainArea(g);
        this.painter.paintCursor(g);
        g.setClip(clipBounds);
    }

    private Object getAntialiasingHint(Graphics2D g) {
        Object antialiasingHint;
        switch (this.charAntialiasingMode) {
            case AUTO: {
                if (g.getDeviceConfiguration().getDevice().getType() == 0) {
                    antialiasingHint = RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB;
                    break;
                }
                antialiasingHint = RenderingHints.VALUE_TEXT_ANTIALIAS_GASP;
                break;
            }
            case BASIC: {
                antialiasingHint = RenderingHints.VALUE_TEXT_ANTIALIAS_ON;
                break;
            }
            case GASP: {
                antialiasingHint = RenderingHints.VALUE_TEXT_ANTIALIAS_GASP;
                break;
            }
            case DEFAULT: {
                antialiasingHint = RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT;
                break;
            }
            case LCD_HRGB: {
                antialiasingHint = RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB;
                break;
            }
            case LCD_HBGR: {
                antialiasingHint = RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HBGR;
                break;
            }
            case LCD_VRGB: {
                antialiasingHint = RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_VRGB;
                break;
            }
            case LCD_VBGR: {
                antialiasingHint = RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_VBGR;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected antialiasing type " + this.charAntialiasingMode.name());
            }
        }
        return antialiasingHint;
    }

    public CodeAreaCaret getCaret() {
        return this.caret;
    }

    private void moveCaret(MouseEvent me, int modifiers) {
        long dataSize;
        long dataPosition;
        int byteOnLine;
        Rectangle hexRect = this.paintDataCache.codeSectionRectangle;
        int bytesPerLine = this.paintDataCache.bytesPerLine;
        int mouseX = me.getX();
        if (mouseX < hexRect.x) {
            mouseX = hexRect.x;
        }
        int cursorCharX = (mouseX - hexRect.x + this.scrollPosition.scrollCharOffset) / this.paintDataCache.charWidth + this.scrollPosition.scrollCharPosition;
        long cursorLineY = (long)((me.getY() - hexRect.y + this.scrollPosition.scrollLineOffset) / this.paintDataCache.lineHeight) + this.scrollPosition.scrollLinePosition;
        if (cursorLineY < 0L) {
            cursorLineY = 0L;
        }
        if (cursorCharX < 0) {
            cursorCharX = 0;
        }
        int codeOffset = 0;
        if (this.viewMode == ViewMode.DUAL && cursorCharX < this.paintDataCache.previewStartChar || this.viewMode == ViewMode.CODE_MATRIX) {
            this.caret.setSection(Section.CODE_MATRIX);
            byteOnLine = this.computeByteOffsetPerCodeCharOffset(cursorCharX, false);
            if (byteOnLine >= bytesPerLine) {
                codeOffset = 0;
            } else {
                codeOffset = cursorCharX - this.computeByteCharPos(byteOnLine);
                if (codeOffset >= this.codeType.getMaxDigits()) {
                    codeOffset = this.codeType.getMaxDigits() - 1;
                }
            }
        } else {
            this.caret.setSection(Section.TEXT_PREVIEW);
            byteOnLine = cursorCharX;
            if (this.viewMode == ViewMode.DUAL) {
                byteOnLine -= this.paintDataCache.previewStartChar;
            }
        }
        if (byteOnLine >= bytesPerLine) {
            byteOnLine = bytesPerLine - 1;
        }
        if ((dataPosition = (long)byteOnLine + cursorLineY * (long)bytesPerLine - (long)this.scrollPosition.lineByteShift) < 0L) {
            dataPosition = 0L;
            codeOffset = 0;
        }
        if (dataPosition >= (dataSize = this.data.getDataSize())) {
            dataPosition = dataSize;
            codeOffset = 0;
        }
        CaretPosition caretPosition = this.caret.getCaretPosition();
        this.caret.setCaretPosition(dataPosition, codeOffset);
        this.notifyCaretMoved();
        this.commandHandler.sequenceBreak();
        this.updateSelection(modifiers, caretPosition);
    }

    public void notifyCaretMoved() {
        for (CaretMovedListener caretMovedListener : this.caretMovedListeners) {
            caretMovedListener.caretMoved(this.caret.getCaretPosition(), this.caret.getSection());
        }
    }

    public void notifyScrolled() {
        for (ScrollingListener scrollingListener : this.scrollingListeners) {
            scrollingListener.scrolled();
        }
    }

    public void notifyDataChanged() {
        if (this.caret.getDataPosition() > this.data.getDataSize()) {
            this.caret.setCaretPosition(0L);
            this.notifyCaretMoved();
        }
        this.computePaintData();
        for (DataChangedListener dataChangedListener : this.dataChangedListeners) {
            dataChangedListener.dataChanged();
        }
    }

    public ScrollPosition getScrollPosition() {
        return this.scrollPosition;
    }

    public void revealCursor() {
        this.revealPosition(this.caret.getCaretPosition().getDataPosition(), this.caret.getSection());
    }

    public void revealPosition(long position, Section section) {
        int positionByte;
        if (this.paintDataCache.fontMetrics == null) {
            return;
        }
        boolean scrolled = false;
        Rectangle hexRect = this.paintDataCache.codeSectionRectangle;
        long caretLine = position / (long)this.paintDataCache.bytesPerLine;
        if (section == Section.CODE_MATRIX) {
            positionByte = this.computeByteCharPos((int)(position % (long)this.paintDataCache.bytesPerLine)) + this.caret.getCodeOffset();
        } else {
            positionByte = (int)(position % (long)this.paintDataCache.bytesPerLine);
            if (this.viewMode == ViewMode.DUAL) {
                positionByte += this.paintDataCache.previewStartChar;
            }
        }
        if (caretLine <= this.scrollPosition.scrollLinePosition) {
            this.scrollPosition.scrollLinePosition = caretLine;
            this.scrollPosition.scrollLineOffset = 0;
            scrolled = true;
        } else if (caretLine >= this.scrollPosition.scrollLinePosition + (long)this.paintDataCache.linesPerRect) {
            this.scrollPosition.scrollLinePosition = caretLine - (long)this.paintDataCache.linesPerRect;
            if (this.verticalScrollMode == VerticalScrollMode.PIXEL) {
                this.scrollPosition.scrollLineOffset = this.paintDataCache.lineHeight - hexRect.height % this.paintDataCache.lineHeight;
            } else {
                this.scrollPosition.scrollLinePosition++;
            }
            scrolled = true;
        }
        if (positionByte <= this.scrollPosition.scrollCharPosition) {
            this.scrollPosition.scrollCharPosition = positionByte;
            this.scrollPosition.scrollCharOffset = 0;
            scrolled = true;
        } else if (positionByte >= this.scrollPosition.scrollCharPosition + this.paintDataCache.bytesPerRect) {
            this.scrollPosition.scrollCharPosition = positionByte - this.paintDataCache.bytesPerRect;
            if (this.horizontalScrollMode == HorizontalScrollMode.PIXEL) {
                this.scrollPosition.scrollCharOffset = this.paintDataCache.charWidth - hexRect.width % this.paintDataCache.charWidth;
            } else {
                this.scrollPosition.scrollCharPosition++;
            }
            scrolled = true;
        }
        if (scrolled) {
            this.updateScrollBars();
            this.notifyScrolled();
        }
    }

    public void updateScrollBars() {
        if (this.scrollPosition.verticalMaxMode) {
            long lines = (this.data.getDataSize() + (long)this.scrollPosition.lineByteShift) / (long)this.paintDataCache.bytesPerLine + 1L;
            int scrollValue = this.scrollPosition.scrollLinePosition < 0x100000002L ? (int)(this.scrollPosition.scrollLinePosition * Integer.MAX_VALUE / lines) : (int)(this.scrollPosition.scrollLinePosition / (lines / Integer.MAX_VALUE));
            this.verticalScrollBar.setValue(scrollValue);
        } else if (this.verticalScrollMode == VerticalScrollMode.PER_LINE) {
            this.verticalScrollBar.setValue((int)this.scrollPosition.scrollLinePosition);
        } else {
            this.verticalScrollBar.setValue((int)(this.scrollPosition.scrollLinePosition * (long)this.paintDataCache.lineHeight + (long)this.scrollPosition.scrollLineOffset));
        }
        if (this.horizontalScrollMode == HorizontalScrollMode.PER_CHAR) {
            this.horizontalScrollBar.setValue(this.scrollPosition.scrollCharPosition);
        } else {
            this.horizontalScrollBar.setValue(this.scrollPosition.scrollCharPosition * this.paintDataCache.charWidth + this.scrollPosition.scrollCharOffset);
        }
        this.repaint();
    }

    public void updateSelection(int modifiers, CaretPosition caretPosition) {
        if ((modifiers & 0x40) > 0) {
            long currentPosition;
            long end = currentPosition = this.caret.getDataPosition();
            if (this.selection != null) {
                long start = this.selection.getStart();
                if (start == currentPosition) {
                    this.clearSelection();
                } else {
                    this.selection.setEnd(start < currentPosition ? end - 1L : end);
                }
            } else {
                long start = caretPosition.getDataPosition();
                if (start == currentPosition) {
                    this.clearSelection();
                } else {
                    this.selection = new SelectionRange(start, start < currentPosition ? end - 1L : end);
                }
            }
            this.notifySelectionChanged();
        } else {
            this.clearSelection();
        }
        this.repaint();
    }

    public void moveRight(int modifiers) {
        CaretPosition caretPosition = this.caret.getCaretPosition();
        if (caretPosition.getDataPosition() < this.data.getDataSize()) {
            if (this.caret.getSection() == Section.CODE_MATRIX) {
                int codeOffset = this.caret.getCodeOffset();
                if (caretPosition.getDataPosition() < this.data.getDataSize()) {
                    if (codeOffset < this.codeType.getMaxDigits() - 1) {
                        this.caret.setCodeOffset(codeOffset + 1);
                    } else {
                        this.caret.setCaretPosition(caretPosition.getDataPosition() + 1L, 0);
                    }
                    this.updateSelection(modifiers, caretPosition);
                    this.notifyCaretMoved();
                }
            } else {
                this.caret.setCaretPosition(caretPosition.getDataPosition() + 1L);
                this.updateSelection(modifiers, caretPosition);
                this.notifyCaretMoved();
            }
        }
    }

    public void moveLeft(int modifiers) {
        CaretPosition caretPosition = this.caret.getCaretPosition();
        if (this.caret.getSection() == Section.CODE_MATRIX) {
            int codeOffset = this.caret.getCodeOffset();
            if (codeOffset > 0) {
                this.caret.setCodeOffset(codeOffset - 1);
                this.updateSelection(modifiers, caretPosition);
                this.notifyCaretMoved();
            } else if (caretPosition.getDataPosition() > 0L) {
                this.caret.setCaretPosition(caretPosition.getDataPosition() - 1L, this.codeType.getMaxDigits() - 1);
                this.updateSelection(modifiers, caretPosition);
                this.notifyCaretMoved();
            }
        } else if (caretPosition.getDataPosition() > 0L) {
            this.caret.setCaretPosition(caretPosition.getDataPosition() - 1L);
            this.updateSelection(modifiers, caretPosition);
            this.notifyCaretMoved();
        }
    }

    public SelectionRange getSelection() {
        return this.selection;
    }

    public void selectAll() {
        long dataSize = this.data.getDataSize();
        if (dataSize > 0L) {
            this.selection = new SelectionRange(0L, dataSize - 1L);
            this.notifySelectionChanged();
            this.repaint();
        }
    }

    public void clearSelection() {
        this.selection = null;
        this.notifySelectionChanged();
        this.repaint();
    }

    private void notifySelectionChanged() {
        for (SelectionChangedListener selectionChangedListener : this.selectionChangedListeners) {
            selectionChangedListener.selectionChanged(this.selection);
        }
    }

    public boolean hasSelection() {
        return this.selection != null;
    }

    public void setSelection(SelectionRange selection) {
        this.selection = selection;
        this.notifySelectionChanged();
    }

    public void setCaretPosition(CaretPosition caretPosition) {
        this.caret.setCaretPosition(caretPosition);
        this.notifyCaretMoved();
    }

    public void setCaretPosition(long dataPosition) {
        this.caret.setCaretPosition(dataPosition);
        this.notifyCaretMoved();
    }

    public void setCaretPosition(long dataPosition, int codeOffset) {
        this.caret.setCaretPosition(dataPosition, codeOffset);
        this.notifyCaretMoved();
    }

    public void addSelectionChangedListener(SelectionChangedListener selectionChangedListener) {
        this.selectionChangedListeners.add(selectionChangedListener);
    }

    public void removeSelectionChangedListener(SelectionChangedListener selectionChangedListener) {
        this.selectionChangedListeners.remove(selectionChangedListener);
    }

    public void addCaretMovedListener(CaretMovedListener caretMovedListener) {
        this.caretMovedListeners.add(caretMovedListener);
    }

    public void removeCaretMovedListener(CaretMovedListener caretMovedListener) {
        this.caretMovedListeners.remove(caretMovedListener);
    }

    public void addEditationModeChangedListener(EditationModeChangedListener editationModeChangedListener) {
        this.editationModeChangedListeners.add(editationModeChangedListener);
    }

    public void removeEditationModeChangedListener(EditationModeChangedListener editationModeChangedListener) {
        this.editationModeChangedListeners.remove(editationModeChangedListener);
    }

    public void addDataChangedListener(DataChangedListener dataChangedListener) {
        this.dataChangedListeners.add(dataChangedListener);
    }

    public void removeDataChangedListener(DataChangedListener dataChangedListener) {
        this.dataChangedListeners.remove(dataChangedListener);
    }

    public void addScrollingListener(ScrollingListener scrollingListener) {
        this.scrollingListeners.add(scrollingListener);
    }

    public void removeScrollingListener(ScrollingListener scrollingListener) {
        this.scrollingListeners.remove(scrollingListener);
    }

    public Rectangle getComponentRectangle() {
        return this.paintDataCache.componentRectangle;
    }

    public Rectangle getCodeSectionRectangle() {
        return this.paintDataCache.codeSectionRectangle;
    }

    public int getPreviewX() {
        return this.paintDataCache.previewX;
    }

    public int getLineHeight() {
        return this.paintDataCache.lineHeight;
    }

    public int getBytesPerLine() {
        return this.paintDataCache.bytesPerLine;
    }

    public int getLinesPerRect() {
        return this.paintDataCache.linesPerRect;
    }

    public int getCharsPerLine() {
        return this.paintDataCache.charsPerLine;
    }

    public int getCharWidth() {
        return this.paintDataCache.charWidth;
    }

    public FontMetrics getFontMetrics() {
        return this.paintDataCache.fontMetrics;
    }

    public int getHeaderSpace() {
        return this.paintDataCache.headerSpace;
    }

    public int getLineNumberSpace() {
        return this.paintDataCache.lineNumberSpace;
    }

    public int getLineNumberLength() {
        return this.paintDataCache.lineNumbersLength;
    }

    public BinaryData getData() {
        return this.data;
    }

    public void setData(BinaryData data) {
        this.data = data;
        this.notifyDataChanged();
        this.computePaintData();
        this.repaint();
    }

    public long getDataSize() {
        return this.data == null ? 0L : this.data.getDataSize();
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
        this.repaint();
    }

    public CodeAreaPainter getPainter() {
        return this.painter;
    }

    public void setPainter(CodeAreaPainter painter) {
        if (painter == null) {
            throw new NullPointerException("Painter cannot be null");
        }
        this.painter = painter;
        this.repaint();
    }

    public boolean isValidChar(char value) {
        return this.charset.canEncode();
    }

    public byte[] charToBytes(char value) {
        ByteBuffer buffer = this.charset.encode(Character.toString(value));
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes, 0, bytes.length);
        return bytes;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.computeFontMetrics();
    }

    @Override
    public void setBorder(Border border) {
        super.setBorder(border);
        this.computePaintData();
    }

    private void computeFontMetrics() {
        Graphics g = this.getGraphics();
        if (g != null) {
            Font font = this.getFont();
            this.paintDataCache.fontMetrics = g.getFontMetrics(font);
            this.paintDataCache.charWidth = this.paintDataCache.fontMetrics.charWidth('w');
            this.paintDataCache.monospaceFont = this.paintDataCache.charWidth == this.paintDataCache.fontMetrics.charWidth(' ') && this.paintDataCache.charWidth == this.paintDataCache.fontMetrics.charWidth('i');
            int fontHeight = font.getSize();
            if (this.paintDataCache.charWidth == 0) {
                this.paintDataCache.charWidth = fontHeight;
            }
            this.paintDataCache.lineHeight = fontHeight + this.subFontSpace;
            this.computePaintData();
        }
    }

    public void computePaintData() {
        boolean horizontalScrollBarVisible;
        boolean verticalScrollBarVisible;
        int bytesPerLine;
        if (this.paintDataCache.fontMetrics == null) {
            return;
        }
        Insets insets = this.getInsets();
        Dimension size = this.getSize();
        Rectangle compRect = this.paintDataCache.componentRectangle;
        compRect.x = insets.left;
        compRect.y = insets.top;
        compRect.width = size.width - insets.left - insets.right;
        compRect.height = size.height - insets.top - insets.bottom;
        switch (this.lineNumberLength.getLineNumberType()) {
            case AUTO: {
                long dataSize = this.getDataSize();
                if (dataSize > 0L) {
                    double natLog = Math.log(dataSize);
                    this.paintDataCache.lineNumbersLength = (int)Math.ceil(natLog / this.positionCodeType.getBaseLog());
                    if (this.paintDataCache.lineNumbersLength != 0) break;
                    this.paintDataCache.lineNumbersLength = 1;
                    break;
                }
                this.paintDataCache.lineNumbersLength = 1;
                break;
            }
            case SPECIFIED: {
                this.paintDataCache.lineNumbersLength = this.lineNumberLength.getLineNumberLength();
            }
        }
        int charsPerRect = this.computeCharsPerRect(compRect.width);
        if (this.wrapMode) {
            bytesPerLine = this.computeFittingBytes(charsPerRect);
            if (bytesPerLine == 0) {
                bytesPerLine = 1;
            }
        } else {
            bytesPerLine = this.lineLength;
        }
        long lines = (this.data.getDataSize() + (long)this.scrollPosition.lineByteShift) / (long)bytesPerLine + 1L;
        CodeAreaSpace.SpaceType headerSpaceType = this.headerSpace.getSpaceType();
        switch (headerSpaceType) {
            case NONE: {
                this.paintDataCache.headerSpace = 0;
                break;
            }
            case SPECIFIED: {
                this.paintDataCache.headerSpace = this.headerSpace.getSpaceSize();
                break;
            }
            case QUARTER_UNIT: {
                this.paintDataCache.headerSpace = this.paintDataCache.lineHeight / 4;
                break;
            }
            case HALF_UNIT: {
                this.paintDataCache.headerSpace = this.paintDataCache.lineHeight / 2;
                break;
            }
            case ONE_UNIT: {
                this.paintDataCache.headerSpace = this.paintDataCache.lineHeight;
                break;
            }
            case ONE_AND_HALF_UNIT: {
                this.paintDataCache.headerSpace = (int)((float)this.paintDataCache.lineHeight * 1.5f);
                break;
            }
            case DOUBLE_UNIT: {
                this.paintDataCache.headerSpace = this.paintDataCache.lineHeight * 2;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected header space type " + headerSpaceType.name());
            }
        }
        CodeAreaSpace.SpaceType lineNumberSpaceType = this.lineNumberSpace.getSpaceType();
        switch (lineNumberSpaceType) {
            case NONE: {
                this.paintDataCache.lineNumberSpace = 0;
                break;
            }
            case SPECIFIED: {
                this.paintDataCache.lineNumberSpace = this.lineNumberSpace.getSpaceSize();
                break;
            }
            case QUARTER_UNIT: {
                this.paintDataCache.lineNumberSpace = this.paintDataCache.charWidth / 4;
                break;
            }
            case HALF_UNIT: {
                this.paintDataCache.lineNumberSpace = this.paintDataCache.charWidth / 2;
                break;
            }
            case ONE_UNIT: {
                this.paintDataCache.lineNumberSpace = this.paintDataCache.charWidth;
                break;
            }
            case ONE_AND_HALF_UNIT: {
                this.paintDataCache.lineNumberSpace = (int)((float)this.paintDataCache.charWidth * 1.5f);
                break;
            }
            case DOUBLE_UNIT: {
                this.paintDataCache.lineNumberSpace = this.paintDataCache.charWidth * 2;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected line number space type " + lineNumberSpaceType.name());
            }
        }
        Rectangle hexRect = this.paintDataCache.codeSectionRectangle;
        hexRect.y = insets.top + (this.showHeader ? this.paintDataCache.lineHeight + this.paintDataCache.headerSpace : 0);
        hexRect.x = insets.left + (this.showLineNumbers ? this.paintDataCache.charWidth * this.paintDataCache.lineNumbersLength + this.paintDataCache.lineNumberSpace : 0);
        if (this.verticalScrollBarVisibility == ScrollBarVisibility.IF_NEEDED) {
            verticalScrollBarVisible = lines > (long)this.paintDataCache.linesPerRect;
        } else {
            boolean bl = verticalScrollBarVisible = this.verticalScrollBarVisibility == ScrollBarVisibility.ALWAYS;
        }
        if (verticalScrollBarVisible) {
            charsPerRect = this.computeCharsPerRect(compRect.x + compRect.width - this.paintDataCache.scrollBarThickness);
            if (this.wrapMode) {
                bytesPerLine = this.computeFittingBytes(charsPerRect);
                if (bytesPerLine <= 0) {
                    bytesPerLine = 1;
                }
                lines = (this.data.getDataSize() + (long)this.scrollPosition.lineByteShift) / (long)bytesPerLine + 1L;
            }
        }
        this.paintDataCache.bytesPerLine = bytesPerLine;
        this.paintDataCache.charsPerLine = this.computeCharsPerLine(bytesPerLine);
        int maxWidth = compRect.x + compRect.width - hexRect.x;
        if (verticalScrollBarVisible) {
            maxWidth -= this.paintDataCache.scrollBarThickness;
        }
        if (this.horizontalScrollBarVisibility == ScrollBarVisibility.IF_NEEDED) {
            horizontalScrollBarVisible = this.paintDataCache.charsPerLine * this.paintDataCache.charWidth > maxWidth;
        } else {
            boolean bl = horizontalScrollBarVisible = this.horizontalScrollBarVisibility == ScrollBarVisibility.ALWAYS;
        }
        if (horizontalScrollBarVisible) {
            this.paintDataCache.linesPerRect = (hexRect.height - this.paintDataCache.scrollBarThickness) / this.paintDataCache.lineHeight;
        }
        hexRect.width = compRect.x + compRect.width - hexRect.x;
        if (verticalScrollBarVisible) {
            hexRect.width -= this.paintDataCache.scrollBarThickness;
        }
        hexRect.height = compRect.y + compRect.height - hexRect.y;
        if (horizontalScrollBarVisible) {
            hexRect.height -= this.paintDataCache.scrollBarThickness;
        }
        this.paintDataCache.bytesPerRect = hexRect.width / this.paintDataCache.charWidth;
        this.paintDataCache.linesPerRect = hexRect.height / this.paintDataCache.lineHeight;
        this.paintDataCache.previewStartChar = 0;
        if (this.viewMode == ViewMode.CODE_MATRIX) {
            this.paintDataCache.previewX = -1;
        } else {
            this.paintDataCache.previewX = hexRect.x;
            if (this.viewMode == ViewMode.DUAL) {
                this.paintDataCache.previewStartChar = this.paintDataCache.charsPerLine - this.paintDataCache.bytesPerLine;
                this.paintDataCache.previewX += (this.paintDataCache.charsPerLine - this.paintDataCache.bytesPerLine) * this.paintDataCache.charWidth;
            }
        }
        boolean scrolled = false;
        this.verticalScrollBar.setVisible(verticalScrollBarVisible);
        if (verticalScrollBarVisible) {
            int verticalVisibleAmount;
            int verticalMaximum;
            int verticalScrollBarHeight = compRect.y + compRect.height - hexRect.y;
            if (horizontalScrollBarVisible) {
                verticalScrollBarHeight -= this.paintDataCache.scrollBarThickness - 2;
            }
            this.verticalScrollBar.setBounds(compRect.x + compRect.width - this.paintDataCache.scrollBarThickness, hexRect.y, this.paintDataCache.scrollBarThickness, verticalScrollBarHeight);
            this.scrollPosition.verticalMaxMode = false;
            if (this.verticalScrollMode == VerticalScrollMode.PIXEL) {
                if (lines * (long)this.paintDataCache.lineHeight > Integer.MAX_VALUE) {
                    this.scrollPosition.verticalMaxMode = true;
                    verticalMaximum = Integer.MAX_VALUE;
                    verticalVisibleAmount = (int)((long)(hexRect.height * Integer.MAX_VALUE) / lines);
                } else {
                    verticalMaximum = (int)(lines * (long)this.paintDataCache.lineHeight);
                    verticalVisibleAmount = hexRect.height;
                }
            } else if (lines > Integer.MAX_VALUE) {
                this.scrollPosition.verticalMaxMode = true;
                verticalMaximum = Integer.MAX_VALUE;
                verticalVisibleAmount = (int)((long)(hexRect.height * Integer.MAX_VALUE / this.paintDataCache.lineHeight) / lines);
            } else {
                verticalMaximum = (int)lines;
                verticalVisibleAmount = hexRect.height / this.paintDataCache.lineHeight;
            }
            if (verticalVisibleAmount == 0) {
                verticalVisibleAmount = 1;
            }
            this.verticalScrollBar.setMaximum(verticalMaximum);
            this.verticalScrollBar.setVisibleAmount(verticalVisibleAmount);
            if (!this.scrollPosition.verticalMaxMode && verticalVisibleAmount < verticalMaximum) {
                long maxLineScroll = verticalMaximum - verticalVisibleAmount;
                if (this.verticalScrollMode == VerticalScrollMode.PER_LINE) {
                    long lineScroll = this.scrollPosition.scrollLinePosition;
                    if (lineScroll > maxLineScroll) {
                        this.scrollPosition.scrollLinePosition = maxLineScroll;
                        scrolled = true;
                    }
                } else {
                    long lineScroll = this.scrollPosition.scrollLinePosition * (long)this.paintDataCache.lineHeight + (long)this.scrollPosition.scrollLineOffset;
                    if (lineScroll > maxLineScroll) {
                        this.scrollPosition.scrollLinePosition = maxLineScroll / (long)this.paintDataCache.lineHeight;
                        this.scrollPosition.scrollLineOffset = (int)(maxLineScroll % (long)this.paintDataCache.lineHeight);
                        scrolled = true;
                    }
                }
            }
        } else if (this.scrollPosition.scrollLinePosition > 0L || this.scrollPosition.scrollLineOffset > 0) {
            this.scrollPosition.scrollLinePosition = 0L;
            this.scrollPosition.scrollLineOffset = 0;
            scrolled = true;
        }
        this.horizontalScrollBar.setVisible(horizontalScrollBarVisible);
        if (horizontalScrollBarVisible) {
            int horizontalVisibleAmount;
            int horizontalScrollBarWidth = compRect.x + compRect.width - hexRect.x;
            if (verticalScrollBarVisible) {
                horizontalScrollBarWidth -= this.paintDataCache.scrollBarThickness - 2;
            }
            this.horizontalScrollBar.setBounds(hexRect.x, compRect.y + compRect.height - this.paintDataCache.scrollBarThickness, horizontalScrollBarWidth, this.paintDataCache.scrollBarThickness);
            int horizontalMaximum = this.paintDataCache.charsPerLine;
            if (this.horizontalScrollMode == HorizontalScrollMode.PIXEL) {
                horizontalVisibleAmount = hexRect.width;
                horizontalMaximum *= this.paintDataCache.charWidth;
            } else {
                horizontalVisibleAmount = hexRect.width / this.paintDataCache.charWidth;
            }
            this.horizontalScrollBar.setMaximum(horizontalMaximum);
            this.horizontalScrollBar.setVisibleAmount(horizontalVisibleAmount);
            int maxByteScroll = horizontalMaximum - horizontalVisibleAmount;
            if (horizontalVisibleAmount < horizontalMaximum) {
                if (this.horizontalScrollMode == HorizontalScrollMode.PIXEL) {
                    int byteScroll = this.scrollPosition.scrollCharPosition * this.paintDataCache.charWidth + this.scrollPosition.scrollCharOffset;
                    if (byteScroll > maxByteScroll) {
                        this.scrollPosition.scrollCharPosition = maxByteScroll / this.paintDataCache.charWidth;
                        this.scrollPosition.scrollCharOffset = maxByteScroll % this.paintDataCache.charWidth;
                        scrolled = true;
                    }
                } else {
                    int byteScroll = this.scrollPosition.scrollCharPosition;
                    if (byteScroll > maxByteScroll) {
                        this.scrollPosition.scrollCharPosition = maxByteScroll;
                        scrolled = true;
                    }
                }
            }
        } else if (this.scrollPosition.scrollCharPosition > 0 || this.scrollPosition.scrollCharOffset > 0) {
            this.scrollPosition.scrollCharPosition = 0;
            this.scrollPosition.scrollCharOffset = 0;
            scrolled = true;
        }
        if (scrolled) {
            this.updateScrollBars();
            this.notifyScrolled();
        }
    }

    private void validateLineOffset() {
        if (this.paintDataCache.bytesPerLine > 0 && this.paintDataCache.bytesPerLine <= this.scrollPosition.lineByteShift) {
            this.scrollPosition.setLineByteShift(this.scrollPosition.lineByteShift % this.paintDataCache.bytesPerLine);
        }
    }

    private int computeCharsPerRect(int width) {
        if (this.showLineNumbers) {
            width -= this.paintDataCache.charWidth * this.paintDataCache.lineNumbersLength + this.getLineNumberSpace();
        }
        return width / this.paintDataCache.charWidth;
    }

    public int computeFittingBytes(int charsPerRect) {
        if (this.viewMode == ViewMode.TEXT_PREVIEW) {
            return charsPerRect;
        }
        int fittingBytes = this.computeByteOffsetPerCodeCharOffset(charsPerRect, this.viewMode == ViewMode.DUAL);
        if ((this.byteGroupSize != 0 || this.spaceGroupSize != 0) && this.computeCharsPerLine(fittingBytes + 1) <= charsPerRect) {
            ++fittingBytes;
        }
        return fittingBytes;
    }

    public int computeByteOffsetPerCodeCharOffset(int charOffset, boolean includePreview) {
        int byteOffset;
        if (this.byteGroupSize == 0) {
            byteOffset = this.spaceGroupSize == 0 ? (charOffset - (includePreview ? 1 : 0)) / (this.codeType.getMaxDigits() + (includePreview ? 1 : 0)) : (int)((long)(charOffset - (includePreview ? 1 : 0)) * (long)this.spaceGroupSize / ((long)(this.codeType.getMaxDigits() + (includePreview ? 1 : 0)) * (long)this.spaceGroupSize + 2L));
        } else if (this.spaceGroupSize == 0) {
            byteOffset = (int)((long)(charOffset - (includePreview ? 1 : 0)) * (long)this.byteGroupSize / ((long)(this.codeType.getMaxDigits() + (includePreview ? 1 : 0)) * (long)this.byteGroupSize + 1L));
        } else {
            int charsPerLine;
            byteOffset = 0;
            int n = charsPerLine = includePreview ? 1 : 0;
            while (charsPerLine < charOffset) {
                charsPerLine += this.codeType.getMaxDigits() + (includePreview ? 1 : 0);
                if (++byteOffset % this.byteGroupSize == 0) {
                    charsPerLine = byteOffset % this.spaceGroupSize == 0 ? (charsPerLine += 2) : ++charsPerLine;
                } else if (byteOffset % this.spaceGroupSize == 0) {
                    charsPerLine += 2;
                }
                if (charsPerLine <= charOffset) continue;
                return byteOffset - 1;
            }
        }
        return byteOffset;
    }

    public int computeCharsPerLine(int bytesPerLine) {
        if (this.viewMode == ViewMode.TEXT_PREVIEW) {
            return bytesPerLine;
        }
        int charsPerLine = this.computeByteCharPos(bytesPerLine, false);
        if (this.viewMode == ViewMode.DUAL) {
            charsPerLine += bytesPerLine + 1;
        }
        return charsPerLine;
    }

    public int computeByteCharPos(int byteOffset) {
        return this.computeByteCharPos(byteOffset, true);
    }

    public int computeByteCharPos(int byteOffset, boolean includeTail) {
        int charsPerLine = this.codeType.getMaxDigits() * byteOffset;
        if (!includeTail) {
            --byteOffset;
        }
        if (this.byteGroupSize == 0) {
            if (this.spaceGroupSize != 0) {
                charsPerLine += byteOffset / this.spaceGroupSize * 2;
            }
        } else if (this.spaceGroupSize == 0) {
            charsPerLine += byteOffset / this.byteGroupSize;
        } else {
            for (int index = 1; index <= byteOffset; ++index) {
                if (index % this.byteGroupSize == 0) {
                    if (index % this.spaceGroupSize == 0) {
                        charsPerLine += 2;
                        continue;
                    }
                    ++charsPerLine;
                    continue;
                }
                if (index % this.spaceGroupSize != 0) continue;
                charsPerLine += 2;
            }
        }
        return charsPerLine;
    }

    public ColorsGroup getMainColors() {
        return new ColorsGroup(this.mainColors);
    }

    public ColorsGroup getAlternateColors() {
        return new ColorsGroup(this.alternateColors);
    }

    public ColorsGroup getSelectionColors() {
        return new ColorsGroup(this.selectionColors);
    }

    public ColorsGroup getMirrorSelectionColors() {
        return new ColorsGroup(this.mirrorSelectionColors);
    }

    public void setMainColors(ColorsGroup colorsGroup) {
        this.mainColors.setColors(colorsGroup);
        this.repaint();
    }

    public void setAlternateColors(ColorsGroup colorsGroup) {
        this.alternateColors.setColors(colorsGroup);
        this.repaint();
    }

    public void setSelectionColors(ColorsGroup colorsGroup) {
        this.selectionColors.setColors(colorsGroup);
        this.repaint();
    }

    public void setMirrorSelectionColors(ColorsGroup colorsGroup) {
        this.mirrorSelectionColors.setColors(colorsGroup);
        this.repaint();
    }

    public Color getCursorColor() {
        return this.cursorColor;
    }

    public void setCursorColor(Color cursorColor) {
        this.cursorColor = cursorColor;
        this.negativeCursorColor = CodeArea.createNegativeColor(cursorColor);
        this.repaint();
    }

    public Color getNegativeCursorColor() {
        return this.negativeCursorColor;
    }

    public Color getDecorationLineColor() {
        return this.decorationLineColor;
    }

    public void setDecorationLineColor(Color decorationLineColor) {
        this.decorationLineColor = decorationLineColor;
        this.repaint();
    }

    public ViewMode getViewMode() {
        return this.viewMode;
    }

    public void setViewMode(ViewMode viewMode) {
        this.viewMode = viewMode;
        if (viewMode == ViewMode.CODE_MATRIX) {
            this.caret.setSection(Section.CODE_MATRIX);
            this.notifyCaretMoved();
        } else if (viewMode == ViewMode.TEXT_PREVIEW) {
            this.caret.setSection(Section.TEXT_PREVIEW);
            this.notifyCaretMoved();
        }
        this.computePaintData();
        this.repaint();
    }

    public CodeType getCodeType() {
        return this.codeType;
    }

    public void setCodeType(CodeType codeType) {
        this.codeType = codeType;
        this.computePaintData();
        this.repaint();
    }

    public PositionCodeType getPositionCodeType() {
        return this.positionCodeType;
    }

    public void setPositionCodeType(PositionCodeType positionCodeType) {
        this.positionCodeType = positionCodeType;
        this.computePaintData();
        this.repaint();
    }

    public BackgroundMode getBackgroundMode() {
        return this.backgroundMode;
    }

    public void setBackgroundMode(BackgroundMode backgroundMode) {
        this.backgroundMode = backgroundMode;
        this.repaint();
    }

    public boolean isLineNumberBackground() {
        return this.lineNumberBackground;
    }

    public void setLineNumberBackground(boolean lineNumberBackground) {
        this.lineNumberBackground = lineNumberBackground;
        this.repaint();
    }

    public int getDecorationMode() {
        return this.decorationMode;
    }

    public void setDecorationMode(int decorationMode) {
        this.decorationMode = decorationMode;
        this.repaint();
    }

    public int getSubFontSpace() {
        return this.subFontSpace;
    }

    public void setSubFontSpace(int subFontSpace) {
        this.subFontSpace = subFontSpace;
    }

    public Section getActiveSection() {
        return this.caret.getSection();
    }

    public void setActiveSection(Section activeSection) {
        this.caret.setSection(activeSection);
        this.revealCursor();
        this.repaint();
    }

    public EditationAllowed getEditationAllowed() {
        return this.editationAllowed;
    }

    public void setEditationAllowed(EditationAllowed editationAllowed) {
        this.editationAllowed = editationAllowed;
        switch (editationAllowed) {
            case READ_ONLY: {
                this.editationMode = EditationMode.INSERT;
                break;
            }
            case OVERWRITE_ONLY: {
                this.editationMode = EditationMode.OVERWRITE;
                break;
            }
        }
        this.repaint();
    }

    public EditationMode getEditationMode() {
        return this.editationMode;
    }

    public void setEditationMode(EditationMode editationMode) {
        switch (this.editationAllowed) {
            case READ_ONLY: {
                editationMode = EditationMode.INSERT;
                break;
            }
            case OVERWRITE_ONLY: {
                editationMode = EditationMode.OVERWRITE;
                break;
            }
        }
        boolean chaged = editationMode != this.editationMode;
        this.editationMode = editationMode;
        if (chaged) {
            for (EditationModeChangedListener listener : this.editationModeChangedListeners) {
                listener.editationModeChanged(editationMode);
            }
            this.caret.resetBlink();
            this.repaint();
        }
    }

    public boolean isShowHeader() {
        return this.showHeader;
    }

    public void setShowHeader(boolean showHeader) {
        this.showHeader = showHeader;
        this.computePaintData();
        this.repaint();
    }

    public boolean isShowLineNumbers() {
        return this.showLineNumbers;
    }

    public void setShowLineNumbers(boolean showLineNumbers) {
        this.showLineNumbers = showLineNumbers;
        this.computePaintData();
        this.repaint();
    }

    public boolean isEditable() {
        return this.editationAllowed != EditationAllowed.READ_ONLY;
    }

    public void setEditable(boolean editable) {
        this.setEditationAllowed(EditationAllowed.ALLOWED);
    }

    public boolean isWrapMode() {
        return this.wrapMode;
    }

    public void setWrapMode(boolean wrapMode) {
        this.wrapMode = wrapMode;
        this.computePaintData();
        this.validateLineOffset();
        this.repaint();
    }

    public boolean isHandleClipboard() {
        return this.handleClipboard;
    }

    public void setHandleClipboard(boolean handleClipboard) {
        this.handleClipboard = handleClipboard;
    }

    public boolean isShowUnprintableCharacters() {
        return this.showUnprintableCharacters;
    }

    public void setShowUnprintableCharacters(boolean showUnprintableCharacters) {
        this.showUnprintableCharacters = showUnprintableCharacters;
        this.repaint();
    }

    public boolean isShowShadowCursor() {
        return this.showShadowCursor;
    }

    public void setShowShadowCursor(boolean showShadowCursor) {
        this.showShadowCursor = showShadowCursor;
        this.repaint();
    }

    public int getLineLength() {
        return this.lineLength;
    }

    public void setLineLength(int lineLength) {
        if (lineLength < 1) {
            throw new IllegalStateException("Line length must be at least 1");
        }
        this.lineLength = lineLength;
        if (!this.wrapMode) {
            this.computePaintData();
            this.repaint();
        }
    }

    public int getByteGroupSize() {
        return this.byteGroupSize;
    }

    public void setByteGroupSize(int byteGroupSize) {
        if (byteGroupSize < 0) {
            throw new IllegalStateException("Negative group size is not valid");
        }
        this.byteGroupSize = byteGroupSize;
        this.computePaintData();
        this.repaint();
    }

    public int getSpaceGroupSize() {
        return this.spaceGroupSize;
    }

    public void setSpaceGroupSize(int spaceGroupSize) {
        if (spaceGroupSize < 0) {
            throw new IllegalStateException("Negative group size is not valid");
        }
        this.spaceGroupSize = spaceGroupSize;
        this.computePaintData();
        this.repaint();
    }

    public CharRenderingMode getCharRenderingMode() {
        return this.charRenderingMode;
    }

    public boolean isMonospaceFontDetected() {
        return this.paintDataCache.monospaceFont;
    }

    public void setCharRenderingMode(CharRenderingMode charRenderingMode) {
        this.charRenderingMode = charRenderingMode;
        this.computeFontMetrics();
        this.repaint();
    }

    public CharAntialiasingMode getCharAntialiasingMode() {
        return this.charAntialiasingMode;
    }

    public void setCharAntialiasingMode(CharAntialiasingMode charAntialiasingMode) {
        this.charAntialiasingMode = charAntialiasingMode;
        this.repaint();
    }

    public HexCharactersCase getHexCharactersCase() {
        return this.hexCharactersCase;
    }

    public void setHexCharactersCase(HexCharactersCase hexCharactersCase) {
        this.hexCharactersCase = hexCharactersCase;
        this.repaint();
    }

    public CodeAreaSpace.SpaceType getHeaderSpaceType() {
        return this.headerSpace.getSpaceType();
    }

    public void setHeaderSpaceType(CodeAreaSpace.SpaceType spaceType) {
        if (spaceType == null) {
            throw new NullPointerException();
        }
        this.headerSpace.setSpaceType(spaceType);
        this.computePaintData();
        this.repaint();
    }

    public int getHeaderSpaceSize() {
        return this.headerSpace.getSpaceSize();
    }

    public void setHeaderSpaceSize(int spaceSize) {
        if (spaceSize < 0) {
            throw new IllegalArgumentException("Negative space size is not valid");
        }
        this.headerSpace.setSpaceSize(spaceSize);
        this.computePaintData();
        this.repaint();
    }

    public CodeAreaSpace.SpaceType getLineNumberSpaceType() {
        return this.lineNumberSpace.getSpaceType();
    }

    public void setLineNumberSpaceType(CodeAreaSpace.SpaceType spaceType) {
        if (spaceType == null) {
            throw new NullPointerException();
        }
        this.lineNumberSpace.setSpaceType(spaceType);
        this.computePaintData();
        this.repaint();
    }

    public int getLineNumberSpaceSize() {
        return this.lineNumberSpace.getSpaceSize();
    }

    public void setLineNumberSpaceSize(int spaceSize) {
        if (spaceSize < 0) {
            throw new IllegalArgumentException("Negative space size is not valid");
        }
        this.lineNumberSpace.setSpaceSize(spaceSize);
        this.computePaintData();
        this.repaint();
    }

    public CodeAreaLineNumberLength.LineNumberType getLineNumberType() {
        return this.lineNumberLength.getLineNumberType();
    }

    public void setLineNumberType(CodeAreaLineNumberLength.LineNumberType lineNumberType) {
        if (lineNumberType == null) {
            throw new NullPointerException("Line number type cannot be null");
        }
        this.lineNumberLength.setLineNumberType(lineNumberType);
        this.computePaintData();
        this.repaint();
    }

    public int getLineNumberSpecifiedLength() {
        return this.lineNumberLength.getLineNumberLength();
    }

    public void setLineNumberSpecifiedLength(int lineNumberSize) {
        if (lineNumberSize < 1) {
            throw new IllegalArgumentException("Line number type cannot be less then 1");
        }
        this.lineNumberLength.setLineNumberLength(lineNumberSize);
        this.computePaintData();
        this.repaint();
    }

    public ScrollBarVisibility getVerticalScrollBarVisibility() {
        return this.verticalScrollBarVisibility;
    }

    public void setVerticalScrollBarVisibility(ScrollBarVisibility verticalScrollBarVisibility) {
        this.verticalScrollBarVisibility = verticalScrollBarVisibility;
        this.computePaintData();
        this.updateScrollBars();
    }

    public VerticalScrollMode getVerticalScrollMode() {
        return this.verticalScrollMode;
    }

    public void setVerticalScrollMode(VerticalScrollMode verticalScrollMode) {
        this.verticalScrollMode = verticalScrollMode;
        long linePosition = this.scrollPosition.scrollLinePosition;
        if (verticalScrollMode == VerticalScrollMode.PER_LINE) {
            this.scrollPosition.scrollLineOffset = 0;
        }
        this.computePaintData();
        this.scrollPosition.scrollLinePosition = linePosition;
        this.updateScrollBars();
        this.notifyScrolled();
    }

    public ScrollBarVisibility getHorizontalScrollBarVisibility() {
        return this.horizontalScrollBarVisibility;
    }

    public void setHorizontalScrollBarVisibility(ScrollBarVisibility horizontalScrollBarVisibility) {
        this.horizontalScrollBarVisibility = horizontalScrollBarVisibility;
        this.computePaintData();
        this.updateScrollBars();
    }

    public HorizontalScrollMode getHorizontalScrollMode() {
        return this.horizontalScrollMode;
    }

    public void setHorizontalScrollMode(HorizontalScrollMode horizontalScrollMode) {
        this.horizontalScrollMode = horizontalScrollMode;
        int bytePosition = this.scrollPosition.scrollCharPosition;
        if (horizontalScrollMode == HorizontalScrollMode.PER_CHAR) {
            this.scrollPosition.scrollCharOffset = 0;
        }
        this.computePaintData();
        this.scrollPosition.scrollCharPosition = bytePosition;
        this.updateScrollBars();
        this.notifyScrolled();
    }

    public long getDataPosition() {
        return this.caret.getDataPosition();
    }

    public int getCodeOffset() {
        return this.caret.getCodeOffset();
    }

    public CaretPosition getCaretPosition() {
        return this.caret.getCaretPosition();
    }

    public CodeAreaCommandHandler getCommandHandler() {
        return this.commandHandler;
    }

    public void setCommandHandler(CodeAreaCommandHandler commandHandler) {
        this.commandHandler = commandHandler;
    }

    public void copy() {
        this.commandHandler.copy();
    }

    public void copyAsCode() {
        this.commandHandler.copyAsCode();
    }

    public void cut() {
        this.commandHandler.cut();
    }

    public void paste() {
        this.commandHandler.paste();
    }

    public void pasteFromCode() {
        this.commandHandler.pasteFromCode();
    }

    public void delete() {
        this.commandHandler.delete();
    }

    public boolean canPaste() {
        return this.commandHandler.canPaste();
    }

    public void resetPosition() {
        this.getScrollPosition().reset();
        this.updateScrollBars();
        this.notifyScrolled();
        this.caret.setCaretPosition(0L);
        this.notifyCaretMoved();
        this.commandHandler.sequenceBreak();
        this.computePaintData();
        this.clearSelection();
    }

    private static Color createOddColor(Color color) {
        return new Color(CodeArea.computeOddColorComponent(color.getRed()), CodeArea.computeOddColorComponent(color.getGreen()), CodeArea.computeOddColorComponent(color.getBlue()));
    }

    private static int computeOddColorComponent(int colorComponent) {
        return colorComponent + (colorComponent > 64 ? -16 : 16);
    }

    private static Color createNegativeColor(Color color) {
        return new Color(255 - color.getRed(), 255 - color.getGreen(), 255 - color.getBlue());
    }

    private class HorizontalAdjustmentListener
    implements AdjustmentListener {
        @Override
        public void adjustmentValueChanged(AdjustmentEvent e) {
            if (CodeArea.this.horizontalScrollMode == HorizontalScrollMode.PER_CHAR) {
                CodeArea.this.scrollPosition.scrollCharPosition = CodeArea.this.horizontalScrollBar.getValue();
            } else {
                CodeArea.this.scrollPosition.scrollCharPosition = CodeArea.this.horizontalScrollBar.getValue() / ((CodeArea)CodeArea.this).paintDataCache.charWidth;
                CodeArea.this.scrollPosition.scrollCharOffset = CodeArea.this.horizontalScrollBar.getValue() % ((CodeArea)CodeArea.this).paintDataCache.charWidth;
            }
            CodeArea.this.repaint();
            CodeArea.this.notifyScrolled();
        }
    }

    private class VerticalAdjustmentListener
    implements AdjustmentListener {
        @Override
        public void adjustmentValueChanged(AdjustmentEvent e) {
            int scrollBarValue = CodeArea.this.verticalScrollBar.getValue();
            if (CodeArea.this.scrollPosition.verticalMaxMode) {
                long targetLine;
                int maxValue = Integer.MAX_VALUE - CodeArea.this.verticalScrollBar.getVisibleAmount();
                long lines = (CodeArea.this.data.getDataSize() + (long)CodeArea.this.scrollPosition.lineByteShift) / (long)((CodeArea)CodeArea.this).paintDataCache.bytesPerLine - (long)((CodeArea)CodeArea.this).paintDataCache.linesPerRect + 1L;
                if (scrollBarValue > 0 && lines > (long)(maxValue / scrollBarValue)) {
                    targetLine = (long)scrollBarValue * (lines / (long)maxValue);
                    long rest = lines % (long)maxValue;
                    targetLine += rest * (long)scrollBarValue / (long)maxValue;
                } else {
                    targetLine = (long)scrollBarValue * lines / Integer.MAX_VALUE;
                }
                CodeArea.this.scrollPosition.scrollLinePosition = targetLine;
                if (CodeArea.this.verticalScrollMode != VerticalScrollMode.PER_LINE) {
                    CodeArea.this.scrollPosition.scrollLineOffset = 0;
                }
            } else if (CodeArea.this.verticalScrollMode == VerticalScrollMode.PER_LINE) {
                CodeArea.this.scrollPosition.scrollLinePosition = scrollBarValue;
            } else {
                CodeArea.this.scrollPosition.scrollLinePosition = scrollBarValue / ((CodeArea)CodeArea.this).paintDataCache.lineHeight;
                CodeArea.this.scrollPosition.scrollLineOffset = scrollBarValue % ((CodeArea)CodeArea.this).paintDataCache.lineHeight;
            }
            CodeArea.this.repaint();
            CodeArea.this.notifyScrolled();
        }
    }

    private class CodeAreaComponentListener
    implements ComponentListener {
        @Override
        public void componentResized(ComponentEvent e) {
            CodeArea.this.computePaintData();
            CodeArea.this.validateLineOffset();
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }
    }

    private class CodeAreaKeyListener
    extends KeyAdapter {
        @Override
        public void keyTyped(KeyEvent keyEvent) {
            CodeArea.this.commandHandler.keyTyped(keyEvent);
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            CodeArea.this.commandHandler.keyPressed(keyEvent);
        }
    }

    private class CodeAreaMouseListener
    extends MouseAdapter
    implements MouseMotionListener,
    MouseWheelListener {
        private Cursor currentCursor;
        private final Cursor defaultCursor;
        private final Cursor textCursor;

        private CodeAreaMouseListener() {
            this.currentCursor = CodeArea.this.getCursor();
            this.defaultCursor = Cursor.getDefaultCursor();
            this.textCursor = Cursor.getPredefinedCursor(2);
        }

        @Override
        public void mousePressed(MouseEvent me) {
            CodeArea.this.requestFocus();
            if (CodeArea.this.isEnabled() && me.getButton() == 1) {
                CodeArea.this.moveCaret(me, me.getModifiersEx());
                CodeArea.this.revealCursor();
                CodeArea.this.mouseDown = true;
            }
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            CodeArea.this.mouseDown = false;
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.currentCursor = this.defaultCursor;
            CodeArea.this.setCursor(this.defaultCursor);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.updateMouseCursor(e);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.updateMouseCursor(e);
        }

        private void updateMouseCursor(MouseEvent e) {
            Cursor newCursor = this.defaultCursor;
            Rectangle hexRect = ((CodeArea)CodeArea.this).paintDataCache.codeSectionRectangle;
            if (e.getX() >= hexRect.x && e.getY() >= hexRect.y) {
                newCursor = this.textCursor;
            }
            if (newCursor != this.currentCursor) {
                this.currentCursor = newCursor;
                CodeArea.this.setCursor(newCursor);
            }
        }

        @Override
        public void mouseDragged(MouseEvent me) {
            this.updateMouseCursor(me);
            if (CodeArea.this.isEnabled() && CodeArea.this.mouseDown) {
                CodeArea.this.moveCaret(me, 64);
                CodeArea.this.revealCursor();
            }
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            if (!CodeArea.this.isEnabled()) {
                return;
            }
            if (e.isShiftDown() && CodeArea.this.horizontalScrollBar.isVisible()) {
                if (e.getWheelRotation() > 0) {
                    int visibleChars = ((CodeArea)CodeArea.this).paintDataCache.codeSectionRectangle.width / ((CodeArea)CodeArea.this).paintDataCache.charWidth;
                    int bytes = ((CodeArea)CodeArea.this).paintDataCache.bytesPerLine - visibleChars;
                    if (CodeArea.this.scrollPosition.scrollCharPosition < bytes) {
                        if (CodeArea.this.scrollPosition.scrollCharPosition < bytes - 3) {
                            ScrollPosition scrollPosition = CodeArea.this.scrollPosition;
                            scrollPosition.scrollCharPosition = scrollPosition.scrollCharPosition + 3;
                        } else {
                            CodeArea.this.scrollPosition.scrollCharPosition = bytes;
                        }
                        CodeArea.this.updateScrollBars();
                        CodeArea.this.notifyScrolled();
                    }
                } else if (CodeArea.this.scrollPosition.scrollCharPosition > 0) {
                    if (CodeArea.this.scrollPosition.scrollCharPosition > 3) {
                        ScrollPosition visibleChars = CodeArea.this.scrollPosition;
                        visibleChars.scrollCharPosition = visibleChars.scrollCharPosition - 3;
                    } else {
                        CodeArea.this.scrollPosition.scrollCharPosition = 0;
                    }
                    CodeArea.this.updateScrollBars();
                    CodeArea.this.notifyScrolled();
                }
            } else if (e.getWheelRotation() > 0) {
                long lines = (CodeArea.this.data.getDataSize() + (long)CodeArea.this.scrollPosition.lineByteShift) / (long)((CodeArea)CodeArea.this).paintDataCache.bytesPerLine;
                if (lines * (long)((CodeArea)CodeArea.this).paintDataCache.bytesPerLine < CodeArea.this.data.getDataSize()) {
                    ++lines;
                }
                if (CodeArea.this.scrollPosition.scrollLinePosition < (lines -= (long)((CodeArea)CodeArea.this).paintDataCache.linesPerRect)) {
                    if (CodeArea.this.scrollPosition.scrollLinePosition < lines - 3L) {
                        ScrollPosition scrollPosition = CodeArea.this.scrollPosition;
                        scrollPosition.scrollLinePosition = scrollPosition.scrollLinePosition + 3L;
                    } else {
                        CodeArea.this.scrollPosition.scrollLinePosition = lines;
                    }
                    CodeArea.this.updateScrollBars();
                    CodeArea.this.notifyScrolled();
                }
            } else if (CodeArea.this.scrollPosition.scrollLinePosition > 0L) {
                if (CodeArea.this.scrollPosition.scrollLinePosition > 3L) {
                    ScrollPosition scrollPosition = CodeArea.this.scrollPosition;
                    scrollPosition.scrollLinePosition = scrollPosition.scrollLinePosition - 3L;
                } else {
                    CodeArea.this.scrollPosition.scrollLinePosition = 0L;
                }
                CodeArea.this.updateScrollBars();
                CodeArea.this.notifyScrolled();
            }
        }
    }

    public static class ScrollPosition {
        private long scrollLinePosition = 0L;
        private int scrollLineOffset = 0;
        private int scrollCharPosition = 0;
        private int scrollCharOffset = 0;
        private int lineByteShift = 0;
        private boolean verticalMaxMode = false;

        public long getScrollLinePosition() {
            return this.scrollLinePosition;
        }

        public int getScrollLineOffset() {
            return this.scrollLineOffset;
        }

        public int getScrollCharPosition() {
            return this.scrollCharPosition;
        }

        public int getScrollCharOffset() {
            return this.scrollCharOffset;
        }

        public int getLineByteShift() {
            return this.lineByteShift;
        }

        public void setScrollLinePosition(long scrollLinePosition) {
            this.scrollLinePosition = scrollLinePosition;
        }

        public void setScrollLineOffset(int scrollLineOffset) {
            this.scrollLineOffset = scrollLineOffset;
        }

        public void setScrollCharPosition(int scrollCharPosition) {
            this.scrollCharPosition = scrollCharPosition;
        }

        public void setScrollCharOffset(int scrollCharOffset) {
            this.scrollCharOffset = scrollCharOffset;
        }

        public void setLineByteShift(int lineByteShift) {
            this.lineByteShift = lineByteShift;
        }

        public boolean isVerticalMaxMode() {
            return this.verticalMaxMode;
        }

        public void setVerticalMaxMode(boolean verticalMaxMode) {
            this.verticalMaxMode = verticalMaxMode;
        }

        private void reset() {
            this.scrollLinePosition = 0L;
            this.scrollLineOffset = 0;
            this.scrollCharPosition = 0;
            this.scrollCharOffset = 0;
            this.lineByteShift = 0;
        }
    }

    private static class PaintDataCache {
        FontMetrics fontMetrics = null;
        int charWidth;
        int lineHeight;
        boolean monospaceFont = false;
        int bytesPerLine;
        int charsPerLine;
        int lineNumbersLength;
        final Rectangle componentRectangle = new Rectangle();
        int headerSpace;
        int lineNumberSpace;
        int previewSpace;
        final Rectangle codeSectionRectangle = new Rectangle();
        int previewX;
        int previewStartChar;
        int bytesPerRect;
        int linesPerRect;
        int scrollBarThickness = 17;

        private PaintDataCache() {
        }
    }

    public static enum CharAntialiasingMode {
        OFF,
        AUTO,
        DEFAULT,
        BASIC,
        GASP,
        LCD_HRGB,
        LCD_HBGR,
        LCD_VRGB,
        LCD_VBGR;

    }

    public static enum CharRenderingMode {
        AUTO,
        LINE_AT_ONCE,
        TOP_LEFT,
        CENTER;

    }

    public static enum HorizontalScrollMode {
        PER_CHAR,
        PIXEL;

    }

    public static enum VerticalScrollMode {
        PER_LINE,
        PIXEL;

    }

    public static enum BackgroundMode {
        NONE,
        PLAIN,
        STRIPPED,
        GRIDDED;

    }
}

