/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.deltahex.swing;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import org.exbin.deltahex.CaretPosition;
import org.exbin.deltahex.EditationMode;
import org.exbin.deltahex.Section;
import org.exbin.deltahex.swing.CodeArea;

public class CodeAreaCaret {
    private static final int LINE_CURSOR_WIDTH = 1;
    private static final int DOUBLE_CURSOR_WIDTH = 2;
    private static final int DEFAULT_BLINK_RATE = 450;
    private final CodeArea codeArea;
    private final CaretPosition caretPosition = new CaretPosition();
    private int blinkRate = 0;
    private Timer blinkTimer = null;
    private boolean cursorVisible = true;
    private Section section = Section.CODE_MATRIX;
    private CursorShape insertCursorShape = CursorShape.DOUBLE_LEFT;
    private CursorShape overwriteCursorShape = CursorShape.BOX;
    private CursorRenderingMode renderingMode = CursorRenderingMode.NEGATIVE;

    public CodeAreaCaret(CodeArea codeArea) {
        this.codeArea = codeArea;
        this.privateSetBlinkRate(450);
    }

    public int getCursorThickness(CursorShape cursorShape, int charWidth, int lineHeight) {
        switch (cursorShape.getWidth()) {
            case LINE: {
                return 1;
            }
            case DOUBLE: {
                return 2;
            }
            case QUARTER: {
                if (cursorShape == CursorShape.QUARTER_LEFT || cursorShape == CursorShape.QUARTER_RIGHT) {
                    return charWidth / 4;
                }
                return lineHeight / 4;
            }
            case HALF: {
                if (cursorShape == CursorShape.HALF_LEFT || cursorShape == CursorShape.HALF_RIGHT) {
                    return charWidth / 2;
                }
                return lineHeight / 2;
            }
        }
        return -1;
    }

    public Point getCursorPoint(int bytesPerLine, int lineHeight, int charWidth, int linesPerRect) {
        CodeArea.ScrollPosition scrollPosition = this.codeArea.getScrollPosition();
        long shiftedPosition = this.caretPosition.getDataPosition() + (long)scrollPosition.getLineByteShift();
        long line = shiftedPosition / (long)bytesPerLine - scrollPosition.getScrollLinePosition();
        if (line < -1L || line > (long)linesPerRect) {
            return null;
        }
        int byteOffset = (int)(shiftedPosition % (long)bytesPerLine);
        Rectangle rect = this.codeArea.getCodeSectionRectangle();
        int caretY = (int)((long)rect.y + line * (long)lineHeight) - scrollPosition.getScrollLineOffset();
        int caretX = this.section == Section.TEXT_PREVIEW ? this.codeArea.getPreviewX() + charWidth * byteOffset : rect.x + charWidth * (this.codeArea.computeByteCharPos(byteOffset) + this.getCodeOffset());
        return new Point(caretX -= scrollPosition.getScrollCharPosition() * charWidth + scrollPosition.getScrollCharOffset(), caretY);
    }

    public Point getShadowCursorPoint(int bytesPerLine, int lineHeight, int charWidth, int linesPerRect) {
        CodeArea.ScrollPosition scrollPosition = this.codeArea.getScrollPosition();
        long shiftedPosition = this.caretPosition.getDataPosition() + (long)scrollPosition.getLineByteShift();
        long line = shiftedPosition / (long)bytesPerLine - scrollPosition.getScrollLinePosition();
        if (line < -1L || line + 1L > (long)linesPerRect) {
            return null;
        }
        int byteOffset = (int)(shiftedPosition % (long)bytesPerLine);
        Rectangle rect = this.codeArea.getCodeSectionRectangle();
        int caretY = (int)((long)rect.y + line * (long)lineHeight) - scrollPosition.getScrollLineOffset();
        int caretX = this.section == Section.TEXT_PREVIEW ? rect.x + charWidth * this.codeArea.computeByteCharPos(byteOffset) : this.codeArea.getPreviewX() + charWidth * byteOffset;
        return new Point(caretX -= scrollPosition.getScrollCharPosition() * charWidth + scrollPosition.getScrollCharOffset(), caretY);
    }

    public Rectangle getCursorRect(int bytesPerLine, int lineHeight, int charWidth, int linesPerRect) {
        Point cursorPoint = this.getCursorPoint(bytesPerLine, lineHeight, charWidth, linesPerRect);
        if (cursorPoint == null) {
            return null;
        }
        CursorShape cursorShape = this.codeArea.getEditationMode() == EditationMode.INSERT ? this.insertCursorShape : this.overwriteCursorShape;
        int cursorThickness = 0;
        if (cursorShape.getWidth() != CursorShapeWidth.FULL) {
            cursorThickness = this.getCursorThickness(cursorShape, charWidth, lineHeight);
        }
        switch (cursorShape) {
            case BOX: 
            case FRAME: 
            case BOTTOM_CORNERS: 
            case CORNERS: {
                int width = charWidth;
                if (cursorShape != CursorShape.BOX) {
                    ++width;
                }
                return new Rectangle(cursorPoint.x, cursorPoint.y, width, lineHeight);
            }
            case LINE_TOP: 
            case DOUBLE_TOP: 
            case QUARTER_TOP: 
            case HALF_TOP: {
                return new Rectangle(cursorPoint.x, cursorPoint.y, charWidth, cursorThickness);
            }
            case LINE_BOTTOM: 
            case DOUBLE_BOTTOM: 
            case QUARTER_BOTTOM: 
            case HALF_BOTTOM: {
                return new Rectangle(cursorPoint.x, cursorPoint.y + lineHeight - cursorThickness, charWidth, cursorThickness);
            }
            case LINE_LEFT: 
            case DOUBLE_LEFT: 
            case QUARTER_LEFT: 
            case HALF_LEFT: {
                return new Rectangle(cursorPoint.x, cursorPoint.y, cursorThickness, lineHeight);
            }
            case LINE_RIGHT: 
            case DOUBLE_RIGHT: 
            case QUARTER_RIGHT: 
            case HALF_RIGHT: {
                return new Rectangle(cursorPoint.x + charWidth - cursorThickness, cursorPoint.y, cursorThickness, lineHeight);
            }
        }
        throw new IllegalStateException("Unexpected cursor shape type " + cursorShape.name());
    }

    public CaretPosition getCaretPosition() {
        return new CaretPosition(this.caretPosition.getDataPosition(), this.caretPosition.getCodeOffset());
    }

    public void resetBlink() {
        if (this.blinkTimer != null) {
            this.cursorVisible = true;
            this.blinkTimer.restart();
        }
    }

    private void cursorRepaint() {
        int linesPerRect;
        int charWidth;
        int lineHeight;
        Rectangle cursorRect;
        int bytesPerLine = this.codeArea.getBytesPerLine();
        if (bytesPerLine > 0 && (cursorRect = this.getCursorRect(bytesPerLine, lineHeight = this.codeArea.getLineHeight(), charWidth = this.codeArea.getCharWidth(), linesPerRect = this.codeArea.getLinesPerRect())) != null) {
            this.codeArea.paintImmediately(cursorRect);
        }
    }

    public void setCaretPosition(CaretPosition caretPosition) {
        this.caretPosition.setDataPosition(caretPosition == null ? 0L : caretPosition.getDataPosition());
        this.caretPosition.setCodeOffset(caretPosition == null ? 0 : caretPosition.getCodeOffset());
    }

    public long getDataPosition() {
        return this.caretPosition.getDataPosition();
    }

    public void setCaretPosition(long dataPosition) {
        this.caretPosition.setDataPosition(dataPosition);
        this.caretPosition.setCodeOffset(0);
        this.resetBlink();
    }

    public void setCaretPosition(long dataPosition, int codeOffset) {
        this.caretPosition.setDataPosition(dataPosition);
        this.caretPosition.setCodeOffset(codeOffset);
        this.resetBlink();
    }

    public int getCodeOffset() {
        return this.caretPosition.getCodeOffset();
    }

    public void setCodeOffset(int codeOffset) {
        this.caretPosition.setCodeOffset(codeOffset);
        this.resetBlink();
    }

    public Section getSection() {
        return this.section;
    }

    public void setSection(Section section) {
        this.section = section;
        this.resetBlink();
    }

    public int getBlinkRate() {
        return this.blinkRate;
    }

    public void setBlinkRate(int blinkRate) {
        this.privateSetBlinkRate(blinkRate);
    }

    public CursorShape getInsertCursorShape() {
        return this.insertCursorShape;
    }

    public void setInsertCursorShape(CursorShape insertCursorShape) {
        if (insertCursorShape == null) {
            throw new NullPointerException("Insert cursor shape cannot be null");
        }
        this.insertCursorShape = insertCursorShape;
        this.cursorRepaint();
    }

    public CursorShape getOverwriteCursorShape() {
        return this.overwriteCursorShape;
    }

    public void setOverwriteCursorShape(CursorShape overwriteCursorShape) {
        if (overwriteCursorShape == null) {
            throw new NullPointerException("Override cursor shape cannot be null");
        }
        this.overwriteCursorShape = overwriteCursorShape;
        this.cursorRepaint();
    }

    public boolean isCursorVisible() {
        return this.cursorVisible;
    }

    public CursorRenderingMode getRenderingMode() {
        return this.renderingMode;
    }

    public void setRenderingMode(CursorRenderingMode renderingMode) {
        if (renderingMode == null) {
            throw new NullPointerException("Cursor rendering mode cannot be null");
        }
        this.renderingMode = renderingMode;
        this.cursorRepaint();
    }

    private void privateSetBlinkRate(int blinkRate) {
        if (blinkRate < 0) {
            throw new IllegalArgumentException("Blink rate cannot be negative");
        }
        this.blinkRate = blinkRate;
        if (this.blinkTimer != null) {
            if (blinkRate == 0) {
                this.blinkTimer.stop();
                this.blinkTimer = null;
                this.cursorVisible = true;
                this.cursorRepaint();
            } else {
                this.blinkTimer.setDelay(blinkRate);
                this.blinkTimer.setInitialDelay(blinkRate);
            }
        } else if (blinkRate > 0) {
            this.blinkTimer = new Timer(blinkRate, new Blink());
            this.blinkTimer.setRepeats(true);
            this.blinkTimer.start();
        }
    }

    public static enum CursorRenderingMode {
        PAINT,
        XOR,
        NEGATIVE;

    }

    public static enum CursorShapeWidth {
        LINE,
        DOUBLE,
        QUARTER,
        HALF,
        FULL;

    }

    public static enum CursorShape {
        LINE_BOTTOM(CursorShapeWidth.LINE),
        LINE_TOP(CursorShapeWidth.LINE),
        LINE_LEFT(CursorShapeWidth.LINE),
        LINE_RIGHT(CursorShapeWidth.LINE),
        DOUBLE_BOTTOM(CursorShapeWidth.DOUBLE),
        DOUBLE_TOP(CursorShapeWidth.DOUBLE),
        DOUBLE_LEFT(CursorShapeWidth.DOUBLE),
        DOUBLE_RIGHT(CursorShapeWidth.DOUBLE),
        QUARTER_BOTTOM(CursorShapeWidth.QUARTER),
        QUARTER_TOP(CursorShapeWidth.QUARTER),
        QUARTER_LEFT(CursorShapeWidth.QUARTER),
        QUARTER_RIGHT(CursorShapeWidth.QUARTER),
        HALF_BOTTOM(CursorShapeWidth.HALF),
        HALF_TOP(CursorShapeWidth.HALF),
        HALF_LEFT(CursorShapeWidth.HALF),
        HALF_RIGHT(CursorShapeWidth.HALF),
        BOX(CursorShapeWidth.FULL),
        FRAME(CursorShapeWidth.FULL),
        CORNERS(CursorShapeWidth.FULL),
        BOTTOM_CORNERS(CursorShapeWidth.FULL);

        private final CursorShapeWidth width;

        private CursorShape(CursorShapeWidth width) {
            this.width = width;
        }

        public CursorShapeWidth getWidth() {
            return this.width;
        }
    }

    private class Blink
    implements ActionListener {
        private Blink() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CodeAreaCaret.this.cursorVisible = !CodeAreaCaret.this.cursorVisible;
            CodeAreaCaret.this.cursorRepaint();
        }
    }
}

