/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.deltahex.swing;

import java.awt.Color;

public class ColorsGroup {
    private Color textColor;
    private Color backgroundColor;
    private Color unprintablesColor;
    private Color unprintablesBackgroundColor;

    public ColorsGroup() {
    }

    public ColorsGroup(ColorsGroup colorsGroup) {
        this.setColorsFromGroup(colorsGroup);
    }

    private void setColorsFromGroup(ColorsGroup colorsGroup) {
        this.textColor = colorsGroup.getTextColor();
        this.backgroundColor = colorsGroup.getBackgroundColor();
        this.unprintablesColor = colorsGroup.getUnprintablesColor();
        this.unprintablesBackgroundColor = colorsGroup.getUnprintablesBackgroundColor();
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public Color getUnprintablesColor() {
        return this.unprintablesColor;
    }

    public void setUnprintablesColor(Color unprintablesColor) {
        this.unprintablesColor = unprintablesColor;
    }

    public Color getUnprintablesBackgroundColor() {
        return this.unprintablesBackgroundColor;
    }

    public void setUnprintablesBackgroundColor(Color unprintablesBackgroundColor) {
        this.unprintablesBackgroundColor = unprintablesBackgroundColor;
    }

    public void setBothBackgroundColors(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        this.unprintablesBackgroundColor = backgroundColor;
    }

    public void setColors(ColorsGroup colorsGroup) {
        this.setColorsFromGroup(colorsGroup);
    }

    public Color getColor(ColorType colorType) {
        switch (colorType) {
            case TEXT: {
                return this.textColor;
            }
            case BACKGROUND: {
                return this.backgroundColor;
            }
            case UNPRINTABLES: {
                return this.unprintablesColor;
            }
            case UNPRINTABLES_BACKGROUND: {
                return this.unprintablesBackgroundColor;
            }
        }
        throw new IllegalStateException();
    }

    public void setColor(ColorType colorType, Color color) {
        switch (colorType) {
            case TEXT: {
                this.textColor = color;
                break;
            }
            case BACKGROUND: {
                this.backgroundColor = color;
                break;
            }
            case UNPRINTABLES: {
                this.unprintablesColor = color;
                break;
            }
            case UNPRINTABLES_BACKGROUND: {
                this.unprintablesBackgroundColor = color;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    public static enum ColorType {
        TEXT,
        BACKGROUND,
        UNPRINTABLES,
        UNPRINTABLES_BACKGROUND;

    }
}

