/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.deltahex.swing;

import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorEvent;
import java.awt.datatransfer.FlavorListener;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.KeyEvent;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.exbin.deltahex.CaretPosition;
import org.exbin.deltahex.CodeAreaUtils;
import org.exbin.deltahex.CodeType;
import org.exbin.deltahex.EditationAllowed;
import org.exbin.deltahex.EditationMode;
import org.exbin.deltahex.HexCharactersCase;
import org.exbin.deltahex.Section;
import org.exbin.deltahex.SelectionRange;
import org.exbin.deltahex.ViewMode;
import org.exbin.deltahex.swing.CodeArea;
import org.exbin.deltahex.swing.CodeAreaCaret;
import org.exbin.deltahex.swing.CodeAreaCommandHandler;
import org.exbin.utils.binary_data.BinaryData;
import org.exbin.utils.binary_data.ByteArrayEditableData;
import org.exbin.utils.binary_data.EditableBinaryData;

public class DefaultCodeAreaCommandHandler
implements CodeAreaCommandHandler {
    public static final String MIME_CLIPBOARD_BINARY = "application/octet-stream";
    private static final int CODE_BUFFER_LENGTH = 16;
    private final int metaMask;
    private final CodeArea codeArea;
    private Clipboard clipboard;
    private boolean canPaste = false;
    private DataFlavor binaryDataFlavor;
    private ClipboardData currentClipboardData = null;

    public DefaultCodeAreaCommandHandler(CodeArea codeArea) {
        int metaMaskInit;
        this.codeArea = codeArea;
        try {
            metaMaskInit = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        }
        catch (HeadlessException ex) {
            metaMaskInit = 2;
        }
        this.metaMask = metaMaskInit;
        try {
            this.clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        catch (HeadlessException ex) {
            this.clipboard = new Clipboard("clipboard");
        }
        try {
            this.clipboard.addFlavorListener(new FlavorListener(){

                @Override
                public void flavorsChanged(FlavorEvent e) {
                    DefaultCodeAreaCommandHandler.this.updateCanPaste();
                }
            });
            try {
                this.binaryDataFlavor = new DataFlavor(MIME_CLIPBOARD_BINARY);
            }
            catch (ClassNotFoundException ex) {
                Logger.getLogger(DefaultCodeAreaCommandHandler.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.updateCanPaste();
        }
        catch (IllegalStateException ex) {
            this.canPaste = false;
        }
        catch (HeadlessException ex) {
            Logger.getLogger(DefaultCodeAreaCommandHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void updateCanPaste() {
        try {
            this.canPaste = this.clipboard.isDataFlavorAvailable(this.binaryDataFlavor) || this.clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor);
        }
        catch (IllegalStateException ex) {
            this.canPaste = false;
        }
    }

    @Override
    public void sequenceBreak() {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (!this.codeArea.isEnabled()) {
            return;
        }
        switch (keyEvent.getKeyCode()) {
            case 37: {
                if ((keyEvent.getModifiersEx() & 0x80) > 0) {
                    CodeArea.ScrollPosition scrollPosition = this.codeArea.getScrollPosition();
                    if (scrollPosition.getLineByteShift() < this.codeArea.getBytesPerLine() - 1) {
                        scrollPosition.setLineByteShift(scrollPosition.getLineByteShift() + 1);
                    } else {
                        if (scrollPosition.getScrollLinePosition() > 0L) {
                            scrollPosition.setScrollLinePosition(scrollPosition.getScrollLinePosition() - 1L);
                        }
                        scrollPosition.setLineByteShift(0);
                    }
                    this.codeArea.getCaret().resetBlink();
                    this.codeArea.computePaintData();
                    this.codeArea.notifyScrolled();
                    this.codeArea.repaint();
                } else {
                    this.codeArea.moveLeft(keyEvent.getModifiersEx());
                    this.sequenceBreak();
                    this.codeArea.revealCursor();
                }
                keyEvent.consume();
                break;
            }
            case 39: {
                if ((keyEvent.getModifiersEx() & 0x80) > 0) {
                    CodeArea.ScrollPosition scrollPosition = this.codeArea.getScrollPosition();
                    if (scrollPosition.getLineByteShift() > 0) {
                        scrollPosition.setLineByteShift(scrollPosition.getLineByteShift() - 1);
                    } else {
                        long dataSize = this.codeArea.getDataSize();
                        if (scrollPosition.getScrollLinePosition() < dataSize / (long)this.codeArea.getBytesPerLine()) {
                            scrollPosition.setScrollLinePosition(scrollPosition.getScrollLinePosition() + 1L);
                        }
                        scrollPosition.setLineByteShift(this.codeArea.getBytesPerLine() - 1);
                    }
                    this.codeArea.getCaret().resetBlink();
                    this.codeArea.computePaintData();
                    this.codeArea.notifyScrolled();
                    this.codeArea.repaint();
                } else {
                    this.codeArea.moveRight(keyEvent.getModifiersEx());
                    this.sequenceBreak();
                    this.codeArea.revealCursor();
                }
                keyEvent.consume();
                break;
            }
            case 38: {
                CaretPosition caretPosition = this.codeArea.getCaretPosition();
                int bytesPerLine = this.codeArea.getBytesPerLine();
                if ((keyEvent.getModifiersEx() & 0x80) > 0) {
                    CodeArea.ScrollPosition scrollPosition = this.codeArea.getScrollPosition();
                    if (scrollPosition.getScrollLinePosition() > 0L) {
                        scrollPosition.setScrollLinePosition(scrollPosition.getScrollLinePosition() - 1L);
                        this.codeArea.updateScrollBars();
                        this.codeArea.notifyScrolled();
                    }
                } else {
                    if (caretPosition.getDataPosition() > 0L) {
                        if (caretPosition.getDataPosition() >= (long)bytesPerLine) {
                            this.codeArea.setCaretPosition(caretPosition.getDataPosition() - (long)bytesPerLine, caretPosition.getCodeOffset());
                            this.codeArea.notifyCaretMoved();
                        }
                        this.codeArea.updateSelection(keyEvent.getModifiersEx(), caretPosition);
                    }
                    this.sequenceBreak();
                    this.codeArea.revealCursor();
                }
                keyEvent.consume();
                break;
            }
            case 40: {
                CaretPosition caretPosition = this.codeArea.getCaretPosition();
                int bytesPerLine = this.codeArea.getBytesPerLine();
                long dataSize = this.codeArea.getDataSize();
                if ((keyEvent.getModifiersEx() & 0x80) > 0) {
                    CodeArea.ScrollPosition scrollPosition = this.codeArea.getScrollPosition();
                    if (scrollPosition.getScrollLinePosition() < dataSize / (long)this.codeArea.getBytesPerLine()) {
                        scrollPosition.setScrollLinePosition(scrollPosition.getScrollLinePosition() + 1L);
                        this.codeArea.updateScrollBars();
                        this.codeArea.notifyScrolled();
                    }
                } else {
                    if (caretPosition.getDataPosition() < dataSize) {
                        if (caretPosition.getDataPosition() + (long)bytesPerLine < dataSize || caretPosition.getDataPosition() + (long)bytesPerLine == dataSize && caretPosition.getCodeOffset() == 0) {
                            this.codeArea.setCaretPosition(caretPosition.getDataPosition() + (long)bytesPerLine, caretPosition.getCodeOffset());
                            this.codeArea.notifyCaretMoved();
                        }
                        this.codeArea.updateSelection(keyEvent.getModifiersEx(), caretPosition);
                    }
                    this.sequenceBreak();
                    this.codeArea.revealCursor();
                }
                keyEvent.consume();
                break;
            }
            case 36: {
                CaretPosition caretPosition = this.codeArea.getCaretPosition();
                int bytesPerLine = this.codeArea.getBytesPerLine();
                CodeArea.ScrollPosition scrollPosition = this.codeArea.getScrollPosition();
                if (caretPosition.getDataPosition() > 0L || caretPosition.getCodeOffset() != 0) {
                    long targetPosition;
                    if ((keyEvent.getModifiersEx() & 0x80) > 0) {
                        targetPosition = 0L;
                    } else {
                        targetPosition = (caretPosition.getDataPosition() + (long)scrollPosition.getLineByteShift()) / (long)bytesPerLine * (long)bytesPerLine - (long)scrollPosition.getLineByteShift();
                        if (targetPosition < 0L) {
                            targetPosition = 0L;
                        }
                    }
                    this.codeArea.setCaretPosition(targetPosition);
                    this.sequenceBreak();
                    this.codeArea.notifyCaretMoved();
                    this.codeArea.updateSelection(keyEvent.getModifiersEx(), caretPosition);
                }
                this.codeArea.revealCursor();
                keyEvent.consume();
                break;
            }
            case 35: {
                CaretPosition caretPosition = this.codeArea.getCaretPosition();
                int bytesPerLine = this.codeArea.getBytesPerLine();
                CodeArea.ScrollPosition scrollPosition = this.codeArea.getScrollPosition();
                long dataSize = this.codeArea.getDataSize();
                if (caretPosition.getDataPosition() < dataSize) {
                    if ((keyEvent.getModifiersEx() & 0x80) > 0) {
                        this.codeArea.setCaretPosition(this.codeArea.getDataSize());
                    } else if (this.codeArea.getActiveSection() == Section.CODE_MATRIX) {
                        long newPosition = ((caretPosition.getDataPosition() + (long)scrollPosition.getLineByteShift()) / (long)bytesPerLine + 1L) * (long)bytesPerLine - 1L - (long)scrollPosition.getLineByteShift();
                        this.codeArea.setCaretPosition(newPosition < dataSize ? newPosition : dataSize, newPosition < dataSize ? this.codeArea.getCodeType().getMaxDigits() - 1 : 0);
                    } else {
                        long newPosition = ((caretPosition.getDataPosition() + (long)scrollPosition.getLineByteShift()) / (long)bytesPerLine + 1L) * (long)bytesPerLine - 1L - (long)scrollPosition.getLineByteShift();
                        this.codeArea.setCaretPosition(newPosition < dataSize ? newPosition : dataSize);
                    }
                    this.sequenceBreak();
                    this.codeArea.updateSelection(keyEvent.getModifiersEx(), caretPosition);
                }
                this.codeArea.revealCursor();
                keyEvent.consume();
                break;
            }
            case 33: {
                CaretPosition caretPosition = this.codeArea.getCaretPosition();
                int bytesStep = this.codeArea.getBytesPerLine() * this.codeArea.getLinesPerRect();
                CodeArea.ScrollPosition scrollPosition = this.codeArea.getScrollPosition();
                if (scrollPosition.getScrollLinePosition() > (long)this.codeArea.getLinesPerRect()) {
                    scrollPosition.setScrollLinePosition(scrollPosition.getScrollLinePosition() - (long)this.codeArea.getLinesPerRect());
                    this.codeArea.updateScrollBars();
                    this.codeArea.notifyScrolled();
                }
                if (caretPosition.getDataPosition() > 0L) {
                    if (caretPosition.getDataPosition() >= (long)bytesStep) {
                        this.codeArea.setCaretPosition(caretPosition.getDataPosition() - (long)bytesStep, caretPosition.getCodeOffset());
                    } else if (caretPosition.getDataPosition() >= (long)this.codeArea.getBytesPerLine()) {
                        this.codeArea.setCaretPosition(caretPosition.getDataPosition() % (long)this.codeArea.getBytesPerLine(), caretPosition.getCodeOffset());
                    }
                    this.sequenceBreak();
                    this.codeArea.updateSelection(keyEvent.getModifiersEx(), caretPosition);
                }
                this.codeArea.revealCursor();
                keyEvent.consume();
                break;
            }
            case 34: {
                CaretPosition caretPosition = this.codeArea.getCaretPosition();
                int bytesStep = this.codeArea.getBytesPerLine() * this.codeArea.getLinesPerRect();
                long dataSize = this.codeArea.getDataSize();
                CodeArea.ScrollPosition scrollPosition = this.codeArea.getScrollPosition();
                if (scrollPosition.getScrollLinePosition() < dataSize / (long)this.codeArea.getBytesPerLine() - (long)(this.codeArea.getLinesPerRect() * 2)) {
                    scrollPosition.setScrollLinePosition(scrollPosition.getScrollLinePosition() + (long)this.codeArea.getLinesPerRect());
                    this.codeArea.updateScrollBars();
                    this.codeArea.notifyScrolled();
                }
                if (caretPosition.getDataPosition() < dataSize) {
                    if (caretPosition.getDataPosition() + (long)bytesStep < dataSize) {
                        this.codeArea.setCaretPosition(caretPosition.getDataPosition() + (long)bytesStep, caretPosition.getCodeOffset());
                    } else if (caretPosition.getDataPosition() + (long)this.codeArea.getBytesPerLine() <= dataSize) {
                        long dataPosition = dataSize - dataSize % (long)this.codeArea.getBytesPerLine() - (long)(caretPosition.getDataPosition() % (long)this.codeArea.getBytesPerLine() <= dataSize % (long)this.codeArea.getBytesPerLine() ? 0 : this.codeArea.getBytesPerLine()) + caretPosition.getDataPosition() % (long)this.codeArea.getBytesPerLine();
                        this.codeArea.setCaretPosition(dataPosition, dataPosition == dataSize ? 0 : caretPosition.getCodeOffset());
                    }
                    this.sequenceBreak();
                    this.codeArea.updateSelection(keyEvent.getModifiersEx(), caretPosition);
                }
                this.codeArea.revealCursor();
                keyEvent.consume();
                break;
            }
            case 155: {
                if (this.codeArea.getEditationAllowed() == EditationAllowed.ALLOWED) {
                    this.codeArea.setEditationMode(this.codeArea.getEditationMode() == EditationMode.INSERT ? EditationMode.OVERWRITE : EditationMode.INSERT);
                }
                keyEvent.consume();
                break;
            }
            case 9: {
                if (this.codeArea.getViewMode() == ViewMode.DUAL) {
                    Section activeSection;
                    Section section = activeSection = this.codeArea.getActiveSection() == Section.CODE_MATRIX ? Section.TEXT_PREVIEW : Section.CODE_MATRIX;
                    if (activeSection == Section.TEXT_PREVIEW) {
                        this.codeArea.getCaretPosition().setCodeOffset(0);
                    }
                    this.codeArea.setActiveSection(activeSection);
                    this.codeArea.revealCursor();
                    this.codeArea.repaint();
                }
                keyEvent.consume();
                break;
            }
            case 127: {
                this.deletePressed();
                keyEvent.consume();
                break;
            }
            case 8: {
                this.backSpacePressed();
                keyEvent.consume();
                break;
            }
            default: {
                if (!this.codeArea.isHandleClipboard()) break;
                if ((keyEvent.getModifiers() & this.metaMask) > 0 && keyEvent.getKeyCode() == 67) {
                    this.copy();
                    keyEvent.consume();
                    break;
                }
                if ((keyEvent.getModifiers() & this.metaMask) > 0 && keyEvent.getKeyCode() == 88) {
                    this.cut();
                    keyEvent.consume();
                    break;
                }
                if ((keyEvent.getModifiers() & this.metaMask) > 0 && keyEvent.getKeyCode() == 86) {
                    this.paste();
                    keyEvent.consume();
                    break;
                }
                if ((keyEvent.getModifiers() & this.metaMask) <= 0 || keyEvent.getKeyCode() != 65) break;
                this.codeArea.selectAll();
                keyEvent.consume();
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        char keyValue = keyEvent.getKeyChar();
        if (keyValue == '\uffff') {
            return;
        }
        if (!this.codeArea.isEditable()) {
            return;
        }
        if (this.codeArea.getActiveSection() == Section.CODE_MATRIX) {
            long dataPosition = this.codeArea.getDataPosition();
            int codeOffset = this.codeArea.getCodeOffset();
            CodeType codeType = this.codeArea.getCodeType();
            boolean validKey = false;
            switch (codeType) {
                case BINARY: {
                    validKey = keyValue >= '0' && keyValue <= '1';
                    break;
                }
                case DECIMAL: {
                    validKey = codeOffset == 0 ? keyValue >= '0' && keyValue <= '2' : keyValue >= '0' && keyValue <= '9';
                    break;
                }
                case OCTAL: {
                    validKey = codeOffset == 0 ? keyValue >= '0' && keyValue <= '3' : keyValue >= '0' && keyValue <= '7';
                    break;
                }
                case HEXADECIMAL: {
                    validKey = keyValue >= '0' && keyValue <= '9' || keyValue >= 'a' && keyValue <= 'f' || keyValue >= 'A' && keyValue <= 'F';
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected code type " + codeType.name());
                }
            }
            if (validKey) {
                if (this.codeArea.hasSelection()) {
                    this.deleteSelection();
                }
                int value = keyValue >= '0' && keyValue <= '9' ? keyValue - 48 : Character.toLowerCase(keyValue) - 97 + 10;
                BinaryData data = this.codeArea.getData();
                if (this.codeArea.getEditationMode() == EditationMode.OVERWRITE) {
                    if (dataPosition == this.codeArea.getDataSize()) {
                        ((EditableBinaryData)data).insert(dataPosition, 1L);
                    }
                    this.setCodeValue(value);
                } else {
                    if (codeOffset > 0) {
                        byte byteRest = data.getByte(dataPosition);
                        switch (codeType) {
                            case BINARY: {
                                byteRest = (byte)(byteRest & 255 >> codeOffset);
                                break;
                            }
                            case DECIMAL: {
                                byteRest = (byte)(byteRest % (codeOffset == 1 ? 100 : 10));
                                break;
                            }
                            case OCTAL: {
                                byteRest = (byte)(byteRest % (codeOffset == 1 ? 64 : 8));
                                break;
                            }
                            case HEXADECIMAL: {
                                byteRest = (byte)(byteRest & 0xF);
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Unexpected code type " + codeType.name());
                            }
                        }
                        if (byteRest > 0) {
                            ((EditableBinaryData)data).insert(dataPosition + 1L, 1L);
                            ((EditableBinaryData)data).setByte(dataPosition, (byte)(data.getByte(dataPosition) - byteRest));
                            ((EditableBinaryData)data).setByte(dataPosition + 1L, byteRest);
                        }
                    } else {
                        ((EditableBinaryData)data).insert(dataPosition, 1L);
                    }
                    this.setCodeValue(value);
                }
                this.codeArea.notifyDataChanged();
                this.codeArea.moveRight(0);
                this.codeArea.revealCursor();
            }
        } else {
            char keyChar = keyValue;
            if (keyChar > '\u001f' && this.codeArea.isValidChar(keyValue)) {
                BinaryData data = this.codeArea.getData();
                CaretPosition caretPosition = this.codeArea.getCaretPosition();
                long dataPosition = caretPosition.getDataPosition();
                byte[] bytes = this.codeArea.charToBytes(keyChar);
                if (this.codeArea.getEditationMode() == EditationMode.OVERWRITE && dataPosition < this.codeArea.getDataSize()) {
                    int length = bytes.length;
                    if (dataPosition + (long)length > this.codeArea.getDataSize()) {
                        length = (int)(this.codeArea.getDataSize() - dataPosition);
                    }
                    ((EditableBinaryData)data).remove(dataPosition, (long)length);
                }
                ((EditableBinaryData)data).insert(dataPosition, bytes);
                this.codeArea.notifyDataChanged();
                this.codeArea.getCaret().setCaretPosition(dataPosition + (long)bytes.length - 1L);
                this.codeArea.moveRight(0);
                this.codeArea.revealCursor();
            }
        }
    }

    private void setCodeValue(int value) {
        long dataPosition = this.codeArea.getDataPosition();
        int codeOffset = this.codeArea.getCodeOffset();
        this.setCodeValue(dataPosition, value, codeOffset);
    }

    private void setCodeValue(long dataPosition, int value, int codeOffset) {
        CodeType codeType = this.codeArea.getCodeType();
        BinaryData data = this.codeArea.getData();
        byte byteValue = data.getByte(dataPosition);
        switch (codeType) {
            case BINARY: {
                int bitMask = 128 >> codeOffset;
                byteValue = (byte)(byteValue & 255 - bitMask | value << 7 - codeOffset);
                break;
            }
            case DECIMAL: {
                int newValue = byteValue & 0xFF;
                switch (codeOffset) {
                    case 0: {
                        newValue = newValue % 100 + value * 100;
                        if (newValue <= 255) break;
                        newValue = 200;
                        break;
                    }
                    case 1: {
                        newValue = newValue / 100 * 100 + value * 10 + newValue % 10;
                        if (newValue <= 255) break;
                        newValue -= 200;
                        break;
                    }
                    case 2: {
                        newValue = newValue / 10 * 10 + value;
                        if (newValue <= 255) break;
                        newValue -= 200;
                    }
                }
                byteValue = (byte)newValue;
                break;
            }
            case OCTAL: {
                int newValue = byteValue & 0xFF;
                switch (codeOffset) {
                    case 0: {
                        newValue = newValue % 64 + value * 64;
                        break;
                    }
                    case 1: {
                        newValue = newValue / 64 * 64 + value * 8 + newValue % 8;
                        break;
                    }
                    case 2: {
                        newValue = newValue / 8 * 8 + value;
                    }
                }
                byteValue = (byte)newValue;
                break;
            }
            case HEXADECIMAL: {
                if (codeOffset == 1) {
                    byteValue = (byte)(byteValue & 0xF0 | value);
                    break;
                }
                byteValue = (byte)(byteValue & 0xF | value << 4);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected code type " + codeType.name());
            }
        }
        ((EditableBinaryData)data).setByte(dataPosition, byteValue);
    }

    @Override
    public void backSpacePressed() {
        if (!this.codeArea.isEditable()) {
            return;
        }
        if (this.codeArea.hasSelection()) {
            this.deleteSelection();
            this.codeArea.notifyDataChanged();
        } else {
            CodeAreaCaret caret = this.codeArea.getCaret();
            long dataPosition = caret.getDataPosition();
            if (dataPosition > 0L && dataPosition <= this.codeArea.getDataSize()) {
                caret.setCodeOffset(0);
                this.codeArea.moveLeft(0);
                caret.setCodeOffset(0);
                ((EditableBinaryData)this.codeArea.getData()).remove(dataPosition - 1L, 1L);
                this.codeArea.notifyDataChanged();
                this.codeArea.revealCursor();
                this.codeArea.updateScrollBars();
            }
        }
    }

    @Override
    public void deletePressed() {
        if (!this.codeArea.isEditable()) {
            return;
        }
        if (this.codeArea.hasSelection()) {
            this.deleteSelection();
            this.codeArea.notifyDataChanged();
            this.codeArea.updateScrollBars();
            this.codeArea.notifyCaretMoved();
            this.codeArea.revealCursor();
        } else {
            CodeAreaCaret caret = this.codeArea.getCaret();
            long dataPosition = caret.getDataPosition();
            if (dataPosition < this.codeArea.getDataSize()) {
                ((EditableBinaryData)this.codeArea.getData()).remove(dataPosition, 1L);
                this.codeArea.notifyDataChanged();
                if (caret.getCodeOffset() > 0) {
                    caret.setCodeOffset(0);
                }
                this.codeArea.updateScrollBars();
                this.codeArea.notifyCaretMoved();
                this.codeArea.revealCursor();
            }
        }
    }

    private void deleteSelection() {
        SelectionRange selection = this.codeArea.getSelection();
        long first = selection.getFirst();
        long last = selection.getLast();
        ((EditableBinaryData)this.codeArea.getData()).remove(first, last - first + 1L);
        this.codeArea.clearSelection();
        CodeAreaCaret caret = this.codeArea.getCaret();
        caret.setCaretPosition(first);
        this.codeArea.revealCursor();
        this.codeArea.updateScrollBars();
    }

    @Override
    public void delete() {
        if (!this.codeArea.isEditable()) {
            return;
        }
        this.deleteSelection();
        this.codeArea.notifyDataChanged();
    }

    @Override
    public void copy() {
        SelectionRange selection = this.codeArea.getSelection();
        if (selection != null) {
            long first = selection.getFirst();
            long last = selection.getLast();
            BinaryData copy = ((EditableBinaryData)this.codeArea.getData()).copy(first, last - first + 1L);
            BinaryDataClipboardData binaryData = new BinaryDataClipboardData(copy);
            this.setClipboardContent(binaryData);
        }
    }

    @Override
    public void copyAsCode() {
        SelectionRange selection = this.codeArea.getSelection();
        if (selection != null) {
            long first = selection.getFirst();
            long last = selection.getLast();
            BinaryData copy = ((EditableBinaryData)this.codeArea.getData()).copy(first, last - first + 1L);
            CodeDataClipboardData binaryData = new CodeDataClipboardData(copy);
            this.setClipboardContent(binaryData);
        }
    }

    private void setClipboardContent(ClipboardData content) {
        this.clearClipboardData();
        try {
            this.currentClipboardData = content;
            this.clipboard.setContents(content, content);
        }
        catch (IllegalStateException ex) {
            this.clearClipboardData();
        }
    }

    private void clearClipboardData() {
        if (this.currentClipboardData != null) {
            this.currentClipboardData.dispose();
            this.currentClipboardData = null;
        }
    }

    @Override
    public void cut() {
        if (!this.codeArea.isEditable()) {
            return;
        }
        SelectionRange selection = this.codeArea.getSelection();
        if (selection != null) {
            this.copy();
            this.deleteSelection();
            this.codeArea.notifyDataChanged();
        }
    }

    @Override
    public void paste() {
        block16: {
            if (!this.codeArea.isEditable()) {
                return;
            }
            try {
                if (this.clipboard.isDataFlavorAvailable(this.binaryDataFlavor)) {
                    if (this.codeArea.hasSelection()) {
                        this.deleteSelection();
                        this.codeArea.notifyDataChanged();
                    }
                    try {
                        Object object = this.clipboard.getData(this.binaryDataFlavor);
                        if (object instanceof BinaryData) {
                            CodeAreaCaret caret = this.codeArea.getCaret();
                            long dataPosition = caret.getDataPosition();
                            BinaryData data = (BinaryData)object;
                            long dataSize = data.getDataSize();
                            if (this.codeArea.getEditationMode() == EditationMode.OVERWRITE) {
                                long toRemove = dataSize;
                                if (dataPosition + toRemove > this.codeArea.getDataSize()) {
                                    toRemove = this.codeArea.getDataSize() - dataPosition;
                                }
                                ((EditableBinaryData)this.codeArea.getData()).remove(dataPosition, toRemove);
                            }
                            ((EditableBinaryData)this.codeArea.getData()).insert(this.codeArea.getDataPosition(), data);
                            this.codeArea.notifyDataChanged();
                            caret.setCaretPosition(caret.getDataPosition() + dataSize);
                            caret.setCodeOffset(0);
                            this.codeArea.updateScrollBars();
                            this.codeArea.notifyCaretMoved();
                            this.codeArea.revealCursor();
                        }
                        break block16;
                    }
                    catch (UnsupportedFlavorException | IOException ex) {
                        Logger.getLogger(DefaultCodeAreaCommandHandler.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    break block16;
                }
                if (!this.clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor)) break block16;
                if (this.codeArea.hasSelection()) {
                    this.deleteSelection();
                    this.codeArea.notifyDataChanged();
                }
                try {
                    Object insertedData = this.clipboard.getData(DataFlavor.stringFlavor);
                    if (insertedData instanceof String) {
                        CodeAreaCaret caret = this.codeArea.getCaret();
                        long dataPosition = caret.getDataPosition();
                        byte[] bytes = ((String)insertedData).getBytes(Charset.forName("UTF-8"));
                        int length = bytes.length;
                        if (this.codeArea.getEditationMode() == EditationMode.OVERWRITE) {
                            long toRemove = length;
                            if (dataPosition + toRemove > this.codeArea.getDataSize()) {
                                toRemove = this.codeArea.getDataSize() - dataPosition;
                            }
                            ((EditableBinaryData)this.codeArea.getData()).remove(dataPosition, toRemove);
                        }
                        ((EditableBinaryData)this.codeArea.getData()).insert(this.codeArea.getDataPosition(), bytes);
                        this.codeArea.notifyDataChanged();
                        caret.setCaretPosition(caret.getDataPosition() + (long)length);
                        caret.setCodeOffset(0);
                        this.codeArea.updateScrollBars();
                        this.codeArea.notifyCaretMoved();
                        this.codeArea.revealCursor();
                    }
                }
                catch (UnsupportedFlavorException | IOException ex) {
                    Logger.getLogger(DefaultCodeAreaCommandHandler.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    @Override
    public void pasteFromCode() {
        block24: {
            if (!this.codeArea.isEditable()) {
                return;
            }
            try {
                if (!this.clipboard.isDataFlavorAvailable(this.binaryDataFlavor) && !this.clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor)) {
                    return;
                }
            }
            catch (IllegalStateException ex) {
                return;
            }
            try {
                if (this.clipboard.isDataFlavorAvailable(this.binaryDataFlavor)) {
                    this.paste();
                    break block24;
                }
                if (!this.clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor)) break block24;
                if (this.codeArea.hasSelection()) {
                    this.deleteSelection();
                    this.codeArea.notifyDataChanged();
                }
                try {
                    Object insertedData = this.clipboard.getData(DataFlavor.stringFlavor);
                    if (insertedData instanceof String) {
                        CodeAreaCaret caret = this.codeArea.getCaret();
                        long dataPosition = caret.getDataPosition();
                        CodeType codeType = this.codeArea.getCodeType();
                        int maxDigits = codeType.getMaxDigits();
                        String insertedString = (String)insertedData;
                        ByteArrayEditableData data = new ByteArrayEditableData();
                        byte[] buffer = new byte[16];
                        int bufferUsage = 0;
                        int offset = 0;
                        for (int i = 0; i < insertedString.length(); ++i) {
                            byte value;
                            char charAt = insertedString.charAt(i);
                            if ((charAt == ' ' || charAt == '\t') && offset == i) {
                                ++offset;
                                continue;
                            }
                            if (charAt == ' ' || charAt == '\t' || charAt == ',' || charAt == ';' || charAt == ':') {
                                value = CodeAreaUtils.stringCodeToByte((String)insertedString.substring(offset, i), (CodeType)codeType);
                                if (bufferUsage < 16) {
                                    buffer[bufferUsage] = value;
                                    ++bufferUsage;
                                } else {
                                    data.insert(data.getDataSize(), buffer, 0, bufferUsage);
                                    bufferUsage = 0;
                                }
                                offset = i + 1;
                                continue;
                            }
                            if (i != offset + maxDigits) continue;
                            value = CodeAreaUtils.stringCodeToByte((String)insertedString.substring(offset, i), (CodeType)codeType);
                            if (bufferUsage < 16) {
                                buffer[bufferUsage] = value;
                                ++bufferUsage;
                            } else {
                                data.insert(data.getDataSize(), buffer, 0, bufferUsage);
                                bufferUsage = 0;
                            }
                            offset = i;
                        }
                        if (offset < insertedString.length()) {
                            byte value = CodeAreaUtils.stringCodeToByte((String)insertedString.substring(offset), (CodeType)codeType);
                            if (bufferUsage < 16) {
                                buffer[bufferUsage] = value;
                                ++bufferUsage;
                            } else {
                                data.insert(data.getDataSize(), buffer, 0, bufferUsage);
                                bufferUsage = 0;
                            }
                        }
                        if (bufferUsage > 0) {
                            data.insert(data.getDataSize(), buffer, 0, bufferUsage);
                        }
                        long length = data.getDataSize();
                        if (this.codeArea.getEditationMode() == EditationMode.OVERWRITE) {
                            long toRemove = length;
                            if (dataPosition + toRemove > this.codeArea.getDataSize()) {
                                toRemove = this.codeArea.getDataSize() - dataPosition;
                            }
                            ((EditableBinaryData)this.codeArea.getData()).remove(dataPosition, toRemove);
                        }
                        ((EditableBinaryData)this.codeArea.getData()).insert(this.codeArea.getDataPosition(), (BinaryData)data);
                        this.codeArea.notifyDataChanged();
                        caret.setCaretPosition(caret.getDataPosition() + length);
                        caret.setCodeOffset(0);
                        this.codeArea.updateScrollBars();
                        this.codeArea.notifyCaretMoved();
                        this.codeArea.revealCursor();
                    }
                }
                catch (UnsupportedFlavorException | IOException ex) {
                    Logger.getLogger(DefaultCodeAreaCommandHandler.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean canPaste() {
        return this.canPaste;
    }

    public static interface ClipboardData
    extends Transferable,
    ClipboardOwner {
        public void dispose();
    }

    public class CodeDataClipboardData
    implements ClipboardData {
        private final BinaryData data;

        public CodeDataClipboardData(BinaryData data) {
            this.data = data;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DefaultCodeAreaCommandHandler.this.binaryDataFlavor, DataFlavor.stringFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor.equals(DefaultCodeAreaCommandHandler.this.binaryDataFlavor) || flavor.equals(DataFlavor.stringFlavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (flavor.equals(DefaultCodeAreaCommandHandler.this.binaryDataFlavor)) {
                return this.data;
            }
            int charsPerByte = DefaultCodeAreaCommandHandler.this.codeArea.getCodeType().getMaxDigits() + 1;
            int textLength = (int)(this.data.getDataSize() * (long)charsPerByte);
            if (textLength > 0) {
                --textLength;
            }
            char[] targetData = new char[textLength];
            Arrays.fill(targetData, ' ');
            int i = 0;
            while ((long)i < this.data.getDataSize()) {
                CodeAreaUtils.byteToCharsCode((byte)this.data.getByte((long)i), (CodeType)DefaultCodeAreaCommandHandler.this.codeArea.getCodeType(), (char[])targetData, (int)(i * charsPerByte), (HexCharactersCase)DefaultCodeAreaCommandHandler.this.codeArea.getHexCharactersCase());
                ++i;
            }
            return new String(targetData);
        }

        @Override
        public void lostOwnership(Clipboard clipboard, Transferable contents) {
        }

        @Override
        public void dispose() {
            this.data.dispose();
        }
    }

    public class BinaryDataClipboardData
    implements ClipboardData {
        private final BinaryData data;

        public BinaryDataClipboardData(BinaryData data) {
            this.data = data;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DefaultCodeAreaCommandHandler.this.binaryDataFlavor, DataFlavor.stringFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor.equals(DefaultCodeAreaCommandHandler.this.binaryDataFlavor) || flavor.equals(DataFlavor.stringFlavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (flavor.equals(DefaultCodeAreaCommandHandler.this.binaryDataFlavor)) {
                return this.data;
            }
            ByteArrayOutputStream byteArrayStream = new ByteArrayOutputStream();
            this.data.saveToStream((OutputStream)byteArrayStream);
            return byteArrayStream.toString("UTF-8");
        }

        @Override
        public void lostOwnership(Clipboard clipboard, Transferable contents) {
        }

        @Override
        public void dispose() {
            this.data.dispose();
        }
    }
}

