/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.deltahex.swing;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.exbin.deltahex.CodeAreaUtils;
import org.exbin.deltahex.CodeType;
import org.exbin.deltahex.EditationMode;
import org.exbin.deltahex.HexCharactersCase;
import org.exbin.deltahex.Section;
import org.exbin.deltahex.SelectionRange;
import org.exbin.deltahex.ViewMode;
import org.exbin.deltahex.swing.CodeArea;
import org.exbin.deltahex.swing.CodeAreaCaret;
import org.exbin.deltahex.swing.CodeAreaPainter;
import org.exbin.deltahex.swing.ColorsGroup;

public class DefaultCodeAreaPainter
implements CodeAreaPainter {
    public static final int MIN_MONOSPACE_CODE_POINT = 25;
    public static final int MAX_MONOSPACE_CODE_POINT = 451;
    public static final int INV_SPACE_CODE_POINT = 127;
    public static final int EXCEPTION1_CODE_POINT = 142;
    public static final int EXCEPTION2_CODE_POINT = 158;
    protected final CodeArea codeArea;
    private Charset charMappingCharset = null;
    protected final char[] charMapping = new char[256];
    protected Map<Character, Character> unprintableCharactersMapping = null;

    public DefaultCodeAreaPainter(CodeArea codeArea) {
        this.codeArea = codeArea;
    }

    @Override
    public void paintOverall(Graphics g) {
        int decorationMode;
        Rectangle compRect = this.codeArea.getComponentRectangle();
        Rectangle codeRect = this.codeArea.getCodeSectionRectangle();
        if (compRect.y < codeRect.y) {
            g.setColor(this.codeArea.getBackground());
            g.fillRect(compRect.x, compRect.y, compRect.x + compRect.width, codeRect.y - compRect.y);
        }
        if (((decorationMode = this.codeArea.getDecorationMode()) & 2) > 0) {
            g.setColor(this.codeArea.getDecorationLineColor());
            int lineX = codeRect.x - 1 - this.codeArea.getLineNumberSpace() / 2;
            g.drawLine(lineX, compRect.y, lineX, codeRect.y);
        }
        if ((decorationMode & 1) > 0) {
            g.setColor(this.codeArea.getDecorationLineColor());
            g.drawLine(compRect.x, codeRect.y - 1, compRect.x + compRect.width, codeRect.y - 1);
        }
        if ((decorationMode & 8) > 0) {
            g.setColor(this.codeArea.getDecorationLineColor());
            g.drawLine(codeRect.x - 1, codeRect.y - 1, codeRect.x + codeRect.width, codeRect.y - 1);
        }
    }

    @Override
    public void paintHeader(Graphics g) {
        int lineX;
        int decorationMode;
        CodeArea.ScrollPosition scrollPosition = this.codeArea.getScrollPosition();
        Rectangle compRect = this.codeArea.getComponentRectangle();
        Rectangle codeRect = this.codeArea.getCodeSectionRectangle();
        boolean monospaceFont = this.codeArea.isMonospaceFontDetected();
        FontMetrics fontMetrics = this.codeArea.getFontMetrics();
        int codeDigits = this.codeArea.getCodeType().getMaxDigits();
        if (this.codeArea.getViewMode() != ViewMode.TEXT_PREVIEW) {
            int visibleCharEnd;
            int charWidth = this.codeArea.getCharWidth();
            int bytesPerLine = this.codeArea.getBytesPerLine();
            int charsPerLine = this.codeArea.computeByteCharPos(bytesPerLine, false);
            int headerX = codeRect.x - scrollPosition.getScrollCharPosition() * charWidth - scrollPosition.getScrollCharOffset();
            int headerY = this.codeArea.getInsets().top + this.codeArea.getLineHeight() - this.codeArea.getSubFontSpace();
            int visibleCharStart = (scrollPosition.getScrollCharPosition() * charWidth + scrollPosition.getScrollCharOffset()) / charWidth;
            if (visibleCharStart < 0) {
                visibleCharStart = 0;
            }
            if ((visibleCharEnd = (codeRect.width + (scrollPosition.getScrollCharPosition() + charsPerLine) * charWidth + scrollPosition.getScrollCharOffset()) / charWidth) > charsPerLine) {
                visibleCharEnd = charsPerLine;
            }
            int visibleStart = this.codeArea.computeByteOffsetPerCodeCharOffset(visibleCharStart, false);
            int visibleEnd = this.codeArea.computeByteOffsetPerCodeCharOffset(visibleCharEnd - 1, false) + 1;
            if (this.codeArea.getBackgroundMode() == CodeArea.BackgroundMode.GRIDDED) {
                ColorsGroup stripColors = this.codeArea.getAlternateColors();
                g.setColor(stripColors.getBackgroundColor());
                int positionX = codeRect.x - scrollPosition.getScrollCharOffset() - scrollPosition.getScrollCharPosition() * charWidth;
                for (int i = visibleStart / 2; i < visibleEnd / 2; ++i) {
                    g.fillRect(positionX + charWidth * this.codeArea.computeByteCharPos(i * 2 + 1), compRect.y, charWidth * codeDigits, codeRect.y - compRect.y);
                }
            }
            g.setColor(this.codeArea.getForeground());
            char[] headerChars = new char[charsPerLine];
            Arrays.fill(headerChars, ' ');
            CodeArea.CharRenderingMode charRenderingMode = this.codeArea.getCharRenderingMode();
            boolean upperCase = this.codeArea.getHexCharactersCase() == HexCharactersCase.UPPER;
            boolean interleaving = false;
            int lastPos = 0;
            for (int index = visibleStart; index < visibleEnd; ++index) {
                int codePos = this.codeArea.computeByteCharPos(index);
                if (codePos == lastPos + 2 && !interleaving) {
                    interleaving = true;
                    continue;
                }
                CodeAreaUtils.longToBaseCode((char[])headerChars, (int)codePos, (long)index, (int)this.codeArea.getPositionCodeType().getBase(), (int)2, (boolean)true, (boolean)upperCase);
                lastPos = codePos;
                interleaving = false;
            }
            int renderOffset = visibleCharStart;
            ColorsGroup.ColorType renderColorType = null;
            Color renderColor = null;
            for (int charOnLine = visibleCharStart; charOnLine < visibleCharEnd; ++charOnLine) {
                int byteOnLine = this.codeArea.computeByteOffsetPerCodeCharOffset(charOnLine, false);
                boolean sequenceBreak = false;
                boolean nativeWidth = true;
                int currentCharWidth = 0;
                ColorsGroup.ColorType colorType = ColorsGroup.ColorType.TEXT;
                if (charRenderingMode != CodeArea.CharRenderingMode.LINE_AT_ONCE) {
                    char currentChar = ' ';
                    if (colorType == ColorsGroup.ColorType.TEXT) {
                        currentChar = headerChars[charOnLine];
                    }
                    if (currentChar == ' ' && renderOffset == charOnLine) {
                        ++renderOffset;
                        continue;
                    }
                    if (charRenderingMode == CodeArea.CharRenderingMode.AUTO && monospaceFont && currentChar > '\u0019' && currentChar < '\u01c3' && currentChar != '\u007f' && currentChar != '\u008e' && currentChar != '\u009e') {
                        currentCharWidth = charWidth;
                    }
                    if (currentCharWidth == 0) {
                        currentCharWidth = fontMetrics.charWidth(currentChar);
                        nativeWidth = currentCharWidth == charWidth;
                    }
                } else {
                    currentCharWidth = charWidth;
                }
                Color color = this.getHeaderPositionColor(byteOnLine, charOnLine);
                if (renderColorType == null) {
                    renderColorType = colorType;
                    renderColor = color;
                    g.setColor(color);
                }
                if (!(nativeWidth && this.areSameColors(color, renderColor) && colorType.equals((Object)renderColorType))) {
                    sequenceBreak = true;
                }
                if (!sequenceBreak) continue;
                if (renderOffset < charOnLine) {
                    g.drawChars(headerChars, renderOffset, charOnLine - renderOffset, headerX + renderOffset * charWidth, headerY);
                }
                if (!colorType.equals((Object)renderColorType)) {
                    renderColorType = colorType;
                }
                if (!this.areSameColors(color, renderColor)) {
                    renderColor = color;
                    g.setColor(color);
                }
                if (!nativeWidth) {
                    renderOffset = charOnLine + 1;
                    if (charRenderingMode == CodeArea.CharRenderingMode.TOP_LEFT) {
                        g.drawChars(headerChars, charOnLine, 1, headerX + charOnLine * charWidth, headerY);
                        continue;
                    }
                    this.drawShiftedChar(g, headerChars, charOnLine, charWidth, headerX + charOnLine * charWidth, headerY, charWidth + 1 - currentCharWidth >> 1);
                    continue;
                }
                renderOffset = charOnLine;
            }
            if (renderOffset < charsPerLine) {
                g.drawChars(headerChars, renderOffset, charsPerLine - renderOffset, headerX + renderOffset * charWidth, headerY);
            }
        }
        if (((decorationMode = this.codeArea.getDecorationMode()) & 1) > 0) {
            g.setColor(this.codeArea.getDecorationLineColor());
            g.drawLine(compRect.x, codeRect.y - 1, compRect.x + compRect.width, codeRect.y - 1);
        }
        if ((decorationMode & 8) > 0) {
            g.setColor(this.codeArea.getDecorationLineColor());
            g.drawLine(codeRect.x - 1, codeRect.y - 1, codeRect.x + codeRect.width, codeRect.y - 1);
        }
        if ((decorationMode & 4) > 0 && (lineX = this.codeArea.getPreviewX() - scrollPosition.getScrollCharPosition() * this.codeArea.getCharWidth() - scrollPosition.getScrollCharOffset() - this.codeArea.getCharWidth() / 2) >= codeRect.x) {
            g.setColor(this.codeArea.getDecorationLineColor());
            g.drawLine(lineX, compRect.y, lineX, codeRect.y);
        }
    }

    public Color getHeaderPositionColor(int byteOnLine, int charOnLine) {
        return this.codeArea.getForeground();
    }

    @Override
    public void paintBackground(Graphics g) {
        int lineNumberWidth;
        Rectangle clipBounds = g.getClipBounds();
        Rectangle codeRect = this.codeArea.getCodeSectionRectangle();
        ColorsGroup mainColors = this.codeArea.getMainColors();
        ColorsGroup stripColors = this.codeArea.getAlternateColors();
        int bytesPerLine = this.codeArea.getBytesPerLine();
        int lineHeight = this.codeArea.getLineHeight();
        int startX = clipBounds.x;
        int width = clipBounds.width;
        if (!this.codeArea.isLineNumberBackground() && this.codeArea.isShowLineNumbers() && startX < (lineNumberWidth = codeRect.x - 1 - this.codeArea.getLineNumberSpace() / 2)) {
            int diff = lineNumberWidth - startX;
            startX = lineNumberWidth;
            width -= diff;
        }
        if (this.codeArea.getBackgroundMode() != CodeArea.BackgroundMode.NONE) {
            g.setColor(mainColors.getBackgroundColor());
            g.fillRect(startX, clipBounds.y, width, clipBounds.height);
        }
        CodeArea.ScrollPosition scrollPosition = this.codeArea.getScrollPosition();
        long line = scrollPosition.getScrollLinePosition();
        long maxDataPosition = this.codeArea.getDataSize();
        int maxY = clipBounds.y + clipBounds.height;
        long dataPosition = line * (long)bytesPerLine;
        if (this.codeArea.getBackgroundMode() == CodeArea.BackgroundMode.STRIPPED || this.codeArea.getBackgroundMode() == CodeArea.BackgroundMode.GRIDDED) {
            g.setColor(stripColors.getBackgroundColor());
            int positionY = codeRect.y - scrollPosition.getScrollLineOffset();
            if ((line & 1L) == 0L) {
                positionY += lineHeight;
                dataPosition += (long)bytesPerLine;
            }
            while (positionY <= maxY && dataPosition < maxDataPosition) {
                g.fillRect(startX, positionY, width, lineHeight);
                positionY += lineHeight * 2;
                dataPosition += (long)(bytesPerLine * 2);
            }
        }
    }

    @Override
    public void paintLineNumbers(Graphics g) {
        boolean upperCase;
        Rectangle clipBounds = g.getClipBounds();
        Rectangle compRect = this.codeArea.getComponentRectangle();
        Rectangle codeRect = this.codeArea.getCodeSectionRectangle();
        int bytesPerLine = this.codeArea.getBytesPerLine();
        int lineHeight = this.codeArea.getLineHeight();
        CodeArea.ScrollPosition scrollPosition = this.codeArea.getScrollPosition();
        long line = scrollPosition.getScrollLinePosition();
        long maxDataPosition = this.codeArea.getDataSize();
        int maxY = clipBounds.y + clipBounds.height + lineHeight;
        long dataPosition = line * (long)bytesPerLine - (long)scrollPosition.getLineByteShift();
        int charWidth = this.codeArea.getCharWidth();
        g.setColor(this.codeArea.getForeground());
        int lineNumberLength = this.codeArea.getLineNumberLength();
        char[] lineNumberCode = new char[lineNumberLength];
        boolean bl = upperCase = this.codeArea.getHexCharactersCase() == HexCharactersCase.UPPER;
        for (int positionY = codeRect.y - this.codeArea.getSubFontSpace() - scrollPosition.getScrollLineOffset() + this.codeArea.getLineHeight(); positionY <= maxY && dataPosition <= maxDataPosition; positionY += lineHeight, dataPosition += (long)bytesPerLine) {
            CodeAreaUtils.longToBaseCode((char[])lineNumberCode, (int)0, (long)(dataPosition < 0L ? 0L : dataPosition), (int)this.codeArea.getPositionCodeType().getBase(), (int)lineNumberLength, (boolean)true, (boolean)upperCase);
            if (this.codeArea.getCharRenderingMode() == CodeArea.CharRenderingMode.LINE_AT_ONCE) {
                g.drawChars(lineNumberCode, 0, lineNumberLength, compRect.x, positionY);
                continue;
            }
            for (int i = 0; i < lineNumberLength; ++i) {
                this.drawCenteredChar(g, lineNumberCode, i, charWidth, compRect.x + charWidth * i, positionY);
            }
        }
        int decorationMode = this.codeArea.getDecorationMode();
        if ((decorationMode & 2) > 0) {
            g.setColor(this.codeArea.getDecorationLineColor());
            int lineX = codeRect.x - 1 - this.codeArea.getLineNumberSpace() / 2;
            g.drawLine(lineX, compRect.y, lineX, codeRect.y + codeRect.height);
        }
        if ((decorationMode & 8) > 0) {
            g.setColor(this.codeArea.getDecorationLineColor());
            g.drawLine(codeRect.x - 1, codeRect.y - 1, codeRect.x - 1, codeRect.y + codeRect.height);
        }
    }

    @Override
    public void paintMainArea(Graphics g) {
        PaintData paintData = new PaintData(this.codeArea);
        this.paintMainArea(g, paintData);
    }

    public void paintMainArea(Graphics g, PaintData paintData) {
        int lineX;
        if (paintData.viewMode != ViewMode.TEXT_PREVIEW && this.codeArea.getBackgroundMode() == CodeArea.BackgroundMode.GRIDDED) {
            g.setColor(paintData.alternateColors.getBackgroundColor());
            int positionX = paintData.codeSectionRect.x - paintData.scrollPosition.getScrollCharOffset() - paintData.scrollPosition.getScrollCharPosition() * paintData.charWidth;
            for (int i = paintData.visibleCodeStart / 2; i < paintData.visibleCodeEnd / 2; ++i) {
                g.fillRect(positionX + paintData.charWidth * this.codeArea.computeByteCharPos(i * 2 + 1), paintData.codeSectionRect.y, paintData.charWidth * paintData.codeDigits, paintData.codeSectionRect.height);
            }
        }
        int positionY = paintData.codeSectionRect.y - paintData.scrollPosition.getScrollLineOffset();
        paintData.line = paintData.scrollPosition.getScrollLinePosition();
        int positionX = paintData.codeSectionRect.x - paintData.scrollPosition.getScrollCharPosition() * paintData.charWidth - paintData.scrollPosition.getScrollCharOffset();
        paintData.lineDataPosition = paintData.line * (long)paintData.bytesPerLine - (long)paintData.scrollPosition.getLineByteShift();
        long dataSize = this.codeArea.getDataSize();
        do {
            byte dataByte;
            int byteOnLine;
            if (paintData.showUnprintableCharacters) {
                Arrays.fill(paintData.unprintableChars, ' ');
            }
            int lineBytesLimit = paintData.bytesPerLine;
            if (paintData.lineDataPosition < dataSize) {
                int lineDataSize = paintData.bytesPerLine + paintData.maxCharLength - 1;
                if (paintData.lineDataPosition + (long)lineDataSize > dataSize) {
                    lineDataSize = (int)(dataSize - paintData.lineDataPosition);
                }
                paintData.lineStart = paintData.lineDataPosition < 0L ? (int)(-paintData.lineDataPosition) : 0;
                this.codeArea.getData().copyToArray(paintData.lineDataPosition + (long)paintData.lineStart, paintData.lineData, paintData.lineStart, lineDataSize - paintData.lineStart);
                if (paintData.lineDataPosition + (long)lineBytesLimit > dataSize) {
                    lineBytesLimit = (int)(dataSize - paintData.lineDataPosition);
                }
            } else {
                lineBytesLimit = 0;
            }
            if (paintData.viewMode != ViewMode.TEXT_PREVIEW) {
                for (byteOnLine = Math.max(paintData.visibleCodeStart, paintData.lineStart); byteOnLine < Math.min(paintData.visibleCodeEnd, lineBytesLimit); ++byteOnLine) {
                    dataByte = paintData.lineData[byteOnLine];
                    CodeAreaUtils.byteToCharsCode((byte)dataByte, (CodeType)this.codeArea.getCodeType(), (char[])paintData.lineChars, (int)this.codeArea.computeByteCharPos(byteOnLine), (HexCharactersCase)this.codeArea.getHexCharactersCase());
                }
                if (paintData.bytesPerLine > lineBytesLimit) {
                    Arrays.fill(paintData.lineChars, this.codeArea.computeByteCharPos(lineBytesLimit), paintData.lineChars.length, ' ');
                }
            }
            if (paintData.viewMode != ViewMode.CODE_MATRIX) {
                for (byteOnLine = paintData.visiblePreviewStart; byteOnLine < Math.min(paintData.visiblePreviewEnd, lineBytesLimit); ++byteOnLine) {
                    Character replacement;
                    dataByte = paintData.lineData[byteOnLine];
                    if (paintData.maxCharLength > 1) {
                        String displayString;
                        int charDataLength;
                        if (paintData.lineDataPosition + (long)paintData.maxCharLength > dataSize) {
                            paintData.maxCharLength = (int)(dataSize - paintData.lineDataPosition);
                        }
                        if (byteOnLine + (charDataLength = paintData.maxCharLength) > paintData.lineData.length) {
                            charDataLength = paintData.lineData.length - byteOnLine;
                        }
                        if (!(displayString = new String(paintData.lineData, byteOnLine, charDataLength, paintData.charset)).isEmpty()) {
                            paintData.lineChars[paintData.previewCharPos + byteOnLine] = displayString.charAt(0);
                        }
                    } else {
                        if (this.charMappingCharset == null || this.charMappingCharset != paintData.charset) {
                            this.buildCharMapping(paintData.charset);
                        }
                        paintData.lineChars[paintData.previewCharPos + byteOnLine] = this.charMapping[dataByte & 0xFF];
                    }
                    if (!paintData.showUnprintableCharacters && paintData.charRenderingMode != CodeArea.CharRenderingMode.LINE_AT_ONCE) continue;
                    if (this.unprintableCharactersMapping == null) {
                        this.buildUnprintableCharactersMapping();
                    }
                    if ((replacement = this.unprintableCharactersMapping.get(Character.valueOf(paintData.lineChars[paintData.previewCharPos + byteOnLine]))) == null) continue;
                    if (paintData.showUnprintableCharacters) {
                        paintData.unprintableChars[paintData.previewCharPos + byteOnLine] = replacement.charValue();
                    }
                    paintData.lineChars[paintData.previewCharPos + byteOnLine] = 32;
                }
                if (paintData.bytesPerLine > lineBytesLimit) {
                    Arrays.fill(paintData.lineChars, paintData.previewCharPos + lineBytesLimit, paintData.previewCharPos + paintData.bytesPerLine, ' ');
                }
            }
            this.paintLineBackground(g, positionX, positionY, paintData);
            this.paintLineText(g, positionX, positionY, paintData);
            paintData.lineDataPosition += (long)paintData.bytesPerLine;
            ++paintData.line;
        } while ((positionY += paintData.lineHeight) - paintData.lineHeight < paintData.codeSectionRect.y + paintData.codeSectionRect.height);
        int decorationMode = this.codeArea.getDecorationMode();
        if ((decorationMode & 4) > 0 && (lineX = this.codeArea.getPreviewX() - paintData.scrollPosition.getScrollCharPosition() * this.codeArea.getCharWidth() - paintData.scrollPosition.getScrollCharOffset() - this.codeArea.getCharWidth() / 2) >= paintData.codeSectionRect.x) {
            g.setColor(this.codeArea.getDecorationLineColor());
            g.drawLine(lineX, paintData.codeSectionRect.y, lineX, paintData.codeSectionRect.y + paintData.codeSectionRect.height);
        }
    }

    public void paintLineBackground(Graphics g, int linePositionX, int linePositionY, PaintData paintData) {
        int renderOffset = paintData.visibleCharStart;
        ColorsGroup.ColorType renderColorType = null;
        Color renderColor = null;
        for (int charOnLine = paintData.visibleCharStart; charOnLine < paintData.visibleCharEnd; ++charOnLine) {
            Section section;
            int byteOnLine;
            if (charOnLine >= paintData.previewCharPos && paintData.viewMode != ViewMode.CODE_MATRIX) {
                byteOnLine = charOnLine - paintData.previewCharPos;
                section = Section.TEXT_PREVIEW;
            } else {
                byteOnLine = this.codeArea.computeByteOffsetPerCodeCharOffset(charOnLine, false);
                section = Section.CODE_MATRIX;
            }
            boolean sequenceBreak = false;
            ColorsGroup.ColorType colorType = ColorsGroup.ColorType.BACKGROUND;
            if (paintData.showUnprintableCharacters && paintData.unprintableChars[charOnLine] != ' ') {
                colorType = ColorsGroup.ColorType.UNPRINTABLES_BACKGROUND;
            }
            Color color = this.getPositionColor(byteOnLine, charOnLine, section, colorType, paintData);
            if (renderColorType == null) {
                renderColorType = colorType;
                renderColor = color;
                g.setColor(color);
            }
            if (!this.areSameColors(color, renderColor) || !colorType.equals((Object)renderColorType)) {
                sequenceBreak = true;
            }
            if (!sequenceBreak) continue;
            if (renderOffset < charOnLine && renderColor != null) {
                this.renderBackgroundSequence(g, renderOffset, charOnLine, linePositionX, linePositionY, paintData);
            }
            if (!colorType.equals((Object)renderColorType)) {
                renderColorType = colorType;
            }
            if (!this.areSameColors(color, renderColor)) {
                renderColor = color;
                g.setColor(color);
            }
            renderOffset = charOnLine;
        }
        if (renderOffset < paintData.charsPerLine && renderColor != null) {
            this.renderBackgroundSequence(g, renderOffset, paintData.charsPerLine, linePositionX, linePositionY, paintData);
        }
    }

    private boolean areSameColors(Color color, Color comparedColor) {
        return color == null && comparedColor == null || color != null && color.equals(comparedColor);
    }

    public void paintLineText(Graphics g, int linePositionX, int linePositionY, PaintData paintData) {
        int positionY = linePositionY + paintData.lineHeight - this.codeArea.getSubFontSpace();
        int renderOffset = paintData.visibleCharStart;
        ColorsGroup.ColorType renderColorType = null;
        Color renderColor = null;
        for (int charOnLine = paintData.visibleCharStart; charOnLine < paintData.visibleCharEnd; ++charOnLine) {
            Section section;
            int byteOnLine;
            if (charOnLine >= paintData.previewCharPos) {
                byteOnLine = charOnLine - paintData.previewCharPos;
                section = Section.TEXT_PREVIEW;
            } else {
                byteOnLine = this.codeArea.computeByteOffsetPerCodeCharOffset(charOnLine, false);
                section = Section.CODE_MATRIX;
            }
            boolean sequenceBreak = false;
            boolean nativeWidth = true;
            int currentCharWidth = 0;
            ColorsGroup.ColorType colorType = ColorsGroup.ColorType.TEXT;
            if (paintData.charRenderingMode != CodeArea.CharRenderingMode.LINE_AT_ONCE) {
                char currentChar = ' ';
                if (paintData.showUnprintableCharacters && (currentChar = paintData.unprintableChars[charOnLine]) != ' ') {
                    colorType = ColorsGroup.ColorType.UNPRINTABLES;
                }
                if (colorType == ColorsGroup.ColorType.TEXT) {
                    currentChar = paintData.lineChars[charOnLine];
                }
                if (currentChar == ' ' && renderOffset == charOnLine) {
                    ++renderOffset;
                    continue;
                }
                if (paintData.charRenderingMode == CodeArea.CharRenderingMode.AUTO && paintData.monospaceFont && currentChar > '\u0019' && currentChar < '\u01c3' && currentChar != '\u007f' && currentChar != '\u008e' && currentChar != '\u009e') {
                    currentCharWidth = paintData.charWidth;
                }
                if (currentCharWidth == 0) {
                    currentCharWidth = paintData.fontMetrics.charWidth(currentChar);
                    nativeWidth = currentCharWidth == paintData.charWidth;
                }
            } else {
                char currentChar;
                currentCharWidth = paintData.charWidth;
                if (paintData.showUnprintableCharacters && (currentChar = paintData.unprintableChars[charOnLine]) != ' ') {
                    colorType = ColorsGroup.ColorType.UNPRINTABLES;
                    currentCharWidth = paintData.fontMetrics.charWidth(currentChar);
                    nativeWidth = currentCharWidth == paintData.charWidth;
                }
            }
            Color color = this.getPositionColor(byteOnLine, charOnLine, section, colorType, paintData);
            if (renderColorType == null) {
                renderColorType = colorType;
                renderColor = color;
                g.setColor(color);
            }
            if (!(nativeWidth && this.areSameColors(color, renderColor) && colorType.equals((Object)renderColorType))) {
                sequenceBreak = true;
            }
            if (!sequenceBreak) continue;
            if (renderOffset < charOnLine) {
                this.renderCharSequence(g, renderOffset, charOnLine, linePositionX, positionY, renderColorType, paintData);
            }
            if (!colorType.equals((Object)renderColorType)) {
                renderColorType = colorType;
            }
            if (!this.areSameColors(color, renderColor)) {
                renderColor = color;
                g.setColor(color);
            }
            if (!nativeWidth) {
                renderOffset = charOnLine + 1;
                if (paintData.charRenderingMode == CodeArea.CharRenderingMode.TOP_LEFT) {
                    g.drawChars(renderColorType == ColorsGroup.ColorType.UNPRINTABLES ? paintData.unprintableChars : paintData.lineChars, charOnLine, 1, linePositionX + charOnLine * paintData.charWidth, positionY);
                    continue;
                }
                this.drawShiftedChar(g, renderColorType == ColorsGroup.ColorType.UNPRINTABLES ? paintData.unprintableChars : paintData.lineChars, charOnLine, paintData.charWidth, linePositionX + charOnLine * paintData.charWidth, positionY, paintData.charWidth + 1 - currentCharWidth >> 1);
                continue;
            }
            renderOffset = charOnLine;
        }
        if (renderOffset < paintData.charsPerLine) {
            this.renderCharSequence(g, renderOffset, paintData.charsPerLine, linePositionX, positionY, renderColorType, paintData);
        }
    }

    public Color getPositionColor(int byteOnLine, int charOnLine, Section section, ColorsGroup.ColorType colorType, PaintData paintData) {
        long dataPosition = paintData.lineDataPosition + (long)byteOnLine;
        SelectionRange selection = this.codeArea.getSelection();
        if (selection != null && dataPosition >= selection.getFirst() && dataPosition <= selection.getLast() && (section == Section.TEXT_PREVIEW || charOnLine < paintData.charsPerCodeArea)) {
            Section activeSection = this.codeArea.getActiveSection();
            if (activeSection == section) {
                return this.codeArea.getSelectionColors().getColor(colorType);
            }
            return this.codeArea.getMirrorSelectionColors().getColor(colorType);
        }
        if (colorType == ColorsGroup.ColorType.BACKGROUND) {
            return null;
        }
        if ((paintData.backgroundMode == CodeArea.BackgroundMode.STRIPPED || paintData.backgroundMode == CodeArea.BackgroundMode.GRIDDED) && (paintData.line & 1L) > 0L || paintData.backgroundMode == CodeArea.BackgroundMode.GRIDDED && (byteOnLine & 1) > 0 && section == Section.CODE_MATRIX) {
            return this.codeArea.getAlternateColors().getColor(colorType);
        }
        return this.codeArea.getMainColors().getColor(colorType);
    }

    private void renderCharSequence(Graphics g, int startOffset, int endOffset, int linePositionX, int positionY, ColorsGroup.ColorType colorType, PaintData paintData) {
        if (colorType == ColorsGroup.ColorType.UNPRINTABLES) {
            g.drawChars(paintData.unprintableChars, startOffset, endOffset - startOffset, linePositionX + startOffset * paintData.charWidth, positionY);
        } else {
            g.drawChars(paintData.lineChars, startOffset, endOffset - startOffset, linePositionX + startOffset * paintData.charWidth, positionY);
        }
    }

    private void renderBackgroundSequence(Graphics g, int startOffset, int endOffset, int linePositionX, int positionY, PaintData paintData) {
        g.fillRect(linePositionX + startOffset * paintData.charWidth, positionY, (endOffset - startOffset) * paintData.charWidth, paintData.lineHeight);
    }

    protected void drawCenteredChar(Graphics g, char[] drawnChars, int charOffset, int charWidthSpace, int startX, int positionY) {
        FontMetrics fontMetrics = this.codeArea.getFontMetrics();
        int charWidth = fontMetrics.charWidth(drawnChars[charOffset]);
        this.drawShiftedChar(g, drawnChars, charOffset, charWidthSpace, startX, positionY, charWidthSpace + 1 - charWidth >> 1);
    }

    protected void drawShiftedChar(Graphics g, char[] drawnChars, int charOffset, int charWidthSpace, int startX, int positionY, int shift) {
        g.drawChars(drawnChars, charOffset, 1, startX + shift, positionY);
    }

    @Override
    public void paintCursor(Graphics g) {
        if (!this.codeArea.hasFocus()) {
            return;
        }
        CodeAreaCaret caret = this.codeArea.getCaret();
        int bytesPerLine = this.codeArea.getBytesPerLine();
        int lineHeight = this.codeArea.getLineHeight();
        int charWidth = this.codeArea.getCharWidth();
        int linesPerRect = this.codeArea.getLinesPerRect();
        int codeDigits = this.codeArea.getCodeType().getMaxDigits();
        Point cursorPoint = caret.getCursorPoint(bytesPerLine, lineHeight, charWidth, linesPerRect);
        boolean cursorVisible = caret.isCursorVisible();
        CodeAreaCaret.CursorRenderingMode renderingMode = caret.getRenderingMode();
        if (cursorVisible && cursorPoint != null) {
            g.setColor(this.codeArea.getCursorColor());
            if (renderingMode == CodeAreaCaret.CursorRenderingMode.XOR) {
                g.setXORMode(Color.WHITE);
            }
            CodeAreaCaret.CursorShape cursorShape = this.codeArea.getEditationMode() == EditationMode.INSERT ? caret.getInsertCursorShape() : caret.getOverwriteCursorShape();
            int cursorThickness = 0;
            if (cursorShape.getWidth() != CodeAreaCaret.CursorShapeWidth.FULL) {
                cursorThickness = caret.getCursorThickness(cursorShape, charWidth, lineHeight);
            }
            switch (cursorShape) {
                case LINE_TOP: 
                case DOUBLE_TOP: 
                case QUARTER_TOP: 
                case HALF_TOP: {
                    this.paintCursorRect(g, cursorPoint.x, cursorPoint.y, charWidth, cursorThickness, renderingMode);
                    break;
                }
                case LINE_BOTTOM: 
                case DOUBLE_BOTTOM: 
                case QUARTER_BOTTOM: 
                case HALF_BOTTOM: {
                    this.paintCursorRect(g, cursorPoint.x, cursorPoint.y + lineHeight - cursorThickness, charWidth, cursorThickness, renderingMode);
                    break;
                }
                case LINE_LEFT: 
                case DOUBLE_LEFT: 
                case QUARTER_LEFT: 
                case HALF_LEFT: {
                    this.paintCursorRect(g, cursorPoint.x, cursorPoint.y, cursorThickness, lineHeight, renderingMode);
                    break;
                }
                case LINE_RIGHT: 
                case DOUBLE_RIGHT: 
                case QUARTER_RIGHT: 
                case HALF_RIGHT: {
                    this.paintCursorRect(g, cursorPoint.x + charWidth - cursorThickness, cursorPoint.y, cursorThickness, lineHeight, renderingMode);
                    break;
                }
                case BOX: {
                    this.paintCursorRect(g, cursorPoint.x, cursorPoint.y, charWidth, lineHeight, renderingMode);
                    break;
                }
                case FRAME: {
                    g.drawRect(cursorPoint.x, cursorPoint.y, charWidth, lineHeight - 1);
                    break;
                }
                case BOTTOM_CORNERS: 
                case CORNERS: {
                    int quarterWidth = charWidth / 4;
                    int quarterLine = lineHeight / 4;
                    if (cursorShape == CodeAreaCaret.CursorShape.CORNERS) {
                        g.drawLine(cursorPoint.x, cursorPoint.y, cursorPoint.x + quarterWidth, cursorPoint.y);
                        g.drawLine(cursorPoint.x + charWidth - quarterWidth, cursorPoint.y, cursorPoint.x + charWidth, cursorPoint.y);
                        g.drawLine(cursorPoint.x, cursorPoint.y + 1, cursorPoint.x, cursorPoint.y + quarterLine);
                        g.drawLine(cursorPoint.x + charWidth, cursorPoint.y + 1, cursorPoint.x + charWidth, cursorPoint.y + quarterLine);
                    }
                    g.drawLine(cursorPoint.x, cursorPoint.y + lineHeight - quarterLine - 1, cursorPoint.x, cursorPoint.y + lineHeight - 2);
                    g.drawLine(cursorPoint.x + charWidth, cursorPoint.y + lineHeight - quarterLine - 1, cursorPoint.x + charWidth, cursorPoint.y + lineHeight - 2);
                    g.drawLine(cursorPoint.x, cursorPoint.y + lineHeight - 1, cursorPoint.x + quarterWidth, cursorPoint.y + lineHeight - 1);
                    g.drawLine(cursorPoint.x + charWidth - quarterWidth, cursorPoint.y + lineHeight - 1, cursorPoint.x + charWidth, cursorPoint.y + lineHeight - 1);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected cursor shape type " + cursorShape.name());
                }
            }
            if (renderingMode == CodeAreaCaret.CursorRenderingMode.XOR) {
                g.setPaintMode();
            }
        }
        if (this.codeArea.getViewMode() == ViewMode.DUAL && this.codeArea.isShowShadowCursor()) {
            g.setColor(this.codeArea.getCursorColor());
            Point shadowCursorPoint = caret.getShadowCursorPoint(bytesPerLine, lineHeight, charWidth, linesPerRect);
            if (shadowCursorPoint != null) {
                Graphics2D g2d = (Graphics2D)g.create();
                BasicStroke dashed = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{2.0f}, 0.0f);
                g2d.setStroke(dashed);
                g2d.drawRect(shadowCursorPoint.x, shadowCursorPoint.y, charWidth * (this.codeArea.getActiveSection() == Section.TEXT_PREVIEW ? codeDigits : 1), lineHeight - 1);
            }
        }
    }

    private void paintCursorRect(Graphics g, int x, int y, int width, int height, CodeAreaCaret.CursorRenderingMode renderingMode) {
        switch (renderingMode) {
            case PAINT: {
                g.fillRect(x, y, width, height);
                break;
            }
            case XOR: {
                Rectangle rect = new Rectangle(x, y, width, height);
                Rectangle intersection = rect.intersection(g.getClipBounds());
                if (intersection.isEmpty()) break;
                g.fillRect(intersection.x, intersection.y, intersection.width, intersection.height);
                break;
            }
            case NEGATIVE: {
                Rectangle rect = new Rectangle(x, y, width, height);
                Rectangle intersection = rect.intersection(g.getClipBounds());
                if (intersection.isEmpty()) break;
                Shape clip = g.getClip();
                g.setClip(intersection.x, intersection.y, intersection.width, intersection.height);
                CodeArea.ScrollPosition scrollPosition = this.codeArea.getScrollPosition();
                g.fillRect(x, y, width, height);
                g.setColor(this.codeArea.getNegativeCursorColor());
                Rectangle codeRect = this.codeArea.getCodeSectionRectangle();
                int previewX = this.codeArea.getPreviewX();
                int charWidth = this.codeArea.getCharWidth();
                int lineHeight = this.codeArea.getLineHeight();
                int line = (y + scrollPosition.getScrollLineOffset() - codeRect.y) / lineHeight;
                int scrolledX = x + scrollPosition.getScrollCharPosition() * charWidth + scrollPosition.getScrollCharOffset();
                int posY = codeRect.y + (line + 1) * lineHeight - this.codeArea.getSubFontSpace() - scrollPosition.getScrollLineOffset();
                if (this.codeArea.getViewMode() != ViewMode.CODE_MATRIX && scrolledX >= previewX) {
                    int charPos = (scrolledX - previewX) / charWidth;
                    long dataSize = this.codeArea.getDataSize();
                    long dataPosition = ((long)line + scrollPosition.getScrollLinePosition()) * (long)this.codeArea.getBytesPerLine() + (long)charPos - (long)scrollPosition.getLineByteShift();
                    if (dataPosition >= dataSize) {
                        g.setClip(clip);
                        break;
                    }
                    char[] previewChars = new char[1];
                    Charset charset = this.codeArea.getCharset();
                    CharsetEncoder encoder = charset.newEncoder();
                    int maxCharLength = (int)encoder.maxBytesPerChar();
                    byte[] data = new byte[maxCharLength];
                    if (maxCharLength > 1) {
                        int charDataLength = maxCharLength;
                        if (dataPosition + (long)maxCharLength > dataSize) {
                            charDataLength = (int)(dataSize - dataPosition);
                        }
                        this.codeArea.getData().copyToArray(dataPosition, data, 0, charDataLength);
                        String displayString = new String(data, 0, charDataLength, charset);
                        if (!displayString.isEmpty()) {
                            previewChars[0] = displayString.charAt(0);
                        }
                    } else {
                        if (this.charMappingCharset == null || this.charMappingCharset != charset) {
                            this.buildCharMapping(charset);
                        }
                        previewChars[0] = this.charMapping[this.codeArea.getData().getByte(dataPosition) & 0xFF];
                    }
                    if (this.codeArea.isShowUnprintableCharacters()) {
                        Character replacement;
                        if (this.unprintableCharactersMapping == null) {
                            this.buildUnprintableCharactersMapping();
                        }
                        if ((replacement = this.unprintableCharactersMapping.get(Character.valueOf(previewChars[0]))) != null) {
                            previewChars[0] = replacement.charValue();
                        }
                    }
                    int posX = previewX + charPos * charWidth - scrollPosition.getScrollCharPosition() * charWidth - scrollPosition.getScrollCharOffset();
                    if (this.codeArea.getCharRenderingMode() == CodeArea.CharRenderingMode.LINE_AT_ONCE) {
                        g.drawChars(previewChars, 0, 1, posX, posY);
                    } else {
                        this.drawCenteredChar(g, previewChars, 0, charWidth, posX, posY);
                    }
                } else {
                    int charPos = (scrolledX - codeRect.x) / charWidth;
                    int byteOffset = this.codeArea.computeByteOffsetPerCodeCharOffset(charPos, false);
                    int codeCharPos = this.codeArea.computeByteCharPos(byteOffset);
                    char[] lineChars = new char[this.codeArea.getCodeType().getMaxDigits()];
                    long dataSize = this.codeArea.getDataSize();
                    long dataPosition = ((long)line + scrollPosition.getScrollLinePosition()) * (long)this.codeArea.getBytesPerLine() + (long)byteOffset - (long)scrollPosition.getLineByteShift();
                    if (dataPosition >= dataSize) {
                        g.setClip(clip);
                        break;
                    }
                    byte dataByte = this.codeArea.getData().getByte(dataPosition);
                    CodeAreaUtils.byteToCharsCode((byte)dataByte, (CodeType)this.codeArea.getCodeType(), (char[])lineChars, (int)0, (HexCharactersCase)this.codeArea.getHexCharactersCase());
                    int posX = codeRect.x + codeCharPos * charWidth - scrollPosition.getScrollCharPosition() * charWidth - scrollPosition.getScrollCharOffset();
                    int charsOffset = charPos - codeCharPos;
                    if (this.codeArea.getCharRenderingMode() == CodeArea.CharRenderingMode.LINE_AT_ONCE) {
                        g.drawChars(lineChars, charsOffset, 1, posX + charsOffset * charWidth, posY);
                    } else {
                        this.drawCenteredChar(g, lineChars, charsOffset, charWidth, posX + charsOffset * charWidth, posY);
                    }
                }
                g.setClip(clip);
                break;
            }
        }
    }

    private void buildCharMapping(Charset charset) {
        for (int i = 0; i < 256; ++i) {
            this.charMapping[i] = new String(new byte[]{(byte)i}, charset).charAt(0);
        }
        this.charMappingCharset = charset;
    }

    private void buildUnprintableCharactersMapping() {
        this.unprintableCharactersMapping = new HashMap<Character, Character>();
        for (int i = 0; i < 32; ++i) {
            this.unprintableCharactersMapping.put(Character.valueOf((char)i), Character.valueOf(Character.toChars(9216 + i)[0]));
        }
        this.unprintableCharactersMapping.put(Character.valueOf(' '), Character.valueOf(Character.toChars(183)[0]));
        this.unprintableCharactersMapping.put(Character.valueOf('\t'), Character.valueOf(Character.toChars(187)[0]));
        this.unprintableCharactersMapping.put(Character.valueOf('\r'), Character.valueOf(Character.toChars(164)[0]));
        this.unprintableCharactersMapping.put(Character.valueOf('\n'), Character.valueOf(Character.toChars(182)[0]));
        this.unprintableCharactersMapping.put(Character.valueOf(Character.toChars(127)[0]), Character.valueOf(Character.toChars(176)[0]));
    }

    protected static class PaintData {
        protected ViewMode viewMode;
        protected CodeArea.BackgroundMode backgroundMode;
        protected Rectangle codeSectionRect;
        protected CodeArea.ScrollPosition scrollPosition;
        protected int charWidth;
        protected int bytesPerLine;
        protected int lineHeight;
        protected int codeDigits;
        protected int byteGroupSize;
        protected int spaceGroupSize;
        protected int charsPerLine;
        protected Charset charset;
        protected int maxCharLength;
        protected boolean showUnprintableCharacters;
        protected CodeArea.CharRenderingMode charRenderingMode;
        protected FontMetrics fontMetrics;
        protected boolean monospaceFont;
        protected int charsPerCodeArea;
        protected int previewCharPos;
        protected int visibleCharStart;
        protected int visibleCharEnd;
        protected int visibleCodeStart;
        protected int visibleCodeEnd;
        protected int visiblePreviewStart;
        protected int visiblePreviewEnd;
        protected ColorsGroup mainColors;
        protected ColorsGroup alternateColors;
        protected int lineStart;
        protected long lineDataPosition;
        protected long line;
        protected char[] lineChars;
        protected byte[] lineData;
        protected char[] unprintableChars;

        public PaintData(CodeArea codeArea) {
            this.viewMode = codeArea.getViewMode();
            this.backgroundMode = codeArea.getBackgroundMode();
            this.codeSectionRect = codeArea.getCodeSectionRectangle();
            this.scrollPosition = codeArea.getScrollPosition();
            this.charWidth = codeArea.getCharWidth();
            this.bytesPerLine = codeArea.getBytesPerLine();
            this.lineHeight = codeArea.getLineHeight();
            this.codeDigits = codeArea.getCodeType().getMaxDigits();
            this.charset = codeArea.getCharset();
            this.mainColors = codeArea.getMainColors();
            this.alternateColors = codeArea.getAlternateColors();
            this.charRenderingMode = codeArea.getCharRenderingMode();
            this.fontMetrics = codeArea.getFontMetrics();
            this.monospaceFont = codeArea.isMonospaceFontDetected();
            this.byteGroupSize = codeArea.getByteGroupSize();
            this.spaceGroupSize = codeArea.getSpaceGroupSize();
            CharsetEncoder encoder = this.charset.newEncoder();
            this.maxCharLength = (int)encoder.maxBytesPerChar();
            this.lineData = new byte[this.bytesPerLine + this.maxCharLength - 1];
            this.charsPerLine = codeArea.getCharsPerLine();
            this.lineChars = new char[this.charsPerLine];
            Arrays.fill(this.lineChars, ' ');
            this.showUnprintableCharacters = codeArea.isShowUnprintableCharacters();
            if (this.showUnprintableCharacters) {
                this.unprintableChars = new char[this.charsPerLine];
            }
            this.charsPerCodeArea = codeArea.computeByteCharPos(this.bytesPerLine, false);
            this.previewCharPos = this.viewMode == ViewMode.DUAL ? this.charsPerCodeArea + 1 : 0;
            if (this.viewMode == ViewMode.DUAL || this.viewMode == ViewMode.CODE_MATRIX) {
                this.visibleCharStart = (this.scrollPosition.getScrollCharPosition() * this.charWidth + this.scrollPosition.getScrollCharOffset()) / this.charWidth;
                if (this.visibleCharStart < 0) {
                    this.visibleCharStart = 0;
                }
                this.visibleCharEnd = (this.codeSectionRect.width + (this.scrollPosition.getScrollCharPosition() + this.charsPerLine) * this.charWidth + this.scrollPosition.getScrollCharOffset()) / this.charWidth;
                if (this.visibleCharEnd > this.charsPerCodeArea) {
                    this.visibleCharEnd = this.charsPerCodeArea;
                }
                this.visibleCodeStart = codeArea.computeByteOffsetPerCodeCharOffset(this.visibleCharStart, false);
                this.visibleCodeEnd = codeArea.computeByteOffsetPerCodeCharOffset(this.visibleCharEnd - 1, false) + 1;
            } else {
                this.visibleCharStart = 0;
                this.visibleCharEnd = -1;
                this.visibleCodeStart = 0;
                this.visibleCodeEnd = -1;
            }
            if (this.viewMode == ViewMode.DUAL || this.viewMode == ViewMode.TEXT_PREVIEW) {
                this.visiblePreviewStart = (this.scrollPosition.getScrollCharPosition() * this.charWidth + this.scrollPosition.getScrollCharOffset()) / this.charWidth - this.previewCharPos;
                if (this.visiblePreviewStart < 0) {
                    this.visiblePreviewStart = 0;
                }
                if (this.visibleCodeEnd < 0) {
                    this.visibleCharStart = this.visiblePreviewStart + this.previewCharPos;
                }
                this.visiblePreviewEnd = (this.codeSectionRect.width + (this.scrollPosition.getScrollCharPosition() + 1) * this.charWidth + this.scrollPosition.getScrollCharOffset()) / this.charWidth - this.previewCharPos;
                if (this.visiblePreviewEnd > this.bytesPerLine) {
                    this.visiblePreviewEnd = this.bytesPerLine;
                }
                if (this.visiblePreviewEnd >= 0) {
                    this.visibleCharEnd = this.visiblePreviewEnd + this.previewCharPos;
                }
            } else {
                this.visiblePreviewStart = 0;
                this.visiblePreviewEnd = -1;
            }
        }

        public ViewMode getViewMode() {
            return this.viewMode;
        }

        public CodeArea.BackgroundMode getBackgroundMode() {
            return this.backgroundMode;
        }

        public Rectangle getCodeSectionRect() {
            return this.codeSectionRect;
        }

        public CodeArea.ScrollPosition getScrollPosition() {
            return this.scrollPosition;
        }

        public CodeArea.CharRenderingMode getCharRenderingMode() {
            return this.charRenderingMode;
        }

        public int getCharWidth() {
            return this.charWidth;
        }

        public int getBytesPerLine() {
            return this.bytesPerLine;
        }

        public int getByteGroupSize() {
            return this.byteGroupSize;
        }

        public int getSpaceGroupSize() {
            return this.spaceGroupSize;
        }

        public int getLineHeight() {
            return this.lineHeight;
        }

        public int getCodeDigits() {
            return this.codeDigits;
        }

        public int getCharsPerLine() {
            return this.charsPerLine;
        }

        public Charset getCharset() {
            return this.charset;
        }

        public int getMaxCharLength() {
            return this.maxCharLength;
        }

        public int getPreviewCharPos() {
            return this.previewCharPos;
        }

        public boolean isShowUnprintableCharacters() {
            return this.showUnprintableCharacters;
        }

        public ColorsGroup getMainColors() {
            return this.mainColors;
        }

        public ColorsGroup getStripColors() {
            return this.alternateColors;
        }

        public long getLineDataPosition() {
            return this.lineDataPosition;
        }

        public long getLine() {
            return this.line;
        }

        public int getVisibleCharStart() {
            return this.visibleCharStart;
        }

        public int getVisibleCharEnd() {
            return this.visibleCharEnd;
        }

        public int getVisibleCodeStart() {
            return this.visibleCodeStart;
        }

        public int getVisibleCodeEnd() {
            return this.visibleCodeEnd;
        }

        public int getVisiblePreviewStart() {
            return this.visiblePreviewStart;
        }

        public int getVisiblePreviewEnd() {
            return this.visiblePreviewEnd;
        }
    }
}

