/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.utils.binary_data;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.exbin.utils.binary_data.BinaryData;
import org.exbin.utils.binary_data.ByteArrayDataInputStream;
import org.exbin.utils.binary_data.OutOfBoundsException;

public class ByteArrayData
implements BinaryData {
    protected byte[] data = new byte[0];

    public ByteArrayData() {
    }

    public ByteArrayData(byte[] data) {
        if (data == null) {
            throw new NullPointerException();
        }
        this.data = data;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        if (data == null) {
            throw new NullPointerException();
        }
        this.data = data;
    }

    @Override
    public boolean isEmpty() {
        return this.data.length == 0;
    }

    @Override
    public long getDataSize() {
        return this.data.length;
    }

    @Override
    public byte getByte(long position) {
        try {
            return this.data[(int)position];
        }
        catch (IndexOutOfBoundsException ex) {
            throw new OutOfBoundsException(ex);
        }
    }

    @Override
    public BinaryData copy() {
        byte[] copy = Arrays.copyOf(this.data, this.data.length);
        return new ByteArrayData(copy);
    }

    @Override
    public BinaryData copy(long startFrom, long length) {
        if (startFrom + length > (long)this.data.length) {
            throw new OutOfBoundsException("Attemt to copy outside of data");
        }
        byte[] copy = Arrays.copyOfRange(this.data, (int)startFrom, (int)(startFrom + length));
        return new ByteArrayData(copy);
    }

    @Override
    public void copyToArray(long startFrom, byte[] target, int offset, int length) {
        try {
            System.arraycopy(this.data, (int)startFrom, target, offset, length);
        }
        catch (IndexOutOfBoundsException ex) {
            throw new OutOfBoundsException(ex);
        }
    }

    @Override
    public void saveToStream(OutputStream outputStream) throws IOException {
        outputStream.write(this.data);
    }

    @Override
    public InputStream getDataInputStream() {
        return new ByteArrayDataInputStream(this);
    }

    public int hashCode() {
        int hash = 7;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            if (obj instanceof BinaryData) {
                BinaryData other = (BinaryData)obj;
                if (other.getDataSize() != this.getDataSize()) {
                    return false;
                }
                for (long position = 0L; position < this.getDataSize(); ++position) {
                    if (other.getByte(position) == this.getByte(position)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        ByteArrayData other = (ByteArrayData)obj;
        return Arrays.equals(this.data, other.data);
    }

    @Override
    public void dispose() {
    }
}

