/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.utils.binary_data;

import java.io.IOException;
import java.io.InputStream;
import org.exbin.utils.binary_data.ByteArrayData;
import org.exbin.utils.binary_data.FinishableStream;
import org.exbin.utils.binary_data.SeekableStream;

public class ByteArrayDataInputStream
extends InputStream
implements SeekableStream,
FinishableStream {
    private final ByteArrayData data;
    private long position = 0L;

    public ByteArrayDataInputStream(ByteArrayData data) {
        this.data = data;
    }

    @Override
    public int read() throws IOException {
        try {
            return this.data.getByte(this.position++);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return -1;
        }
    }

    @Override
    public void close() throws IOException {
        this.finish();
    }

    @Override
    public int available() throws IOException {
        return (int)(this.data.getDataSize() - this.position);
    }

    @Override
    public int read(byte[] output, int off, int len) throws IOException {
        if (output.length == 0 || len == 0) {
            return 0;
        }
        byte[] byteArray = this.data.getData();
        System.arraycopy(byteArray, (int)this.position, output, off, len);
        this.position += (long)len;
        return len;
    }

    @Override
    public void seek(long position) throws IOException {
        this.position = position;
    }

    @Override
    public long finish() throws IOException {
        this.position = this.data.getDataSize();
        return this.position;
    }

    @Override
    public long getLength() {
        return this.position;
    }

    @Override
    public long getStreamSize() {
        return this.data.getDataSize();
    }
}

