/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.utils.binary_data;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.exbin.utils.binary_data.BinaryData;
import org.exbin.utils.binary_data.ByteArrayData;
import org.exbin.utils.binary_data.ByteArrayDataOutputStream;
import org.exbin.utils.binary_data.EditableBinaryData;
import org.exbin.utils.binary_data.OutOfBoundsException;

public class ByteArrayEditableData
extends ByteArrayData
implements EditableBinaryData {
    public static final int BUFFER_SIZE = 1024;

    public ByteArrayEditableData() {
        this(new byte[0]);
    }

    public ByteArrayEditableData(byte[] data) {
        super(data);
    }

    @Override
    public void setDataSize(long size) {
        if ((long)this.data.length != size) {
            if (size < (long)this.data.length) {
                this.data = Arrays.copyOfRange(this.data, 0, (int)size);
            } else {
                byte[] newData = new byte[(int)size];
                System.arraycopy(this.data, 0, newData, 0, this.data.length);
                this.data = newData;
            }
        }
    }

    @Override
    public void setByte(long position, byte value) {
        try {
            this.data[(int)position] = value;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new OutOfBoundsException(ex);
        }
    }

    @Override
    public void insertUninitialized(long startFrom, long length) {
        if (startFrom > (long)this.data.length) {
            throw new OutOfBoundsException("Data can be inserted only inside or at the end");
        }
        if (length > 0L) {
            byte[] newData = new byte[(int)((long)this.data.length + length)];
            System.arraycopy(this.data, 0, newData, 0, (int)startFrom);
            System.arraycopy(this.data, (int)startFrom, newData, (int)(startFrom + length), (int)((long)this.data.length - startFrom));
            this.data = newData;
        }
    }

    @Override
    public void insert(long startFrom, long length) {
        if (startFrom > (long)this.data.length) {
            throw new OutOfBoundsException("Data can be inserted only inside or at the end");
        }
        if (length > 0L) {
            byte[] newData = new byte[(int)((long)this.data.length + length)];
            System.arraycopy(this.data, 0, newData, 0, (int)startFrom);
            System.arraycopy(this.data, (int)startFrom, newData, (int)(startFrom + length), (int)((long)this.data.length - startFrom));
            this.data = newData;
        }
    }

    @Override
    public void insert(long startFrom, byte[] insertedData) {
        if (startFrom > (long)this.data.length) {
            throw new OutOfBoundsException("Data can be inserted only inside or at the end");
        }
        int length = insertedData.length;
        if (length > 0) {
            byte[] newData = new byte[this.data.length + length];
            System.arraycopy(this.data, 0, newData, 0, (int)startFrom);
            try {
                System.arraycopy(insertedData, 0, newData, (int)startFrom, length);
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                throw new OutOfBoundsException(ex);
            }
            System.arraycopy(this.data, (int)startFrom, newData, (int)(startFrom + (long)length), (int)((long)this.data.length - startFrom));
            this.data = newData;
        }
    }

    @Override
    public void insert(long startFrom, byte[] insertedData, int insertedDataOffset, int length) {
        if (startFrom > (long)this.data.length) {
            throw new OutOfBoundsException("Data can be inserted only inside or at the end");
        }
        if (length > 0) {
            byte[] newData = new byte[this.data.length + length];
            System.arraycopy(this.data, 0, newData, 0, (int)startFrom);
            try {
                System.arraycopy(insertedData, insertedDataOffset, newData, (int)startFrom, length);
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                throw new OutOfBoundsException(ex);
            }
            System.arraycopy(this.data, (int)startFrom, newData, (int)(startFrom + (long)length), (int)((long)this.data.length - startFrom));
            this.data = newData;
        }
    }

    @Override
    public void insert(long startFrom, BinaryData insertedData) {
        if (startFrom > (long)this.data.length) {
            throw new OutOfBoundsException("Data can be inserted only inside or at the end");
        }
        if (insertedData instanceof ByteArrayData) {
            this.insert(startFrom, ((ByteArrayData)insertedData).data);
        } else {
            this.insert(startFrom, insertedData, 0L, insertedData.getDataSize());
        }
    }

    @Override
    public void insert(long startFrom, BinaryData insertedData, long insertedDataOffset, long insertedDataLength) {
        if (startFrom > (long)this.data.length) {
            throw new OutOfBoundsException("Data can be inserted only inside or at the end");
        }
        if (insertedData instanceof ByteArrayData) {
            this.insert(startFrom, ((ByteArrayData)insertedData).data);
        } else {
            long length = insertedDataLength;
            if (length > 0L) {
                byte[] newData = new byte[(int)((long)this.data.length + length)];
                System.arraycopy(this.data, 0, newData, 0, (int)startFrom);
                int i = 0;
                while ((long)i < length) {
                    newData[(int)(startFrom + (long)i)] = insertedData.getByte(insertedDataOffset + (long)i);
                    ++i;
                }
                System.arraycopy(this.data, (int)startFrom, newData, (int)(startFrom + length), (int)((long)this.data.length - startFrom));
                this.data = newData;
            }
        }
    }

    @Override
    public long insert(long startFrom, InputStream inputStream, long dataSize) throws IOException {
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            byte[] newData;
            byte[] buffer = new byte[1024];
            while (inputStream.available() > 0 && dataSize > 0L) {
                int red;
                int toRead = buffer.length;
                if ((long)toRead > dataSize) {
                    toRead = (int)dataSize;
                }
                if ((red = inputStream.read(buffer, 0, toRead)) <= 0) break;
                output.write(buffer, 0, red);
                dataSize -= (long)red;
            }
            if (startFrom + (long)(newData = output.toByteArray()).length > this.getDataSize()) {
                this.setDataSize(startFrom + (long)newData.length);
            }
            this.replace(startFrom, newData);
            long l = newData.length;
            return l;
        }
    }

    @Override
    public void fillData(long startFrom, long length) {
        this.fillData(startFrom, length, (byte)0);
    }

    @Override
    public void fillData(long startFrom, long length, byte fill) {
        if (length > 0L) {
            try {
                Arrays.fill(this.data, (int)startFrom, (int)(startFrom + length), fill);
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                throw new OutOfBoundsException(ex);
            }
        }
    }

    @Override
    public void replace(long targetPosition, BinaryData sourceData) {
        this.replace(targetPosition, sourceData, 0L, sourceData.getDataSize());
    }

    @Override
    public void replace(long targetPosition, BinaryData sourceData, long startFrom, long length) {
        if (targetPosition + length > this.getDataSize()) {
            throw new OutOfBoundsException("Data can be replaced only inside or at the end");
        }
        if (sourceData instanceof ByteArrayData) {
            this.replace(targetPosition, ((ByteArrayData)sourceData).data, (int)startFrom, (int)length);
        } else {
            while (length > 0L) {
                this.setByte(targetPosition, sourceData.getByte(startFrom));
                ++targetPosition;
                ++startFrom;
                --length;
            }
        }
    }

    @Override
    public void replace(long targetPosition, byte[] replacingData) {
        this.replace(targetPosition, replacingData, 0, replacingData.length);
    }

    @Override
    public void replace(long targetPosition, byte[] replacingData, int replacingDataOffset, int length) {
        if (targetPosition + (long)length > this.getDataSize()) {
            throw new OutOfBoundsException("Data can be replaced only inside or at the end");
        }
        try {
            System.arraycopy(replacingData, replacingDataOffset, this.data, (int)targetPosition, length);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new OutOfBoundsException(ex);
        }
    }

    @Override
    public void remove(long startFrom, long length) {
        if (startFrom + length > (long)this.data.length) {
            throw new OutOfBoundsException("Cannot remove from " + startFrom + " with length " + length);
        }
        if (length > 0L) {
            byte[] newData = new byte[(int)((long)this.data.length - length)];
            System.arraycopy(this.data, 0, newData, 0, (int)startFrom);
            System.arraycopy(this.data, (int)(startFrom + length), newData, (int)startFrom, (int)((long)this.data.length - startFrom - length));
            this.data = newData;
        }
    }

    @Override
    public BinaryData copy() {
        byte[] copy = Arrays.copyOf(this.data, this.data.length);
        return new ByteArrayEditableData(copy);
    }

    @Override
    public BinaryData copy(long startFrom, long length) {
        if (startFrom + length > (long)this.data.length) {
            throw new OutOfBoundsException("Attemt to copy outside of data");
        }
        byte[] copy = Arrays.copyOfRange(this.data, (int)startFrom, (int)(startFrom + length));
        return new ByteArrayEditableData(copy);
    }

    @Override
    public void clear() {
        this.data = new byte[0];
    }

    @Override
    public void loadFromStream(InputStream inputStream) throws IOException {
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            byte[] buffer = new byte[1024];
            while (inputStream.available() > 0) {
                int read = inputStream.read(buffer);
                if (read <= 0) continue;
                output.write(buffer, 0, read);
            }
            this.data = output.toByteArray();
        }
    }

    @Override
    public OutputStream getDataOutputStream() {
        return new ByteArrayDataOutputStream(this);
    }
}

