/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.utils.binary_data;

import java.io.IOException;
import java.io.InputStream;
import org.exbin.utils.binary_data.FinishableStream;
import org.exbin.utils.binary_data.PagedData;
import org.exbin.utils.binary_data.SeekableStream;

public class PagedDataInputStream
extends InputStream
implements SeekableStream,
FinishableStream {
    private final PagedData data;
    private long position = 0L;

    public PagedDataInputStream(PagedData data) {
        this.data = data;
    }

    @Override
    public int read() throws IOException {
        try {
            return this.data.getByte(this.position++);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return -1;
        }
    }

    @Override
    public void close() throws IOException {
        this.finish();
    }

    @Override
    public int available() throws IOException {
        return (int)(this.data.getDataSize() - this.position);
    }

    @Override
    public int read(byte[] output, int off, int len) throws IOException {
        if (output.length == 0 || len == 0) {
            return 0;
        }
        int length = len;
        int offset = off;
        while (length > 0) {
            int srcPos;
            int pageIndex = (int)(this.position / (long)this.data.getPageSize());
            if (pageIndex >= this.data.getPagesCount()) {
                return offset == off ? -1 : offset - off;
            }
            byte[] page = this.data.getPage(pageIndex);
            int copyLength = page.length - (srcPos = (int)(this.position % (long)this.data.getPageSize()));
            if (copyLength > length) {
                copyLength = length;
            }
            if (copyLength == 0) {
                return len == length ? -1 : len - length;
            }
            System.arraycopy(page, srcPos, output, offset, copyLength);
            length -= copyLength;
            this.position += (long)copyLength;
            offset += copyLength;
        }
        return len;
    }

    @Override
    public void seek(long position) throws IOException {
        this.position = position;
    }

    @Override
    public long finish() throws IOException {
        this.position = this.data.getDataSize();
        return this.position;
    }

    @Override
    public long getLength() {
        return this.position;
    }

    @Override
    public long getStreamSize() {
        return this.data.getDataSize();
    }
}

