/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.process;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.xml.stream.XMLStreamException;
import org.exist.dom.QName;
import org.exist.dom.memtree.ElementImpl;
import org.exist.dom.memtree.MemTreeBuilder;
import org.exist.numbering.NodeId;
import org.exist.stax.ExtendedXMLStreamReader;
import org.exist.util.FileUtils;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Cardinality;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class Execute
extends BasicFunction {
    public static final FunctionSignature signature = new FunctionSignature(new QName("execute", "http://exist-db.org/xquery/process", "process"), "", new SequenceType[]{new FunctionParameterSequenceType("args", 22, Cardinality.ONE_OR_MORE, "a list of strings which signifies the external program file to be invoked and its arguments, if any"), new FunctionParameterSequenceType("options", 1, Cardinality.ZERO_OR_ONE, "an XML fragment defining optional parameters like working directory or the lines to send to the process via stdin. Format: <options><workingDir>workingDir</workingDir><environment><env name=\"name\" value=\"value\"/></environment><stdin><line>line</line></stdin></options>")}, (SequenceType)new FunctionReturnSequenceType(1, Cardinality.EXACTLY_ONE, "the sequence of code points"));
    public static final QName RESULT_QNAME = new QName("execution", "");
    public static final QName COMMAND_LINE_QNAME = new QName("commandline", "");
    public static final QName STDOUT_QNAME = new QName("stdout", "");
    public static final QName LINE_QNAME = new QName("line", "");

    public Execute(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (!this.context.getSubject().hasDbaRole()) {
            throw new XPathException((Expression)this, "process:execute is only available to users with dba role");
        }
        ArrayList<String> cmdArgs = new ArrayList<String>(args[0].getItemCount());
        SequenceIterator i = args[0].iterate();
        while (i.hasNext()) {
            cmdArgs.add(i.nextItem().getStringValue());
        }
        ArrayList<String> stdin = null;
        Path workingDir = null;
        HashMap<String, String> environment = null;
        if (!args[1].isEmpty()) {
            try {
                NodeValue options = (NodeValue)args[1].itemAt(0);
                int thisLevel = options.getNodeId().getTreeLevel();
                ExtendedXMLStreamReader reader = this.context.getXMLStreamReader(options);
                reader.next();
                while (reader.hasNext()) {
                    NodeId otherId;
                    int otherLevel;
                    int status = reader.next();
                    if (status == 1) {
                        String name = reader.getLocalName();
                        if ("workingDir".equals(name)) {
                            workingDir = this.getWorkingDir(reader.getElementText());
                            continue;
                        }
                        if ("line".equals(name)) {
                            if (stdin == null) {
                                stdin = new ArrayList<String>(21);
                            }
                            stdin.add(reader.getElementText() + "\n");
                            continue;
                        }
                        if (!"env".equals(name)) continue;
                        if (environment == null) {
                            environment = new HashMap<String, String>();
                        }
                        String key = reader.getAttributeValue(null, "name");
                        String value = reader.getAttributeValue(null, "value");
                        if (key == null || value == null) continue;
                        environment.put(key, value);
                        continue;
                    }
                    if (status != 2 || (otherLevel = (otherId = (NodeId)reader.getProperty("node-id")).getTreeLevel()) != thisLevel) continue;
                    break;
                }
            }
            catch (IOException | XMLStreamException e) {
                throw new XPathException((Expression)this, "Invalid XML fragment for options: " + e.getMessage(), (Throwable)e);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating process {}", cmdArgs.get(0));
        }
        ProcessBuilder pb = new ProcessBuilder(cmdArgs);
        pb.redirectErrorStream(true);
        if (workingDir != null) {
            pb.directory(workingDir.toFile());
        }
        if (environment != null) {
            Map<String, String> env = pb.environment();
            env.putAll(environment);
        }
        try {
            Process process = pb.start();
            if (stdin != null) {
                try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(process.getOutputStream(), StandardCharsets.UTF_8));){
                    for (String line : stdin) {
                        writer.write(line);
                    }
                }
            }
            List<String> output = this.readOutput(process);
            int exitValue = process.waitFor();
            return this.createReport(exitValue, output, cmdArgs);
        }
        catch (IOException e) {
            throw new XPathException((Expression)this, "An IO error occurred while executing the process " + (String)cmdArgs.get(0) + ": " + e.getMessage(), (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new XPathException((Expression)this, "process:execute was interrupted while waiting for process " + (String)cmdArgs.get(0));
        }
    }

    private Path getWorkingDir(String arg) {
        Path file = Paths.get(arg, new String[0]);
        if (file.isAbsolute()) {
            return file;
        }
        Optional home = this.context.getBroker().getConfiguration().getExistHome();
        return FileUtils.resolve((Optional)home, (String)arg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ElementImpl createReport(int exitValue, List<String> output, List<String> cmdArgs) {
        this.context.pushDocumentContext();
        try {
            MemTreeBuilder builder = this.context.getDocumentBuilder();
            AttributesImpl attribs = new AttributesImpl();
            attribs.addAttribute("", "exitCode", "exitCode", "CDATA", Integer.toString(exitValue));
            builder.startDocument();
            int nodeNr = builder.startElement(RESULT_QNAME, (Attributes)attribs);
            StringBuilder cmdLine = new StringBuilder();
            for (String param : cmdArgs) {
                cmdLine.append(param).append(' ');
            }
            builder.startElement(COMMAND_LINE_QNAME, null);
            builder.characters((CharSequence)cmdLine.toString());
            builder.endElement();
            builder.startElement(STDOUT_QNAME, null);
            for (String line : output) {
                builder.startElement(LINE_QNAME, null);
                builder.characters((CharSequence)line);
                builder.endElement();
            }
            builder.endElement();
            builder.endElement();
            ElementImpl elementImpl = (ElementImpl)builder.getDocument().getNode(nodeNr);
            return elementImpl;
        }
        finally {
            this.context.popDocumentContext();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> readOutput(Process process) throws XPathException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));){
            String line;
            ArrayList<String> output = new ArrayList<String>(31);
            while ((line = reader.readLine()) != null) {
                output.add(line);
            }
            ArrayList<String> arrayList = output;
            return arrayList;
        }
        catch (IOException e) {
            throw new XPathException((Expression)this, "An IO error occurred while reading output from the process: " + e.getMessage(), (Throwable)e);
        }
    }
}

