/*
 * Decompiled with CFR 0.152.
 */
package xjs.compat.serialization.parser;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import xjs.data.Json;
import xjs.data.JsonArray;
import xjs.data.JsonLiteral;
import xjs.data.JsonObject;
import xjs.data.JsonReference;
import xjs.data.JsonValue;
import xjs.data.serialization.parser.ValueParser;

public class UbjsonParser
implements ValueParser {
    protected final InputStream input;

    public UbjsonParser(File file) throws IOException {
        this(new FileInputStream(file));
    }

    public UbjsonParser(InputStream input) {
        this.input = input;
    }

    @NotNull
    public JsonValue parse() throws IOException {
        return this.readValue();
    }

    protected byte read() throws IOException {
        int value = this.input.read();
        if (value == -1) {
            throw new IOException("Unexpected end of input");
        }
        return (byte)value;
    }

    protected long readInt() throws IOException {
        return this.readInt(this.read());
    }

    protected long readInt(byte type) throws IOException {
        return switch (type) {
            case 105 -> this.read();
            case 85 -> this.readUInt8();
            case 73 -> this.readInt16();
            case 108 -> this.readInt32();
            case 76 -> this.readInt64();
            default -> throw new IOException("Not an integer");
        };
    }

    protected short readUInt8() throws IOException {
        return (short)(this.read() & 0xFF);
    }

    protected short readInt16() throws IOException {
        return (short)((this.read() & 0xFF) << 8 | this.read() & 0xFF);
    }

    protected int readInt32() throws IOException {
        return (this.read() & 0xFF) << 24 | (this.read() & 0xFF) << 16 | (this.read() & 0xFF) << 8 | this.read() & 0xFF;
    }

    protected long readInt64() throws IOException {
        return ((long)this.read() & 0xFFL) << 56 | ((long)this.read() & 0xFFL) << 48 | ((long)this.read() & 0xFFL) << 40 | ((long)this.read() & 0xFFL) << 32 | ((long)this.read() & 0xFFL) << 24 | ((long)this.read() & 0xFFL) << 16 | ((long)this.read() & 0xFFL) << 8 | (long)this.read() & 0xFFL;
    }

    protected float readFloat32() throws IOException {
        return Float.intBitsToFloat(this.readInt32());
    }

    protected double readFloat64() throws IOException {
        return Double.longBitsToDouble(this.readInt64());
    }

    protected String readString() throws IOException {
        return this.readString(this.read());
    }

    protected String readString(byte sizeType) throws IOException {
        int size = (int)this.readInt(sizeType);
        byte[] bytes = new byte[size];
        int bytesLeft = size;
        int offset = 0;
        while (bytesLeft > 0) {
            int bytesRead = this.input.read(bytes, offset, size);
            if (bytesRead < 0) {
                throw new IOException("Unexpected end of input");
            }
            bytesLeft -= bytesRead;
            offset += bytesRead;
        }
        return new String(bytes, StandardCharsets.UTF_8);
    }

    protected JsonArray readOptimizedArray(int size, byte type) throws IOException {
        ArrayList<JsonReference> array = new ArrayList<JsonReference>(size);
        for (int i = 0; i < size; ++i) {
            array.add(new JsonReference(this.readValue(type)));
        }
        return new JsonArray(array);
    }

    protected JsonArray readSizedArray(int size) throws IOException {
        ArrayList<JsonReference> array = new ArrayList<JsonReference>(size);
        for (int i = 0; i < size; ++i) {
            array.add(new JsonReference(this.readValue(this.read())));
        }
        return new JsonArray(array);
    }

    protected JsonArray readGenericArray(byte type) throws IOException {
        JsonArray array = new JsonArray();
        while (type != 93) {
            array.add(this.readValue(type));
            type = this.read();
        }
        return array;
    }

    protected JsonArray readArray() throws IOException {
        byte marker = this.read();
        if (marker == 36) {
            byte type = this.read();
            if (this.read() != 35) {
                throw new IOException("Missing size marker");
            }
            return this.readOptimizedArray((int)this.readInt(), type);
        }
        if (marker == 35) {
            return this.readSizedArray((int)this.readInt());
        }
        return this.readGenericArray(marker);
    }

    protected JsonObject readOptimizedObject(int size, byte type) throws IOException {
        JsonObject object = new JsonObject();
        for (int i = 0; i < size; ++i) {
            object.add(this.readString(), this.readValue(type));
        }
        return object;
    }

    protected JsonObject readSizedObject(int size) throws IOException {
        JsonObject object = new JsonObject();
        for (int i = 0; i < size; ++i) {
            object.add(this.readString(), this.readValue(this.read()));
        }
        return object;
    }

    protected JsonObject readGenericObject(byte type) throws IOException {
        JsonObject object = new JsonObject();
        while (type != 125) {
            object.add(this.readString(type), this.readValue());
            type = this.read();
        }
        return object;
    }

    protected JsonObject readObject() throws IOException {
        byte marker = this.read();
        if (marker == 36) {
            byte type = this.read();
            if (this.read() != 35) {
                throw new IOException("Missing size marker");
            }
            return this.readOptimizedObject((int)this.readInt(), type);
        }
        if (marker == 35) {
            return this.readSizedObject((int)this.readInt());
        }
        return this.readGenericObject(marker);
    }

    protected JsonValue readValue() throws IOException {
        return this.readValue(this.read());
    }

    protected JsonValue readValue(byte type) throws IOException {
        switch (type) {
            case 90: {
                return JsonLiteral.jsonNull();
            }
            case 84: {
                return JsonLiteral.jsonTrue();
            }
            case 70: {
                return JsonLiteral.jsonFalse();
            }
            case 67: 
            case 105: {
                return Json.value((long)this.read());
            }
            case 73: 
            case 76: 
            case 85: 
            case 108: {
                return Json.value((long)this.readInt(type));
            }
            case 100: {
                return Json.value((double)this.readFloat32());
            }
            case 68: {
                return Json.value((double)this.readFloat64());
            }
            case 83: {
                return Json.value((String)this.readString());
            }
            case 91: {
                return this.readArray();
            }
            case 123: {
                return this.readObject();
            }
        }
        throw new IOException("Unrecognized marker: " + (char)type);
    }

    public void close() throws Exception {
        this.input.close();
    }
}

