/*
 * Decompiled with CFR 0.152.
 */
package xjs.compat.serialization.token;

import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.Nullable;
import xjs.compat.serialization.util.StringContext;
import xjs.data.StringType;
import xjs.data.serialization.token.NumberToken;
import xjs.data.serialization.token.ParsedToken;
import xjs.data.serialization.token.Token;
import xjs.data.serialization.token.TokenStream;
import xjs.data.serialization.token.TokenType;
import xjs.data.serialization.token.Tokenizer;
import xjs.data.serialization.util.PositionTrackingReader;

public class HjsonTokenizer
extends Tokenizer {
    protected final StringContext stringContext = new StringContext();

    public HjsonTokenizer(InputStream is, boolean containerized) throws IOException {
        super(is, containerized);
    }

    public HjsonTokenizer(String text, boolean containerized) {
        super(text, containerized);
    }

    public HjsonTokenizer(PositionTrackingReader reader, boolean containerized) {
        super(reader, containerized);
    }

    public static TokenStream stream(String text) {
        return new TokenStream((Tokenizer)new HjsonTokenizer(text, false), TokenType.OPEN);
    }

    public static TokenStream stream(InputStream is) throws IOException {
        return new TokenStream((Tokenizer)new HjsonTokenizer(is, false), TokenType.OPEN);
    }

    @Nullable
    protected Token single() throws IOException {
        PositionTrackingReader reader = this.reader;
        reader.skipLineWhitespace();
        if (reader.isEndOfText()) {
            return null;
        }
        char c = (char)reader.current;
        this.stringContext.prepare(c);
        this.startReading();
        Token t = switch (c) {
            case '#', '/' -> this.comment(c);
            case '\"', '\'' -> this.quote(c);
            case '\n' -> this.newLine();
            default -> {
                if (this.isPunctuation(c) || c == ':') {
                    reader.read();
                    yield this.newSymbolToken(c);
                }
                yield this.word();
            }
        };
        this.stringContext.update(t);
        return t;
    }

    protected Token word() throws IOException {
        if (this.stringContext.isExpectingKey()) {
            return this.key();
        }
        if (this.stringContext.isAmbiguous()) {
            return this.ambiguous();
        }
        return this.unquoted();
    }

    protected Token key() throws IOException {
        char c;
        PositionTrackingReader reader = this.reader;
        reader.startCapture();
        while (this.isLegalKeyCharacter(c = (char)reader.current)) {
            reader.read();
            if (!reader.isEndOfText()) continue;
        }
        return this.newWordToken(reader.endCapture());
    }

    protected Token ambiguous() throws IOException {
        PositionTrackingReader reader = this.reader;
        reader.startCapture();
        while (true) {
            if (reader.isEndOfText()) {
                String prefix = reader.endCapture();
                Token t = this.asKwOrNum(prefix);
                if (t != null) {
                    return t;
                }
                return this.newUnquoted(prefix);
            }
            if (reader.current == 58) {
                return this.newUnquoted(reader.endCapture());
            }
            if (reader.isWhitespace()) {
                Token t;
                String prefix = reader.endCapture();
                reader.startCapture();
                reader.skipLineWhitespace();
                if (reader.current == 58 || reader.current == 10) {
                    reader.invalidateCapture();
                    return this.newUnquoted(prefix);
                }
                if (this.canBeEndOfKwOrNum() && (t = this.asKwOrNum(prefix)) != null) {
                    return t;
                }
                String remaining = reader.endCapture(reader.skipToNL());
                return this.newUnquoted(prefix + remaining);
            }
            if (this.canBeEndOfKwOrNum()) {
                String prefix = reader.endCapture();
                Token t = this.asKwOrNum(prefix);
                if (t != null) {
                    return t;
                }
                reader.startCapture();
                String remaining = reader.endCapture(reader.skipToNL());
                return this.newUnquoted(prefix + remaining);
            }
            reader.read();
        }
    }

    protected Token unquoted() throws IOException {
        PositionTrackingReader reader = this.reader;
        reader.startCapture();
        while (!reader.isEndOfText()) {
            if (reader.isWhitespace()) {
                Token t;
                String prefix = reader.endCapture();
                reader.startCapture();
                reader.skipLineWhitespace();
                if (this.canBeEndOfKwOrNum() && (t = this.asKwOrNum(prefix)) != null) {
                    return t;
                }
                String remaining = reader.endCapture(reader.skipToNL());
                return this.newUnquoted(prefix + remaining);
            }
            if (this.canBeEndOfKwOrNum()) {
                String prefix = reader.endCapture();
                Token t = this.asKwOrNum(prefix);
                if (t != null) {
                    return t;
                }
                reader.startCapture();
                String remaining = reader.endCapture(reader.skipToNL());
                return this.newUnquoted(prefix + remaining);
            }
            reader.read();
        }
        String parsed = reader.endCapture();
        Token t = this.asKwOrNum(parsed);
        if (t != null) {
            return t;
        }
        return this.newUnquoted(parsed);
    }

    @Nullable
    protected Token asKwOrNum(String text) {
        switch (text) {
            case "true": 
            case "false": 
            case "null": {
                int e = this.index + text.length();
                return this.newWordToken(text, e);
            }
        }
        if (this.isOctalFormat(text)) {
            return null;
        }
        try {
            double n = Double.parseDouble(text);
            int e = this.index + text.length();
            return this.newNumberToken(text, n, e);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    protected boolean isOctalFormat(String text) {
        return text.length() > 1 && text.charAt(0) == '0' && Character.isDigit(text.charAt(1));
    }

    protected boolean isLegalKeyCharacter(char c) {
        return !this.isWhitespace(c) && c != ':' && !this.isPunctuation(c);
    }

    protected boolean isWhitespace(char c) {
        return c == ' ' || c == '\t' || c == '\r' || c == '\n';
    }

    protected boolean isPunctuation(char c) {
        return c == ',' || c == '{' || c == '}' || c == '[' || c == ']';
    }

    protected boolean canBeEndOfKwOrNum() throws IOException {
        char c = (char)this.reader.current;
        if (c == '\n' || c == ',' || c == '}' || c == ']' || c == '#') {
            return true;
        }
        if (c == '/') {
            int peek = this.reader.peek();
            return peek == 47 || peek == 42;
        }
        return false;
    }

    protected Token newUnquoted(String text) {
        return this.newStringToken(text, StringType.IMPLICIT);
    }

    protected Token newNumberToken(String text, double number, int e) {
        return new NumberToken(this.index, e, this.line, this.column, number, text);
    }

    protected Token newWordToken(String capture, int e) {
        return new ParsedToken(this.index, e, this.line, this.column, TokenType.WORD, capture);
    }
}

