/*
 * Decompiled with CFR 0.152.
 */
package xjs.compat.serialization.writer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import xjs.compat.serialization.util.UBTyping;
import xjs.data.JsonArray;
import xjs.data.JsonContainer;
import xjs.data.JsonObject;
import xjs.data.JsonType;
import xjs.data.JsonValue;
import xjs.data.serialization.writer.ValueWriter;

public class UbjsonWriter
implements ValueWriter {
    protected static final int U_INT_8_MIN = 0;
    protected static final int U_INT_8_MAX = 255;
    protected static final int INT_8_MAX = 127;
    protected static final int INT_8_MIN = -128;
    protected static final int INT_16_MAX = Short.MAX_VALUE;
    protected static final int INT_16_MIN = Short.MIN_VALUE;
    protected static final int INT_32_MIN = Integer.MIN_VALUE;
    protected static final int INT_32_MAX = Integer.MAX_VALUE;
    protected final OutputStream output;
    protected final UBTyping typing;

    public UbjsonWriter(File file) throws IOException {
        this(new FileOutputStream(file), UBTyping.COMPRESSED);
    }

    public UbjsonWriter(File file, UBTyping typing) throws IOException {
        this(new FileOutputStream(file), typing);
    }

    public UbjsonWriter(OutputStream output, UBTyping typing) {
        this.output = output;
        this.typing = typing;
    }

    public void write(JsonValue value) throws IOException {
        this.writeValue(value);
    }

    protected void writeNull() throws IOException {
        this.output.write(90);
    }

    protected void writeBool(boolean b) throws IOException {
        this.output.write(b ? 84 : 70);
    }

    protected void writeInt8(byte value) throws IOException {
        this.output.write(105);
        this.writeRawInt8(value);
    }

    protected void writeRawInt8(byte value) throws IOException {
        this.output.write(value);
    }

    protected void writeUInt8(short value) throws IOException {
        this.output.write(85);
        this.writeRawUInt8(value);
    }

    protected void writeRawUInt8(short value) throws IOException {
        this.output.write(value & 0xFF);
    }

    protected void writeInt16(short value) throws IOException {
        this.output.write(73);
        this.writeRawInt16(value);
    }

    protected void writeRawInt16(short value) throws IOException {
        this.output.write(value >> 8);
        this.output.write(value);
    }

    protected void writeInt32(int value) throws IOException {
        this.output.write(108);
        this.writeRawInt32(value);
    }

    protected void writeRawInt32(int value) throws IOException {
        this.output.write(value >> 24);
        this.output.write(value >> 16);
        this.output.write(value >> 8);
        this.output.write(value);
    }

    protected void writeInt64(long value) throws IOException {
        this.output.write(108);
        this.writeRawInt64(value);
    }

    protected void writeRawInt64(long value) throws IOException {
        this.output.write((byte)(0xFFL & value >> 56));
        this.output.write((byte)(0xFFL & value >> 48));
        this.output.write((byte)(0xFFL & value >> 40));
        this.output.write((byte)(0xFFL & value >> 32));
        this.output.write((byte)(0xFFL & value >> 24));
        this.output.write((byte)(0xFFL & value >> 16));
        this.output.write((byte)(0xFFL & value >> 8));
        this.output.write((byte)(0xFFL & value));
    }

    protected void writeInt(long value) throws IOException {
        if (value >= 0L && value <= 255L) {
            this.writeUInt8((byte)value);
        } else if (value >= -128L && value <= 127L) {
            this.writeInt8((byte)value);
        } else if (value >= -32768L && value <= 32767L) {
            this.writeInt16((short)value);
        } else if (value >= Integer.MIN_VALUE && value <= Integer.MAX_VALUE) {
            this.writeInt32((int)value);
        } else {
            this.writeInt64(value);
        }
    }

    protected void writeFloat32(float value) throws IOException {
        this.output.write(100);
        this.writeRawFloat32(value);
    }

    protected void writeRawFloat32(float value) throws IOException {
        this.writeRawInt32(Float.floatToIntBits(value));
    }

    protected void writeFloat64(double value) throws IOException {
        this.output.write(68);
        this.writeRawFloat64(value);
    }

    protected void writeRawFloat64(double value) throws IOException {
        this.writeRawInt64(Double.doubleToLongBits(value));
    }

    protected void writeFloat(double value) throws IOException {
        if ((double)((float)value) == value) {
            this.writeFloat32((float)value);
        } else {
            this.writeFloat64(value);
        }
    }

    protected void writeNumber(double value) throws IOException {
        long integer = (long)value;
        if ((double)integer == value) {
            this.writeInt(integer);
        } else {
            this.writeFloat(value);
        }
    }

    protected void writeString(String value) throws IOException {
        this.output.write(83);
        this.writeRawString(value);
    }

    protected void writeRawString(String value) throws IOException {
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        this.writeInt(bytes.length);
        this.output.write(bytes);
    }

    protected void writeArray(JsonArray array) throws IOException {
        this.output.write(91);
        this.writeRawArray(array);
    }

    protected void writeRawArray(JsonArray array) throws IOException {
        if (array.isEmpty()) {
            this.output.write(93);
        } else if (this.typing == UBTyping.WEAK) {
            this.writeGenericArray(array);
        } else {
            byte type = this.getCompressionType((JsonContainer)array);
            if (type != 0) {
                this.writeOptimizedArray(array, type);
            } else if (this.typing == UBTyping.COMPRESSED) {
                this.writeGenericArray(array);
            } else {
                this.writeSizedArray(array);
            }
        }
    }

    protected void writeSizedArray(JsonArray array) throws IOException {
        this.output.write(35);
        this.writeInt(array.size());
        for (JsonValue value : array.visitAll()) {
            this.writeValue(value);
        }
    }

    protected void writeGenericArray(JsonArray array) throws IOException {
        for (JsonValue value : array.visitAll()) {
            this.writeValue(value);
        }
        this.output.write(93);
    }

    protected void writeOptimizedArray(JsonArray array, byte type) throws IOException {
        this.output.write(36);
        this.output.write(type);
        this.output.write(35);
        this.writeInt(array.size());
        for (JsonValue value : array.visitAll()) {
            this.writeRawValue(value, type);
        }
    }

    protected byte getCompressionType(JsonContainer container) {
        int minSize;
        int n = minSize = this.typing == UBTyping.STRONG ? 1 : 2;
        if (container.size() < minSize) {
            return 0;
        }
        byte type = this.getContainerType(container);
        if (this.typing != UBTyping.STRONG && this.isSingleByte(type) && container.size() < 5) {
            return 0;
        }
        return type;
    }

    protected byte getType(JsonValue value) {
        return (byte)(switch (value.getType()) {
            case JsonType.STRING -> 83;
            case JsonType.BOOLEAN -> {
                if (value.asBoolean()) {
                    yield 84;
                }
                yield 70;
            }
            case JsonType.ARRAY -> 91;
            case JsonType.OBJECT -> 123;
            case JsonType.NUMBER -> this.getNumberType(value.asDouble());
            default -> 90;
        });
    }

    protected byte getContainerType(JsonContainer container) {
        JsonValue firstValue = container.get(0);
        if (firstValue.isNumber()) {
            return this.getNumberType(container);
        }
        byte type = this.getType(firstValue);
        if (this.isMarkerOnly(type)) {
            return 0;
        }
        for (int i = 1; i < container.size(); ++i) {
            if (type == this.getType(container.getReference(i).getOnly())) continue;
            return 0;
        }
        return type;
    }

    protected byte getNumberType(JsonContainer container) {
        double max = -2.147483648E9;
        double min = 2.147483647E9;
        for (JsonValue value : container.visitAll()) {
            if (!value.isNumber()) {
                return 0;
            }
            max = Double.max(max, value.asDouble());
            min = Double.min(min, value.asDouble());
        }
        return this.getNumberType(min, max);
    }

    protected byte getNumberType(double min, double max) {
        if ((double)((long)min) == min && (double)((long)max) == max) {
            if (min >= 0.0 && max <= 255.0) {
                return 85;
            }
            if (min >= -128.0 && max <= 127.0) {
                return 105;
            }
            if (min >= -32768.0 && max <= 32767.0) {
                return 73;
            }
            if (min >= -2.147483648E9 && max <= 2.147483647E9) {
                return 108;
            }
            return 76;
        }
        if ((double)((float)min) == min && (double)((float)max) == max) {
            return 100;
        }
        return 68;
    }

    protected byte getNumberType(double value) {
        return this.getNumberType(value, value);
    }

    protected boolean isMarkerOnly(byte marker) {
        return marker == 84 || marker == 70 || marker == 90;
    }

    protected boolean isSingleByte(byte marker) {
        return marker == 105 || marker == 85;
    }

    protected void writeObject(JsonObject object) throws IOException {
        this.output.write(123);
        this.writeRawObject(object);
    }

    protected void writeRawObject(JsonObject object) throws IOException {
        if (object.isEmpty()) {
            this.output.write(125);
        } else if (this.typing == UBTyping.WEAK) {
            this.writeGenericObject(object);
        } else {
            byte type = this.getCompressionType((JsonContainer)object);
            if (type != 0) {
                this.writeOptimizedObject(object, type);
            } else if (this.typing == UBTyping.COMPRESSED) {
                this.writeGenericObject(object);
            } else {
                this.writeSizedObject(object);
            }
        }
    }

    protected void writeSizedObject(JsonObject object) throws IOException {
        this.output.write(35);
        this.writeInt(object.size());
        for (JsonObject.Member member : object) {
            this.writeRawString(member.getKey());
            this.writeValue(member.getOnly());
        }
    }

    protected void writeGenericObject(JsonObject object) throws IOException {
        for (JsonObject.Member member : object) {
            this.writeRawString(member.getKey());
            this.writeValue(member.getOnly());
        }
        this.output.write(125);
    }

    protected void writeOptimizedObject(JsonObject object, byte type) throws IOException {
        this.output.write(36);
        this.output.write(type);
        this.output.write(35);
        this.writeInt(object.size());
        for (JsonObject.Member member : object) {
            this.writeRawString(member.getKey());
            this.writeRawValue(member.getOnly(), type);
        }
    }

    protected void writeValue(JsonValue value) throws IOException {
        switch (value.getType()) {
            case NUMBER: {
                this.writeNumber(value.asDouble());
                break;
            }
            case ARRAY: {
                this.writeArray(value.asArray());
                break;
            }
            case OBJECT: {
                this.writeObject(value.asObject());
                break;
            }
            case BOOLEAN: {
                this.writeBool(value.asBoolean());
                break;
            }
            case STRING: {
                this.writeString(value.asString());
                break;
            }
            default: {
                this.writeNull();
            }
        }
    }

    protected void writeRawValue(JsonValue value, byte type) throws IOException {
        switch (type) {
            case 105: {
                this.writeRawInt8((byte)value.asDouble());
                break;
            }
            case 85: {
                this.writeRawUInt8((short)value.asDouble());
                break;
            }
            case 73: {
                this.writeRawInt16((short)value.asDouble());
                break;
            }
            case 108: {
                this.writeRawInt32(value.asInt());
                break;
            }
            case 76: {
                this.writeRawInt64(value.asLong());
                break;
            }
            case 100: {
                this.writeRawFloat32(value.asFloat());
                break;
            }
            case 68: {
                this.writeRawFloat64(value.asDouble());
                break;
            }
            case 83: {
                this.writeRawString(value.asString());
                break;
            }
            case 91: {
                this.writeRawArray(value.asArray());
                break;
            }
            case 123: {
                this.writeRawObject(value.asObject());
                break;
            }
            case 70: 
            case 84: 
            case 90: {
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognized marker: " + (char)type);
            }
        }
    }

    public void close() throws Exception {
        this.output.close();
    }
}

