/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.organization;

import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.container.configuration.ConfigurationException;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.organization.GroupHandlerImpl;
import org.exoplatform.services.jcr.ext.organization.JCRCacheHandler;
import org.exoplatform.services.jcr.ext.organization.MembershipHandlerImpl;
import org.exoplatform.services.jcr.ext.organization.MembershipTypeHandlerImpl;
import org.exoplatform.services.jcr.ext.organization.MigrationTool;
import org.exoplatform.services.jcr.ext.organization.UserHandlerImpl;
import org.exoplatform.services.jcr.ext.organization.UserProfileHandlerImpl;
import org.exoplatform.services.jcr.ext.registry.RegistryService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.BaseOrganizationService;
import org.picocontainer.Startable;

public class JCROrganizationServiceImpl
extends BaseOrganizationService
implements Startable {
    public static final String REPOSITORY_NAME = "repository";
    public static final String STORAGE_PATH = "storage-path";
    public static final String STORAGE_WORKSPACE = "storage-workspace";
    public static final String CACHE_ENABLED = "cache-enabled";
    public static final String STORAGE_PATH_DEFAULT = "/exo:organization";
    protected RepositoryService repositoryService;
    protected RegistryService registryService;
    protected String storagePath;
    protected String repositoryName;
    protected String storageWorkspace;
    protected boolean cacheEnabled;
    protected JCRCacheHandler cacheHandler;
    public static final String STORAGE_JOS_GROUPS = "jos:groups";
    public static final String STORAGE_JOS_MEMBERSHIP_TYPES = "jos:membershipTypes";
    public static final String STORAGE_JOS_USERS = "jos:users";
    public static final String JOS_PROFILE = "jos:profile";
    public static final String JOS_MEMBERSHIP = "jos:memberships";
    public static final String JOS_MEMBERSHIP_TYPE_ANY = "jos:membershipTypeAny";
    public static final String JOS_HIERARCHY_GROUP_NODETYPE = "jos:hierarchyGroup-v2";
    public static final String JOS_USERS_NODETYPE = "jos:user-v2";
    public static final String JOS_DISABLED = "jos:disabled";
    public static final String STORAGE_NODETYPE = "jos:organizationStorage-v2";
    public static final String STORAGE_JOS_USERS_NODETYPE = "jos:organizationUsers-v2";
    public static final String STORAGE_JOS_GROUPS_NODETYPE = "jos:organizationGroups-v2";
    public static final String STORAGE_JOS_MEMBERSHIP_TYPES_NODETYPE = "jos:organizationMembershipTypes-v2";
    public static final boolean CACHE_ENABLED_DEFAULT = true;
    private static final Log LOG = ExoLogger.getLogger((String)"exo-jcr-services.JCROrganizationService");

    public JCROrganizationServiceImpl(InitParams params, RepositoryService repositoryService, CacheService cservice) throws ConfigurationException {
        this(params, repositoryService, null, cservice);
    }

    public JCROrganizationServiceImpl(InitParams initParams, RepositoryService repositoryService, RegistryService registryService, CacheService cservice) throws ConfigurationException {
        this.repositoryService = repositoryService;
        this.registryService = registryService;
        this.initializeParameters(initParams);
        this.cacheHandler = new JCRCacheHandler(cservice, this, this.cacheEnabled);
        if (initParams == null) {
            throw new ConfigurationException("Initialization parameters expected !!!");
        }
        this.membershipDAO_ = new MembershipHandlerImpl(this);
        this.groupDAO_ = new GroupHandlerImpl(this);
        this.userDAO_ = new UserHandlerImpl(this);
        this.userProfileDAO_ = new UserProfileHandlerImpl(this);
        this.membershipTypeDAO_ = new MembershipTypeHandlerImpl(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        try {
            MigrationTool migrationTool = new MigrationTool(this);
            if (migrationTool.migrationRequired()) {
                LOG.info((Object)"Detected old organization service structure.");
                migrationTool.migrate();
            }
            Session session = this.getStorageSession();
            try {
                session.getItem(this.storagePath);
            }
            catch (PathNotFoundException e) {
                this.createStructure();
            }
            finally {
                session.logout();
            }
        }
        catch (RepositoryException e) {
            throw new IllegalArgumentException("Can not configure storage", e);
        }
        super.start();
    }

    public void stop() {
        super.stop();
    }

    JCRCacheHandler getCacheHandler() {
        return this.cacheHandler;
    }

    String getStoragePath() throws RepositoryException {
        if (this.storagePath == null) {
            throw new RepositoryException("Can not get storage path because JCROrganizationService is not started");
        }
        return this.storagePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createStructure() throws RepositoryException {
        Session session = this.getStorageSession();
        try {
            Node storage = session.getRootNode().addNode(this.storagePath.substring(1), STORAGE_NODETYPE);
            storage.addNode(STORAGE_JOS_USERS, STORAGE_JOS_USERS_NODETYPE);
            storage.addNode(STORAGE_JOS_GROUPS, STORAGE_JOS_GROUPS_NODETYPE);
            Node storageTypesNode = storage.addNode(STORAGE_JOS_MEMBERSHIP_TYPES, STORAGE_JOS_MEMBERSHIP_TYPES_NODETYPE);
            storageTypesNode.addNode(JOS_MEMBERSHIP_TYPE_ANY);
            session.save();
        }
        finally {
            session.logout();
        }
    }

    Session getStorageSession() throws RepositoryException {
        try {
            ManageableRepository repository = this.getWorkingRepository();
            String workspaceName = this.storageWorkspace;
            if (workspaceName == null) {
                workspaceName = repository.getConfiguration().getDefaultWorkspaceName();
            }
            return repository.getSystemSession(workspaceName);
        }
        catch (RepositoryConfigurationException e) {
            throw new RepositoryException("Can not get system session", (Throwable)e);
        }
    }

    private void initializeParameters(InitParams initParams) {
        ValueParam paramRepository = initParams.getValueParam(REPOSITORY_NAME);
        this.repositoryName = paramRepository != null ? paramRepository.getValue() : null;
        ValueParam paramStoragePath = initParams.getValueParam(STORAGE_PATH);
        this.storagePath = paramStoragePath != null ? paramStoragePath.getValue() : STORAGE_PATH_DEFAULT;
        ValueParam paramStorageWorkspace = initParams.getValueParam(STORAGE_WORKSPACE);
        this.storageWorkspace = paramStorageWorkspace != null ? paramStorageWorkspace.getValue() : null;
        ValueParam paramDisableCache = initParams.getValueParam(CACHE_ENABLED);
        boolean bl = this.cacheEnabled = paramDisableCache != null ? Boolean.parseBoolean(paramDisableCache.getValue()) : true;
        if (this.repositoryName != null) {
            LOG.info((Object)("Repository from configuration file: " + this.repositoryName));
        }
        if (this.storageWorkspace != null) {
            LOG.info((Object)("Workspace from configuration file: " + this.storageWorkspace));
        }
        if (this.storagePath != null) {
            LOG.info((Object)("Root node from configuration file: " + this.storagePath));
        }
        LOG.info((Object)("Cache is " + (this.cacheEnabled ? "enabled" : "disabled")));
    }

    protected ManageableRepository getWorkingRepository() throws RepositoryException, RepositoryConfigurationException {
        return this.repositoryName != null ? this.repositoryService.getRepository(this.repositoryName) : this.repositoryService.getCurrentRepository();
    }
}

