/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl.method;

import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyReader;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.ApplicationContext;
import org.exoplatform.services.rest.FilterDescriptor;
import org.exoplatform.services.rest.ObjectFactory;
import org.exoplatform.services.rest.impl.InternalException;
import org.exoplatform.services.rest.impl.method.ParameterResolver;
import org.exoplatform.services.rest.impl.method.ParameterResolverFactory;
import org.exoplatform.services.rest.method.MethodInvoker;
import org.exoplatform.services.rest.method.MethodInvokerFilter;
import org.exoplatform.services.rest.method.MethodParameter;
import org.exoplatform.services.rest.resource.GenericMethodResource;

public class DefaultMethodInvoker
implements MethodInvoker {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.ws.rest.core.DefaultMethodInvoker");

    public Object invokeMethod(Object resource, GenericMethodResource methodResource, ApplicationContext context) {
        for (ObjectFactory<FilterDescriptor> factory : context.getProviders().getMethodInvokerFilters(context.getPath())) {
            MethodInvokerFilter f = (MethodInvokerFilter)factory.getInstance(context);
            f.accept(methodResource);
        }
        Object[] p = new Object[methodResource.getMethodParameters().size()];
        int i = 0;
        for (MethodParameter mp : methodResource.getMethodParameters()) {
            Annotation a = mp.getAnnotation();
            if (a != null) {
                ParameterResolver pr = ParameterResolverFactory.createParameterResolver(a);
                try {
                    p[i++] = pr.resolve(mp, context);
                    continue;
                }
                catch (Exception e) {
                    String msg = "Not able resolve method parameter " + mp;
                    Class<? extends Annotation> ac = a.annotationType();
                    if (ac == MatrixParam.class || ac == QueryParam.class || ac == PathParam.class) {
                        throw new WebApplicationException((Throwable)e, Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)msg).type("text/plain").build());
                    }
                    throw new WebApplicationException((Throwable)e, Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)msg).type("text/plain").build());
                }
            }
            InputStream entityStream = context.getContainerRequest().getEntityStream();
            if (entityStream == null) {
                p[i++] = null;
                continue;
            }
            MediaType contentType = context.getContainerRequest().getMediaType();
            MessageBodyReader<?> entityReader = context.getProviders().getMessageBodyReader(mp.getParameterClass(), mp.getGenericType(), mp.getAnnotations(), contentType);
            if (entityReader == null) {
                List contentLength = context.getContainerRequest().getRequestHeader("Content-Length");
                int length = 0;
                if (contentLength != null && contentLength.size() > 0) {
                    length = Integer.parseInt((String)contentLength.get(0));
                }
                if (contentType == null && length == 0) {
                    p[i++] = null;
                    continue;
                }
                String msg = "Media type " + contentType + " is not supported. There is no corresponded entity reader.";
                if (LOG.isDebugEnabled()) {
                    LOG.warn((Object)msg);
                }
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.UNSUPPORTED_MEDIA_TYPE).entity((Object)msg).type("text/plain").build());
            }
            try {
                MultivaluedMap headers = context.getContainerRequest().getRequestHeaders();
                p[i++] = entityReader.readFrom(mp.getParameterClass(), mp.getGenericType(), mp.getAnnotations(), contentType, headers, entityStream);
            }
            catch (WebApplicationException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                }
                throw e;
            }
            catch (Exception e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                }
                throw new InternalException(e);
            }
        }
        return this.invokeMethod(resource, methodResource, p);
    }

    protected Object invokeMethod(final Object resource, final GenericMethodResource methodResource, final Object[] p) {
        try {
            return SecurityHelper.doPrivilegedExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    return methodResource.getMethod().invoke(resource, p);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Throwable cause = pae.getCause();
            if (cause instanceof IllegalArgumentException) {
                throw new InternalException(cause);
            }
            if (cause instanceof IllegalAccessException) {
                throw new InternalException(cause);
            }
            if (cause instanceof InvocationTargetException) {
                Throwable throwable;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)cause.getLocalizedMessage(), cause);
                }
                if (WebApplicationException.class == (throwable = cause.getCause()).getClass()) {
                    throw (WebApplicationException)throwable;
                }
                throw new InternalException(throwable);
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }
}

