/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.common.p3p;

public final class P3PConstants {
    private static final String POSTAL_NAME = "postal.name";
    private static final String POSTAL_STREET = "postal.street";
    private static final String POSTAL_CITY = "postal.city";
    private static final String POSTAL_STATEPROV = "postal.stateprov";
    private static final String POSTAL_POSTALCODE = "postal.postalcode";
    private static final String POSTAL_COUNTRY = "postal.country";
    private static final String POSTAL_ORGANIZATION = "postal.organization";
    private static final String TELECOM_TELEPHONE = "telecom.telephone.";
    private static final String TELECOM_FAX = "telecom.fax.";
    private static final String TELECOM_MOBILE = "telecom.mobile.";
    private static final String TELECOM_PAGER = "telecom.pager.";
    private static final String TELECOM_INTCODE = "intcode";
    private static final String TELECOM_LOCCODE = "loccode";
    private static final String TELECOM_NUMBER = "number";
    private static final String TELECOM_EXT = "ext";
    private static final String TELECOM_COMMENT = "comment";
    private static final String ONLINE_URI = "online.uri";
    private static final String ONLINE_EMAIL = "online.email";
    public static final String INFO_USER_BDATE = "user.bdate";
    private static final String INFO_USER_BDATE_YMD = "user.bdate.ymd";
    public static final String INFO_USER_BDATE_YMD_YEAR = "user.bdate.ymd.year";
    public static final String INFO_USER_BDATE_YMD_MONTH = "user.bdate.ymd.month";
    public static final String INFO_USER_BDATE_YMD_DAY = "user.bdate.ymd.day";
    private static final String INFO_USER_BDATE_HMS = "user.bdate.hms";
    public static final String INFO_USER_BDATE_HMS_HOUR = "user.bdate.hms.hour";
    public static final String INFO_USER_BDATE_HMS_MINUTE = "user.bdate.hms.minute";
    public static final String INFO_USER_BDATE_HMS_SECOND = "user.bdate.hms.second";
    public static final String INFO_USER_BDATE_FRACTIONSECOND = "user.bdate.fractionsecond";
    public static final String INFO_USER_BDATE_TIMEZONE = "user.bdate.timezone";
    public static final String INFO_USER_GENDER = "user.gender";
    public static final String INFO_USER_EMPLOYER = "user.employer";
    public static final String INFO_USER_DEPARTMENT = "user.department";
    public static final String INFO_USER_JOB_TITLE = "user.jobtitle";
    public static final String INFO_USER_NAME_PREFIX = "user.name.prefix";
    public static final String INFO_USER_NAME_GIVEN = "user.name.given";
    public static final String INFO_USER_NAME_FAMILY = "user.name.family";
    public static final String INFO_USER_NAME_MIDDLE = "user.name.middle";
    public static final String INFO_USER_NAME_SUFFIX = "user.name.suffix";
    public static final String INFO_USER_NAME_NICKNAME = "user.name.nickName";
    public static final String INFO_USER_LOGIN_ID = "user.login.id";
    private static final String INFO_USER_HOME_PREFIX = "user.home-info.";
    public static final String INFO_USER_HOME_INFO_POSTAL_NAME = "user.home-info.postal.name";
    public static final String INFO_USER_HOME_INFO_POSTAL_STREET = "user.home-info.postal.street";
    public static final String INFO_USER_HOME_INFO_POSTAL_CITY = "user.home-info.postal.city";
    public static final String INFO_USER_HOME_INFO_POSTAL_STATEPROV = "user.home-info.postal.stateprov";
    public static final String INFO_USER_HOME_INFO_POSTAL_POSTALCODE = "user.home-info.postal.postalcode";
    public static final String INFO_USER_HOME_INFO_POSTAL_COUNTRY = "user.home-info.postal.country";
    public static final String INFO_USER_HOME_INFO_POSTAL_ORGANIZATION = "user.home-info.postal.organization";
    public static final String INFO_USER_HOME_INFO_TELECOM_TELEPHONE_INTCODE = "user.home-info.telecom.telephone.intcode";
    public static final String INFO_USER_HOME_INFO_TELECOM_TELEPHONE_LOCCODE = "user.home-info.telecom.telephone.loccode";
    public static final String INFO_USER_HOME_INFO_TELECOM_TELEPHONE_NUMBER = "user.home-info.telecom.telephone.number";
    public static final String INFO_USER_HOME_INFO_TELECOM_TELEPHONE_EXT = "user.home-info.telecom.telephone.ext";
    public static final String INFO_USER_HOME_INFO_TELECOM_TELEPHONE_COMMENT = "user.home-info.telecom.telephone.comment";
    public static final String INFO_USER_HOME_INFO_TELECOM_FAX_INTCODE = "user.home-info.telecom.fax.intcode";
    public static final String INFO_USER_HOME_INFO_TELECOM_FAX_LOCCODE = "user.home-info.telecom.fax.loccode";
    public static final String INFO_USER_HOME_INFO_TELECOM_FAX_NUMBER = "user.home-info.telecom.fax.number";
    public static final String INFO_USER_HOME_INFO_TELECOM_FAX_EXT = "user.home-info.telecom.fax.ext";
    public static final String INFO_USER_HOME_INFO_TELECOM_FAX_COMMENT = "user.home-info.telecom.fax.comment";
    public static final String INFO_USER_HOME_INFO_TELECOM_MOBILE_INTCODE = "user.home-info.telecom.mobile.intcode";
    public static final String INFO_USER_HOME_INFO_TELECOM_MOBILE_LOCCODE = "user.home-info.telecom.mobile.loccode";
    public static final String INFO_USER_HOME_INFO_TELECOM_MOBILE_NUMBER = "user.home-info.telecom.mobile.number";
    public static final String INFO_USER_HOME_INFO_TELECOM_MOBILE_EXT = "user.home-info.telecom.mobile.ext";
    public static final String INFO_USER_HOME_INFO_TELECOM_MOBILE_COMMENT = "user.home-info.telecom.mobile.comment";
    public static final String INFO_USER_HOME_INFO_TELECOM_PAGER_INTCODE = "user.home-info.telecom.pager.intcode";
    public static final String INFO_USER_HOME_INFO_TELECOM_PAGER_LOCCODE = "user.home-info.telecom.pager.loccode";
    public static final String INFO_USER_HOME_INFO_TELECOM_PAGER_NUMBER = "user.home-info.telecom.pager.number";
    public static final String INFO_USER_HOME_INFO_TELECOM_PAGER_EXT = "user.home-info.telecom.pager.ext";
    public static final String INFO_USER_HOME_INFO_TELECOM_PAGER_COMMENT = "user.home-info.telecom.pager.comment";
    public static final String INFO_USER_HOME_INFO_ONLINE_EMAIL = "user.home-info.online.email";
    public static final String INFO_USER_HOME_INFO_ONLINE_URI = "user.home-info.online.uri";
    private static final String INFO_USER_BUSINESS_PREFIX = "user.business-info.";
    public static final String INFO_USER_BUSINESS_INFO_POSTAL_NAME = "user.business-info.postal.name";
    public static final String INFO_USER_BUSINESS_INFO_POSTAL_STREET = "user.business-info.postal.street";
    public static final String INFO_USER_BUSINESS_INFO_POSTAL_CITY = "user.business-info.postal.city";
    public static final String INFO_USER_BUSINESS_INFO_POSTAL_STATEPROV = "user.business-info.postal.stateprov";
    public static final String INFO_USER_BUSINESS_INFO_POSTAL_POSTALCODE = "user.business-info.postal.postalcode";
    public static final String INFO_USER_BUSINESS_INFO_POSTAL_COUNTRY = "user.business-info.postal.country";
    public static final String INFO_USER_BUSINESS_INFO_POSTAL_ORGANIZATION = "user.business-info.postal.organization";
    public static final String INFO_USER_BUSINESS_INFO_TELECOM_TELEPHONE_INTCODE = "user.business-info.telecom.telephone.intcode";
    public static final String INFO_USER_BUSINESS_INFO_TELECOM_TELEPHONE_LOCCODE = "user.business-info.telecom.telephone.loccode";
    public static final String INFO_USER_BUSINESS_INFO_TELECOM_TELEPHONE_NUMBER = "user.business-info.telecom.telephone.number";
    public static final String INFO_USER_BUSINESS_INFO_TELECOM_TELEPHONE_EXT = "user.business-info.telecom.telephone.ext";
    public static final String INFO_USER_BUSINESS_INFO_TELECOM_TELEPHONE_COMMENT = "user.business-info.telecom.telephone.comment";
    public static final String INFO_USER_BUSINESS_INFO_TELECOM_FAX_INTCODE = "user.business-info.telecom.fax.intcode";
    public static final String INFO_USER_BUSINESS_INFO_TELECOM_FAX_LOCCODE = "user.business-info.telecom.fax.loccode";
    public static final String INFO_USER_BUSINESS_INFO_TELECOM_FAX_NUMBER = "user.business-info.telecom.fax.number";
    public static final String INFO_USER_BUSINESS_INFO_TELECOM_FAX_EXT = "user.business-info.telecom.fax.ext";
    public static final String INFO_USER_BUSINESS_INFO_TELECOM_FAX_COMMENT = "user.business-info.telecom.fax.comment";
    public static final String INFO_USER_BUSINESS_INFO_TELECOM_MOBILE_INTCODE = "user.business-info.telecom.mobile.intcode";
    public static final String INFO_USER_BUSINESS_INFO_TELECOM_MOBILE_LOCCODE = "user.business-info.telecom.mobile.loccode";
    public static final String INFO_USER_BUSINESS_INFO_TELECOM_MOBILE_NUMBER = "user.business-info.telecom.mobile.number";
    public static final String INFO_USER_BUSINESS_INFO_TELECOM_MOBILE_EXT = "user.business-info.telecom.mobile.ext";
    public static final String INFO_USER_BUSINESS_INFO_TELECOM_MOBILE_COMMENT = "user.business-info.telecom.mobile.comment";
    public static final String INFO_USER_BUSINESS_INFO_TELECOM_PAGER_INTCODE = "user.business-info.telecom.pager.intcode";
    public static final String INFO_USER_BUSINESS_INFO_TELECOM_PAGER_LOCCODE = "user.business-info.telecom.pager.loccode";
    public static final String INFO_USER_BUSINESS_INFO_TELECOM_PAGER_NUMBER = "user.business-info.telecom.pager.number";
    public static final String INFO_USER_BUSINESS_INFO_TELECOM_PAGER_EXT = "user.business-info.telecom.pager.ext";
    public static final String INFO_USER_BUSINESS_INFO_TELECOM_PAGER_COMMENT = "user.business-info.telecom.pager.comment";
    public static final String INFO_USER_BUSINESS_INFO_ONLINE_EMAIL = "user.business-info.online.email";
    public static final String INFO_USER_BUSINESS_INFO_ONLINE_URI = "user.business-info.online.uri";

    private P3PConstants() {
    }

    private static String getHomeOrBusinessPrefix(boolean isBusiness) {
        return isBusiness ? INFO_USER_BUSINESS_PREFIX : INFO_USER_HOME_PREFIX;
    }

    public static String getPostalUserInfoKey(PostalInfo info, boolean isBusiness) {
        return P3PConstants.getHomeOrBusinessPrefix(isBusiness) + info.getName();
    }

    public static String getTelecomInfoKey(TelecomType type, TelecomInfo info, boolean isBusiness) {
        return P3PConstants.getHomeOrBusinessPrefix(isBusiness) + type.getPrefix() + info.getName();
    }

    public static String getOnlineUserInfoKey(OnlineInfo info, boolean isBusiness) {
        return P3PConstants.getHomeOrBusinessPrefix(isBusiness) + info.getName();
    }

    public static enum OnlineInfo {
        EMAIL("online.email"),
        URI("online.uri");

        private final String name;

        private OnlineInfo(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static enum PostalInfo {
        NAME("postal.name"),
        STREET("postal.street"),
        CITY("postal.city"),
        STATEPROV("postal.stateprov"),
        POSTALCODE("postal.postalcode"),
        COUNTRY("postal.country"),
        ORGANIZATION("postal.organization");

        private final String name;

        private PostalInfo(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static enum TelecomInfo {
        INTCODE("intcode"),
        LOCCODE("loccode"),
        NUMBER("number"),
        EXT("ext"),
        COMMENT("comment");

        private final String name;

        private TelecomInfo(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static enum TelecomType {
        TELEPHONE("telecom.telephone."),
        FAX("telecom.fax."),
        MOBILE("telecom.mobile."),
        PAGER("telecom.pager.");

        private final String prefix;

        private TelecomType(String prefix) {
            this.prefix = prefix;
        }

        public String getPrefix() {
            return this.prefix;
        }
    }
}

