/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.applications.ooplugin.client;

import org.exoplatform.applications.ooplugin.client.DavCommand;
import org.exoplatform.applications.ooplugin.client.DocumentApi;
import org.exoplatform.applications.ooplugin.client.DocumentManager;
import org.exoplatform.applications.ooplugin.client.Multistatus;
import org.exoplatform.applications.ooplugin.client.WebDavContext;
import org.exoplatform.applications.ooplugin.props.PropertyList;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class MultistatusCommand
extends DavCommand {
    private static final Log LOG = ExoLogger.getLogger(MultistatusCommand.class);
    protected PropertyList propList = new PropertyList();
    protected String xmlName = "propfind";
    protected DocumentApi multistatusDocument = null;

    public MultistatusCommand(WebDavContext context) throws Exception {
        super(context);
    }

    public void requireAllProperties() {
        this.propList.clearProperies();
    }

    public void setRequiredProperty(String name, String nameSpace) {
        this.propList.setProperty(name, nameSpace);
    }

    public void setRequiredProperty(String name) {
        this.propList.setProperty(name, "DAV:");
    }

    public void isPropNamesRequired(boolean isPropNames) {
        this.propList.isPropNamesRequired(isPropNames);
    }

    public Element toXml(Document xmlDocument) {
        Element propFindEl = xmlDocument.createElementNS("DAV:", "A:" + this.xmlName);
        xmlDocument.appendChild(propFindEl);
        propFindEl.appendChild(this.propList.toXml(xmlDocument));
        return propFindEl;
    }

    public void finalExecute() {
        try {
            if (this.client.getReplyCode() != 207) {
                return;
            }
        }
        catch (Exception exc) {
            LOG.info((Object)("Unhandled exception. " + exc.getMessage()), (Throwable)exc);
        }
        this.multistatusDocument = DocumentManager.getResponseDocument(this.client.getResponseStream());
    }

    public Multistatus getMultistatus() {
        return (Multistatus)this.multistatusDocument;
    }
}

