/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.applications.ooplugin.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.BitSet;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

public class TextUtils {
    public static final char[] hexTable;
    public static BitSet URISave;
    public static BitSet URISaveEx;

    public static Document getXmlFromBytes(byte[] xmlBytes) throws Exception {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(xmlBytes);
        return builderFactory.newDocumentBuilder().parse(inputStream);
    }

    public static String Escape(String string, char escape, boolean isPath) {
        try {
            BitSet validChars = isPath ? URISaveEx : URISave;
            byte[] bytes = string.getBytes("utf-8");
            StringBuffer out = new StringBuffer(bytes.length);
            for (int i = 0; i < bytes.length; ++i) {
                int c = bytes[i] & 0xFF;
                if (validChars.get(c) && c != escape) {
                    out.append((char)c);
                    continue;
                }
                out.append(escape);
                out.append(hexTable[c >> 4 & 0xF]);
                out.append(hexTable[c & 0xF]);
            }
            return out.toString();
        }
        catch (Exception exc) {
            throw new InternalError(exc.toString());
        }
    }

    public static String UnEscape(String string, char escape) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == escape) {
                try {
                    out.write(Integer.parseInt(string.substring(i + 1, i + 3), 16));
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException();
                }
                i += 2;
                continue;
            }
            out.write(c);
        }
        try {
            return new String(out.toByteArray(), "utf-8");
        }
        catch (Exception exc) {
            throw new InternalError(exc.toString());
        }
    }

    public static String getMimeType(String type) {
        if (type.equalsIgnoreCase(".odt")) {
            return "application/vnd.oasis.opendocument.text";
        }
        if (type.equalsIgnoreCase(".odp")) {
            return "application/vnd.oasis.opendocument.presentation";
        }
        if (type.equalsIgnoreCase(".ods")) {
            return "application/vnd.oasis.opendocument.spreadsheet";
        }
        if (type.equalsIgnoreCase(".doc")) {
            return "application/msword";
        }
        if (type.equalsIgnoreCase(".ppt")) {
            return "application/vnd.ms-powerpoint ";
        }
        if (type.equalsIgnoreCase(".xls")) {
            return "application/msexcel";
        }
        if (type.equalsIgnoreCase(".rtf")) {
            return "application/vnd.oasis.opendocument.spreadsheet";
        }
        return "";
    }

    public static String EncodePath(String path) throws Exception {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        String[] pathElements = path.split("/");
        StringBuffer sb = new StringBuffer();
        for (String string : pathElements) {
            sb.append("/").append(URLEncoder.encode(string, "UTF-8"));
        }
        return sb.toString();
    }

    public static String DecodePath(String path) throws Exception {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        String[] pathElements = path.split("/");
        StringBuffer sb = new StringBuffer();
        for (String string : pathElements) {
            sb.append("/").append(URLDecoder.decode(string, "UTF-8"));
        }
        return sb.toString();
    }

    public static String FilterFileName(String filename) {
        while (filename.startsWith(" ")) {
            filename = filename.substring(1);
        }
        filename = filename.substring(0, filename.indexOf("."));
        return filename;
    }

    static {
        int i;
        hexTable = "0123456789abcdef".toCharArray();
        URISave = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            URISave.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            URISave.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            URISave.set(i);
        }
        URISave.set(45);
        URISave.set(95);
        URISave.set(46);
        URISave.set(33);
        URISave.set(126);
        URISave.set(42);
        URISave.set(39);
        URISave.set(40);
        URISave.set(41);
        URISave.set(58);
        URISave.set(63);
        URISave.set(61);
        URISaveEx = (BitSet)URISave.clone();
        URISaveEx.set(47);
    }
}

