/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.applications.ooplugin.utils;

import java.io.File;
import java.io.FileInputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.exoplatform.applications.ooplugin.WebDavConfig;
import org.exoplatform.common.http.client.CookieModule;
import org.exoplatform.common.http.client.HTTPConnection;

public class WebDavUtils {
    public static HTTPConnection getAuthConnection(WebDavConfig config) {
        CookieModule.setCookiePolicyHandler(null);
        HTTPConnection connection = new HTTPConnection(config.getHost(), config.getPort());
        connection.addBasicAuthorization("eXo REST services", config.getUserId(), config.getUserPass());
        return connection;
    }

    public static String getFullPath(WebDavConfig config) {
        String host = config.getHost();
        int port = config.getPort();
        String path = config.getServlet();
        String repository = config.getRepository();
        String workspace = config.getWorkSpace();
        String fullPath = "http://" + host + ":" + port + path + repository + "/" + workspace;
        return fullPath;
    }

    public static byte[] getBytes(File inFile) throws Exception {
        FileInputStream fis = new FileInputStream(inFile);
        FileChannel fc = fis.getChannel();
        byte[] data = new byte[(int)fc.size()];
        ByteBuffer bb = ByteBuffer.wrap(data);
        fc.read(bb);
        return data;
    }
}

