/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.applications.ooplugin;

import com.sun.star.awt.ActionEvent;
import com.sun.star.awt.XComboBox;
import com.sun.star.awt.XTextComponent;
import com.sun.star.awt.XToolkit;
import com.sun.star.awt.XWindow;
import com.sun.star.beans.PropertyValue;
import com.sun.star.document.XDocumentInfo;
import com.sun.star.document.XDocumentInfoSupplier;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XModel;
import com.sun.star.frame.XModuleManager;
import com.sun.star.frame.XStorable;
import com.sun.star.io.IOException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.uri.ExternalUriReferenceTranslator;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import org.exoplatform.applications.ooplugin.BrowseDialog;
import org.exoplatform.applications.ooplugin.LocalFileSystem;
import org.exoplatform.applications.ooplugin.WebDavConfig;
import org.exoplatform.applications.ooplugin.client.ResponseDoc;
import org.exoplatform.applications.ooplugin.config.FilterListLoader;
import org.exoplatform.applications.ooplugin.config.FilterType;
import org.exoplatform.applications.ooplugin.dialog.DialogException;
import org.exoplatform.applications.ooplugin.events.ActionListener;
import org.exoplatform.applications.ooplugin.props.DisplayNameProp;
import org.exoplatform.applications.ooplugin.utils.TextUtils;
import org.exoplatform.applications.ooplugin.utils.WebDavUtils;
import org.exoplatform.common.http.client.HTTPConnection;
import org.exoplatform.common.http.client.HTTPResponse;
import org.exoplatform.common.http.client.NVPair;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class SaveDialog
extends BrowseDialog {
    private static final Log LOG = ExoLogger.getLogger(SaveDialog.class);
    public static final String DIALOG_NAME = "_SaveDialog";
    private Thread launchThread;
    private Thread enableSaveThread;
    private XMultiComponentFactory xMultiComponentFactory;
    private XStorable xStorable;
    private XDocumentInfo xDocumentInfo;
    private XModel xModel;
    private String localFilePath = "";
    private String currentModelName = "";
    private static final String EDT_NAME = "edtName";
    private static final String COMBO_TYPE = "edtType";
    private static final String BTN_SAVE = "btnSave";
    private boolean isSaveAs = false;
    private String oldFileName = "";
    private FilterListLoader filterLoader = new FilterListLoader();

    public SaveDialog(WebDavConfig config, XComponentContext xComponentContext, XFrame xFrame, XToolkit xToolkit, boolean isSaveAs) {
        super(config, xComponentContext, xFrame, xToolkit);
        this.dialogName = DIALOG_NAME;
        this.isSaveAs = isSaveAs;
        this.addHandler(BTN_SAVE, 1, new SaveClick());
        this.launchThread = new LaunchThread();
        this.launchThread.start();
    }

    protected void disableAll() {
        super.disableAll();
    }

    protected void enableAll() {
        super.enableAll();
    }

    protected String getEditFileName() {
        XTextComponent xComboText = (XTextComponent)UnoRuntime.queryInterface(XTextComponent.class, (Object)this.xControlContainer.getControl(EDT_NAME));
        return xComboText.getText();
    }

    protected void setEditFileName(String fileName) {
        XTextComponent xComboText = (XTextComponent)UnoRuntime.queryInterface(XTextComponent.class, (Object)this.xControlContainer.getControl(EDT_NAME));
        xComboText.setText(fileName);
    }

    protected void doSelectItem() {
        int selectedPos = this.getSelectedItemPos();
        if (selectedPos < 0) {
            return;
        }
        ResponseDoc response = (ResponseDoc)this.responses.get(selectedPos);
        if (this.isCollection(response)) {
            this.doPropFindResponse(response);
        } else {
            try {
                DisplayNameProp displayNameProperty = (DisplayNameProp)response.getProperty("displayname");
                this.setEditFileName(displayNameProperty.getDisplayName());
            }
            catch (Exception exc) {
                LOG.info((Object)("Can't open remote file... " + exc.getMessage()), (Throwable)exc);
            }
        }
    }

    public String[] getTypedFileInfo() throws DialogException {
        String fileName = this.getEditFileName();
        return this.getTypedFileInfo(fileName);
    }

    public String[] getTypedFileInfo(String fileName) throws DialogException {
        XComboBox xComboType = (XComboBox)UnoRuntime.queryInterface(XComboBox.class, (Object)this.xControlContainer.getControl(COMBO_TYPE));
        String comboText = this.getEditFilterValue();
        int index = -1;
        for (int i = 0; i < xComboType.getItemCount(); ++i) {
            String comboValue = xComboType.getItem((short)i);
            if (!comboValue.equals(comboText)) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new DialogException("Can't use this type of file!!!");
        }
        ArrayList<FilterType> filters = this.filterLoader.getFilterTypes(this.currentModelName);
        FilterType filter = filters.get(index);
        String[] fileInfo = new String[2];
        if (!fileName.endsWith("." + filter.getFileExtension())) {
            fileName = fileName + "." + filter.getFileExtension();
        }
        fileInfo[0] = fileName;
        fileInfo[1] = filter.getApiName();
        return fileInfo;
    }

    protected void doSaveFile() throws Exception {
        String[] fileInfo = this.getTypedFileInfo();
        String fileName = fileInfo[0];
        String filterName = fileInfo[1];
        if ("".equals(fileName)) {
            this.showMessageBox("File name required!");
            return;
        }
        if (!this.oldFileName.equals(fileName)) {
            boolean finded = false;
            for (int i = 0; i < this.responses.size(); ++i) {
                ResponseDoc response = (ResponseDoc)this.responses.get(i);
                DisplayNameProp displayNameProperty = (DisplayNameProp)response.getProperty("displayname");
                if (!displayNameProperty.getDisplayName().equals(fileName)) continue;
                finded = true;
                break;
            }
            if (finded) {
                short confirmResult = this.confirmMessageBox("Do you want to rewrite file " + fileName);
                if (confirmResult == 0) {
                    this.xDialog.endExecute();
                    return;
                }
                if (confirmResult == 3) {
                    return;
                }
            }
        }
        String storeToPath = LocalFileSystem.getDocumentsPath() + File.separatorChar + LocalFileSystem.STORAGEDIR + File.separatorChar + this.config.getWorkSpace() + this.currentPath;
        storeToPath = storeToPath.replace("\\", "/");
        this.prepareTmpPath(storeToPath);
        storeToPath = "/".equals(this.currentPath) ? storeToPath + fileName : storeToPath + "/" + fileName;
        storeToPath = storeToPath.replace("\\", "/");
        this.storeLocal(storeToPath, filterName);
        String repoFilePath = this.currentPath;
        repoFilePath = repoFilePath.endsWith("/") ? repoFilePath + fileName : repoFilePath + "/" + fileName;
        if (this.doSave(storeToPath, repoFilePath)) {
            this.xDialog.endExecute();
        }
    }

    protected void setSessionPath(String path) throws IndexOutOfBoundsException {
        this.showMessageBox("Set session path: " + path);
        this.xDocumentInfo.setUserFieldName((short)0, "eXoRemoteFileName");
        this.xDocumentInfo.setUserFieldValue((short)0, path);
    }

    protected String getSessionPath() throws IndexOutOfBoundsException {
        if (this.xDocumentInfo.getUserFieldName((short)0).compareTo("eXoRemoteFileName") == 0 && this.xDocumentInfo.getUserFieldValue((short)0).length() > 0) {
            return this.xDocumentInfo.getUserFieldValue((short)0);
        }
        return null;
    }

    public String getEditFilterValue() {
        XTextComponent xComboText = (XTextComponent)UnoRuntime.queryInterface(XTextComponent.class, (Object)this.xControlContainer.getControl(COMBO_TYPE));
        return xComboText.getText();
    }

    public void setEditFilterValue(String typeValue) {
        XTextComponent xComboText = (XTextComponent)UnoRuntime.queryInterface(XTextComponent.class, (Object)this.xControlContainer.getControl(COMBO_TYPE));
        xComboText.setText(typeValue);
    }

    public void storeLocal(String url, String filter) {
        try {
            PropertyValue asTemplate;
            String path = ExternalUriReferenceTranslator.create((XComponentContext)this.xComponentContext).translateToInternal("file:///" + url.replace("\\", "/"));
            if (path.length() == 0) {
                throw new RuntimeException();
            }
            PropertyValue[] loadProps = new PropertyValue[2];
            loadProps[0] = asTemplate = new PropertyValue();
            PropertyValue documentType = new PropertyValue();
            documentType.Name = "FilterName";
            documentType.Value = filter;
            loadProps[1] = documentType;
            this.xStorable.storeAsURL(path, loadProps);
        }
        catch (IOException e) {
            this.showMessageBox("Can't save file locally!!!!!!!!");
            LOG.info((Object)("Exception" + e.getMessage()), (Throwable)e);
        }
    }

    public boolean launchBeforeOpen() {
        if (!super.launchBeforeOpen()) {
            return false;
        }
        try {
            this.initDefaults();
        }
        catch (Exception pexc) {
            this.showMessageBox("Can't save document!");
            return false;
        }
        try {
            String remotePath;
            XComboBox xComboType = (XComboBox)UnoRuntime.queryInterface(XComboBox.class, (Object)this.xControlContainer.getControl(COMBO_TYPE));
            ArrayList<FilterType> filters = this.filterLoader.getFilterTypes(this.currentModelName);
            if (filters.size() != 0) {
                for (int i = filters.size() - 1; i >= 0; --i) {
                    FilterType currentFilter = filters.get(i);
                    String filterStr = currentFilter.getLocalizedName() + " [." + currentFilter.getFileExtension() + "]";
                    xComboType.addItem(filterStr, (short)0);
                    if (i != 0) continue;
                    this.setEditFilterValue(filterStr);
                }
            }
            if ("".equals(this.localFilePath)) {
                return true;
            }
            if (this.isSaveAs) {
                if (this.getSessionPath() != null) {
                    String onlyPath;
                    String sessPath = this.getSessionPath();
                    this.currentPath = onlyPath = sessPath.substring(0, sessPath.lastIndexOf("/"));
                    String onlyName = sessPath.substring(sessPath.lastIndexOf("/") + 1);
                    this.setEditFileName(onlyName);
                    this.oldFileName = onlyName;
                } else {
                    String onlyName = this.localFilePath.substring(this.localFilePath.lastIndexOf("/") + 1);
                    this.setEditFileName(onlyName);
                    this.oldFileName = onlyName;
                }
                return true;
            }
            String onlyName = this.localFilePath.substring(this.localFilePath.lastIndexOf("/") + 1);
            this.setEditFileName(onlyName);
            String repositoryFolderName = LocalFileSystem.getDocumentsPath() + File.separatorChar + LocalFileSystem.STORAGEDIR + File.separatorChar + this.config.getWorkSpace();
            repositoryFolderName = repositoryFolderName.replace("\\", "/");
            if (this.getSessionPath() != null) {
                remotePath = this.getSessionPath();
                this.xStorable.store();
                this.doSave(this.localFilePath, remotePath);
                return false;
            }
            if (this.localFilePath.startsWith(repositoryFolderName)) {
                this.xStorable.store();
                remotePath = this.localFilePath.substring(repositoryFolderName.length());
                this.doSave(this.localFilePath, remotePath);
                return false;
            }
            return true;
        }
        catch (Exception exc) {
            LOG.info((Object)("Unhandled ecxeption. " + exc.getMessage()), (Throwable)exc);
            return false;
        }
    }

    protected void initDefaults() throws Exception {
        this.xMultiComponentFactory = this.xComponentContext.getServiceManager();
        Object descTop = this.xMultiComponentFactory.createInstanceWithContext("com.sun.star.frame.Desktop", this.xComponentContext);
        XDesktop xDescTop = (XDesktop)UnoRuntime.queryInterface(XDesktop.class, (Object)descTop);
        XComponent xComponent = xDescTop.getCurrentComponent();
        Object moduleManager = this.xMultiComponentFactory.createInstanceWithContext("com.sun.star.frame.ModuleManager", this.xComponentContext);
        XModuleManager xMM = (XModuleManager)UnoRuntime.queryInterface(XModuleManager.class, (Object)moduleManager);
        this.currentModelName = xMM.identify((Object)xComponent);
        this.xStorable = (XStorable)UnoRuntime.queryInterface(XStorable.class, (Object)xComponent);
        XDocumentInfoSupplier xDocumentInfoSupplier = (XDocumentInfoSupplier)UnoRuntime.queryInterface(XDocumentInfoSupplier.class, (Object)xComponent);
        this.xDocumentInfo = xDocumentInfoSupplier.getDocumentInfo();
        this.xModel = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)xComponent);
        this.localFilePath = this.getDocumentFileName();
    }

    public String getDocumentFileName() throws UnsupportedEncodingException {
        return URLDecoder.decode(this.xModel.getURL().replaceFirst("file:///", ""), "UTF-8");
    }

    protected boolean doSave(String localPath, String remotePath) {
        try {
            File inFile = new File(localPath);
            remotePath = remotePath.replace("//", "/");
            if (remotePath.contains("?version")) {
                remotePath = remotePath.substring(0, remotePath.lastIndexOf("?"));
            }
            HTTPConnection connection = WebDavUtils.getAuthConnection(this.config);
            String type = localPath.substring(localPath.lastIndexOf(46));
            String mimetype = TextUtils.getMimeType(type);
            NVPair mimeHeader = new NVPair("Content-type", mimetype);
            NVPair[] headers = new NVPair[]{mimeHeader};
            HTTPResponse response = connection.Put(WebDavUtils.getFullPath(this.config) + TextUtils.EncodePath(remotePath), WebDavUtils.getBytes(inFile), headers);
            int status = response.getStatusCode();
            if (status == 201) {
                this.showMessageBox("File " + this.config.getContext().getServerPrefix() + remotePath + " succesfully saved!");
                return true;
            }
            this.showMessageBox("Can't store file. Error code: " + status);
        }
        catch (Exception exc) {
            LOG.info((Object)("Unhandled exception. " + exc.getMessage()), (Throwable)exc);
            this.showMessageBox("Can't store file. Error: " + exc.getMessage());
        }
        return false;
    }

    private class EnableSaveThread
    extends Thread {
        private EnableSaveThread() {
        }

        public void run() {
            try {
                while (true) {
                    Thread.sleep(100L);
                    if ("".equals(SaveDialog.this.getEditFileName())) {
                        ((XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)SaveDialog.this.xControlContainer.getControl(SaveDialog.BTN_SAVE))).setEnable(false);
                        continue;
                    }
                    ((XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)SaveDialog.this.xControlContainer.getControl(SaveDialog.BTN_SAVE))).setEnable(true);
                }
            }
            catch (Exception exception) {
                return;
            }
        }
    }

    private class LaunchThread
    extends Thread {
        private LaunchThread() {
        }

        public void run() {
            try {
                while (!SaveDialog.this.enabled) {
                    Thread.sleep(100L);
                }
                Thread.sleep(100L);
                SaveDialog.this.enableSaveThread = new EnableSaveThread();
                SaveDialog.this.enableSaveThread.start();
                SaveDialog.this.doPropFind();
            }
            catch (Exception exc) {
                LOG.info((Object)("Unhandled exception. " + exc.getMessage()), (Throwable)exc);
            }
        }
    }

    private class SaveClick
    extends ActionListener {
        private SaveClick() {
        }

        public void actionPerformed(ActionEvent arg0) {
            try {
                SaveDialog.this.doSaveFile();
            }
            catch (Exception exc) {
                LOG.info((Object)("Unhandled exception: " + exc.getMessage()), (Throwable)exc);
            }
        }
    }
}

