/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.applications.ooplugin.client;

import java.util.ArrayList;
import org.exoplatform.applications.ooplugin.XmlUtil;
import org.exoplatform.applications.ooplugin.client.PropApi;
import org.exoplatform.applications.ooplugin.client.PropManager;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResponseDoc {
    protected String href;
    protected ArrayList<PropApi> properties = new ArrayList();
    protected int status = 0;
    protected String responseDescription;

    public ResponseDoc(Node node) {
        Node responseDescriptionNode;
        String statusLine;
        Node hrefNode = XmlUtil.getChildNode(node, "href");
        this.href = hrefNode.getTextContent();
        Node statusNode = XmlUtil.getChildNode(node, "status");
        if (statusNode != null && !"".equals(statusLine = statusNode.getTextContent())) {
            String[] statusPart = statusLine.split(" ");
            this.status = new Integer(statusPart[1]);
        }
        if ((responseDescriptionNode = XmlUtil.getChildNode(node, "responsedescription")) != null) {
            this.responseDescription = responseDescriptionNode.getTextContent();
        }
        NodeList nodes = node.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node curNode = nodes.item(i);
            String localName = curNode.getLocalName();
            String nameSpace = curNode.getNamespaceURI();
            if (localName == null || !"propstat".equals(localName) || !"DAV:".equals(nameSpace)) continue;
            ArrayList<PropApi> props = this.getPropertiesForStatus(curNode);
            this.properties.addAll(props);
        }
    }

    protected ArrayList<PropApi> getPropertiesForStatus(Node propStatNode) {
        ArrayList<PropApi> properties = new ArrayList<PropApi>();
        Node propsNode = XmlUtil.getChildNode(propStatNode, "prop");
        NodeList propsNodes = propsNode.getChildNodes();
        Node statusNode = XmlUtil.getChildNode(propStatNode, "status");
        String status = statusNode.getTextContent();
        for (int i = 0; i < propsNodes.getLength(); ++i) {
            Node propertyNode = propsNodes.item(i);
            String localName = propertyNode.getLocalName();
            if (localName == null) continue;
            PropApi curProp = PropManager.getPropertyByNode(propertyNode, status);
            properties.add(curProp);
        }
        return properties;
    }

    public String getHref() {
        return this.href;
    }

    public PropApi getProperty(String propertyName) {
        for (int i = 0; i < this.properties.size(); ++i) {
            PropApi curProperty = this.properties.get(i);
            if (!propertyName.equals(curProperty.getName())) continue;
            return curProperty;
        }
        return null;
    }

    public ArrayList<PropApi> getProperties() {
        return this.properties;
    }

    public int getStatus() {
        return this.status;
    }

    public String getResponseDescription() {
        return this.responseDescription;
    }
}

