/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.applications.jcr.browser;

import java.io.IOException;
import javax.jcr.LoginException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.exoplatform.applications.jcr.browser.JCRBrowser;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;

public class JCRBrowserFilter
implements Filter {
    private static final Log LOG = ExoLogger.getLogger((String)"jcr.JCRBrowserFilter");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        block37: {
            HttpServletRequest httpRequest = (HttpServletRequest)servletRequest;
            httpRequest.setCharacterEncoding("UTF-8");
            JCRBrowser jcrBrowser = (JCRBrowser)httpRequest.getSession().getAttribute("browser");
            ExoContainer container = (ExoContainer)httpRequest.getSession().getServletContext().getAttribute("org.exoplatform.frameworks.web.eXoContainer");
            if (container == null) {
                String portalName = httpRequest.getSession().getServletContext().getServletContextName();
                container = ExoContainerContext.getCurrentContainer();
            }
            SessionProviderService sessionProviderService = (SessionProviderService)container.getComponentInstanceOfType(SessionProviderService.class);
            RepositoryService repositoryService = (RepositoryService)container.getComponentInstanceOfType(RepositoryService.class);
            try {
                if (ConversationState.getCurrent() == null) break block37;
                if (jcrBrowser != null && jcrBrowser.getNode() != null) {
                    String workspaceName;
                    block38: {
                        String repositoryName = httpRequest.getParameter("repositoryName");
                        workspaceName = httpRequest.getParameter("workspaceName");
                        if (repositoryName != null && !jcrBrowser.getRepository().getConfiguration().getName().equals(repositoryName)) {
                            try {
                                jcrBrowser.setRepository(repositoryService.getRepository(repositoryName));
                            }
                            catch (RepositoryException e) {
                                ManageableRepository jndiRepo;
                                if (e.getMessage().indexOf("not found") <= 0) break block38;
                                LOG.warn((Object)("Repository '" + repositoryName + "' is not local. Trying JNDI lookup with the name."));
                                try {
                                    InitialContext ctx = new InitialContext();
                                    Object obj = ctx.lookup(repositoryName);
                                    if (obj instanceof ManageableRepository) {
                                        jndiRepo = (ManageableRepository)obj;
                                    } else {
                                        obj = ctx.lookup("java:comp/env/" + repositoryName);
                                        if (obj instanceof ManageableRepository) {
                                            jndiRepo = (ManageableRepository)obj;
                                        } else {
                                            LOG.warn((Object)("Can't cast object " + obj + " as ManageableRepository class object"));
                                            jndiRepo = null;
                                        }
                                    }
                                    if (jndiRepo == null) {
                                        jcrBrowser.addError((Throwable)e);
                                    } else {
                                        jcrBrowser.setRepository(jndiRepo);
                                    }
                                }
                                catch (NamingException jndie) {
                                    LOG.warn((Object)("Repository not bound in JNDI with one of names '" + repositoryName + "', 'java:comp/env/" + repositoryName + "' or can't be connected."), (Throwable)jndie);
                                    try {
                                        InitialContext ctx = new InitialContext();
                                        Object obj = ctx.lookup("java:comp/env/jcr/" + repositoryName);
                                        if (obj instanceof ManageableRepository) {
                                            jndiRepo = (ManageableRepository)obj;
                                        } else {
                                            LOG.warn((Object)("Can't cast object " + obj + " as ManageableRepository class object"));
                                            jndiRepo = null;
                                        }
                                        if (jndiRepo == null) {
                                            jcrBrowser.addError((Throwable)e);
                                            jcrBrowser.addError((Throwable)jndie);
                                        } else {
                                            jcrBrowser.setRepository(jndiRepo);
                                        }
                                    }
                                    catch (NamingException jndie1) {
                                        LOG.warn((Object)("Repository not bound in JNDI with name 'java:comp/env/jcr/" + repositoryName + "' or can't be connected."), (Throwable)jndie1);
                                        jcrBrowser.addError((Throwable)e);
                                        jcrBrowser.addError((Throwable)jndie);
                                        jcrBrowser.addError((Throwable)jndie1);
                                    }
                                }
                            }
                        }
                    }
                    if (jcrBrowser.getRepository() != null) {
                        String path;
                        if (workspaceName != null && !jcrBrowser.getSession().getWorkspace().getName().equals(workspaceName)) {
                            jcrBrowser.setSession(sessionProviderService.getSessionProvider(null).getSession(workspaceName, jcrBrowser.getRepository()));
                        }
                        if ((path = httpRequest.getParameter("goParent")) != null) {
                            jcrBrowser.setNode(jcrBrowser.getNode().getNode(path));
                        } else {
                            path = httpRequest.getParameter("goNodePath");
                            if (path != null) {
                                jcrBrowser.setNode((Node)jcrBrowser.getSession().getItem(path));
                            }
                        }
                        String doSynchronize = httpRequest.getParameter("synchronize");
                        if (doSynchronize != null && doSynchronize.equals("run")) {
                            jcrBrowser.runSynchronization();
                        }
                    }
                    break block37;
                }
                ManageableRepository repository = repositoryService.getDefaultRepository();
                Session jcrSession = sessionProviderService.getSessionProvider(null).getSession(repository.getConfiguration().getDefaultWorkspaceName(), repository);
                if (jcrBrowser == null) {
                    jcrBrowser = new JCRBrowser();
                    jcrBrowser.setRepositoryService(repositoryService);
                }
                jcrBrowser.setRepository(repository);
                jcrBrowser.setSession(jcrSession);
            }
            catch (NoSuchWorkspaceException e) {
                LOG.error((Object)("JCR Browser error " + (Object)((Object)e)), (Throwable)e);
                jcrBrowser.addError((Throwable)e);
            }
            catch (LoginException e) {
                LOG.error((Object)("JCR Browser error " + (Object)((Object)e)), (Throwable)e);
                jcrBrowser.addError((Throwable)e);
            }
            catch (RepositoryException e) {
                LOG.error((Object)("JCR Browser error " + (Object)((Object)e)), (Throwable)e);
                jcrBrowser.addError((Throwable)e);
            }
            catch (RepositoryConfigurationException e) {
                LOG.error((Object)("JCR Browser error " + (Object)((Object)e)), (Throwable)e);
                jcrBrowser.addError((Throwable)e);
            }
            finally {
                httpRequest.getSession().setAttribute("browser", (Object)jcrBrowser);
            }
        }
        chain.doFilter(servletRequest, servletResponse);
    }

    public void init(FilterConfig arg0) throws ServletException {
    }

    public void destroy() {
    }
}

