/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.backup;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.jcr.ValueFormatException;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.exoplatform.services.jcr.ext.backup.BackupConfig;
import org.exoplatform.services.jcr.ext.backup.BackupOperationException;
import org.exoplatform.services.jcr.ext.backup.JobEntryInfo;
import org.exoplatform.services.jcr.ext.backup.RepositoryBackupConfig;
import org.exoplatform.services.jcr.impl.util.JCRDateFormat;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryBackupChainLog {
    protected static Log logger = ExoLogger.getLogger((String)"exo.jcr.component.ext.BackupChainLog");
    public static final String PREFIX = "repository-backup-";
    private static final String SUFFIX = ".xml";
    private File log;
    private LogWriter logWriter;
    private LogReader logReader;
    private RepositoryBackupConfig config;
    private String backupId;
    private Calendar startedTime;
    private Calendar finishedTime;
    private boolean finalized;
    private List<String> workspaceBackupsInfo;
    private String workspaceSystem;
    private String fullBackupType;
    private String increnetalBackupType;

    public RepositoryBackupChainLog(File logDirectory, RepositoryBackupConfig config, String fullBackupType, String incrementalBackupType, String systemWorkspace, List<String> wsLogFilePathList, String backupId, Calendar startTime) throws BackupOperationException {
        try {
            this.finalized = false;
            this.log = new File(logDirectory.getCanonicalPath() + File.separator + PREFIX + backupId + SUFFIX);
            this.log.createNewFile();
            this.backupId = backupId;
            this.config = config;
            this.startedTime = Calendar.getInstance();
            this.fullBackupType = fullBackupType;
            this.increnetalBackupType = incrementalBackupType;
            this.logWriter = new LogWriter(this.log);
            this.logWriter.write(config, fullBackupType, incrementalBackupType);
            this.logWriter.writeSystemWorkspaceName(systemWorkspace);
            this.logWriter.writeBackupsPath(wsLogFilePathList);
            this.workspaceBackupsInfo = wsLogFilePathList;
            this.workspaceSystem = systemWorkspace;
        }
        catch (IOException e) {
            throw new BackupOperationException("Can not create backup log ...", e);
        }
        catch (XMLStreamException e) {
            throw new BackupOperationException("Can not create backup log ...", e);
        }
        catch (FactoryConfigurationError e) {
            throw new BackupOperationException("Can not create backup log ...", e);
        }
    }

    public RepositoryBackupChainLog(File log) throws BackupOperationException {
        this.log = log;
        this.backupId = log.getName().replaceAll(PREFIX, "").replaceAll(SUFFIX, "");
        try {
            this.logReader = new LogReader(log);
            this.logReader.readLogFile();
        }
        catch (FileNotFoundException e) {
            throw new BackupOperationException("Can not read RepositoryBackupChainLog from file :" + log.getAbsolutePath(), e);
        }
        catch (XMLStreamException e) {
            throw new BackupOperationException("Can not read RepositoryBackupChainLog from file :" + log.getAbsolutePath(), e);
        }
        catch (FactoryConfigurationError e) {
            throw new BackupOperationException("Can not read RepositoryBackupChainLog from file :" + log.getAbsolutePath(), e);
        }
        catch (MalformedURLException e) {
            throw new BackupOperationException("Can not read RepositoryBackupChainLog from file :" + log.getAbsolutePath(), e);
        }
        catch (ValueFormatException e) {
            throw new BackupOperationException("Can not read RepositoryBackupChainLog from file :" + log.getAbsolutePath(), e);
        }
    }

    public String getLogFilePath() {
        return this.log.getAbsolutePath();
    }

    public RepositoryBackupConfig getBackupConfig() {
        return this.config;
    }

    public Calendar getStartedTime() {
        return this.startedTime;
    }

    public Calendar getFinishedTime() {
        return this.finishedTime;
    }

    public boolean isFinilized() {
        return this.finalized;
    }

    public synchronized void endLog() {
        if (!this.finalized) {
            this.finishedTime = Calendar.getInstance();
            this.finalized = true;
            this.logWriter.writeEndLog();
        }
    }

    public String getSystemWorkspace() {
        return this.workspaceSystem;
    }

    public List<String> getWorkspaceBackupsInfo() {
        return this.workspaceBackupsInfo;
    }

    public String getBackupId() {
        return this.backupId;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LogReader {
        protected Log logger = ExoLogger.getLogger((String)"exo.jcr.component.ext.LogReader");
        private File logFile;
        private XMLStreamReader reader;

        public LogReader(File logFile) throws FileNotFoundException, XMLStreamException, FactoryConfigurationError {
            this.logFile = logFile;
            this.reader = XMLInputFactory.newInstance().createXMLStreamReader(new FileInputStream(logFile));
        }

        public void readLogFile() throws XMLStreamException, MalformedURLException, ValueFormatException {
            boolean endDocument = false;
            while (!endDocument) {
                int eventCode = this.reader.next();
                switch (eventCode) {
                    case 1: {
                        String name = this.reader.getLocalName();
                        if (name.equals("repository-backup-config")) {
                            RepositoryBackupChainLog.this.config = this.readBackupConfig();
                        }
                        if (name.equals("system-workspace")) {
                            RepositoryBackupChainLog.this.workspaceSystem = this.readContent();
                        }
                        if (name.equals("backup-config")) {
                            RepositoryBackupChainLog.this.config = this.readBackupConfig();
                        }
                        if (name.equals("workspaces-backup-info")) {
                            RepositoryBackupChainLog.this.workspaceBackupsInfo = this.readWorkspaceBackupInfo();
                        }
                        if (name.equals("start-time")) {
                            RepositoryBackupChainLog.this.startedTime = JCRDateFormat.parse((String)this.readContent());
                        }
                        if (!name.equals("finish-time")) break;
                        RepositoryBackupChainLog.this.finishedTime = JCRDateFormat.parse((String)this.readContent());
                        break;
                    }
                    case 8: {
                        endDocument = true;
                    }
                }
            }
        }

        private List<String> readWorkspaceBackupInfo() throws XMLStreamException {
            ArrayList<String> wsBackupInfo = new ArrayList<String>();
            boolean endWorkspaceBackupInfo = false;
            while (!endWorkspaceBackupInfo) {
                int eventCode = this.reader.next();
                switch (eventCode) {
                    case 1: {
                        String name = this.reader.getLocalName();
                        if (!name.equals("url")) break;
                        wsBackupInfo.add(this.readContent());
                        break;
                    }
                    case 2: {
                        String tagName = this.reader.getLocalName();
                        if (!tagName.equals("workspaces-backup-info")) break;
                        endWorkspaceBackupInfo = true;
                    }
                }
            }
            return wsBackupInfo;
        }

        private BackupConfig readBackupConfig() throws XMLStreamException {
            BackupConfig conf = new BackupConfig();
            boolean endBackupConfig = false;
            while (!endBackupConfig) {
                int eventCode = this.reader.next();
                switch (eventCode) {
                    case 1: {
                        String name = this.reader.getLocalName();
                        if (name.equals("backup-dir")) {
                            conf.setBackupDir(new File(this.readContent()));
                        }
                        if (name.equals("backup-type")) {
                            conf.setBackupType(Integer.valueOf(this.readContent()));
                        }
                        if (name.equals("repository")) {
                            conf.setRepository(this.readContent());
                        }
                        if (name.equals("workspace")) {
                            conf.setWorkspace(this.readContent());
                        }
                        if (name.equals("incremental-job-period")) {
                            conf.setIncrementalJobPeriod(Long.valueOf(this.readContent()));
                        }
                        if (name.equals("incremental-job-number")) {
                            conf.setIncrementalJobNumber(Integer.valueOf(this.readContent()));
                        }
                        if (name.equals("full-backup-type")) {
                            RepositoryBackupChainLog.this.fullBackupType = this.readContent();
                        }
                        if (!name.equals("incremental-backup-type")) break;
                        RepositoryBackupChainLog.this.increnetalBackupType = this.readContent();
                        break;
                    }
                    case 2: {
                        String tagName = this.reader.getLocalName();
                        if (!tagName.equals("repository-backup-config")) break;
                        endBackupConfig = true;
                    }
                }
            }
            return conf;
        }

        private String readContent() throws XMLStreamException {
            String content = null;
            int eventCode = this.reader.next();
            if (eventCode == 4) {
                content = this.reader.getText();
            }
            return content;
        }

        private JobEntryInfo readJobEntryInfo() throws XMLStreamException, MalformedURLException, ValueFormatException {
            JobEntryInfo info = new JobEntryInfo();
            boolean endJobEntryInfo = false;
            while (!endJobEntryInfo) {
                int eventCode = this.reader.next();
                switch (eventCode) {
                    case 1: {
                        String name = this.reader.getLocalName();
                        if (name.equals("type")) {
                            info.setType(this.getType(this.readContent()));
                        }
                        if (name.equals("state")) {
                            info.setState(this.getState(this.readContent()));
                        }
                        if (name.equals("url")) {
                            info.setURL(new URL(this.readContent()));
                        }
                        if (!name.equals("date")) break;
                        info.setDate(JCRDateFormat.parse((String)this.readContent()));
                        break;
                    }
                    case 2: {
                        String tagName = this.reader.getLocalName();
                        if (!tagName.equals("job-entry-info")) break;
                        endJobEntryInfo = true;
                    }
                }
            }
            return info;
        }

        private int getState(String content) {
            int state = -1;
            if (content.equals("FINISHED")) {
                state = 4;
            }
            if (content.equals("STARTING")) {
                state = 0;
            }
            if (content.equals("WAITING")) {
                state = 1;
            }
            if (content.equals("WORKING")) {
                state = 2;
            }
            return state;
        }

        private int getType(String content) {
            int type = -1;
            if (content.equals("FULL")) {
                type = 1;
            }
            if (content.equals("INCREMENTAL")) {
                type = 2;
            }
            return type;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LogWriter {
        protected Log logger = ExoLogger.getLogger((String)"exo.jcr.component.ext.LogWriter");
        private File logFile;
        XMLStreamWriter writer;

        public LogWriter(File logFile) throws FileNotFoundException, XMLStreamException, FactoryConfigurationError {
            this.logFile = logFile;
            this.writer = XMLOutputFactory.newInstance().createXMLStreamWriter(new FileOutputStream(this.logFile));
            this.writer.writeStartDocument();
            this.writer.writeStartElement("repository-backup-chain-log");
            this.writer.flush();
            this.writer.writeStartElement("start-time");
            this.writer.writeCharacters(JCRDateFormat.format((Calendar)RepositoryBackupChainLog.this.startedTime));
            this.writer.writeEndElement();
        }

        public void writeSystemWorkspaceName(String wsName) throws XMLStreamException {
            this.writer.writeStartElement("system-workspace");
            this.writer.writeCharacters(wsName);
            this.writer.writeEndElement();
            this.writer.flush();
        }

        public void writeBackupsPath(List<String> wsLogFilePathList) throws XMLStreamException {
            this.writer.writeStartElement("workspaces-backup-info");
            for (String path : wsLogFilePathList) {
                this.writer.writeStartElement("url");
                this.writer.writeCharacters(path);
                this.writer.writeEndElement();
            }
            this.writer.writeEndElement();
            this.writer.flush();
        }

        public synchronized void write(RepositoryBackupConfig config, String fullBackupType, String incrementalBackupType) throws XMLStreamException {
            this.writer.writeStartElement("repository-backup-config");
            this.writer.writeStartElement("backup-type");
            this.writer.writeCharacters(String.valueOf(config.getBackupType()));
            this.writer.writeEndElement();
            this.writer.writeStartElement("full-backup-type");
            this.writer.writeCharacters(fullBackupType);
            this.writer.writeEndElement();
            this.writer.writeStartElement("incremental-backup-type");
            this.writer.writeCharacters(incrementalBackupType);
            this.writer.writeEndElement();
            if (config.getBackupDir() != null) {
                this.writer.writeStartElement("backup-dir");
                this.writer.writeCharacters(config.getBackupDir().getAbsolutePath());
                this.writer.writeEndElement();
            }
            if (config.getRepository() != null) {
                this.writer.writeStartElement("repository");
                this.writer.writeCharacters(config.getRepository());
                this.writer.writeEndElement();
            }
            this.writer.writeStartElement("incremental-job-period");
            this.writer.writeCharacters(Long.toString(config.getIncrementalJobPeriod()));
            this.writer.writeEndElement();
            this.writer.writeStartElement("incremental-job-number");
            this.writer.writeCharacters(Integer.toString(config.getIncrementalJobNumber()));
            this.writer.writeEndElement();
            this.writer.writeEndElement();
            this.writer.flush();
        }

        public synchronized void writeEndLog() {
            try {
                this.writer.writeStartElement("finish-time");
                this.writer.writeCharacters(JCRDateFormat.format((Calendar)RepositoryBackupChainLog.this.finishedTime));
                this.writer.writeEndElement();
                this.writer.writeEndElement();
                this.writer.writeEndDocument();
                this.writer.flush();
            }
            catch (Exception e) {
                this.logger.error((Object)"Can't write end log", (Throwable)e);
            }
        }
    }
}

