/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.backup.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Map;
import javax.jcr.InvalidItemStateException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.SimpleParameterEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.config.WorkspaceInitializerEntry;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.core.WorkspaceContainerFacade;
import org.exoplatform.services.jcr.ext.backup.BackupChainLog;
import org.exoplatform.services.jcr.ext.backup.RepositoryBackupChainLog;
import org.exoplatform.services.jcr.ext.backup.RepositoryRestoreExeption;
import org.exoplatform.services.jcr.ext.backup.impl.BackupManagerImpl;
import org.exoplatform.services.jcr.impl.core.BackupWorkspaceInitializer;
import org.exoplatform.services.jcr.impl.core.RepositoryImpl;
import org.exoplatform.services.jcr.impl.core.SessionRegistry;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobRepositoryRestore
extends Thread {
    private static Log log = ExoLogger.getLogger((String)"exo.jcr.component.ext.JobRepositoryRestore");
    public static final int REPOSITORY_RESTORE_STARTED = 1;
    public static final int REPOSITORY_RESTORE_SUCCESSFUL = 2;
    public static final int REPOSITORY_RESTORE_FAIL = 3;
    public static final int REPOSITORY_RESTORE_INITIALIZED = 4;
    private int stateRestore;
    private Calendar startTime;
    private Calendar endTime;
    private Throwable restoreException = null;
    private RepositoryService repositoryService;
    private BackupManagerImpl backupManager;
    private RepositoryEntry repositoryEntry;
    private Map<String, BackupChainLog> workspacesMapping;
    private RepositoryBackupChainLog repositoryBackupChainLog;

    public JobRepositoryRestore(RepositoryService repoService, BackupManagerImpl backupManagerImpl, RepositoryEntry repositoryEntry, Map<String, BackupChainLog> workspacesMapping, RepositoryBackupChainLog backupChainLog) {
        this.repositoryService = repoService;
        this.backupManager = backupManagerImpl;
        this.repositoryEntry = repositoryEntry;
        this.workspacesMapping = workspacesMapping;
        this.repositoryBackupChainLog = backupChainLog;
    }

    /*
     * Loose catch block
     */
    protected void restore() throws RepositoryRestoreExeption {
        block16: {
            ArrayList originalWorkspaceEntrys = this.repositoryEntry.getWorkspaceEntries();
            WorkspaceEntry systemWorkspaceEntry = null;
            for (WorkspaceEntry wsEntry : originalWorkspaceEntrys) {
                if (!wsEntry.getName().equals(this.repositoryEntry.getSystemWorkspaceName())) continue;
                systemWorkspaceEntry = wsEntry;
                break;
            }
            WorkspaceInitializerEntry wieOriginal = systemWorkspaceEntry.getInitializer();
            BackupChainLog systemBackupChainLog = this.workspacesMapping.get(systemWorkspaceEntry.getName());
            File fullBackupFile = new File(systemBackupChainLog.getJobEntryInfos().get(0).getURL().getPath());
            WorkspaceInitializerEntry wiEntry = new WorkspaceInitializerEntry();
            wiEntry.setType(BackupWorkspaceInitializer.class.getCanonicalName());
            ArrayList<SimpleParameterEntry> wieParams = new ArrayList<SimpleParameterEntry>();
            wieParams.add(new SimpleParameterEntry("restore-path", fullBackupFile.getParent()));
            wiEntry.setParameters(wieParams);
            systemWorkspaceEntry.setInitializer(wiEntry);
            ArrayList<WorkspaceEntry> newEntries = new ArrayList<WorkspaceEntry>();
            newEntries.add(systemWorkspaceEntry);
            this.repositoryEntry.setWorkspaceEntries(newEntries);
            String currennWorkspaceName = this.repositoryEntry.getSystemWorkspaceName();
            boolean restored = true;
            this.repositoryService.createRepository(this.repositoryEntry);
            RepositoryImpl defRep = (RepositoryImpl)this.repositoryService.getRepository(this.repositoryEntry.getName());
            WorkspaceContainerFacade wcf = defRep.getWorkspaceContainer(systemWorkspaceEntry.getName());
            WorkspaceEntry createdWorkspaceEntry = (WorkspaceEntry)wcf.getComponent(WorkspaceEntry.class);
            createdWorkspaceEntry.setInitializer(wieOriginal);
            this.repositoryService.getConfig().retain();
            for (WorkspaceEntry wsEntry : originalWorkspaceEntrys) {
                if (wsEntry.getName().equals(this.repositoryEntry.getSystemWorkspaceName())) continue;
                currennWorkspaceName = wsEntry.getName();
                this.backupManager.restore(this.workspacesMapping.get(wsEntry.getName()), this.repositoryEntry.getName(), wsEntry, false);
            }
            Object var17_18 = null;
            if (restored) break block16;
            try {
                ManageableRepository mr = null;
                try {
                    mr = this.repositoryService.getRepository(this.repositoryEntry.getName());
                }
                catch (RepositoryException e) {
                    // empty catch block
                }
                if (mr != null) {
                    this.closeAllSession(mr);
                    this.repositoryService.removeRepository(this.repositoryEntry.getName());
                    this.repositoryService.getConfig().retain();
                }
                break block16;
            }
            catch (Throwable thr) {
                log.error((Object)("The partly restored repository \"" + this.repositoryEntry.getName() + "\" can not be removed."), thr);
            }
            break block16;
            {
                catch (InvalidItemStateException e) {
                    restored = false;
                    log.error((Object)("Can not restore workspace \"" + currennWorkspaceName + " in repository \"" + this.repositoryEntry.getName() + "\"."), (Throwable)e);
                    throw new RepositoryRestoreExeption("Can not restore workspace \"" + currennWorkspaceName + " in repository \"" + this.repositoryEntry.getName() + "\"." + " There was database error.", e);
                }
                catch (Throwable t) {
                    restored = false;
                    log.error((Object)("Can not restore workspace \"" + currennWorkspaceName + " in repository \"" + this.repositoryEntry.getName() + "\"."), t);
                    throw new RepositoryRestoreExeption("Can not restore workspace \"" + currennWorkspaceName + " in repository \"" + this.repositoryEntry.getName() + "\".", t);
                }
            }
            catch (Throwable throwable) {
                Object var17_19 = null;
                if (!restored) {
                    try {
                        ManageableRepository mr = null;
                        try {
                            mr = this.repositoryService.getRepository(this.repositoryEntry.getName());
                        }
                        catch (RepositoryException e) {
                            // empty catch block
                        }
                        if (mr != null) {
                            this.closeAllSession(mr);
                            this.repositoryService.removeRepository(this.repositoryEntry.getName());
                            this.repositoryService.getConfig().retain();
                        }
                    }
                    catch (Throwable thr) {
                        log.error((Object)("The partly restored repository \"" + this.repositoryEntry.getName() + "\" can not be removed."), thr);
                    }
                }
                throw throwable;
            }
        }
    }

    private void closeAllSession(ManageableRepository mr) throws NoSuchWorkspaceException {
        for (String wsName : mr.getWorkspaceNames()) {
            if (mr.canRemoveWorkspace(wsName)) continue;
            WorkspaceContainerFacade wc = mr.getWorkspaceContainer(wsName);
            SessionRegistry sessionRegistry = (SessionRegistry)wc.getComponent(SessionRegistry.class);
            sessionRegistry.closeSessions(wsName);
        }
    }

    @Override
    public void run() {
        try {
            this.stateRestore = 1;
            this.startTime = Calendar.getInstance();
            this.restore();
            this.stateRestore = 2;
            this.endTime = Calendar.getInstance();
        }
        catch (Throwable t) {
            this.stateRestore = 3;
            this.restoreException = t;
            log.error((Object)"The restore was fail", t);
        }
    }

    public Throwable getRestoreException() {
        return this.restoreException;
    }

    public int getStateRestore() {
        return this.stateRestore;
    }

    public Calendar getStartTime() {
        return this.startTime;
    }

    public Calendar getEndTime() {
        return this.endTime;
    }

    public String getRepositoryName() {
        return this.repositoryEntry.getName();
    }

    public RepositoryBackupChainLog getRepositoryBackupChainLog() {
        return this.repositoryBackupChainLog;
    }

    public RepositoryEntry getRepositoryEntry() {
        return this.repositoryEntry;
    }
}

