/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.script.groovy;

import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyCodeSource;
import groovy.lang.GroovyResourceLoader;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.EventListener;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.fileupload.FileItem;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.ThreadLocalSessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.registry.RegistryEntry;
import org.exoplatform.services.jcr.ext.registry.RegistryService;
import org.exoplatform.services.jcr.ext.resource.jcr.Handler;
import org.exoplatform.services.jcr.ext.script.groovy.GroovyScript2RestLoaderPlugin;
import org.exoplatform.services.jcr.ext.script.groovy.GroovyScript2RestUpdateListener;
import org.exoplatform.services.jcr.ext.script.groovy.GroovyScriptAddRepoPlugin;
import org.exoplatform.services.jcr.ext.script.groovy.JcrGroovyResourceLoader;
import org.exoplatform.services.jcr.ext.script.groovy.NodeScriptKey;
import org.exoplatform.services.jcr.ext.script.groovy.ObservationListenerConfiguration;
import org.exoplatform.services.jcr.ext.script.groovy.ScriptKey;
import org.exoplatform.services.jcr.ext.script.groovy.SimpleScriptKey;
import org.exoplatform.services.jcr.ext.script.groovy.URLScriptKey;
import org.exoplatform.services.jcr.ext.script.groovy.XMLGroovyScript2Rest;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.impl.ResourceBinder;
import org.exoplatform.services.script.groovy.GroovyScriptInstantiator;
import org.picocontainer.Startable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="script/groovy")
public class GroovyScript2RestLoader
implements Startable {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.ext.GroovyScript2RestLoader");
    private static final String DEFAULT_NODETYPE = "exo:groovyResourceContainer";
    private static final String SERVICE_NAME = "GroovyScript2RestLoader";
    protected InitParams initParams;
    protected ResourceBinder binder;
    protected GroovyScriptInstantiator groovyScriptInstantiator;
    protected RepositoryService repositoryService;
    protected ConfigurationManager configurationManager;
    protected RegistryService registryService;
    protected ThreadLocalSessionProviderService sessionProviderService;
    protected ObservationListenerConfiguration observationListenerConfiguration;
    protected String nodeType;
    protected Map<ScriptKey, Class<?>> scriptsURL2ClassMap = new HashMap();
    protected GroovyClassLoader groovyClassLoader;
    protected List<GroovyScriptAddRepoPlugin> addRepoPlugins;
    protected List<GroovyScript2RestLoaderPlugin> loadPlugins;

    public GroovyScript2RestLoader(ResourceBinder binder, GroovyScriptInstantiator groovyScriptInstantiator, RepositoryService repositoryService, ThreadLocalSessionProviderService sessionProviderService, ConfigurationManager configurationManager, Handler jcrUrlHandler, InitParams params) {
        this(binder, groovyScriptInstantiator, repositoryService, sessionProviderService, configurationManager, null, jcrUrlHandler, params);
    }

    public GroovyScript2RestLoader(ResourceBinder binder, GroovyScriptInstantiator groovyScriptInstantiator, RepositoryService repositoryService, ThreadLocalSessionProviderService sessionProviderService, ConfigurationManager configurationManager, RegistryService registryService, Handler jcrUrlHandler, InitParams params) {
        this.binder = binder;
        this.groovyScriptInstantiator = groovyScriptInstantiator;
        this.repositoryService = repositoryService;
        this.configurationManager = configurationManager;
        this.registryService = registryService;
        this.sessionProviderService = sessionProviderService;
        this.initParams = params;
    }

    public void unloadScript(URL url) {
        this.unloadScript(new URLScriptKey(url));
    }

    public boolean unloadScript(String key) {
        return this.unloadScript(new SimpleScriptKey(key));
    }

    public boolean unloadScript(ScriptKey key) {
        if (this.scriptsURL2ClassMap.containsKey(key)) {
            if (this.binder.unbind(this.scriptsURL2ClassMap.get(key))) {
                this.scriptsURL2ClassMap.remove(key);
                return true;
            }
            LOG.warn((Object)("Can't remove groovy script, key " + key));
        } else {
            LOG.warn((Object)("Specified key '" + key + "' does not corresponds to any class name."));
        }
        return false;
    }

    public boolean isLoaded(String key) {
        return this.isLoaded(new SimpleScriptKey(key));
    }

    public boolean isLoaded(URL url) {
        return this.isLoaded(new URLScriptKey(url));
    }

    public boolean isLoaded(ScriptKey key) {
        return this.scriptsURL2ClassMap.containsKey(key);
    }

    public String getNodeType() {
        if (this.nodeType == null) {
            throw new IllegalStateException("Node type not initialized, yet. ");
        }
        return this.nodeType;
    }

    public boolean loadScript(URL url) throws IOException {
        Object resource = this.groovyScriptInstantiator.instantiateScript(new GroovyCodeSource(url), this.groovyClassLoader);
        if (this.binder.bind(resource)) {
            this.scriptsURL2ClassMap.put(new URLScriptKey(url), resource.getClass());
            return true;
        }
        LOG.warn((Object)("Groovy script was not binded, URL: " + url));
        return false;
    }

    public boolean loadScript(String key, InputStream stream) throws IOException {
        return this.loadScript(key, null, stream);
    }

    public boolean loadScript(String key, String name, InputStream stream) throws IOException {
        return this.loadScript(new SimpleScriptKey(key), name, stream);
    }

    public boolean loadScript(ScriptKey key, String name, InputStream stream) throws IOException {
        Object resource = this.groovyScriptInstantiator.instantiateScript(this.createCodeSource(stream, name), this.groovyClassLoader);
        if (this.binder.bind(resource)) {
            this.scriptsURL2ClassMap.put(key, resource.getClass());
            return true;
        }
        LOG.warn((Object)("Groovy script was not binded, key: " + key));
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (this.registryService != null && this.initParams != null && !this.registryService.getForceXMLConfigurationValue(this.initParams)) {
            SessionProvider sessionProvider = SessionProvider.createSystemProvider();
            try {
                Object var5_2;
                try {
                    this.readParamsFromRegistryService(sessionProvider);
                }
                catch (Exception e) {
                    this.readParamsFromFile();
                    try {
                        this.writeParamsToRegistryService(sessionProvider);
                    }
                    catch (Exception exc) {
                        LOG.error((Object)"Cannot write init configuration to RegistryService.", (Throwable)exc);
                    }
                    var5_2 = null;
                    sessionProvider.close();
                }
                var5_2 = null;
                sessionProvider.close();
            }
            catch (Throwable throwable) {
                Object var5_3 = null;
                sessionProvider.close();
                throw throwable;
            }
        } else {
            this.readParamsFromFile();
        }
        this.addScripts();
        ClassLoader cl = this.getClass().getClassLoader();
        this.groovyClassLoader = new GroovyClassLoader(cl);
        if (this.addRepoPlugins != null && this.addRepoPlugins.size() > 0) {
            try {
                HashSet<URL> repos = new HashSet<URL>();
                for (GroovyScriptAddRepoPlugin pl : this.addRepoPlugins) {
                    repos.addAll(pl.getRepositories());
                }
                this.groovyClassLoader.setResourceLoader((GroovyResourceLoader)new JcrGroovyResourceLoader(repos.toArray(new URL[repos.size()])));
            }
            catch (MalformedURLException e) {
                LOG.error((Object)"Unable add groovy script repository. ", (Throwable)e);
            }
        }
        try {
            String repositoryName = this.observationListenerConfiguration.getRepository();
            List<String> workspaceNames = this.observationListenerConfiguration.getWorkspaces();
            ManageableRepository repository = this.repositoryService.getRepository(repositoryName);
            for (String workspaceName : workspaceNames) {
                Session session = repository.getSystemSession(workspaceName);
                String xpath = "//element(*, " + this.getNodeType() + ")[@exo:autoload='true']";
                Query query = session.getWorkspace().getQueryManager().createQuery(xpath, "xpath");
                QueryResult result = query.execute();
                NodeIterator nodeIterator = result.getNodes();
                while (nodeIterator.hasNext()) {
                    Node node = nodeIterator.nextNode();
                    if (node.getPath().startsWith("/jcr:system")) continue;
                    this.loadScript(new NodeScriptKey(repositoryName, workspaceName, node), node.getPath(), node.getProperty("jcr:data").getStream());
                }
                session.getWorkspace().getObservationManager().addEventListener((EventListener)new GroovyScript2RestUpdateListener(repositoryName, workspaceName, this, session), 28, "/", true, null, new String[]{this.getNodeType()}, false);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error occurs ", (Throwable)e);
        }
        this.binder.bind((Object)this);
    }

    public void stop() {
    }

    public void addPlugin(ComponentPlugin cp) {
        if (cp instanceof GroovyScript2RestLoaderPlugin) {
            if (this.loadPlugins == null) {
                this.loadPlugins = new ArrayList<GroovyScript2RestLoaderPlugin>();
            }
            this.loadPlugins.add((GroovyScript2RestLoaderPlugin)cp);
        }
        if (cp instanceof GroovyScriptAddRepoPlugin) {
            if (this.addRepoPlugins == null) {
                this.addRepoPlugins = new ArrayList<GroovyScriptAddRepoPlugin>();
            }
            this.addRepoPlugins.add((GroovyScriptAddRepoPlugin)cp);
        }
    }

    private GroovyCodeSource createCodeSource(InputStream in, String name) {
        GroovyCodeSource gcs = new GroovyCodeSource(in, name, "/groovy/script/jaxrs");
        gcs.setCachable(false);
        return gcs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void addScripts() {
        if (this.loadPlugins == null || this.loadPlugins.size() == 0) {
            return;
        }
        Iterator<GroovyScript2RestLoaderPlugin> i$ = this.loadPlugins.iterator();
        while (i$.hasNext()) {
            Object var12_13;
            GroovyScript2RestLoaderPlugin loadPlugin = i$.next();
            if (loadPlugin.getXMLConfigs().size() == 0) continue;
            Session session = null;
            try {
                try {
                    ManageableRepository repository = this.repositoryService.getRepository(loadPlugin.getRepository());
                    String workspace = loadPlugin.getWorkspace();
                    session = repository.getSystemSession(workspace);
                    String nodeName = loadPlugin.getNode();
                    Node node = null;
                    try {
                        node = (Node)session.getItem(nodeName);
                    }
                    catch (PathNotFoundException e) {
                        StringTokenizer tokens = new StringTokenizer(nodeName, "/");
                        node = session.getRootNode();
                        while (tokens.hasMoreTokens()) {
                            String t = tokens.nextToken();
                            if (node.hasNode(t)) {
                                node = node.getNode(t);
                                continue;
                            }
                            node = node.addNode(t, "nt:folder");
                        }
                    }
                    for (XMLGroovyScript2Rest xg : loadPlugin.getXMLConfigs()) {
                        String scriptName = xg.getName();
                        if (node.hasNode(scriptName)) {
                            LOG.warn((Object)("Node '" + node.getPath() + "/" + scriptName + "' already exists. "));
                            continue;
                        }
                        this.createScript(node, scriptName, xg.isAutoload(), this.configurationManager.getInputStream(xg.getPath()));
                    }
                    session.save();
                }
                catch (Exception e) {
                    LOG.error((Object)"Failed add scripts. ", (Throwable)e);
                    var12_13 = null;
                    if (session == null) continue;
                    session.logout();
                    continue;
                }
                var12_13 = null;
                if (session == null) continue;
            }
            catch (Throwable throwable) {
                var12_13 = null;
                if (session != null) {
                    session.logout();
                }
                throw throwable;
            }
            session.logout();
        }
        return;
    }

    protected Node createScript(Node parent, String name, boolean autoload, InputStream stream) throws Exception {
        Node scriptFile = parent.addNode(name, "nt:file");
        Node script = scriptFile.addNode("jcr:content", this.getNodeType());
        script.setProperty("exo:autoload", autoload);
        script.setProperty("jcr:mimeType", "script/groovy");
        script.setProperty("jcr:lastModified", Calendar.getInstance());
        script.setProperty("jcr:data", stream);
        return scriptFile;
    }

    protected void readParamsFromRegistryService(SessionProvider sessionProvider) throws PathNotFoundException, RepositoryException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<<< Read init parametrs from registry service.");
        }
        this.observationListenerConfiguration = new ObservationListenerConfiguration();
        String entryPath = "exo:services/GroovyScript2RestLoader/nodeType";
        RegistryEntry registryEntry = this.registryService.getEntry(sessionProvider, entryPath);
        Document doc = registryEntry.getDocument();
        Element element = doc.getDocumentElement();
        this.nodeType = this.getAttributeSmart(element, "value");
        entryPath = "exo:services/GroovyScript2RestLoader/repository";
        registryEntry = this.registryService.getEntry(sessionProvider, entryPath);
        doc = registryEntry.getDocument();
        element = doc.getDocumentElement();
        this.observationListenerConfiguration.setRepository(this.getAttributeSmart(element, "value"));
        entryPath = "exo:services/GroovyScript2RestLoader/workspaces";
        registryEntry = this.registryService.getEntry(sessionProvider, entryPath);
        doc = registryEntry.getDocument();
        element = doc.getDocumentElement();
        String workspaces = this.getAttributeSmart(element, "value");
        String[] ws = workspaces.split(";");
        ArrayList<String> wsList = new ArrayList<String>();
        for (String w : ws) {
            wsList.add(w);
        }
        this.observationListenerConfiguration.setWorkspaces(wsList);
        LOG.info((Object)("NodeType from RegistryService: " + this.getNodeType()));
        LOG.info((Object)("Repository from RegistryService: " + this.observationListenerConfiguration.getRepository()));
        LOG.info((Object)("Workspaces node from RegistryService: " + this.observationListenerConfiguration.getWorkspaces()));
    }

    protected void writeParamsToRegistryService(SessionProvider sessionProvider) throws IOException, SAXException, ParserConfigurationException, RepositoryException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)">>> Save init parametrs in registry service.");
        }
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element root = doc.createElement(SERVICE_NAME);
        doc.appendChild(root);
        Element element = doc.createElement("nodeType");
        this.setAttributeSmart(element, "value", this.getNodeType());
        root.appendChild(element);
        StringBuffer sb = new StringBuffer();
        for (String workspace : this.observationListenerConfiguration.getWorkspaces()) {
            if (sb.length() > 0) {
                sb.append(';');
            }
            sb.append(workspace);
        }
        element = doc.createElement("workspaces");
        this.setAttributeSmart(element, "value", sb.toString());
        root.appendChild(element);
        element = doc.createElement("repository");
        this.setAttributeSmart(element, "value", this.observationListenerConfiguration.getRepository());
        root.appendChild(element);
        RegistryEntry serviceEntry = new RegistryEntry(doc);
        this.registryService.createEntry(sessionProvider, "exo:services", serviceEntry);
    }

    protected String getAttributeSmart(Element element, String attr) {
        return element.hasAttribute(attr) ? element.getAttribute(attr) : null;
    }

    protected void setAttributeSmart(Element element, String attr, String value) {
        if (value == null) {
            element.removeAttribute(attr);
        } else {
            element.setAttribute(attr, value);
        }
    }

    protected void readParamsFromFile() {
        if (this.initParams != null) {
            this.nodeType = this.initParams.getValuesParam("nodetype") != null ? this.initParams.getValueParam("nodetype").getValue() : DEFAULT_NODETYPE;
            ObjectParameter param = this.initParams.getObjectParam("observation.config");
            this.observationListenerConfiguration = (ObservationListenerConfiguration)param.getObject();
        }
        LOG.info((Object)("NodeType from configuration file: " + this.getNodeType()));
        LOG.info((Object)("Repository from configuration file: " + this.observationListenerConfiguration.getRepository()));
        LOG.info((Object)("Workspaces node from configuration file: " + this.observationListenerConfiguration.getWorkspaces()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @POST
    @Consumes(value={"script/groovy"})
    @Path(value="add/{repository}/{workspace}/{path:.*}")
    public Response addScript(InputStream stream, @Context UriInfo uriInfo, @PathParam(value="repository") String repository, @PathParam(value="workspace") String workspace, @PathParam(value="path") String path) {
        Response response;
        Session ses = null;
        try {
            try {
                ses = this.sessionProviderService.getSessionProvider(null).getSession(workspace, this.repositoryService.getRepository(repository));
                Node node = (Node)ses.getItem(GroovyScript2RestLoader.getPath(path));
                this.createScript(node, GroovyScript2RestLoader.getName(path), false, stream);
                ses.save();
                URI location = uriInfo.getBaseUriBuilder().path(this.getClass(), "getScript").build(new Object[]{repository, workspace, path});
                response = Response.created((URI)location).build();
                Object var11_14 = null;
                if (ses == null) return response;
            }
            catch (PathNotFoundException e) {
                LOG.error((Object)("Path " + path + " does not exists"), (Throwable)e);
                Response response2 = Response.status((Response.Status)Response.Status.NOT_FOUND).build();
                Object var11_15 = null;
                if (ses == null) return response2;
                ses.logout();
                return response2;
            }
            catch (Exception e) {
                LOG.error((Object)"Unexpected error occurs ", (Throwable)e);
                Response response3 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Unexpected error. " + e.getMessage())).type("text/plain").build();
                Object var11_16 = null;
                if (ses == null) return response3;
                ses.logout();
                return response3;
            }
        }
        catch (Throwable throwable) {
            Object var11_17 = null;
            if (ses == null) throw throwable;
            ses.logout();
            throw throwable;
        }
        ses.logout();
        return response;
    }

    @POST
    @Consumes(value={"script/groovy"})
    @Path(value="validate{name:.*}")
    public Response validateScript(@PathParam(value="name") String name, InputStream script) {
        try {
            if (name != null && name.startsWith("/")) {
                name = name.substring(1);
            }
            if (name == null || name.length() == 0) {
                name = this.groovyClassLoader.generateScriptName();
            }
            this.groovyScriptInstantiator.instantiateScript(this.createCodeSource(script, name), this.groovyClassLoader);
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Unexpected error occurs ", (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Unexpected error. " + e.getMessage())).type("text/plain").build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @POST
    @Consumes(value={"script/groovy"})
    @Path(value="update/{repository}/{workspace}/{path:.*}")
    public Response updateScript(InputStream stream, @Context UriInfo uriInfo, @PathParam(value="repository") String repository, @PathParam(value="workspace") String workspace, @PathParam(value="path") String path) {
        Response response;
        Session ses = null;
        try {
            try {
                ses = this.sessionProviderService.getSessionProvider(null).getSession(workspace, this.repositoryService.getRepository(repository));
                Node node = (Node)ses.getItem("/" + path);
                node.getNode("jcr:content").setProperty("jcr:data", stream);
                ses.save();
                URI location = uriInfo.getBaseUriBuilder().path(this.getClass(), "getScript").build(new Object[]{repository, workspace, path});
                response = Response.created((URI)location).build();
                Object var11_14 = null;
                if (ses == null) return response;
            }
            catch (PathNotFoundException e) {
                LOG.error((Object)("Path " + path + " does not exists"), (Throwable)e);
                Response response2 = Response.status((Response.Status)Response.Status.NOT_FOUND).build();
                Object var11_15 = null;
                if (ses == null) return response2;
                ses.logout();
                return response2;
            }
            catch (Exception e) {
                LOG.error((Object)"Unexpected error occurs ", (Throwable)e);
                Response response3 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Unexpected error. " + e.getMessage())).type("text/plain").build();
                Object var11_16 = null;
                if (ses == null) return response3;
                ses.logout();
                return response3;
            }
        }
        catch (Throwable throwable) {
            Object var11_17 = null;
            if (ses == null) throw throwable;
            ses.logout();
            throw throwable;
        }
        ses.logout();
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @POST
    @Consumes(value={"multipart/*"})
    @Path(value="add/{repository}/{workspace}/{path:.*}")
    public Response addScript(Iterator<FileItem> items, @Context UriInfo uriInfo, @PathParam(value="repository") String repository, @PathParam(value="workspace") String workspace, @PathParam(value="path") String path) {
        Response response;
        Session ses = null;
        try {
            try {
                ses = this.sessionProviderService.getSessionProvider(null).getSession(workspace, this.repositoryService.getRepository(repository));
                Node node = (Node)ses.getItem(GroovyScript2RestLoader.getPath(path));
                InputStream stream = null;
                boolean autoload = false;
                while (items.hasNext()) {
                    FileItem fitem = items.next();
                    if (fitem.isFormField() && fitem.getFieldName() != null && fitem.getFieldName().equalsIgnoreCase("autoload")) {
                        autoload = Boolean.valueOf(fitem.getString());
                        continue;
                    }
                    if (fitem.isFormField()) continue;
                    stream = fitem.getInputStream();
                }
                this.createScript(node, GroovyScript2RestLoader.getName(path), autoload, stream);
                ses.save();
                URI location = uriInfo.getBaseUriBuilder().path(this.getClass(), "getScript").build(new Object[]{repository, workspace, path});
                response = Response.created((URI)location).build();
                Object var13_16 = null;
                if (ses == null) return response;
            }
            catch (PathNotFoundException e) {
                LOG.error((Object)("Path " + path + " does not exists"), (Throwable)e);
                Response response2 = Response.status((Response.Status)Response.Status.NOT_FOUND).build();
                Object var13_17 = null;
                if (ses == null) return response2;
                ses.logout();
                return response2;
            }
            catch (Exception e) {
                LOG.error((Object)"Unexpected error occurs ", (Throwable)e);
                Response response3 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Unexpected error. " + e.getMessage())).type("text/plain").build();
                Object var13_18 = null;
                if (ses == null) return response3;
                ses.logout();
                return response3;
            }
        }
        catch (Throwable throwable) {
            Object var13_19 = null;
            if (ses == null) throw throwable;
            ses.logout();
            throw throwable;
        }
        ses.logout();
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @POST
    @Consumes(value={"multipart/*"})
    @Path(value="update/{repository}/{workspace}/{path:.*}")
    public Response updateScripts(Iterator<FileItem> items, @Context UriInfo uriInfo, @PathParam(value="repository") String repository, @PathParam(value="workspace") String workspace, @PathParam(value="path") String path) {
        Response response;
        Session ses = null;
        try {
            try {
                FileItem fitem = items.next();
                InputStream stream = null;
                if (!fitem.isFormField()) {
                    stream = fitem.getInputStream();
                }
                ses = this.sessionProviderService.getSessionProvider(null).getSession(workspace, this.repositoryService.getRepository(repository));
                Node node = (Node)ses.getItem("/" + path);
                node.getNode("jcr:content").setProperty("jcr:data", stream);
                ses.save();
                URI location = uriInfo.getBaseUriBuilder().path(this.getClass(), "getScript").build(new Object[]{repository, workspace, path});
                response = Response.created((URI)location).build();
                Object var13_16 = null;
                if (ses == null) return response;
            }
            catch (PathNotFoundException e) {
                LOG.error((Object)("Path " + path + " does not exists"), (Throwable)e);
                Response response2 = Response.status((Response.Status)Response.Status.NOT_FOUND).build();
                Object var13_17 = null;
                if (ses == null) return response2;
                ses.logout();
                return response2;
            }
            catch (Exception e) {
                LOG.error((Object)"Unexpected error occurs ", (Throwable)e);
                Response response3 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Unexpected error. " + e.getMessage())).type("text/plain").build();
                Object var13_18 = null;
                if (ses == null) return response3;
                ses.logout();
                return response3;
            }
        }
        catch (Throwable throwable) {
            Object var13_19 = null;
            if (ses == null) throw throwable;
            ses.logout();
            throw throwable;
        }
        ses.logout();
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @POST
    @Produces(value={"script/groovy"})
    @Path(value="src/{repository}/{workspace}/{path:.*}")
    public Response getScript(@PathParam(value="repository") String repository, @PathParam(value="workspace") String workspace, @PathParam(value="path") String path) {
        Response response;
        Session ses = null;
        try {
            try {
                ses = this.sessionProviderService.getSessionProvider(null).getSession(workspace, this.repositoryService.getRepository(repository));
                Node scriptFile = (Node)ses.getItem("/" + path);
                response = Response.status((Response.Status)Response.Status.OK).entity((Object)scriptFile.getNode("jcr:content").getProperty("jcr:data").getStream()).type("script/groovy").build();
                Object var8_11 = null;
                if (ses == null) return response;
            }
            catch (PathNotFoundException e) {
                LOG.error((Object)("Path " + path + " does not exists"), (Throwable)e);
                Response response2 = Response.status((Response.Status)Response.Status.NOT_FOUND).build();
                Object var8_12 = null;
                if (ses == null) return response2;
                ses.logout();
                return response2;
            }
            catch (Exception e) {
                LOG.error((Object)"Unexpected error occurs ", (Throwable)e);
                Response response3 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Unexpected error. " + e.getMessage())).type("text/plain").build();
                Object var8_13 = null;
                if (ses == null) return response3;
                ses.logout();
                return response3;
            }
        }
        catch (Throwable throwable) {
            Object var8_14 = null;
            if (ses == null) throw throwable;
            ses.logout();
            throw throwable;
        }
        ses.logout();
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @POST
    @Produces(value={"application/json"})
    @Path(value="meta/{repository}/{workspace}/{path:.*}")
    public Response getScriptMetadata(@PathParam(value="repository") String repository, @PathParam(value="workspace") String workspace, @PathParam(value="path") String path) {
        Response response;
        Session ses = null;
        try {
            try {
                ses = this.sessionProviderService.getSessionProvider(null).getSession(workspace, this.repositoryService.getRepository(repository));
                Node script = ((Node)ses.getItem("/" + path)).getNode("jcr:content");
                ScriptMetadata meta = new ScriptMetadata(script.getProperty("exo:autoload").getBoolean(), this.isLoaded(new NodeScriptKey(repository, workspace, script)), script.getProperty("jcr:mimeType").getString(), script.getProperty("jcr:lastModified").getDate().getTimeInMillis());
                response = Response.status((Response.Status)Response.Status.OK).entity((Object)meta).type("application/json").build();
                Object var9_12 = null;
                if (ses == null) return response;
            }
            catch (PathNotFoundException e) {
                LOG.error((Object)("Path " + path + " does not exists"), (Throwable)e);
                Response response2 = Response.status((Response.Status)Response.Status.NOT_FOUND).build();
                Object var9_13 = null;
                if (ses == null) return response2;
                ses.logout();
                return response2;
            }
            catch (Exception e) {
                LOG.error((Object)"Unexpected error occurs ", (Throwable)e);
                Response response3 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Unexpected error. " + e.getMessage())).type("text/plain").build();
                Object var9_14 = null;
                if (ses == null) return response3;
                ses.logout();
                return response3;
            }
        }
        catch (Throwable throwable) {
            Object var9_15 = null;
            if (ses == null) throw throwable;
            ses.logout();
            throw throwable;
        }
        ses.logout();
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @POST
    @Path(value="delete/{repository}/{workspace}/{path:.*}")
    public Response deleteScript(@PathParam(value="repository") String repository, @PathParam(value="workspace") String workspace, @PathParam(value="path") String path) {
        Response response;
        Session ses = null;
        try {
            try {
                ses = this.sessionProviderService.getSessionProvider(null).getSession(workspace, this.repositoryService.getRepository(repository));
                ses.getItem("/" + path).remove();
                ses.save();
                response = Response.status((Response.Status)Response.Status.NO_CONTENT).build();
                Object var8_8 = null;
                if (ses == null) return response;
            }
            catch (PathNotFoundException e) {
                LOG.error((Object)("Path " + path + " does not exists"), (Throwable)e);
                Response response2 = Response.status((Response.Status)Response.Status.NOT_FOUND).build();
                Object var8_9 = null;
                if (ses == null) return response2;
                ses.logout();
                return response2;
            }
            catch (Exception e) {
                LOG.error((Object)"Unexpected error occurs ", (Throwable)e);
                Response response3 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Unexpected error. " + e.getMessage())).type("text/plain").build();
                Object var8_10 = null;
                if (ses == null) return response3;
                ses.logout();
                return response3;
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (ses == null) throw throwable;
            ses.logout();
            throw throwable;
        }
        ses.logout();
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @POST
    @Path(value="autoload/{repository}/{workspace}/{path:.*}")
    public Response autoload(@PathParam(value="repository") String repository, @PathParam(value="workspace") String workspace, @PathParam(value="path") String path, @DefaultValue(value="true") @QueryParam(value="state") boolean state) {
        Response response;
        Session ses = null;
        try {
            try {
                ses = this.sessionProviderService.getSessionProvider(null).getSession(workspace, this.repositoryService.getRepository(repository));
                Node script = ((Node)ses.getItem("/" + path)).getNode("jcr:content");
                script.setProperty("exo:autoload", state);
                ses.save();
                response = Response.status((Response.Status)Response.Status.NO_CONTENT).build();
                Object var9_12 = null;
                if (ses == null) return response;
            }
            catch (PathNotFoundException e) {
                LOG.error((Object)("Path " + path + " does not exists"), (Throwable)e);
                Response response2 = Response.status((Response.Status)Response.Status.NOT_FOUND).build();
                Object var9_13 = null;
                if (ses == null) return response2;
                ses.logout();
                return response2;
            }
            catch (Exception e) {
                LOG.error((Object)"Unexpected error occurs ", (Throwable)e);
                Response response3 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Unexpected error. " + e.getMessage())).type("text/plain").build();
                Object var9_14 = null;
                if (ses == null) return response3;
                ses.logout();
                return response3;
            }
        }
        catch (Throwable throwable) {
            Object var9_15 = null;
            if (ses == null) throw throwable;
            ses.logout();
            throw throwable;
        }
        ses.logout();
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @POST
    @Path(value="load/{repository}/{workspace}/{path:.*}")
    public Response load(@PathParam(value="repository") String repository, @PathParam(value="workspace") String workspace, @PathParam(value="path") String path, @DefaultValue(value="true") @QueryParam(value="state") boolean state) {
        Response response;
        Session ses;
        block13: {
            Response response2;
            block12: {
                Response response3;
                block11: {
                    ses = null;
                    try {
                        try {
                            ses = this.sessionProviderService.getSessionProvider(null).getSession(workspace, this.repositoryService.getRepository(repository));
                            Node script = ((Node)ses.getItem("/" + path)).getNode("jcr:content");
                            NodeScriptKey key = new NodeScriptKey(repository, workspace, script);
                            if (state) {
                                if (this.isLoaded(key)) {
                                    this.unloadScript(key);
                                }
                                if (!this.loadScript(key, path, script.getProperty("jcr:data").getStream())) {
                                    String message = "Can't bind script " + path + ", it is not root resource or root resource with the same URI pattern already registered";
                                    response3 = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)message).build();
                                    Object var11_17 = null;
                                    if (ses == null) return response3;
                                    break block11;
                                }
                            } else if (!this.unloadScript(key)) {
                                String message = "Can't unbind script " + path + ", not bound or has wrong mapping to the resource class ";
                                response2 = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)message).build();
                                break block12;
                            }
                            response = Response.status((Response.Status)Response.Status.NO_CONTENT).build();
                            break block13;
                        }
                        catch (PathNotFoundException e) {
                            LOG.error((Object)("Path " + path + " does not exists"), (Throwable)e);
                            Response response4 = Response.status((Response.Status)Response.Status.NOT_FOUND).build();
                            Object var11_20 = null;
                            if (ses == null) return response4;
                            ses.logout();
                            return response4;
                        }
                        catch (Exception e) {
                            LOG.error((Object)"Unexpected error occurs ", (Throwable)e);
                            Response response5 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Unexpected error. " + e.getMessage())).type("text/plain").build();
                            Object var11_21 = null;
                            if (ses == null) return response5;
                            ses.logout();
                            return response5;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var11_22 = null;
                        if (ses == null) throw throwable;
                        ses.logout();
                        throw throwable;
                    }
                }
                ses.logout();
                return response3;
            }
            Object var11_18 = null;
            if (ses == null) return response2;
            ses.logout();
            return response2;
        }
        Object var11_19 = null;
        if (ses == null) return response;
        ses.logout();
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Produces(value={"application/json"})
    @Path(value="list/{repository}/{workspace}")
    public Response list(@PathParam(value="repository") String repository, @PathParam(value="workspace") String workspace, @QueryParam(value="name") String name) {
        Response response;
        block11: {
            Session ses = null;
            try {
                ses = this.sessionProviderService.getSessionProvider(null).getSession(workspace, this.repositoryService.getRepository(repository));
                String xpath = "//element(*, exo:groovyResourceContainer)";
                Query query = ses.getWorkspace().getQueryManager().createQuery(xpath, "xpath");
                QueryResult result = query.execute();
                NodeIterator nodeIterator = result.getNodes();
                ArrayList<String> scriptList = new ArrayList<String>();
                if (name == null || "".equals(name)) {
                    while (nodeIterator.hasNext()) {
                        Node node = nodeIterator.nextNode();
                        scriptList.add(node.getParent().getPath());
                    }
                } else {
                    StringBuffer p = new StringBuffer();
                    p.append(".*");
                    for (int i = 0; i < name.length(); ++i) {
                        char c = name.charAt(i);
                        if (c == '*' || c == '?') {
                            p.append('.');
                        }
                        if (".()[]^$|".indexOf(c) != -1) {
                            p.append('\\');
                        }
                        p.append(c);
                    }
                    p.append(".*");
                    Pattern pattern = Pattern.compile(p.toString(), 2);
                    while (nodeIterator.hasNext()) {
                        Node node = nodeIterator.nextNode();
                        String scriptName = node.getParent().getPath();
                        if (!pattern.matcher(scriptName).matches()) continue;
                        scriptList.add(scriptName);
                    }
                }
                Collections.sort(scriptList);
                response = Response.status((Response.Status)Response.Status.OK).entity((Object)new ScriptList(scriptList)).type("application/json").build();
                Object var15_18 = null;
                if (ses == null) break block11;
            }
            catch (Exception e) {
                Response response2;
                block12: {
                    try {
                        LOG.error((Object)"Unexpected error occurs ", (Throwable)e);
                        response2 = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Unexpected error. " + e.getMessage())).type("text/plain").build();
                        Object var15_19 = null;
                        if (ses == null) break block12;
                    }
                    catch (Throwable throwable) {
                        block13: {
                            Object var15_20 = null;
                            if (ses == null) break block13;
                            ses.logout();
                        }
                        throw throwable;
                    }
                    ses.logout();
                }
                return response2;
            }
            ses.logout();
        }
        return response;
    }

    protected static String getPath(String fullPath) {
        int sl = fullPath.lastIndexOf(47);
        return sl > 0 ? "/" + fullPath.substring(0, sl) : "/";
    }

    protected static String getName(String fullPath) {
        int sl = fullPath.lastIndexOf(47);
        return sl >= 0 ? fullPath.substring(sl + 1) : fullPath;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ScriptList {
        private List<String> list;

        public List<String> getList() {
            return this.list;
        }

        public ScriptList(List<String> scriptList) {
            this.list = scriptList;
        }
    }

    public static class ScriptMetadata {
        private final boolean autoload;
        private final boolean load;
        private final String mediaType;
        private final long lastModified;

        public ScriptMetadata(boolean autoload, boolean load, String mediaType, long lastModified) {
            this.autoload = autoload;
            this.load = load;
            this.mediaType = mediaType;
            this.lastModified = lastModified;
        }

        public boolean getAutoload() {
            return this.autoload;
        }

        public boolean getLoad() {
            return this.load;
        }

        public String getMediaType() {
            return this.mediaType;
        }

        public long getLastModified() {
            return this.lastModified;
        }
    }
}

